/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.misc.CVM;
import sun.misc.URLClassPath;
import sun.security.action.GetPropertyAction;

public class Launcher {
    private static Launcher launcher;
    private static URLStreamHandlerFactory factory;
    private ClassLoader loader;
    private static URLClassPath bootstrapClassPath;
    private static URLStreamHandler fileHandler;

    public static Launcher getLauncher() {
        return launcher;
    }

    private static ClassLoader getAppClassLoader() {
        return Launcher.launcher.loader;
    }

    static boolean inList(URL uRL, URL[] uRLArray) {
        for (int i = 0; i < uRLArray.length; ++i) {
            if (!uRL.equals(uRLArray[i])) continue;
            return true;
        }
        return false;
    }

    public static void updateLauncher() throws IOException {
        bootstrapClassPath = null;
        AppClassLoader appClassLoader = (AppClassLoader)Launcher.launcher.loader;
        appClassLoader.updateWithNewClasspath();
        ExtClassLoader extClassLoader = (ExtClassLoader)appClassLoader.getParent();
        extClassLoader.updateWithNewExtdirs();
        Launcher.installSecurityManagerIfRequested(appClassLoader);
    }

    public Launcher() {
        ExtClassLoader extClassLoader;
        try {
            extClassLoader = ExtClassLoader.getExtClassLoader();
        }
        catch (IOException iOException) {
            throw new InternalError("Could not create extension class loader");
        }
        try {
            this.loader = AppClassLoader.getAppClassLoader(extClassLoader);
        }
        catch (IOException iOException) {
            throw new InternalError("Could not create application class loader");
        }
        CVM.setSystemClassLoader(this.loader);
        CVM.Preloader.registerClassLoader("sys", this.loader);
        Thread.currentThread().setContextClassLoader(this.loader);
        Launcher.installSecurityManagerIfRequested(this.loader);
    }

    private static void installSecurityManagerIfRequested(ClassLoader classLoader) {
        String string = System.getProperty("java.security.manager");
        if (string != null) {
            SecurityManager securityManager = null;
            if ("".equals(string) || "default".equals(string)) {
                securityManager = new SecurityManager();
            } else {
                try {
                    securityManager = (SecurityManager)classLoader.loadClass(string).newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (securityManager != null) {
                System.setSecurityManager(securityManager);
            } else {
                throw new InternalError("Could not create SecurityManager: " + string);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public static URLClassPath getBootstrapClassPath() {
        if (bootstrapClassPath == null) {
            bootstrapClassPath = Launcher.getBootstrapClassPath0();
        }
        return bootstrapClassPath;
    }

    private static URLClassPath getBootstrapClassPath0() {
        URL[] uRLArray;
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.boot.class.path"));
        if (string == null) {
            string = (String)AccessController.doPrivileged(new GetPropertyAction("java.class.path"));
        }
        if (string != null) {
            final String string2 = string;
            uRLArray = (URL[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Launcher.pathToURLs(Launcher.getClassPath(string2));
                }
            });
        } else {
            uRLArray = new URL[]{};
        }
        return new URLClassPath(uRLArray, factory);
    }

    private static URL[] pathToURLs(File[] fileArray) {
        URL[] uRLArray = new URL[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            uRLArray[i] = Launcher.getFileURL(fileArray[i]);
        }
        return uRLArray;
    }

    private static File[] getClassPath(String string) {
        File[] fileArray;
        if (string != null) {
            int n = 0;
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            while ((n3 = string.indexOf(File.pathSeparator, n4)) != -1) {
                ++n2;
                n4 = n3 + 1;
            }
            fileArray = new File[n2];
            n3 = 0;
            n4 = 0;
            while ((n3 = string.indexOf(File.pathSeparator, n4)) != -1) {
                fileArray[n++] = n3 - n4 > 0 ? new File(string.substring(n4, n3)) : new File(".");
                n4 = n3 + 1;
            }
            fileArray[n++] = n4 < string.length() ? new File(string.substring(n4)) : new File(".");
            if (n != n2) {
                File[] fileArray2 = new File[n];
                System.arraycopy(fileArray, 0, fileArray2, 0, n);
                fileArray = fileArray2;
            }
        } else {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    static URL getFileURL(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        if (fileHandler == null) {
            fileHandler = factory.createURLStreamHandler("file");
        }
        try {
            return new URL("file", "", -1, string, fileHandler);
        }
        catch (MalformedURLException malformedURLException) {
            throw new InternalError();
        }
    }

    static {
        factory = new Factory();
        launcher = (Launcher)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("sun.boot.class.path");
                if (string != null) {
                    return new Launcher();
                }
                return null;
            }
        });
        bootstrapClassPath = null;
    }

    private static class Factory
    implements URLStreamHandlerFactory {
        private static String PREFIX = "sun.net.www.protocol";

        private Factory() {
        }

        public URLStreamHandler createURLStreamHandler(String string) {
            String string2 = PREFIX + "." + string + ".Handler";
            try {
                Class clazz = Class.forName(string2);
                return (URLStreamHandler)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw new InternalError("could not load " + string + "system protocol handler");
        }
    }

    static class AppClassLoader
    extends URLClassLoader {
        private static boolean hasExtension = false;

        public static void setExtInfo() {
            hasExtension = true;
        }

        public static ClassLoader getAppClassLoader(ClassLoader classLoader) throws IOException {
            String string = System.getProperty("java.class.path");
            File[] fileArray = string == null ? new File[]{} : Launcher.getClassPath(string);
            return (AppClassLoader)AccessController.doPrivileged(new PrivilegedAction(string, fileArray, classLoader){
                private final /* synthetic */ String val$s;
                private final /* synthetic */ File[] val$path;
                private final /* synthetic */ ClassLoader val$extcl;
                {
                    this.val$s = string;
                    this.val$path = fileArray;
                    this.val$extcl = classLoader;
                }

                public Object run() {
                    URL[] uRLArray = this.val$s == null ? new URL[]{} : Launcher.access$300(this.val$path);
                    return new AppClassLoader(uRLArray, this.val$extcl);
                }
            });
        }

        AppClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader, factory);
        }

        void updateWithNewClasspath() throws IOException {
            String string = System.getProperty("java.class.path");
            File[] fileArray = string == null ? new File[]{} : Launcher.getClassPath(string);
            URL[] uRLArray = Launcher.pathToURLs(fileArray);
            URL[] uRLArray2 = this.getURLs();
            for (int i = 0; i < uRLArray.length; ++i) {
                URL uRL = uRLArray[i];
                if (Launcher.inList(uRL, uRLArray2)) continue;
                this.addURL(uRL);
            }
        }

        public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            SecurityManager securityManager;
            int n = string.lastIndexOf(46);
            if (n != -1 && (securityManager = System.getSecurityManager()) != null) {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
            return super.loadClass(string, bl);
        }

        private boolean isSealedPrivate(String string, Manifest manifest) {
            String string2 = string.replace('.', '/').concat("/");
            Attributes attributes = manifest.getAttributes(string2);
            String string3 = null;
            if (attributes != null) {
                string3 = attributes.getValue(Attributes.Name.SEALED);
            }
            if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
                string3 = attributes.getValue(Attributes.Name.SEALED);
            }
            return "true".equalsIgnoreCase(string3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getBytesPrivate(InputStream inputStream, int n) throws IOException {
            byte[] byArray;
            try {
                if (n != -1) {
                    byArray = new byte[n];
                    while (n > 0) {
                        int n2 = inputStream.read(byArray, byArray.length - n, n);
                        if (n2 == -1) {
                            throw new IOException("unexpected EOF");
                        }
                        n -= n2;
                    }
                } else {
                    byte[] byArray2;
                    byArray = new byte[1024];
                    int n3 = 0;
                    while ((n = inputStream.read(byArray, n3, byArray.length - n3)) != -1) {
                        if ((n3 += n) < byArray.length) continue;
                        byArray2 = new byte[n3 * 2];
                        System.arraycopy(byArray, 0, byArray2, 0, n3);
                        byArray = byArray2;
                    }
                    if (n3 != byArray.length) {
                        byArray2 = new byte[n3];
                        System.arraycopy(byArray, 0, byArray2, 0, n3);
                        byArray = byArray2;
                    }
                }
            }
            finally {
                inputStream.close();
            }
            return byArray;
        }

        private void handlePackage(String string, Manifest manifest, URL uRL) throws IOException {
            int n = string.lastIndexOf(46);
            if (n == -1) {
                return;
            }
            String string2 = string.substring(0, n);
            if (string.startsWith("java.")) {
                throw new SecurityException("Prohibited package name: " + string2);
            }
            Package package_ = this.getPackage(string2);
            if (package_ != null) {
                boolean bl;
                if (package_.isSealed()) {
                    bl = package_.isSealed(uRL);
                } else {
                    boolean bl2 = bl = manifest == null || !this.isSealedPrivate(string2, manifest);
                }
                if (!bl) {
                    throw new SecurityException("sealing violation");
                }
            } else if (manifest != null) {
                this.definePackage(string2, manifest, uRL);
            } else {
                this.definePackage(string2, null, null, null, null, null, null, null);
            }
        }

        private Class defineClassPrivate(String string, ClassContainer classContainer) throws IOException {
            URL uRL = classContainer.url;
            JarFile jarFile = classContainer.jfile;
            Manifest manifest = jarFile != null ? jarFile.getManifest() : null;
            this.handlePackage(string, manifest, uRL);
            if (classContainer.clazz != null) {
                CVM.executeLoadSuperClasses(classContainer.clazz);
                return classContainer.clazz;
            }
            String string2 = classContainer.entryname;
            JarEntry jarEntry = jarFile.getJarEntry(string2);
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            int n = (int)jarEntry.getSize();
            byte[] byArray = this.getBytesPrivate(inputStream, n);
            Certificate[] certificateArray = jarEntry.getCertificates();
            CodeSource codeSource = new CodeSource(uRL, certificateArray);
            return this.defineClass(string, byArray, 0, byArray.length, codeSource);
        }

        private Class doClassFind(String string) throws ClassNotFoundException, PrivilegedActionException {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(this, string){
                private final /* synthetic */ String val$name;
                private final /* synthetic */ AppClassLoader this$0;
                {
                    this.this$0 = appClassLoader;
                    this.val$name = string;
                }

                public Object run() throws ClassNotFoundException {
                    ClassContainer classContainer = AppClassLoader.access$400(this.this$0, this.val$name);
                    if (classContainer != null) {
                        try {
                            return AppClassLoader.access$500(this.this$0, this.val$name, classContainer);
                        }
                        catch (IOException iOException) {
                            throw new ClassNotFoundException(this.val$name, iOException);
                        }
                    }
                    throw new ClassNotFoundException(this.val$name);
                }
            });
        }

        private boolean checkName(String string) {
            if (string == null || string.length() == 0) {
                return true;
            }
            if (string.indexOf(47) != -1) {
                return false;
            }
            return string.charAt(0) != '[';
        }

        protected Class findClass(String string) throws ClassNotFoundException {
            if (!this.checkName(string)) {
                throw new ClassNotFoundException("Illegal name: " + string);
            }
            if (hasExtension) {
                return super.findClass(string);
            }
            try {
                return this.doClassFind(string);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (ClassNotFoundException)privilegedActionException.getException();
            }
        }

        private native ClassContainer findContainer(String var1) throws ClassNotFoundException;

        protected PermissionCollection getPermissions(CodeSource codeSource) {
            PermissionCollection permissionCollection = super.getPermissions(codeSource);
            permissionCollection.add(new RuntimePermission("exitVM"));
            return permissionCollection;
        }

        static /* synthetic */ ClassContainer access$400(AppClassLoader appClassLoader, String string) throws ClassNotFoundException {
            return appClassLoader.findContainer(string);
        }

        static /* synthetic */ Class access$500(AppClassLoader appClassLoader, String string, ClassContainer classContainer) throws IOException {
            return appClassLoader.defineClassPrivate(string, classContainer);
        }
    }

    static class ClassContainer {
        URL url;
        String entryname;
        JarFile jfile;
        Class clazz;

        ClassContainer(URL uRL, String string, JarFile jarFile) {
            this.url = uRL;
            this.entryname = string;
            this.jfile = jarFile;
            this.clazz = null;
        }

        ClassContainer(URL uRL, Class clazz, String string, JarFile jarFile) {
            this.url = uRL;
            this.entryname = string;
            this.jfile = jarFile;
            this.clazz = clazz;
        }
    }

    static class ExtClassLoader
    extends URLClassLoader {
        private File[] dirs;

        public static ExtClassLoader getExtClassLoader() throws IOException {
            File[] fileArray = ExtClassLoader.getExtDirs();
            try {
                return (ExtClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(fileArray){
                    private final /* synthetic */ File[] val$dirs;
                    {
                        this.val$dirs = fileArray;
                    }

                    public Object run() throws IOException {
                        return new ExtClassLoader(this.val$dirs);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }

        void addExtURL(URL uRL) {
            super.addURL(uRL);
        }

        public ExtClassLoader(File[] fileArray) throws IOException {
            super(ExtClassLoader.getExtURLs(fileArray), null, factory);
            this.dirs = fileArray;
            CVM.Preloader.registerClassLoader("ext", this);
        }

        void updateWithNewExtdirs() throws IOException {
            URL[] uRLArray = this.getURLs();
            URL[] uRLArray2 = ExtClassLoader.getExtURLs(ExtClassLoader.getExtDirs());
            for (int i = 0; i < uRLArray2.length; ++i) {
                URL uRL = uRLArray2[i];
                if (Launcher.inList(uRL, uRLArray)) continue;
                this.addURL(uRL);
            }
        }

        private static File[] getExtDirs() {
            File[] fileArray;
            String string = System.getProperty("java.ext.dirs");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                int n = stringTokenizer.countTokens();
                fileArray = new File[n];
                for (int i = 0; i < n; ++i) {
                    fileArray[i] = new File(stringTokenizer.nextToken());
                }
            } else {
                fileArray = new File[]{};
            }
            return fileArray;
        }

        private static URL[] getExtURLs(File[] fileArray) throws IOException {
            Vector vector = new Vector();
            for (int i = 0; i < fileArray.length; ++i) {
                String[] stringArray = fileArray[i].list();
                if (stringArray == null) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    File file = new File(fileArray[i], stringArray[j]);
                    vector.add(Launcher.getFileURL(file));
                }
            }
            Object[] objectArray = new URL[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public String findLibrary(String string) {
            string = System.mapLibraryName(string);
            for (int i = 0; i < this.dirs.length; ++i) {
                File file;
                String string2 = System.getProperty("os.arch");
                if (string2 != null && (file = new File(new File(this.dirs[i], string2), string)).exists()) {
                    return file.getAbsolutePath();
                }
                file = new File(this.dirs[i], string);
                if (!file.exists()) continue;
                return file.getAbsolutePath();
            }
            return null;
        }
    }
}

