/* simplelist.c
 * Part of ziproxy package
 *
 * Copyright (c)2005-2010 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * High level routines for dealing with text files (read-only) with an item per line.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "txtfiletools.h"
#include "strtables.h"
#include "simplelist.h"

/* loads text file into memory and return struct to be used for queries
   returns NULL if unable to load file or create structure */
t_st_strtable *slist_create (const char* given_filename)
{
	char *filedata;
	int filedata_len;
	t_st_strtable *slist_table;
	int linelen;
	char *curpos;

	if ((filedata = load_textfile_to_memory (given_filename)) != NULL) {
		filedata_len = strlen (filedata);
		fix_linebreaks_qp (filedata, filedata_len, filedata);
		remove_junk_data (filedata, filedata);
		if ((slist_table = st_create ()) != NULL) {
			curpos = filedata;
			while ((linelen = get_line_len (curpos))) {
				if (*(curpos + linelen - 1) == '\n')
					*(curpos + linelen - 1) = '\0';
				if (strchr (curpos, '*') == NULL)
					st_insert_nometa (slist_table, curpos);
				else
					st_insert (slist_table, curpos);
				curpos += linelen;
			}
			/* finished, return */
			free (filedata);
			return (slist_table);
		}
		free (filedata);
	}
	return (NULL);
}

void slist_destroy (t_st_strtable *slist_table)
{
	st_destroy (slist_table);
}

/* if string is present in the list, returns !=0
   otherwise returns 0.
   this function makes pattern-mathing (based on '*') */
int slist_check_if_matches (t_st_strtable *slist_table, const char *strdata)
{
	return (st_check_if_matches (slist_table, strdata));
}

