/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.ConnectionLostException;
import Ice.Logger;
import Ice.PluginInitializationException;
import Ice.SecurityException;
import Ice.SocketException;
import Ice.TimeoutException;
import IceInternal.Acceptor;
import IceInternal.Network;
import IceInternal.Transceiver;
import IceSSL.ConnectionInfo;
import IceSSL.Instance;
import IceSSL.TransceiverI;
import IceSSL.Util;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

class AcceptorI
implements Acceptor {
    private Instance _instance;
    private String _adapterName;
    private Logger _logger;
    private SSLServerSocket _fd;
    private int _backlog;
    private InetSocketAddress _addr;
    private InetSocketAddress _connectToSelfAddr;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ServerSocketChannel fd() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SSLServerSocket fd;
        if (this._instance.networkTraceLevel() >= 1) {
            String s = "stopping to accept ssl connections at " + this.toString();
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
        AcceptorI acceptorI = this;
        synchronized (acceptorI) {
            fd = this._fd;
            this._fd = null;
        }
        if (fd != null) {
            try {
                fd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void listen() {
        if (this._instance.networkTraceLevel() >= 1) {
            String s = "accepting ssl connections at " + this.toString();
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transceiver accept(int timeout) {
        if (!this._instance.initialized()) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: plugin is not initialized";
            throw ex;
        }
        Socket fd = null;
        ConnectionInfo connInfo = null;
        try {
            if (timeout == -1) {
                timeout = 0;
            } else if (timeout == 0) {
                timeout = 1;
            }
            this._fd.setSoTimeout(timeout);
            fd = (SSLSocket)this._fd.accept();
            SocketAddress remoteAddr = fd.getRemoteSocketAddress();
            AcceptorI acceptorI = this;
            synchronized (acceptorI) {
                if (remoteAddr.equals(this._connectToSelfAddr)) {
                    try {
                        fd.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return null;
                }
            }
            ((SSLSocket)fd).setUseClientMode(false);
            if (timeout == 0) {
                ((SSLSocket)fd).getSession();
            } else {
                HandshakeThread ht = new HandshakeThread((SSLSocket)fd);
                ht.start();
                if (!ht.waitForHandshake(timeout)) {
                    throw new TimeoutException();
                }
            }
            connInfo = Util.populateConnectionInfo((SSLSocket)fd, this._adapterName, true);
            this._instance.verifyPeer(connInfo, (SSLSocket)fd, "", true);
        }
        catch (SocketTimeoutException ex) {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            TimeoutException e = new TimeoutException();
            e.initCause(ex);
            throw e;
        }
        catch (SSLException ex) {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (ex.getMessage().toLowerCase().startsWith("no available certificate corresponds to the ssl cipher suites which are enabled")) {
                RuntimeException e = new RuntimeException();
                e.initCause(ex);
                throw e;
            }
            SecurityException e = new SecurityException();
            e.initCause(ex);
            throw e;
        }
        catch (IOException ex) {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (Network.connectionLost(ex)) {
                throw new ConnectionLostException();
            }
            SocketException e = new SocketException();
            e.initCause(ex);
            throw e;
        }
        catch (RuntimeException ex) {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw ex;
        }
        if (this._instance.networkTraceLevel() >= 1) {
            String s = "accepted ssl connection\n" + Network.fdToString(fd);
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
        if (this._instance.securityTraceLevel() > 0) {
            this._instance.traceConnection((SSLSocket)fd, true);
        }
        return new TransceiverI(this._instance, (SSLSocket)fd, connInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToSelf() {
        SocketChannel fd = Network.createTcpSocket();
        Network.setBlock(fd, false);
        AcceptorI acceptorI = this;
        synchronized (acceptorI) {
            Network.doConnect(fd, this._addr, -1);
            this._connectToSelfAddr = (InetSocketAddress)fd.socket().getLocalSocketAddress();
        }
        Network.closeSocket(fd);
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    final boolean equivalent(String host, int port) {
        InetSocketAddress addr = Network.getAddress(host, port);
        return addr.equals(this._addr);
    }

    int effectivePort() {
        return this._addr.getPort();
    }

    AcceptorI(Instance instance, String adapterName, String host, int port) {
        block17: {
            this._instance = instance;
            this._adapterName = adapterName;
            this._logger = instance.communicator().getLogger();
            this._backlog = 0;
            if (this._backlog <= 0) {
                this._backlog = 5;
            }
            try {
                String[] protocols;
                SSLServerSocketFactory factory = this._instance.context().getServerSocketFactory();
                this._addr = new InetSocketAddress(host, port);
                if (this._instance.networkTraceLevel() >= 2) {
                    String s = "attempting to bind to ssl socket " + this.toString();
                    this._logger.trace(this._instance.networkTraceCategory(), s);
                }
                InetSocketAddress iface = Network.getAddress(host, port);
                this._fd = (SSLServerSocket)factory.createServerSocket(port, this._backlog, iface.getAddress());
                this._addr = (InetSocketAddress)this._fd.getLocalSocketAddress();
                int verifyPeer = this._instance.communicator().getProperties().getPropertyAsIntWithDefault("IceSSL.VerifyPeer", 2);
                if (verifyPeer == 0) {
                    this._fd.setWantClientAuth(false);
                    this._fd.setNeedClientAuth(false);
                } else if (verifyPeer == 1) {
                    this._fd.setWantClientAuth(true);
                } else {
                    this._fd.setNeedClientAuth(true);
                }
                String[] cipherSuites = this._instance.filterCiphers(this._fd.getSupportedCipherSuites(), this._fd.getEnabledCipherSuites());
                try {
                    this._fd.setEnabledCipherSuites(cipherSuites);
                }
                catch (IllegalArgumentException ex) {
                    SecurityException e = new SecurityException();
                    e.reason = "IceSSL: invalid ciphersuite";
                    e.initCause(ex);
                    throw e;
                }
                if (this._instance.securityTraceLevel() > 0) {
                    StringBuffer s = new StringBuffer();
                    s.append("enabling SSL ciphersuites for server socket " + this.toString() + ":");
                    for (int i = 0; i < cipherSuites.length; ++i) {
                        s.append("\n  " + cipherSuites[i]);
                    }
                    this._logger.trace(this._instance.securityTraceCategory(), s.toString());
                }
                if ((protocols = this._instance.protocols()) == null) break block17;
                try {
                    this._fd.setEnabledProtocols(protocols);
                }
                catch (IllegalArgumentException ex) {
                    SecurityException e = new SecurityException();
                    e.reason = "IceSSL: invalid protocol";
                    e.initCause(ex);
                    throw e;
                }
            }
            catch (IOException ex) {
                try {
                    if (this._fd != null) {
                        this._fd.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                this._fd = null;
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!$assertionsDisabled && this._fd != null) {
            throw new AssertionError();
        }
        super.finalize();
    }

    static {
        $assertionsDisabled = !AcceptorI.class.desiredAssertionStatus();
    }

    private static class HandshakeThread
    extends Thread {
        private SSLSocket _fd;
        private boolean _ok;
        private RuntimeException _ex;

        HandshakeThread(SSLSocket fd) {
            this._fd = fd;
            this._ok = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this._fd.getSession();
                HandshakeThread handshakeThread = this;
                synchronized (handshakeThread) {
                    this._ok = true;
                    this.notifyAll();
                }
            }
            catch (RuntimeException ex) {
                HandshakeThread handshakeThread = this;
                synchronized (handshakeThread) {
                    this._ex = ex;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean waitForHandshake(int timeout) {
            boolean result = false;
            HandshakeThread handshakeThread = this;
            synchronized (handshakeThread) {
                while (!this._ok && this._ex == null) {
                    try {
                        this.wait(timeout);
                        break;
                    }
                    catch (InterruptedException ex) {
                    }
                }
                if (this._ex != null) {
                    throw this._ex;
                }
                result = this._ok;
            }
            return result;
        }
    }
}

