/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.NotRegisteredException;
import Ice.ObjectFactory;
import java.util.HashMap;
import java.util.Iterator;

public final class ObjectFactoryManager {
    private HashMap _factoryMap = new HashMap();

    public synchronized void add(ObjectFactory factory, String id) {
        Object o = this._factoryMap.get(id);
        if (o != null) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.id = id;
            ex.kindOfObject = "object factory";
            throw ex;
        }
        this._factoryMap.put(id, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) {
        Object o = null;
        ObjectFactoryManager objectFactoryManager = this;
        synchronized (objectFactoryManager) {
            o = this._factoryMap.get(id);
            if (o == null) {
                NotRegisteredException ex = new NotRegisteredException();
                ex.id = id;
                ex.kindOfObject = "object factory";
                throw ex;
            }
            this._factoryMap.remove(id);
        }
        ((ObjectFactory)o).destroy();
    }

    public synchronized ObjectFactory find(String id) {
        return (ObjectFactory)this._factoryMap.get(id);
    }

    ObjectFactoryManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        HashMap oldMap = null;
        ObjectFactoryManager objectFactoryManager = this;
        synchronized (objectFactoryManager) {
            oldMap = this._factoryMap;
            this._factoryMap = new HashMap();
        }
        Iterator i = oldMap.values().iterator();
        while (i.hasNext()) {
            ObjectFactory factory = (ObjectFactory)i.next();
            factory.destroy();
        }
    }
}

