/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Identity;
import Ice.ObjectPrx;
import IceInternal.EndpointI;
import java.util.HashMap;

final class LocatorTable {
    private HashMap _adapterEndpointsTable = new HashMap();
    private HashMap _objectTable = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    LocatorTable() {
    }

    synchronized void clear() {
        this._adapterEndpointsTable.clear();
        this._objectTable.clear();
    }

    synchronized EndpointI[] getAdapterEndpoints(String adapter, int ttl) {
        if (ttl == 0) {
            return null;
        }
        EndpointTableEntry entry = (EndpointTableEntry)this._adapterEndpointsTable.get(adapter);
        if (entry != null && this.checkTTL(entry.time, ttl)) {
            return entry.endpoints;
        }
        return null;
    }

    synchronized void addAdapterEndpoints(String adapter, EndpointI[] endpoints) {
        this._adapterEndpointsTable.put(adapter, new EndpointTableEntry(System.currentTimeMillis(), endpoints));
    }

    synchronized EndpointI[] removeAdapterEndpoints(String adapter) {
        EndpointTableEntry entry = (EndpointTableEntry)this._adapterEndpointsTable.remove(adapter);
        return entry != null ? entry.endpoints : null;
    }

    synchronized ObjectPrx getProxy(Identity id, int ttl) {
        if (ttl == 0) {
            return null;
        }
        ProxyTableEntry entry = (ProxyTableEntry)this._objectTable.get(id);
        if (entry != null && this.checkTTL(entry.time, ttl)) {
            return entry.proxy;
        }
        return null;
    }

    synchronized void addProxy(Identity id, ObjectPrx proxy) {
        this._objectTable.put(id, new ProxyTableEntry(System.currentTimeMillis(), proxy));
    }

    synchronized ObjectPrx removeProxy(Identity id) {
        ProxyTableEntry entry = (ProxyTableEntry)this._objectTable.remove(id);
        return entry != null ? entry.proxy : null;
    }

    private boolean checkTTL(long time, int ttl) {
        if (!$assertionsDisabled && ttl == 0) {
            throw new AssertionError();
        }
        if (ttl < 0) {
            return true;
        }
        return System.currentTimeMillis() - time <= (long)ttl * 1000L;
    }

    static {
        $assertionsDisabled = !LocatorTable.class.desiredAssertionStatus();
    }

    private static final class ProxyTableEntry {
        public final long time;
        public final ObjectPrx proxy;

        public ProxyTableEntry(long time, ObjectPrx proxy) {
            this.time = time;
            this.proxy = proxy;
        }
    }

    private static final class EndpointTableEntry {
        public final long time;
        public final EndpointI[] endpoints;

        public EndpointTableEntry(long time, EndpointI[] endpoints) {
            this.time = time;
            this.endpoints = endpoints;
        }
    }
}

