/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import Ice.Current;
import Ice.Identity;
import Ice.TimeoutException;
import IceGrid.AdapterInfo;
import IceGrid.ApplicationDescriptor;
import IceGrid.ApplicationUpdateDescriptor;
import IceGrid.ObjectInfo;
import IceGrid._RegistryObserverDisp;
import IceGridGUI.Coordinator;
import java.util.List;
import javax.swing.SwingUtilities;

class RegistryObserverI
extends _RegistryObserverDisp {
    private final Coordinator _coordinator;
    private boolean _initialized = false;
    private final String _instanceName;
    private int _serial;
    private List _applications;
    private AdapterInfo[] _adapters;
    private ObjectInfo[] _objects;

    RegistryObserverI(String instanceName, Coordinator coordinator) {
        this._instanceName = instanceName;
        this._coordinator = coordinator;
    }

    synchronized void waitForInit() {
        long timeout = 10000L;
        long start = System.currentTimeMillis();
        while (!this._initialized) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (start + timeout >= System.currentTimeMillis()) continue;
        }
        if (!this._initialized) {
            throw new TimeoutException();
        }
        this._coordinator.registryInit(this._instanceName, this._serial, this._applications, this._adapters, this._objects);
    }

    public synchronized void init(int serial, List applications, AdapterInfo[] adapters, ObjectInfo[] objects, Current current) {
        this._initialized = true;
        this._serial = serial;
        this._applications = applications;
        this._adapters = adapters;
        this._objects = objects;
        this.notify();
    }

    public void applicationAdded(final int serial, final ApplicationDescriptor desc, Current current) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryObserverI.this._coordinator.applicationAdded(serial, desc);
            }
        });
    }

    public void applicationRemoved(final int serial, final String name, Current current) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryObserverI.this._coordinator.applicationRemoved(serial, name);
            }
        });
    }

    public void applicationUpdated(final int serial, final ApplicationUpdateDescriptor desc, Current current) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryObserverI.this._coordinator.applicationUpdated(serial, desc);
            }
        });
    }

    public void adapterAdded(final int serial, final AdapterInfo info, Current current) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryObserverI.this._coordinator.adapterAdded(serial, info);
            }
        });
    }

    public void adapterUpdated(final int serial, final AdapterInfo info, Current current) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryObserverI.this._coordinator.adapterUpdated(serial, info);
            }
        });
    }

    public void adapterRemoved(final int serial, final String id, Current current) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryObserverI.this._coordinator.adapterRemoved(serial, id);
            }
        });
    }

    public void objectAdded(final int serial, final ObjectInfo info, Current current) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryObserverI.this._coordinator.objectAdded(serial, info);
            }
        });
    }

    public void objectUpdated(final int serial, final ObjectInfo info, Current current) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryObserverI.this._coordinator.objectUpdated(serial, info);
            }
        });
    }

    public void objectRemoved(final int serial, final Identity id, Current current) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryObserverI.this._coordinator.objectRemoved(serial, id);
            }
        });
    }
}

