/*
 * @(#)Rubik3dP.h
 *
 * Copyright 1994 - 2008  David A. Bagley, bagleyd@tux.org
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for Rubik3d */

#ifndef _Rubik3dP_h
#define _Rubik3dP_h

#include "Rubik3d.h"

#ifndef WINVER
/* This gets around C's inability to do inheritance */
typedef struct _Rubik3DClassPart {
	int         ignore;
} Rubik3DClassPart;

typedef struct _Rubik3DClassRec {
	CoreClassPart coreClass;
	RubikClassPart rubikClass;
	Rubik3DClassPart rubik3dClass;
} Rubik3DClassRec;

extern Rubik3DClassRec rubik3dClassRec;
#endif

#define TR 8
#define BR 9
#define BL 10
#define TL 11
#define SAME 0
#define OPPOSITE 1
#define DOWN 0
#define UP 1
#define COORD3D 12

#define SQRT_3 1.732050808
#define MULTIPLY(a) ((int)(a*SQRT_3/2.0))
#define DIVIDE(a) ((int)(a*2.0/SQRT_3))

typedef struct _Rubik3DPart {
#if 1
#ifdef WINVER
	int         dummy[2]; /* There is some corruption, so this is needed */
#endif
#endif
	Point       viewMiddle;
	Point       faceSize, viewSize;
	Point       cubeSizex, cubeSizey, cubeSizez;
	Position    faceDiagonal;
	Position    cubeDiagonalx, cubeDiagonaly, cubeDiagonalz;
} Rubik3DPart;

typedef struct _Rubik3DRec {
	CorePart    core;
	RubikPart   rubik;
	Rubik3DPart rubik3d;
} Rubik3DRec;

extern Boolean selectPieces3D(Rubik3DWidget w, int x, int y,
	int *face, int *position);
extern Boolean narrowSelection3D(Rubik3DWidget w,
	int *face, int *position, int *direction);
extern void drawFrame3D(Rubik3DWidget w, Boolean focus);
extern void drawSquare3D(Rubik3DWidget w, int face, int position, int offset);
#ifdef WINVER
extern void resizePuzzle3D(Rubik3DWidget w);
extern void exposePuzzle3D(Rubik3DWidget w);
#endif

#endif /* _Rubik3dP_h */
