/*
 * @(#)DinoGLP.h
 *
 * Copyright 2007 - 2008  David A. Bagley, bagleyd@tux.org
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for DinoGL */

#ifndef _DinoGLP_h
#define _DinoGLP_h

#include "DinoGL.h"
#include <GL/gl.h>
#ifndef WINVER
#include <GL/glx.h>

/* This gets around C's inability to do inheritance */
typedef struct _DinoGLClassPart {
	int         ignore;
} DinoGLClassPart;

typedef struct _DinoGLClassRec {
	CoreClassPart coreClass;
	DinoClassPart dinoClass;
	DinoGLClassPart dinoGLClass;
} DinoGLClassRec;

extern DinoGLClassRec dinoGLClassRec;
#endif

#define CCW 7
#define TOP 8
#define RIGHT 9
#define BOTTOM 10
#define LEFT 11
#define MAX_ROTATE 3

#define TOP_FACE 0
#define LEFT_FACE 1
#define FRONT_FACE 2
#define RIGHT_FACE 3
#define BOTTOM_FACE 4
#define BACK_FACE 5
#define NO_FACE (IGNORE_DIR)
#define TEST_FACE (MAX_FACES)
#define ERROR_FACE (MAX_FACES+1)
#define NO_ROTATION (2*MAX_ORIENT)

#define CUBE_LENGTH 0.5
#define CUBEFULLLEN (2.0*CUBE_LENGTH)
#define OFFSET 0.1
#define CUBE_ROUND (CUBE_LENGTH-0.05)
#define CUBEFULLROUND (2.0*CUBE_ROUND)
#define STICKER_LONG (CUBE_ROUND-0.05)
#define STICKERFULLLONG (2.0*STICKER_LONG)
#define STICKER_SHORT (STICKER_LONG-0.05)
#define STICKERFULLSHORT (2.0*STICKER_SHORT)
#define STICKER_DEPTH (CUBE_LENGTH+0.01)
#define CUT 0.04
#define CUT_DEPTH (STICKER_DEPTH+0.001)

#define SCALE (1.1)

typedef struct _DinoMove {
        int         face, direction;
        int         position;
} DinoMove;

typedef struct _DinoSlice {
        int         face, rotation;
        int         depth;
} DinoSlice;

typedef struct _DinoGLPart {
	double angleStep;
	double vx, vy;
	double rotateStep;

	Position    faceDiagonal;
	Position    cubeDiagonalx, cubeDiagonaly, cubeDiagonalz;
	/*Point       cubeSizex, cubeSizey, cubeSizez;*/
	Point       faceSize, viewSize;
	Point       viewMiddle;
	DinoMove    movement;
	int step;
} DinoGLPart;

typedef struct _DinoGLRec {
	CorePart    core;
	DinoPart    dino;
	DinoGLPart  dinoGL;
} DinoGLRec;

extern Boolean selectPiecesGL(DinoGLWidget w, int x, int y,
	int *face, int *position);
extern void drawFrameGL(DinoGLWidget w, Boolean focus);
extern void drawAllPiecesGL(DinoGLWidget w);
#ifdef WINVER
extern void resizePuzzleGL(DinoGLWidget w);
extern void exposePuzzleGL(DinoGLWidget w);
#endif

#endif /* _DinoGLP_h */
