/*
 * @(#)Dino.h
 *
 * Copyright 1995 - 2008  David A. Bagley, bagleyd@tux.org
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Public header file for Dino */

#ifndef _XtDino_h
#define _XtDino_h

/***********************************************************************
 *
 * Dino Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNframeColor ((char *) "frameColor")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNfaceColor4 ((char *) "faceColor4")
#define XtNfaceColor5 ((char *) "faceColor5")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNview ((char *) "view")
#define XtNmode ((char *) "mode")
#define XtNorient ((char *) "orient")
#define XtNpractice ((char *) "practice")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNface ((char *) "face")
#define XtNpos ((char *) "position")
#define XtNdirection ((char *) "direction")
#define XtNstyle ((char *) "style")
#define XtNpixmapSize ((char *) "pixmapSize")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCView ((char *) "View")
#define XtCMode ((char *) "Mode")
#define XtCOrient ((char *) "Orient")
#define XtCPractice ((char *) "Practice")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")
#define XtCFace ((char *) "Face")
#define XtCPos ((char *) "Position")
#define XtCDirection ((char *) "Direction")
#define XtCStyle ((char *) "Style")
#define XtCPixmapSize ((char *) "PixmapSize")

typedef struct _DinoClassRec *DinoWidgetClass;

extern WidgetClass dinoWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
	int         face, position, direction, style;
} dinoCallbackStruct;
#endif

#define ACTION_GET 100
#define ACTION_WRITE 101
#define ACTION_EXIT 102
#define ACTION_HIDE 103
#define ACTION_PRACTICE_QUERY 104
#define ACTION_RANDOMIZE_QUERY 105
#define ACTION_SOLVE_MESSAGE 106
#define ACTION_RESTORE 107
#define ACTION_RESET 108
#define ACTION_AMBIGUOUS 109
#define ACTION_ILLEGAL 110
#define ACTION_MOVED 111
#define ACTION_CONTROL 112
#define ACTION_SOLVED 113
#define ACTION_COMPUTED 114
#define ACTION_UNDO 200
#define ACTION_REDO 201
#define ACTION_CLEAR 202
#define ACTION_PRACTICE 203
#define ACTION_RANDOMIZE 204
#define ACTION_SOLVE 205
#define ACTION_ORIENTIZE 206
#define ACTION_SPEED 207
#define ACTION_SLOW 208
#define ACTION_SOUND 209
#define ACTION_VIEW 210
#define ACTION_DIM 211
#define ACTION_TR 300
#define ACTION_BR 301
#define ACTION_BL 302
#define ACTION_TL 303
#define ACTION_CW 305
#define ACTION_CCW 307
#define ACTION_TOP 308
#define ACTION_RIGHT 309
#define ACTION_BOTTOM 310
#define ACTION_LEFT 311
#define ACTION_SHIFT_TR 320
#define ACTION_SHIFT_BR 321
#define ACTION_SHIFT_BL 322
#define ACTION_SHIFT_TL 323
#define ACTION_SHIFT_CW 325
#define ACTION_SHIFT_CCW 327
#define ACTION_SHIFT_TOP 328
#define ACTION_SHIFT_RIGHT 329
#define ACTION_SHIFT_BOTTOM 330
#define ACTION_SHIFT_LEFT 331
#define ACTION_CONTROL_TR 340
#define ACTION_CONTROL_BR 341
#define ACTION_CONTROL_BL 342
#define ACTION_CONTROL_TL 343
#define ACTION_CONTROL_CW 345
#define ACTION_CONTROL_CCW 347
#define ACTION_CONTROL_TOP 348
#define ACTION_CONTROL_RIGHT 349
#define ACTION_CONTROL_BOTTOM 350
#define ACTION_CONTROL_LEFT 351
#define ACTION_SHIFT_CONTROL_TR 360
#define ACTION_SHIFT_CONTROL_BR 361
#define ACTION_SHIFT_CONTROL_BL 362
#define ACTION_SHIFT_CONTROL_TL 363
#define ACTION_SHIFT_CONTROL_CW 365
#define ACTION_SHIFT_CONTROL_CCW 367
#define ACTION_SHIFT_CONTROL_TOP 368
#define ACTION_SHIFT_CONTROL_RIGHT 369
#define ACTION_SHIFT_CONTROL_BOTTOM 370
#define ACTION_SHIFT_CONTROL_LEFT 371
#define ACTION_ALT_TR 380
#define ACTION_ALT_BR 381
#define ACTION_ALT_BL 382
#define ACTION_ALT_TL 383
#define ACTION_ALT_CW 385
#define ACTION_ALT_CCW 387
#define ACTION_ALT_TOP 388
#define ACTION_ALT_RIGHT 389
#define ACTION_ALT_BOTTOM 390
#define ACTION_ALT_LEFT 391
#define ACTION_CONTROL_ALT_TR 400
#define ACTION_CONTROL_ALT_BR 401
#define ACTION_CONTROL_ALT_BL 402
#define ACTION_CONTROL_ALT_TL 403
#define ACTION_CONTROL_ALT_CW 405
#define ACTION_CONTROL_ALT_CCW 407
#define ACTION_CONTROL_ALT_TOP 408
#define ACTION_CONTROL_ALT_RIGHT 409
#define ACTION_CONTROL_ALT_BOTTOM 410
#define ACTION_CONTROL_ALT_LEFT  411
#define ACTION_PERIOD2 500
#define ACTION_PERIOD3 501
#define ACTION_BOTH 502
#define ACTION_DESCRIPTION 900
#define ACTION_FEATURES 901
#define ACTION_REFERENCES 902
#define ACTION_ABOUT 903
#define ACTION_IGNORE 999

#define RESTORE_DIR (-5)
#define CLEAR_DIR (-4)
#define AMBIGUOUS_DIR (-3)
#define ILLEGAL_DIR (-2)
#define IGNORE_DIR (-1)
#define PERIOD2 2
#define PERIOD3 3
#define BOTH 4
#define MAX_MODES 3
#define MAX_FACES 6
#define MAX_VIEWS 2
#define DEFAULT_MODE PERIOD3
#define DEFAULT_ORIENT FALSE
#define DEFAULT_PRACTICE TRUE
#ifdef MONOTEST
#define DEFAULT_MONO TRUE
#else
#define DEFAULT_MONO FALSE
#endif
#define DEFAULT_REVERSE FALSE

#define BOOL_STRING(a) ((a==0)?"false":"true")

typedef struct _DinoRec *DinoWidget;

#endif /* _XtDino_h */
/* DON'T ADD STUFF AFTER THIS #endif */
