#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#include "gtktopdata.h"
#include "gtksettings.h"

#include "settings.h"

//#include "callbacks.h"
//#include "interface.h"
#include "support.h"
#include "main.h"
#include "utils.h"



void
gtkmorph_settings_callback()
{
  int i,s;
/* if the meshes do not have the same sizes, something will crash */
  if (settings_get_value("mesh auto sync"))    
    promote_meshes();

  s=settings_get_value( "automatic mesh interpolation");
  i= MAX_WINS+1;
  if(sp->im_widget[i])
    {
      GtkWidget *m=
	gtk_widget_get_data_top(sp->im_widget[i],"button_interp_meshes");
      g_assert(m);
      if(s==0)
	gtk_widget_show(m);
      else
	gtk_widget_hide(m);
    }
}


gpointer gtkmorph_settings[] =
{ 
  gtkmorph_settings_callback,

  /****** next*******/
  "no warnings", //name
  NULL,//integer value, stored in pointer
  NULL,//accels
  ("dont warn, just beep; warnings may be read with 'why the beep' in the 'help' menu"),
  NULL, //widget that is expressing this setting

  /****** next *****/
  "preserve aspect ratio", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  "when loading an image, preserve aspect ratio", //tooltip (they are translated below)
  NULL, //widget that is expressing this setting

  /****** next *****/
  "mesh cant overlap", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  "a mesh point cannot enter in a neighbouring cell", //tooltip (they are translated below)
  NULL, //widget that is expressing this setting

 /****** next *****/
  "mesh factors sum to 1", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  ("the factors should sum to 1;\n\
if they dont, they are internally renormiized before using"), //tooltip 
  NULL, //widget that is expressing this setting

 /****** next *****/
  "image factors sum to 1", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  ("the factors should sum to 1;\n\
if they dont, they are internally renormiized before using"), //tooltip 
  NULL, //widget that is expressing this setting

 /****** next *****/
  "automatic mesh interpolation", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  ("automatically interpolates the resulting mesh when morphing\
(note that in this case you cant edit it)"), //tooltip 
  NULL, //widget that is expressing this setting

 /****** next *****/
  "mesh auto sync", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  ("any change (add/del, label/unlabel) to a mesh is replicated"), //tooltip 
  NULL, //widget that is expressing this setting

  /****** next *****/
  "warped image in other win", //name
  GUINT_TO_POINTER(0),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  ("put warped images in another window"), //tooltip (they are translated below)
  NULL, //widget that is expressing this setting

  /****** next*******/
  /*      what is shown after a "warp" or "mix" or "morph"
     button is hit ?*/
  "show warp after warp",
  GUINT_TO_POINTER(EDITSHOW_SHOW),
  NULL,
  "switch the input window(s) to the warped image after a warp (overridden by the above)", //name
  NULL,

  /****** next*******/
  NULL};


GtkWidget*
create_gtkmorph_menuSettings ()
{

  int lp;
  //BAD HACK
  static int translated =0;
  translated =1;
  lp=0;
  while(translated ==0 && gtkmorph_settings[lp]) { //translate
    gtkmorph_settings[lp+3]=_(gtkmorph_settings[lp+3]);
    lp+=GTKSETTINGS_BLOCKS_SIZE;
  }  
  return   gtk_settings_create(gtkmorph_settings, gtkmorph_settings_callback);
}



int
settings_get_value(char *name)
{
  return gtk_settings_get_value(name, gtkmorph_settings);
}
