sub require_postgres
{
return if ($require_postgres++);
$postgresql::use_global_login = 1;
&foreign_require("postgresql", "postgresql-lib.pl");
%qconfig = &foreign_config("postgresql");
}

# check_postgres_clash(&domain, [field])
# Returns 1 if some PostgreSQL database already exists
sub check_postgres_clash
{
if (!$_[1] || $_[1] eq 'db') {
	&require_postgres();
	local @dblist = &postgresql::list_databases();
	return 1 if (&indexof($_[0]->{'db'}, @dblist) >= 0);
	}
if (!$_[0]->{'parent'} && (!$_[1] || $_[1] eq 'db')) {
	return 1 if (&postgres_user_exists($_[0]) ? 1 : 0);
	}
return 0;
}

# postgres_user_exists(&domain)
# Returns 1 if some user exists in PostgreSQL
sub postgres_user_exists
{
&require_postgres();
local $user = &postgres_user($_[0]);
local $s = &postgresql::execute_sql($qconfig{'basedb'}, "select * from pg_shadow where usename = '$user'");
return $s->{'data'}->[0] ? 1 : 0;
}

# setup_postgres(&domain, [no-dbs])
# Create a new PostgreSQL database and user
sub setup_postgres
{
&require_postgres();
local $user = $_[0]->{'postgres_user'} = &postgres_user($_[0]);
if (!$_[0]->{'parent'}) {
	&$first_print($text{'setup_postgresuser'});
	local $pass = &postgres_pass($_[0]);
	&postgresql::execute_sql_logged($qconfig{'basedb'}, "create user \"$user\" with password $pass nocreatedb nocreateuser");
	&$second_print($text{'setup_done'});
	}
if (!$_[1]) {
	&create_postgres_database($_[0], $_[0]->{'db'});
	}
}

# postgres_pass(&domain, [neverquote])
sub postgres_pass
{
local $pass = defined($_[0]->{'postgres_pass'}) ? $_[0]->{'postgres_pass'}
						: $_[0]->{'pass'};
return !$_[1] && &postgresql::get_postgresql_version() >= 7 ? "'$pass'" : $pass;
}

# modify_postgres(&domain, &olddomain)
# Change the PostgreSQL user's password if needed
sub modify_postgres
{
&require_postgres();
local $user = &postgres_user($_[0], 1);
local $olduser = &postgres_user($_[1]);
if ($_[0]->{'pass'} ne $_[1]->{'pass'} &&
    !$_[0]->{'parent'} && !$config{'postgres_nopass'}) {
	# Change PostgreSQL password ..
	local $pass = &postgres_pass($_[0]);
	local $oldpass = &postgres_pass($_[1]);
	&$first_print($text{'save_postgrespass'});
	if (&postgres_user_exists($_[1])) {
		&postgresql::execute_sql_logged($qconfig{'basedb'}, "alter user \"$olduser\" with password $pass");
		&$second_print($text{'setup_done'});
		}
	else {
		&$second_print($text{'save_nopostgres'});
		}
	}
if ($_[0]->{'user'} ne $_[1]->{'user'} && !$_[0]->{'parent'}) {
	# Rename PostgreSQL user ..
	&$first_print($text{'save_postgresuser'});
	if (&postgres_user_exists($_[1])) {
		if (&postgresql::get_postgresql_version() >= 7.4) {
			# Can use proper rename command
			&postgresql::execute_sql_logged($qconfig{'basedb'}, "alter user \"$olduser\" rename to \"$user\"");
			$_[0]->{'postgres_user'} = $user;
			&$second_print($text{'setup_done'});
			}
		else {
			# Cannot
			&$second_print($text{'save_norename'});
			}
		}
	else {
		&$second_print($text{'save_nopostgres'}." ".$_[1]->{'user'});
		}
	}
}

# delete_postgres(&domain)
# Delete the PostgreSQL database and user
sub delete_postgres
{
# Delete all databases
&require_postgres();
&delete_postgres_database($_[0], split(/\s+/, $_[0]->{'db_postgres'}))
	if ($_[0]->{'db_postgres'});
local $user = &postgres_user($_[0]);

if (!$_[0]->{'parent'}) {
	# Delete the user
	&$first_print($text{'delete_postgresuser'});
	if (&postgres_user_exists($_[0])) {
		&postgresql::execute_sql_logged($qconfig{'basedb'}, "drop user \"$user\"");
		&$second_print($text{'setup_done'});
		}
	else {
		&$second_print($text{'save_nopostgres'});
		}
	}
}

# disable_postgres(&domain)
# Invalidate the domain's PostgreSQL user
sub disable_postgres
{
&$first_print($text{'disable_postgres'});
local $user = &postgres_user($_[0]);
if ($_[0]->{'parent'}) {
	&$second_print($text{'save_nopostgrespar'});
	}
elsif (&postgres_user_exists($_[0])) {
	&require_postgres();
	local $date = localtime(0);
	&postgresql::execute_sql_logged($qconfig{'basedb'}, "alter user \"$user\" valid until '$date'");
	&$second_print($text{'setup_done'});
	}
else {
	&$second_print($text{'save_nopostgres'});
	}
}

# enable_postgres(&domain)
# Validate the domain's PostgreSQL user
sub enable_postgres
{
&$first_print($text{'enable_postgres'});
local $user = &postgres_user($_[0]);
if ($_[0]->{'parent'}) {
	&$second_print($text{'save_nopostgrespar'});
	}
elsif (&postgres_user_exists($_[0])) {
	&require_postgres();
	&postgresql::execute_sql_logged($qconfig{'basedb'}, "alter user \"$user\" valid until 'Jan 1 2038'");
	&$second_print($text{'setup_done'});
	}
else {
	&$second_print($text{'save_nopostgres'});
	}
}

# backup_postgres(&domain, file)
# Dumps this domain's postgreSQL database to a backup file
sub backup_postgres
{
&require_postgres();

# Find all the domains's databases
local @dbs = split(/\s+/, $_[0]->{'db_postgres'});

# Create empty 'base' backup file
open(EMPTY, ">$_[1]");
close(EMPTY);

# Back them all up
local $db;
foreach $db (@dbs) {
	&$first_print(&text('backup_postgresdump', $db));
	local $dbfile = $_[1]."_".$db;
	&foreign_require("proc", "proc-lib.pl");
	local $pass = &tempname();
	open(PASS, ">$pass");
	print PASS "$postgresql::postgres_pass\n";
	close(PASS);
	local $cmd = $postgresql::config{'dump_cmd'}.
	     ($postgresql::postgres_login ?
		" -U $postgresql::postgres_login" : "").
	     ($postgresql::config{'host'} ?
		" -h $postgresql::config{'host'}" : "").
	     " -F c -b -f ".quotemeta($dbfile)." ".quotemeta($db).
	     " 2>&1 <$pass";
	local $out = `$cmd`;
	unlink($pass);
	if ($?) {
		&$second_print(&text('backup_postgresdumpfailed', "<pre>$out</pre>"));
		return 0;
		}
	else {
		&$second_print($text{'setup_done'});
		}
	}
return 1;
}

# restore_postgres(&domain, file)
# Restores this domain's postgresql database from a backup file, and re-creates
# the postgresql user.
sub restore_postgres
{
&require_postgres();
&foreign_require("proc", "proc-lib.pl");
&$first_print($text{'restore_postgresdrop'});
	{
	local $first_print = \&null_print;	# supress messages
	local $second_print = \&null_print;
	&require_mysql();

	# First clear out the databases
	&delete_postgres($_[0]);

	# Now re-set up the user only
	&setup_postgres($_[0], 1);
	}
&$second_print($text{'setup_done'});

# Work out which databases are in backup
local ($dbfile, @dbs);
push(@dbs, [ $_[0]->{'db'}, $_[1] ]) if (-s $_[1]);
foreach $dbfile (glob("$_[1]_*")) {
	if (-r $dbfile) {
		$dbfile =~ /\Q$_[1]\E_(.*)$/;
		push(@dbs, [ $1, $dbfile ]);
		}
	}

# Finally, import the data
local $db;
foreach $db (@dbs) {
	&create_postgres_database($_[0], $db->[0]);
	&$first_print(&text('restore_postgresload', $db->[0]));
	local $pass = &tempname();
	open(PASS, ">$pass");
	print PASS "$postgresql::postgres_pass\n";
	close(PASS);
	local $cmd = $postgresql::config{'rstr_cmd'}.
	     ($postgresql::postgres_login ?
		" -U $postgresql::postgres_login" : "").
	     ($postgresql::config{'host'} ?
		" -h $postgresql::config{'host'}" : "").
	     " -d ".quotemeta($db->[0])." ".quotemeta($db->[1])." <$pass 2>&1";
	local $out = &backquote_logged($cmd);
	unlink($pass);
	if ($? || $out =~ /failed|fatal/i) {
		&$second_print(&text('restore_mysqlloadfailed', "<pre>$out</pre>"));
		return 0;
		}
	else {
		&$second_print($text{'setup_done'});
		}
	}
return 1;
}

# postgres_user(&domain, [always-new])
sub postgres_user
{
return defined($_[0]->{'postgres_user'}) && !$_[1] ?
	$_[0]->{'postgres_user'} : $_[0]->{'user'}; 
}

sub postgres_size
{
&require_postgres();
local $size;
local $d = &postgresql::execute_sql($_[1], "select sum(relpages) from pg_class where relname not like 'pg_%'");
$size = $d->{'data'}->[0]->[0]*1024*2;
local @tables = &postgresql::list_tables($_[1], 1);
return ($size, scalar(@tables));
}

# check_postgres_database_clash(&domain, db)
# Returns 1 if some database name is already in use
sub check_postgres_database_clash
{
&require_postgres();
local @dblist = &postgresql::list_databases();
return 1 if (&indexof($_[1], @dblist) >= 0);
}

# create_postgres_database(&domain, db)
# Create one PostgreSQL database
sub create_postgres_database
{
&$first_print(&text('setup_postgresdb', $_[1]));
&require_postgres();
local $user = &postgres_user($_[0]);
local $owner = &postgresql::get_postgresql_version() >= 7 ?
		"with owner=\"$user\"" : "";
&postgresql::execute_sql_logged($qconfig{'basedb'}, "create database $_[1] $owner");
local @dbs = split(/\s+/, $_[0]->{'db_postgres'});
push(@dbs, $_[1]);
$_[0]->{'db_postgres'} = join(" ", @dbs);
&$second_print($text{'setup_done'});
}

# delete_postgres_database(&domain, dbname, ...)
# Delete one PostgreSQL database
sub delete_postgres_database
{
&require_postgres();
local @dblist = &postgresql::list_databases();
&$first_print(&text('delete_postgresdb', join(", ", @_[1..$#_])));
local @dbs = split(/\s+/, $_[0]->{'db_postgres'});
local $db;
foreach $db (@_[1..$#_]) {
	if (&indexof($db, @dblist) >= 0) {
		&postgresql::execute_sql_logged($qconfig{'basedb'}, "drop database $db");
		}
	@dbs = grep { $_ ne $db } @dbs;
	}
&$second_print($text{'setup_done'});
$_[0]->{'db_postgres'} = join(" ", @dbs);
}

1;

