/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "iconloader.h"

#include <QPixmapCache>
#include <QPainter>
#include <QFile>

using namespace WebIssues;

QPixmap IconLoader::pixmap( const QString& name, int size )
{
    QString key = QString( "pixmap:%1:%2" ).arg( name ).arg( size );

    QPixmap pixmap;
    if ( QPixmapCache::find( key, pixmap ) )
        return pixmap;

    QString path = QString( ":/icons/%1-%2.png" ).arg( name ).arg( size );

    pixmap = QPixmap( path );

    if ( !pixmap.isNull() )
        QPixmapCache::insert( key, pixmap );

    return pixmap;
}

QPixmap IconLoader::overlayedPixmap( const QString& name, const QString& overlay, int size )
{
    QString key = QString( "overlayed:%1:%2:%3" ).arg( name ).arg( overlay ).arg( size );

    QPixmap resultPixmap;
    if ( QPixmapCache::find( key, resultPixmap ) )
        return resultPixmap;

    QPixmap basePixmap = pixmap( name, size );
    QPixmap overlayPixmap = pixmap( overlay, size );

    resultPixmap = QPixmap( size, size );
    resultPixmap.fill( QColor( 0, 0, 0, 0 ) );

    QPainter painter( &resultPixmap );
    painter.drawPixmap( 0, 0, basePixmap );
    painter.drawPixmap( 0, 0, overlayPixmap );

    QPixmapCache::insert( key, resultPixmap );

    return resultPixmap;
}

QIcon IconLoader::icon( const QString& name )
{
    QIcon icon;

    const int sizes[ 4 ] = { 16, 22, 32, 48 };

    for ( int i = 0; i < 4; i++ ) {
        QString path = QString( ":/icons/%1-%2.png" ).arg( name ).arg( sizes[ i ] );

        if ( QFile::exists( path ) )
            icon.addFile( path, QSize( sizes[ i ], sizes[ i ] ) );
    }

    return icon;
}
