<?php
/**************************************************************************
* This file is part of the WebIssues Server program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

function wi_mail_send( $from, $to, $subject, $body, $content_type )
{
    $headers = array();
    $headers[ 'MIME-Version' ] = '1.0';
    $headers[ 'Content-Type' ] = $content_type . '; charset=UTF-8';
    $headers[ 'Content-Transfer-Encoding' ] = '8Bit';
    $headers[ 'X-Mailer' ] = 'WebIssues Server';
    if ( !empty( $from ) ) {
        $headers[ 'From' ] = $from;
        $headers[ 'Reply-To' ] = $from;
        $headers[ 'Sender' ] = $from;
        $headers[ 'Return-Path' ] = $from;
        $headers[ 'Errors-To' ] = $from;
    }

    $subject = wi_mime_header_encode( $subject );
    $headers = wi_format_headers( $headers );

    $body = str_replace( "\r", '', $body );

    return mail( $to, $subject, $body, $headers );
}
