// Opens the URL in a new tab
function webdeveloper_openURL(urlElement)
{
		var parentWindow = null;
		var url          = urlElement.firstChild.nodeValue;
	
		// If there is a parent window
		if(window.opener)
		{
			// If there is a grand parent window and it has the extension menu
			if(window.opener.opener && window.opener.opener.document.getElementById("webdeveloper-menu"))
			{
				parentWindow = window.opener.opener;
			}
			else
			{
				parentWindow = window.opener;
			}
		}

    // If a parent window was found
    if(parentWindow)
    {
        // If the open in windows preference is set to true
        if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs", true))
        {
						try
						{
		            var newTab = parentWindow.getBrowser().addTab(url);
		
		            // If the open tabs in background preference is not set or is set to false
		            if(!webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
		            {
		                parentWindow.getBrowser().selectedTab = newTab;
		            }
						}
						catch(exception)
						{
		            parentWindow.open(url);
						}
        }
        else
        {
            parentWindow.open(url);
        }

        window.close();
    }
}
