// Creates the element information block
function webdeveloper_createElementInformationBlock(ownerDocument)
{
    var definitionElement = ownerDocument.createElement("dd");
    var divElement        = ownerDocument.createElement("div");
    var headerElement     = ownerDocument.createElement("h2");
    var listElement       = ownerDocument.createElement("dl");
    var stringBundle      = document.getElementById("webdeveloper-string-bundle");
    var termElement       = ownerDocument.createElement("dt");

    headerElement.addEventListener("mousedown", webdeveloper_selectElementInformation, true);
    headerElement.addEventListener("mouseup", webdeveloper_deselectElementInformation, true);
    headerElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_elementInformation")));
    divElement.appendChild(headerElement);

    termElement.addEventListener("click", webdeveloper_toggleElementInformationBlock, true);
    termElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_attributes")));
    definitionElement.setAttribute("id", "webdeveloper-element-information-attributes");
    listElement.appendChild(termElement);
    listElement.appendChild(definitionElement);
    divElement.appendChild(listElement);

    definitionElement = ownerDocument.createElement("dd");
    listElement       = ownerDocument.createElement("dl");
    termElement       = ownerDocument.createElement("dt");

    termElement.addEventListener("click", webdeveloper_toggleElementInformationBlock, true);
    termElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_position")));
    definitionElement.setAttribute("id", "webdeveloper-element-information-position");
    listElement.appendChild(termElement);
    listElement.appendChild(definitionElement);
    divElement.appendChild(listElement);

    definitionElement = ownerDocument.createElement("dd");
    listElement       = ownerDocument.createElement("dl");
    termElement       = ownerDocument.createElement("dt");

    termElement.addEventListener("click", webdeveloper_toggleElementInformationBlock, true);
    termElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_other")));
    definitionElement.setAttribute("id", "webdeveloper-element-information-other");
    listElement.appendChild(termElement);
    listElement.appendChild(definitionElement);
    divElement.appendChild(listElement);

    definitionElement = ownerDocument.createElement("dd");
    listElement       = ownerDocument.createElement("dl");
    termElement       = ownerDocument.createElement("dt");

    termElement.addEventListener("click", webdeveloper_toggleElementInformationBlock, true);
    termElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_ancestors")));
    definitionElement.setAttribute("id", "webdeveloper-element-information-ancestors");
    listElement.appendChild(termElement);
    listElement.appendChild(definitionElement);
    divElement.appendChild(listElement);

    definitionElement = ownerDocument.createElement("dd");
    listElement       = ownerDocument.createElement("dl");
    termElement       = ownerDocument.createElement("dt");

    termElement.addEventListener("click", webdeveloper_toggleElementInformationBlock, true);
    termElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_children")));
    definitionElement.setAttribute("id", "webdeveloper-element-information-children");
    listElement.appendChild(termElement);
    listElement.appendChild(definitionElement);
    divElement.appendChild(listElement);

    divElement.setAttribute("id", "webdeveloper-element-information");
    ownerDocument.body.appendChild(divElement);
}

// Called when the element information is deselected
function webdeveloper_deselectElementInformation(event)
{
    webdeveloper_elementInformationBlockSelected = false;
}

// Displays information about the element
function webdeveloper_displayElementInformation(element, applyStyle)
{
    var checked         = true;
    var contentDocument = webdeveloper_getContentDocument();
    var contentWindow   = webdeveloper_getContentWindow();
    var divElement      = null;
    var documentList    = webdeveloper_getDocuments(contentWindow);
    var documentLength  = documentList.length;
    var leftOffset      = contentWindow.pageXOffset;
    var pageDocument    = null;
    var topOffset       = contentWindow.pageYOffset;

    // If the element is set
    if(element)
    {
        checked = element.getAttribute("checked");
    }
    else
    {
        var currentDocument = contentWindow.document;

        element = document.getElementById("webdeveloper-display-element-information-menu");

        // If the display element information element is set
        if(currentDocument.getElementById("webdeveloper-display-element-information"))
        {
            checked = false;
        }

        webdeveloper_configureElement(element, "checked", checked);
    }

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];

        // If displaying element information
        if(checked)
        {
            webdeveloper_createElementInformationBlock(pageDocument);

            // If this is the content document
            if(pageDocument == contentDocument)
            {
                divElement = pageDocument.getElementById("webdeveloper-element-information");

                // If the div element was found
                if(divElement)
                {
                    divElement.style.left = (leftOffset + 5) + "px";
                    divElement.style.top  = (topOffset + 5) + "px";
                }
            }

            pageDocument.addEventListener("mousemove", webdeveloper_moveElementInformation, true);
        }
        else
        {
            divElement = pageDocument.getElementById("webdeveloper-element-information");

            // Try to remove the event listener
            try
            {
                pageDocument.removeEventListener("mousemove", webdeveloper_moveElementInformation, true);
            }
            catch(exception)
            {
                // Do nothing
            }

            webdeveloper_removeElementOutline(webdeveloper_informationElement);

            // If the div element was found
            if(divElement)
            {
                divElement.parentNode.removeChild(divElement);
            }
        }
    }

    // If not displaying element information
    if(!checked)
    {
        webdeveloper_elementInformationBlockSelected = false;
        webdeveloper_informationElement              = null;
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_element_information.css", "webdeveloper-display-element-information", applyStyle);
}

// Displays information about the specific element
function webdeveloper_displayElementInformationForElement(event)
{
    var element = event.target;

    // If the element is set and is not the same as the current information element
    if(element && element != webdeveloper_informationElement)
    {
        var elementName   = element.tagName;
        var ownerDocument = element.ownerDocument;

        // If the element has a name and it is not scrollbar and it has an owner document
        if(elementName && elementName != "scrollbar" && ownerDocument)
        {
            var divElement = ownerDocument.getElementById("webdeveloper-element-information");

            // If the div element was found
            if(divElement)
            {
                // If the element is not the div element and the div element is not an ancestor of the element
                if(element != divElement && !webdeveloper_isAncestor(element, divElement))
                {
                    var definitionElement = ownerDocument.getElementById("webdeveloper-element-information-attributes");
                    var headerElements    = divElement.getElementsByTagName("h2");
                    var pElement          = null;
                    var stringBundle      = document.getElementById("webdeveloper-string-bundle");
                    var tableElement      = null;
                    var tableCellElement  = null;
                    var tableRowElement   = null;

                    webdeveloper_removeElementOutline(webdeveloper_informationElement);

                    // If header elements were found
                    if(headerElements.length > 0)
                    {
                        var headerElement = headerElements[0];

                        // If the header element is set
                        if(headerElement)
                        {
                            webdeveloper_removeAllChildNodes(headerElement);

                            headerElement.appendChild(ownerDocument.createTextNode(webdeveloper_getElementDescription(element)));
                        }
                    }

                    // If the definition element is set
                    if(definitionElement)
                    {
                        var elementAttribute        = null;
                        var elementAttributes       = element.attributes;
                        var elementAttributesLength = elementAttributes.length;

                        webdeveloper_removeAllChildNodes(definitionElement);

                        // If there are no attributes
                        if(elementAttributesLength == 0)
                        {
                            definitionElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_none")));
                        }
                        else
                        {
                            // Loop through the attributes
                            for(var i = 0; i < elementAttributesLength; i++)
                            {
                                elementAttribute = elementAttributes[i];
                                pElement         = ownerDocument.createElement("p");

                                pElement.appendChild(ownerDocument.createTextNode(elementAttribute.name + " = " + elementAttribute.value));
                                definitionElement.appendChild(pElement);
                            }
                        }
                    }

                    definitionElement = ownerDocument.getElementById("webdeveloper-element-information-position");

                    // If the definition element is set
                    if(definitionElement)
                    {
                        tableElement     = ownerDocument.createElement("table");
                        tableCellElement = ownerDocument.createElement("td");
                        tableRowElement  = ownerDocument.createElement("tr");

                        webdeveloper_removeAllChildNodes(definitionElement);

                        tableCellElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_left") + ": " + webdeveloper_getElementPositionX(element) + "px"));
                        tableRowElement.appendChild(tableCellElement);

                        tableCellElement = ownerDocument.createElement("td");
                        tableCellElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_top") + ": " + webdeveloper_getElementPositionY(element) + "px"));
                        tableRowElement.appendChild(tableCellElement);
                        tableElement.appendChild(tableRowElement);

                        tableCellElement = ownerDocument.createElement("td");
                        tableRowElement  = ownerDocument.createElement("tr");
                        tableCellElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_width") + ": " + element.clientWidth + "px"));
                        tableRowElement.appendChild(tableCellElement);

                        tableCellElement = ownerDocument.createElement("td");
                        tableCellElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_height") + ": " + element.clientHeight + "px"));
                        tableRowElement.appendChild(tableCellElement);
                        tableElement.appendChild(tableRowElement);
                        definitionElement.appendChild(tableElement);
                    }

                    definitionElement = ownerDocument.getElementById("webdeveloper-element-information-other");

                    // If the definition element is set
                    if(definitionElement)
                    {
                        var fontFamily = element.ownerDocument.defaultView.getComputedStyle(element, null).getPropertyCSSValue("font-family");
                        var fontSize   = element.ownerDocument.defaultView.getComputedStyle(element, null).getPropertyCSSValue("font-size");

                        tableElement    = ownerDocument.createElement("table");

                        webdeveloper_removeAllChildNodes(definitionElement);

                        // If this element has a font family
                        if(fontFamily)
                        {
                            tableCellElement = ownerDocument.createElement("td");
                            tableRowElement = ownerDocument.createElement("tr");
                            tableCellElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_fontFamily") + ":"));
                            tableRowElement.appendChild(tableCellElement);

                            tableCellElement = ownerDocument.createElement("td");
                            tableCellElement.appendChild(ownerDocument.createTextNode(fontFamily.cssText));
                            tableRowElement.appendChild(tableCellElement);
                            tableElement.appendChild(tableRowElement);
                        }

                        // If this element has a font size
                        if(fontSize)
                        {
                            tableCellElement = ownerDocument.createElement("td");
                            tableRowElement = ownerDocument.createElement("tr");
                            tableCellElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_fontSize") + ":"));
                            tableRowElement.appendChild(tableCellElement);

                            tableCellElement = ownerDocument.createElement("td");
                            tableCellElement.appendChild(ownerDocument.createTextNode(fontSize.cssText));
                            tableRowElement.appendChild(tableCellElement);
                            tableElement.appendChild(tableRowElement);
                        }

                        // If the table has child nodes
                        if(tableElement.hasChildNodes())
                        {
                            definitionElement.appendChild(tableElement);
                        }
                    }

                    definitionElement = ownerDocument.getElementById("webdeveloper-element-information-ancestors");

                    // If the definition element is set
                    if(definitionElement)
                    {
                        var ancestorList   = webdeveloper_getElementAncestors(element);
                        var ancestorLength = ancestorList.length;

                        webdeveloper_removeAllChildNodes(definitionElement);

                        // If there are no ancestors
                        if(ancestorLength == 0)
                        {
                            definitionElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_none")));
                        }
                        else
                        {
                            // Loop through the ancestors
                            for(i = 0; i < ancestorLength; i++)
                            {
                                pElement = ownerDocument.createElement("p");

                                pElement.appendChild(ownerDocument.createTextNode(webdeveloper_getElementDescription(ancestorList[i])));
                                definitionElement.appendChild(pElement);
                            }
                        }
                    }

                    definitionElement = ownerDocument.getElementById("webdeveloper-element-information-children");

                    // If the definition element is set
                    if(definitionElement)
                    {
                        var children    = webdeveloper_getElementChildren(element);
                        var childLength = children.length;

                        webdeveloper_removeAllChildNodes(definitionElement);

                        // If there are no children
                        if(childLength == 0)
                        {
                            definitionElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_none")));
                        }
                        else
                        {
                            // Loop through the children
                            for(i = 0; i < childLength; i++)
                            {
                                pElement = ownerDocument.createElement("p");

                                pElement.appendChild(ownerDocument.createTextNode(webdeveloper_getElementDescription(children[i])));
                                definitionElement.appendChild(pElement);
                            }
                        }
                    }

                    webdeveloper_informationElement                  = element;
                    webdeveloper_informationElement.style.MozOutline = "1px solid #ff0000";

                    // Force the style sheet to refresh
                    divElement.setAttribute("class", "force-width");
                    divElement.removeAttribute("class");
                }
            }
        }
    }
}

// Called when the element information is moved
function webdeveloper_moveElementInformation(event)
{
    // If the element information block is selected
    if(webdeveloper_elementInformationBlockSelected)
    {
        webdeveloper_moveElementInformationBlock(event);
    }
    else
    {
        webdeveloper_displayElementInformationForElement(event);
    }
}

// Move the element information block
function webdeveloper_moveElementInformationBlock(event)
{
    var element = event.target;

    // If the element is set
    if(element)
    {
        var ownerDocument = element.ownerDocument;

        // If the target has an owner document
        if(ownerDocument)
        {
            var divElement = ownerDocument.getElementById("webdeveloper-element-information");

            // If the div element was found
            if(divElement)
            {
                divElement.style.left = (event.pageX - 5) + "px";
                divElement.style.top  = (event.pageY - 5) + "px";
            }
        }
    }
}

// Called when the element information is selected
function webdeveloper_selectElementInformation(event)
{
    // If the click was not a right click
    if(event.button != 2)
    {
        webdeveloper_elementInformationBlockSelected = true;
    }
}

// Toggles an element information block
function webdeveloper_toggleElementInformationBlock(event)
{
    var element = event.target;

    // If there is a target element
    if(element)
    {
        // If the element has a class attribute
        if(element.hasAttribute("class"))
        {
            element.removeAttribute("class");
        }
        else
        {
            element.setAttribute("class", "collapsed");
        }
    }
}
