// Gets the size of a file
function webdeveloper_getFileSize(url)
{
    var cacheService = Components.classes["@mozilla.org/network/cache-service;1"].getService(Components.interfaces.nsICacheService);
    var cacheSession = null;
    var file         = null;
    var fileSize     = null;
    var readAccess   = Components.interfaces.nsICache.ACCESS_READ;

    // Try to get the file size from the HTTP cache
    try
    {
        cacheSession                      = cacheService.createSession("HTTP", 0, true);
        cacheSession.doomEntriesIfExpired = false;
        file                              = cacheSession.openCacheEntry(url, readAccess, false);

        // If there is a file
        if(file)
        {
            fileSize = file.dataSize;
        }
    }
    catch(exception)
    {
        // Try to get the file size from the FTP cache
        try
        {
            cacheSession                      = cacheService.createSession("FTP", 0, true);
            cacheSession.doomEntriesIfExpired = false;
            file                              = cacheSession.openCacheEntry(url, readAccess, false);

            // If there is a file
            if(file)
            {
                fileSize = file.dataSize;
            }
        }
        catch(exception)
        {
            fileSize = null;
        }
    }

    // If the file size could not be retrieved from the cache
    if(!fileSize)
    {
        var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);

        // Try to download the file
        try
        {
            fileSize = ioService.newChannelFromURI(ioService.newURI(url, null, null)).open().available();
        }
        catch(exception)
        {
            fileSize = null;
        }
    }

    return fileSize;
}

// Retrieves the source from the given URL
function webdeveloper_retrieveSource(url)
{
    var source = null;

    // If the URL is not entirely generated
    if(url.indexOf("wyciwyg://") != 0)
    {
        // Try to get the file from the cache
        try
        {
            var httpCacheSession = Components.classes["@mozilla.org/network/cache-service;1"].getService(Components.interfaces.nsICacheService).createSession("HTTP", 0, true);
            var descriptor       = httpCacheSession.openCacheEntry(url, Components.interfaces.nsICache.ACCESS_READ, false);

            // If there is a descriptor
            if(descriptor)
            {
                var file = descriptor.file;

                // If the file is set and it exists, is a file and is readable
                if(file && file.exists() && file.isFile() && file.isReadable())
                {
                    var inputStream      = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
                    var scriptableStream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);

                    inputStream.init(file, 0x01, 0444, null);
                    scriptableStream.init(inputStream);

                    source = scriptableStream.read(scriptableStream.available());

                    scriptableStream.close();
                    inputStream.close();
                }
            }
        }
        catch(exception)
        {
            source = null;
        }

        // If the source has not been loaded
        if(!source)
        {
            // Try to load the URL
            try
            {
                var request = new XMLHttpRequest();

                request.open("get", url, false);
                request.send("");

                source = request.responseText;
            }
            catch(exception)
            {
                source = null;
            }
        }
    }

    return source;
}
