/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#if STDC_HEADERS
# include <string.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr (), *strrchr ();
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif
#ifdef HAVE_DMALLOC_H
#include <dmalloc.h>
#endif /* HAVE_DMALLOC_H */

#include <salloc.h>

static char base64_table[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

char *base64_encode(char* string)
{
  static char *tostring = 0;
  static int tostring_size = 0;
  static char *fromstring = 0;
  static int fromstring_size = 0;
  int string_length = strlen(string);
  int from=0;
  int to=0;

  static_alloc(&tostring, &tostring_size, (string_length / 3 + 1) * 4 + 1);
  memset(tostring , '\0' , (string_length / 3 + 1) * 4 + 1);
  static_alloc(&fromstring, &fromstring_size, string_length + 3);
  memset(fromstring , '\0' , string_length + 3);
  strcpy(fromstring,string);

  while(fromstring[from]) {
    if (from % 3 == 0)
      {
	tostring[to] = base64_table[(int)(fromstring[from] >> 2)];
	to ++;
      }
    else if (from % 3 == 1)
      {
	tostring[to] = base64_table[(int)
				   (((fromstring[from - 1] << 4) & 0x30) | 
				    ((fromstring[from] >> 4) & 0x0f))];
	to ++;
			
	tostring[to] = base64_table[(int)
				   (((fromstring[from] << 2) & 0x3c) | 
				    ((fromstring[from + 1] >> 6) & 0x03)) ];
	to ++;
      }
    else
      {
	tostring[to] = base64_table[(int)(fromstring[from] & 0x3f)];
	to ++;
      }
    from ++;
  }
  if (from % 3 == 1) {
    tostring[to] = base64_table[(int)
			       (((fromstring[from - 1] << 4) & 0x30) | 
				((fromstring[from] >> 4) & 0x0f))];
    tostring[to+1] = '=';
    tostring[to+2] = '=';
  }
  if (from % 3 == 2)
      tostring[to] = '=';
	
  return tostring;
}
