/*
 *   Copyright (C) 2000 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _server_h
#define _server_h

#include <khash.h>
#include <webbase_hook.h>

typedef struct webbase webbase_t;
typedef struct server_entry server_entry_t;

typedef struct server {
  /* Map netloc to regular expression used to extract the server part. */
  hash_t* netloc2re;
  /* True if has a non empty home_re table. */
  int netloc2re_filled;
  /* The default regexp to apply if the netloc does not show in netloc2re. */
  server_entry_t* default_re;
  /* The pool of server_entries pointed to by netloc2re. */
  server_entry_t* entries;
  int entries_length;
  /* Function table that may override some server functions. */
  webbase_hook_params_t* hook;
  /* Database context. */
  webbase_t* base;
} server_t;

#define SERVER_OPTIONS		0x0020000

/*
 * Return the list of options suported by the server module.
 */
struct option* server_options(struct option []);
struct option_help* server_help_options(struct option_help []);

/*
 * Create/destroy server object
 */
server_t* server_alloc(int argc, char** argv, struct option options[]);
void server_free(server_t* params);

/*
 * Load the home_re table in memory.
 */
int server_load_re(server_t* params);
/*
 * Register hook 
 */
int server_hook(server_t* params, webbase_hook_params_t* hook);
/*
 * Map server string to server id
 */
int server_id(server_t* params, const char* url);
/*
 * Add a server to the list of known servers
 */
int server_add(server_t* params, const char* url);
/*
 * Remove a server from the list of known servers
 */
int server_remove(server_t* params, const char* url);

#endif /* _server_h */
