// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1994
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        chlookup.C
// 
// Purpose:     
// 
// Created:     2 Nov 95   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// 
// </file> 
#include "chlookup.h"

#if (!(defined(SUN)&&HG_OSMaj==4))
Arraysimplement (ChildLookup, DChildHandler) ;
#else

#include <sys/mman.h>

#include <hyperg/utils/assert.h>
#include <hyperg/utils/verbose.h>

static int pagesize = 4096 ;

Arraysimplement (ChildLookupBase, DChildHandler) ;

ChildLookup :: ChildLookup() {
   ::mprotect (this, pagesize, PROT_READ) ;
}

ChildLookup :: ~ChildLookup() {
   ::mprotect (this, pagesize, PROT_READ|PROT_WRITE) ;
}

bool ChildLookup :: insert (const DChildHandler& h) {
   DEBUGNL ("ChildLookup::insert()") ;
   ::mprotect (this, pagesize, PROT_READ|PROT_WRITE) ;
   bool rv = ChildLookupBase::insert (h) ;
   ::mprotect (this, pagesize, PROT_READ) ;
   return rv ;
}

bool ChildLookup :: remove (const DChildHandler& h) {
   DEBUGNL ("ChildLookup::remove()") ;
   ::mprotect (this, pagesize, PROT_READ|PROT_WRITE) ;
   bool rv = ChildLookupBase::remove (h) ;
   ::mprotect (this, pagesize, PROT_READ) ;
   return  rv ;
}

void* ChildLookup :: operator new (size_t) {
   int fd = open ("/dev/zero", O_RDONLY) ;
   void* ret = ::mmap (nil, pagesize, PROT_READ|PROT_WRITE, MAP_PRIVATE, fd, 0) ;
   close (fd) ;
   hgassert (ret>0, "ChildLookup::operator new(): ::mmap failed") ;
   return ret ;
}

void ChildLookup :: operator delete (void* p, size_t) {
   int ret = ::munmap (p, pagesize) ;
}


#endif
