/*
 * virtualconsoles.h: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */


#ifndef __VIRTUALCONSOLES_H__
#define __VIRTUALCONSOLES_H__


#include <sys/ioctl.h>
#include <termios.h>

#include <vdr/tools.h>
#include <vdr/remote.h>

#include "ipc.h"



// This program will be used to realize a console.
// Be carefull! If your VDR runs as root, then every
// user can kill your machine if you don't protect
// the cnsoles.
// So the default is "/bin/login".

#ifdef CONSOLE_USE_SHELL_INSTEAD_LOGIN
#define PROG_FOR_CONSOLE "/bin/sh"
#else
#define PROG_FOR_CONSOLE "/bin/login"
#endif




class cConsVirtualConsole;



class cConsConsoles
: public cThread
{
private:

  cList<cConsVirtualConsole> _consoles;

  int _inputActive;
  struct termios _oldTerminalSettings;

  cConsSignal _consolesChanged;
  cConsWaitableList _wait;

  volatile bool _terminate;

  int _openConsoleNr;
  int _selectConsoleNr;

private:
  virtual void Action();

public:
  cConsConsoles();
  ~cConsConsoles();

  virtual bool Start();

  void activateInputForTerminal();
  void deactivateInputForTerminal();
  void Flush(int WaitMs);
  void WantAllRefreshEvents(bool WantIt);


  int getCount() { LOCK_THREAD; return _consoles.Count(); }
  cConsVirtualConsole& getItem(int index0) { LOCK_THREAD; return *_consoles.Get(index0); }

  int CreateConsole();
  int CreateCommand(const char* title, const char* command);
  void Remove(cConsVirtualConsole* pConsole);

  static bool Active();

  // Sets or gets the number of the console to be opened in the main menu
  void SetOpenConsoleNr(int nr) {_openConsoleNr = nr;}
  int OpenConsoleNr() {return _openConsoleNr;}

  // Sets or gets the number of the console to be selected in the console list
  void SetSelectConsoleNr(int nr) {_selectConsoleNr = nr;}
  int SelectConsoleNr() {return _selectConsoleNr;}
};


extern cConsConsoles* gl_pConsConsoles;



#endif // __VIRTUALCONSOLES_H__


