#include "cs_mex.h"
/* cs_usolve: solve an upper triangular system U*x=b */
void mexFunction
(
    int nargout,
    mxArray *pargout [ ],
    int nargin,
    const mxArray *pargin [ ]
)
{
    cs Umatrix, *U ;
    double *x, *b ;
    if (nargout > 1 || nargin != 2)
    {
	mexErrMsgTxt ("Usage: x = cs_usolve(U,b)") ;
    }
    U = cs_get_sparse (&Umatrix, 1, 1, pargin [0]) ;	    /* get U */
    b = cs_get_double (U->n, pargin [1]) ;		    /* get b */
    x = cs_put_double (U->n, b, &(pargout [0])) ;	    /* x = b */
    cs_usolve (U, x) ;					    /* x = U\x */
}
