
#ifndef _RWFILTEREDITOR_H_
#define _RWFILTEREDITOR_H_

#include <vector>
#include <string>

#include <WINGs/WINGs.h>
#include <WINGs/wtableview.h>

#include "rpackagefilter.h"

struct RFilter;

class RWFilterEditor
{
private:
   struct PatternFilterItem {
       int type;
       string pattern;
       bool exclude;
   };
   
   static int numberOfRows(WMTableViewDelegate *self, WMTableView *table);
   static void *valueForCell(WMTableViewDelegate *self, 
			     WMTableColumn *column, int row);
   static void setValueForCell(WMTableViewDelegate *self, 
			       WMTableColumn *column, int row, 
			       void *data);

   static void newPatternAction(WMWidget *w, void *data);
   static void removePatternAction(WMWidget *w, void *data);
   
   static void selectedPatternRow(WMWidget *w, void *data);

   
   WMTabView *_tabview;

   WMTableViewDelegate *_tableDelegate;
   
   RFilter *_filter;

   // group/section list
   WMList *_groupL;
   WMButton *_inclGB;
   WMButton *_exclGB;

   void setSectionFilter(RSectionPackageFilter &f);
   void getSectionFilter(RSectionPackageFilter &f);

   // by status
   WMButton *_statusB[7];
   
   void setStatusFilter(RStatusPackageFilter &f);
   void getStatusFilter(RStatusPackageFilter &f);
   
   // by pattern
   WMTableView *_patT;
   WMButton *_removePB;

   vector<PatternFilterItem> _patternL;
   
   void setPatternFilter(RPatternPackageFilter &f);
   void getPatternFilter(RPatternPackageFilter &f);

   
   void makeSectionFilterPanel(WMTabView *tabview);   
   void makePatternFilterPanel(WMTabView *tabview);
   void makeStatusFilterPanel(WMTabView *tabview);

   
public:
   RWFilterEditor(WMWidget *parent);
   virtual ~RWFilterEditor();
   
   inline WMWidget *widget() { return _tabview; };

   void resetFilter();
   void editFilter(RFilter *filter);
//   void makeNewFilter();
  
   void applyChanges();

   void setPackageSections(vector<string> &sections);
};


#endif
