/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGENTRYLVI_H
#define _SC_LOGENTRYLVI_H

// sc
#include "svn/LogEntryTypes.h"

// qt
#include <qlistview.h>


class LogEntryLvi : public QListViewItem
{
  typedef QListViewItem super;

public:
  LogEntryLvi( QListView* parent, const svn::LogEntryPtr entry );
  virtual ~LogEntryLvi();

  QString text( int column ) const;
  QString key( int column, bool ascending ) const;
  int compare( QListViewItem* i, int col, bool ascending ) const;

  const svn::LogEntryPtr getLogEntry() const;

private:
  const svn::LogEntryPtr _entry;
};

#endif // _SC_LOGENTRYLVI_H
