from unittest import makeSuite

from base import SquishdotBase

import re

class MailTests(SquishdotBase):

    def _mail(self,Posting):
        Site = self.Site
        mail =Site.mail_html(Site,
                             Site.REQUEST,
                             newItem=Posting,
                             email='test@address.com')
        f = open('%s.mailre' % Posting.title,'r')
        mailre = re.compile('^%s$' % f.read())
        f.close()
        assert mailre.match(mail)
        

    def testMailHTMLArticle(self):
        "Check HTML Article Mailing"
        
        id = self._addPosting(title    = 'testMailHTMLArticle',
                              author   = 'tester',
                              body     = '<b>body</b><br><i>italic</i>',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'HTML',
                              subject  = 'test subject',
                              summary  = '<hr>summary<p>no way</p>',
                              dept     = 'dept')
        
        self._mail(self.Site[id])
        
    def testMailPlainArticle(self):
        "Check Plain Article Mailing"
        
        id = self._addPosting(title    = 'testMailPlainArticle',
                              author   = 'tester',
                              body     = '<b>body</b><br><i>italic</i>',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain',
                              subject  = 'test subject',
                              summary  = '<hr>summary<p>no way</p>',
                              dept     = 'dept')
        
        self._mail(self.Site[id])

    def testMailHTMLComment(self):
        "Check HTML Comment Mailing"
        
        parent = self._getPosting()
        
        id = self._addPosting(object   = parent,
                              title    = 'testMailHTMLComment',
                              author   = 'tester',
                              body     = '<b>body</b><br><i>italic</i>',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'HTML')
        
        self._mail(self.Site[parent.getId()][id])

    def testMailPlainComment(self):
        "Check Plain Comment Mailing"
        
        parent = self._getPosting()
        
        id = self._addPosting(object   = parent,
                              title    = 'testMailPlainComment',
                              author   = 'tester',
                              body     = '<b>body</b><br><i>italic</i>',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain')
        
        self._mail(self.Site[parent.getId()][id])

def test_suite():
    return makeSuite(MailTests)

def debug():
   test_suite().debug()
    
