/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "../src/libraries.h"
#include "../src/utilities.h"
#include "../src/constants.h"


/*
This converter reads from stdin and writes to stdout.
The input file is a .vrs file from Paratext.
The output file is a versification file as used in scripturechecks.
*/


int main (int argc, char *argv[])
{
  cout << "<" << VERSIFICATION_TAG << " name=\"Original\">" << endl;
  GIOChannel* io;
  gchar* text;
  gsize length;
  io = g_io_channel_unix_new (0);
  while (g_io_channel_read_line (io, &text, &length, NULL, NULL) == G_IO_STATUS_NORMAL) {
    ustring utext (text);
    utext = trim (utext);
    g_free (text);
    if (utext.empty())
      continue;
    if (utext.substr (0, 1) == "#")
      continue;
    ustring book = utext.substr (0, 3);
    utext.erase (0, 4);
    book = id_to_biblebook_english (book);
    cout << "  <" << BOOK_TAG << " name=\"" << book << "\">" << endl;
    Parse parse (utext, false);
    for (unsigned int i = 0; i < parse.words.size(); i++) {
      ustring chapter;
      ustring highverse;
      size_t position;
      position = parse.words[i].find(":");
      chapter = parse.words[i].substr (0, position);
      parse.words[i].erase (0, ++position);
      highverse = parse.words[i];
      cout << xml_tag (2, LIMIT_TAG, false) << endl;
      cout << xml_text_embed_in_tags (3, CHAPTER_TAG, chapter) << endl;
      cout << xml_text_embed_in_tags (3, VERSE_TAG, highverse) << endl;
      cout << xml_tag (2, LIMIT_TAG, true) << endl;
    }
    cout << xml_tag (1, BOOK_TAG, true) << endl;
  }
  g_io_channel_unref (io);     
  cout << xml_tag (0, VERSIFICATION_TAG, true) << endl;
  return 0;
}
