/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Fre Apr  6 21:47:55 CEST 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qapplication.h>
#include <qfont.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qtranslator.h>
#include <qplatinumstyle.h>
#include <qfileinfo.h>
#include <qtextcodec.h>
#include "scribus.h"
#include "config.h"
#include "iostream.h"

int main(int argc, char *argv[])
{
  QString pfad = PREL;
  pfad += "/share/scribus/";
  QApplication a(argc, argv);
//  a.setFont(QFont("helvetica", 12));
  QTranslator tor( 0 );
  tor.load( QString(pfad+"scribus.") + QString(QTextCodec::locale()).left(2), "." );
//	cout << QString(QTextCodec::codecForLocale()->name()).lower() << endl;
  a.installTranslator( &tor );
  if (argc > 1)
  	{
  	if (QString(argv[1]) == "--version")
  		{
  		cout << "Scribus Version " << VERSION << endl;
  		return 0;
  		}
  	if (QString(argv[1]) == "--help")
  		{
  		cout << endl;
  		cout << "Scribus, a DTP-Program for Linux." << endl;
  		cout << endl;
  		cout << "Usage:" << endl;
  		cout << "scribus --version  -> prints Version-Number and exits." << endl;
  		cout << "scribus --help     -> prints this Info and exits." << endl;
  		cout << "scribus \"String\"   -> Interprets \"String\" as Filename" << endl;
  		cout << "                      for a Document and tries to open it." << endl;
  		cout << endl;
  		return 0;
  		}
  	QFileInfo fi = QFileInfo(QString(argv[1]));
  	if (!fi.exists())
  		{
  		cout << "File does not exist, aborting." << endl;
  		cout << endl;
  		cout << "Usage:" << endl;
  		cout << "scribus --version  -> prints Version-Number and exits." << endl;
  		cout << "scribus --help     -> prints this Info and exits." << endl;
  		cout << "scribus \"String\"   -> Interprets \"String\" as Filename" << endl;
  		cout << "                      for a Document and tries to open it." << endl;
  		cout << endl;
  		return 0;
  		}
  	}
//  a.setStyle(new QPlatinumStyle);
    
  ScribusApp *scribus=new ScribusApp();
  if (scribus->NoFonts)
  	return 0;
  a.setMainWidget(scribus);
  a.connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));
  scribus->show();
  scribus->ShowSubs();
  if (argc > 1)
  	{
  	if (QString(argv[1]) != "--version")
  		scribus->LadeDoc(argv[1]);
  	}
  return a.exec();
}
