/***************************************************************************
                          pslib.h  -  description
                             -------------------
    begin                : Sat May 26 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PSLIB_H
#define PSLIB_H
#include <qstring.h>
#include <qcstring.h>
#include <qpen.h>
#include "scribusdoc.h"

/**
  *@author Franz Schmid
  * Diese Klasse erzeugt Postscript-Dateien
  */

class PSLib {
public:
	PSLib(bool psart, SCFonts &AllFonts, QMap<QString,QFont> DocFonts, CListe DocColors, bool pdf = false);
	virtual ~PSLib();
	virtual void PS_set_Info(QString art, QString was);
	virtual void PS_begin_page(float breite, float hoehe, struct Margs* Ma);
	virtual void PS_end_page();
	virtual void PS_rect(float x, float y, float b, float h);
	virtual void PS_RoundRect(float x, float y, float b, float h, float r);
	virtual void PS_circle(float r, float r2);
	virtual void PS_moveto(float x, float y);
	virtual void PS_lineto(float x, float y);
	virtual void PS_closepath();
	virtual void PS_translate(float x, float y);
	virtual void PS_scale(float x, float y);
	virtual void PS_rotate(float x);
	virtual void PS_clip();
	virtual void PS_save();
	virtual void PS_restore();
	virtual void PS_setcmykcolor_fill(float c, float m, float y, float k);
	virtual void PS_setcmykcolor_stroke(float c, float m, float y, float k);
	virtual void PS_setlinewidth(int w);
	virtual void PS_setdash(Qt::PenStyle st, Qt::PenCapStyle ca, Qt::PenJoinStyle jo);
	virtual void PS_selectfont(QString f, int s);
	virtual void PS_selectfontItalic(QString f, int s);
	virtual void PS_fill();
	virtual void PS_stroke();
	virtual void PS_fill_stroke();
	virtual void PS_underline(QCString ch, float x, float y);
	virtual void PS_strikeout(QCString ch, float x, float y);
	virtual void PS_show_xy(QCString ch, float x, float y);
	virtual void PS_show();
	virtual void PS_show_xyBold(QCString ch, float x, float y);
	virtual void PS_image(float x, float y, QString fn, float scalex, float scaley);
	virtual void PS_plate(int nr);
	virtual void PS_setGray();
	virtual void PDF_Bookmark(QString text, uint Seite);
	virtual void PDF_Annotation(QString text, float x, float y, float b, float h);
	virtual QString PS_close();
private:
	void PutSeite(QString c);
	void PutDoc(QString c);
	QString ToStr(float c);
	QString IToStr(int c);
	bool Art;
	QString Prolog;
	QString Header;
	QString Creator;
	QString User;
	QString Titel;
	QString BBox;
	QString BBoxH;
	QString Farben;
	QString FNamen;
	QString PDev;
	QString GrayCalc;
	bool GraySc;
	int Seiten;
	QString Dokument;
	QString Seite;
	QString FillColor;
	QString StrokeColor;
	int LineW;
	QString Fonts;
	QString FontDesc;
	QMap<QString, QString> UsedFonts;
	SCFonts FontDef;
	bool isPDF;
};

#endif
