;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/io.scm                     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Sep 29 05:42:56 2001                          */
;*    Last change :  Sun Dec  9 14:49:51 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    All the scribe IO                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_io
   
   (import __scribeapi_param
	   __scribeapi_reader)
   
   (export (open-source-file ::bstring)
	   (open-style-file ::bstring)
	   (open-bib-file ::bstring)
	   (port->ast ::input-port)))

;*---------------------------------------------------------------------*/
;*    open-source-file ...                                             */
;*---------------------------------------------------------------------*/
(define (open-source-file name)
   (let ((fname (find-file/path name *scribe-path*)))
      (if (string? fname)
	  (let ((p (open-input-file fname)))
	     (if (not (input-port? p))
		 (error "scribe" "Can't find input `source' file" name)
		 p)))))

;*---------------------------------------------------------------------*/
;*    open-style-file ...                                              */
;*---------------------------------------------------------------------*/
(define (open-style-file name)
   (let ((fname (find-file/path name
				(append *scribe-style-path* *scribe-path*))))
      (if (string? fname)
	  (let ((p (open-input-file fname)))
	     (if (not (input-port? p))
		 (error "scribe" "Can't find `style' file" name)
		 p)))))

;*---------------------------------------------------------------------*/
;*    open-bib-file ...                                                */
;*---------------------------------------------------------------------*/
(define (open-bib-file name)
   (let ((fname (find-file/path name *scribe-bib-path*)))
      (if (string? fname)
	  (let ((p (open-input-file fname)))
	     (if (not (input-port? p))
		 (error "scribe" "Can't find input `bib' file" name)
		 p)))))

;*---------------------------------------------------------------------*/
;*    port->ast ...                                                    */
;*---------------------------------------------------------------------*/
(define (port->ast port)
   (scribe-eval (scribe-parse port)))

;*---------------------------------------------------------------------*/
;*    scribe-parse ...                                                 */
;*---------------------------------------------------------------------*/
(define (scribe-parse port)
   (try (let loop ((exp (scribe-read port))
		   (res '()))
	   (if (eof-object? exp)
	       (reverse! res)
	       (loop (scribe-read port)
		     (cons exp res))))
	(lambda (escape obj proc msg)
	   (notify-error proc obj msg)
	   (error #f obj msg))))

;*---------------------------------------------------------------------*/
;*    scribe-eval ...                                                  */
;*---------------------------------------------------------------------*/
(define (scribe-eval lst)
   (try (map eval lst)
	(lambda (escape proc msg obj)
	   (evmeaning-notify-error proc obj msg)
	   (error #f obj msg))))
   
