;*=====================================================================*/
;*    serrano/prgm/project/scribe/engine/main.scm                      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Sep 29 05:34:27 2001                          */
;*    Last change :  Mon Jan 14 16:19:51 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The main Scribe module                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module main

   (library scribeapi)
   
   (main    main)

   (import  scribe_param
	    scribe_cmdline))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   ;; parse the Shell variables
   (parse-env-variables)
   ;; then we parse the command line arguments
   (parse-cmdline argv)
   ;; then we start processing the document
   (let ((pin (if (string? *scribe-src*)
		  (let ((p (open-source-file *scribe-src*)))
		     (if (not (input-port? p))
			 (error "scribe"
				"Can't open file for input"
				*scribe-src*)
			 p))
		  (current-input-port))))
      (try (engine pin (if (string? *scribe-src*) *scribe-src* "[stdin]"))
	   (lambda (escape obj proc msg)
	      (if obj (notify-error obj proc msg))
	      (if (string? *scribe-dest*)
		  (delete-file *scribe-dest*))
	      (exit -1)))))

;*---------------------------------------------------------------------*/
;*    engine ...                                                       */
;*---------------------------------------------------------------------*/
(define (engine pin::input-port file::bstring)
   ;; load the back-end, load the standard style file
   ;; and process the user source file
   (let* ((proc (find-backend-processor *scribe-format*))
	  (_ (if (string? *scribe-standard-style*)
		 (style *scribe-standard-style*)))
	  (node (port->ast pin))
	  (pout (if (string? *scribe-dest*)
		    (let ((p (open-output-file *scribe-dest*)))
		       (if (not (output-port? p))
			   (error "scribe"
				  "Can't open file for output"
				  *scribe-dest*)
			   p))
		    (current-output-port))))
      ;; make a dummy reference to a function of scribeapi. This force
      ;; the module containing the scribe api to be loaded at runtime
      (list %document document pre)
      ;; then process the user file
      (if node
	  (with-output-to-port pout
	     (lambda ()
		(proc node)))
	  (error "scribe" "aborting on file" file))))
		     

