# Based on the viewer from Tobias Nurmiranta for the old ruby-v4l API

require "V4l"
require "opengl" # http://www2.giganet.net/~yoshi/
require "glut"   # included in the opengl module.

vid = V4l.new("/dev/video")

display = Proc.new {
   GL.RasterPos(0, vid.height - 1)
   GL.DrawPixels(vid.width, vid.height, GL::RGB, GL::UNSIGNED_BYTE, vid.get_frame)
   GLUT.SwapBuffers
   GLUT.PostRedisplay
}

reshape = Proc.new {|w, h|
   GL.Viewport(0, 0,  w,  h)
   GL.MatrixMode(GL::PROJECTION)
   GL.LoadIdentity
   GLU.Ortho2D(0.0,  w, 0.0, h)
   GL.MatrixMode(GL::MODELVIEW)
   GL.LoadIdentity
   GL.PixelZoom(1.0, -1.0)
}

keyboard = Proc.new {|key, x, y| exit(0) if key == 27 } #escape

GLUT.Init
GLUT.InitDisplayMode(GLUT::DOUBLE | GLUT::RGB)
GLUT.InitWindowSize(vid.width, vid.height)
GLUT.InitWindowPosition(100, 100)
GLUT.CreateWindow($0)
GL.ClearColor(0.0, 0.0, 0.0, 0.0)
GL.ShadeModel(GL::FLAT)
GL.PixelStorei(GL::UNPACK_ALIGNMENT, 1)
GLUT.DisplayFunc(display)
GLUT.ReshapeFunc(reshape)
GLUT.KeyboardFunc(keyboard)
GLUT.MainLoop
