/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998, 1999  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Or look at http://www.gnu.org/copyleft/gpl.html .

**********************************************************************/
/* $Id: read_file_utils.c,v 1.4.1.1 1999/01/16 01:27:34 lance Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "data.h"

#define DEBUG 0

#if(DEBUG)
static struct Data **d = NULL;
#endif

/* realloc this many points at a time */
#define DELTA_NUM_POINTS 9000 /* must be > 1 */

int check_data_size(Plot *plot,int num_fields,
		    unsigned long num_points)
{
  int i;
  unsigned long k;
  struct Data *D;/* dummy data pointer */

  if(num_points < 2)
    {      
      fprintf(stderr,
	      "quickplot ERROR: There is just a single point in this file. Quickplot can't plot a single point.\n");
      return 1; /* error */
    }

  for(i=plot->dim - num_fields;i<plot->dim;i++)
    { 
      assert((D =plot->data[i] = (struct Data *) realloc((void*) plot->data[i],
	      sizeof(struct Data)*num_points)) != NULL);
      /* rebuild linked list because addresses 
       * may have changed and add the new links
       */
      D[0].prev = NULL;
      D[0].next = &(D[1]);
      for(k=1;k<num_points-1;k++)
	{
	  D[k].next = &(D[k+1]);
	  D[k].prev = &(D[k-1]);
	}
      D[k].prev = &(D[k-1]);
      D[k].next = NULL;
    }

  return 0; /* no error */
}


/* I think this function here could be made to make quickplot data loading
 * a lot faster, by not using realloc and reconnecting the linked lists;
 * but by using malloc and saving a list of pointers to free, or not free
 * at all since quickplot never frees the data until it exits.
 */
#if(1)
void add_data_size(Plot *plot, struct Data **currentdata,
		     int num_fields,unsigned long *num_points)
{
  int i;
  unsigned long k,n;
  struct Data *D;/* dummy data pointer */

  n = *num_points + DELTA_NUM_POINTS/num_fields + 1000;

  for(i=plot->dim - num_fields;i<plot->dim;i++)
    { 
      assert((D = plot->data[i] = (struct Data *) realloc((void*) plot->data[i],
	      sizeof(struct Data)*n)) != NULL);
      /* rebuild linked list because addresses 
       * may have changed and add the new links
       */
      D[0].prev = NULL;
      D[0].next = &(D[1]);
      for(k=1;k<n-1;k++)
	{
	  D[k].next = &(D[k+1]);
	  D[k].prev = &(D[k-1]);
	}
      D[k].prev = &(D[k-1]);
      D[k].next = NULL;
      currentdata[i-plot->dim+num_fields] = &(D[*num_points]);
    }
  *num_points = n;
}

#else
void add_data_size(Plot *plot, struct Data **currentdata,
		     int num_fields,unsigned long *num_points)
{
  int i;
  unsigned long k,n;
  struct Data *D,*E;/* dummy data pointer */

  if((*num_points))
    

  n = DELTA_NUM_POINTS/num_fields;

  for(i=plot->dim - num_fields;i<plot->dim;i++)
    {
      E = &(currentdata[i-plot->dim+num_fields][*num_points -1]);
      assert((currentdata[i-plot->dim+num_fields] = plot->data[i] =
	      D = (struct Data *) malloc(sizeof(struct Data)*n)));
      D->prev = E;
      E->next = D;
      for(k=1;k<n;k++)
	{
	  E=D;
	  D++;
	  D->prev = E;
	  E->next = D;
	}
      D->next = NULL;
    }
  *num_points += n;
}
#endif


void verbose_read_report(Plot *plot, unsigned long num_points, int num_fields, const char *file)
{
  if(plot->flag & VERBOSE)
    fprintf(stderr,
	    "quickplot Info: read in (%ld lines) x (%d values/line) = (%ld values) from file: %s\n",
	    num_points,num_fields,num_points*num_fields,file);

  if(num_points == 1)
    {
      fprintf(stderr,
	      "quickplot Error: Can't plot a single point by its self. from file: %s\n",file);
      exit(1);
    }
}

void realloc_plot_data_and_max_min(Plot *plot, int num_fields)
{
  int i;
  /** setup plot->data,plot->max and plot->min */
  assert((plot->data = (struct Data **) realloc(
           (void *)plot->data,
	   sizeof(struct Data *)*plot->dim)) != NULL);
  for(i=plot->dim-num_fields;i<plot->dim;i++)
    plot->data[i] = NULL;

  /* realloc max and min */
  assert((plot->max = (double *) realloc(
           (void *)plot->max,
	   sizeof(double)*plot->dim)) != NULL);
  assert((plot->min = (double *) realloc(
           (void *)plot->min,
	   sizeof(double)*plot->dim)) != NULL);
}
