/* 
    menus.c
    sam@usaworks.com

   
*/

#include "includes.h"
#include "globals.h"

static GtkItemFactoryEntry list_menu[] = {
    { "/File",			NULL,		NULL,		0,	"<Branch>" },
    { "/File/New list...",	"<Alt>N", 	new_file,	0, 	"" },
    { "/File/Open...",		"<Alt>O",	open_file,	0,	"" },
    { "/File/Close",		"<Alt>W",	close_file,	0,	"" },
    { "/File/Save",		"<Alt>S",	save_file,	0,	"" },
    { "/File/Save as...",	"",		save_as,	0,	"" },
    { "/File/Import...",	"",		file_import,	0,	"" },
    { "/File/Export...",	"",		file_export,	0,	"" },
    { "/File/Exit",		"",		file_exit,	0,	"" },

    { "/Edit",			NULL,		NULL,			0,	"<Branch>" },
    { "/Edit/Cut",		"<Alt>X",	edit_cut,		0,	"" },
    { "/Edit/Copy",		"<Alt>C",	edit_copy,		0,	"" },
    { "/Edit/Copy down",	"<Alt>E",	edit_ditto,		0,	"" },
    { "/Edit/Paste",		"<Alt>V",	edit_paste,		0,	"" },
    { "/Edit/Clear",		"",		edit_clear,		0,	"" },
    { "/Edit/Fill down",	"<Alt>D",	edit_fill_down,		0,	"" },
    { "/Edit/Select all",	"<Alt>A",	edit_select_all,	0,	"" },
    { "/Edit/Insert rows",	"<Alt>I",	edit_insert_rows,	0,	"" },

    { "/Sort",			NULL,		NULL,		0,	"<Branch>" },
    { "/Sort/Column",		"<Alt>Y",	sort_by_column,	0,	"" },
    { "/Sort/Apply...",		"",		sort_apply,	0,	"" },
    { "/Sort/Add...",		"",		sort_add,	0,	"" },
    { "/Sort/Edit...",		"",		sort_edit,	0,	"" },
    { "/Sort/Delete...",	"",		sort_delete,	0,	"" },

    { "/Filter",		NULL,		NULL,		0,	"<Branch>" },
    { "/Filter/Show all",	"",		filter_show_all,0,	"" },
    { "/Filter/Apply...",	"",		filter_apply,	0,	"" },
    { "/Filter/Add...",		"",		filter_add,	0,	"" },
    { "/Filter/Edit...",	"",		filter_edit,	0,	"" },
    { "/Filter/Delete...",	"",		filter_delete,	0,	"" },

    { "/Report",		NULL,		NULL,		0,	"<Branch>" },
    { "/Report/Select...",	"",		report_select,	0,	"" },
    { "/Report/Add...",		"",		report_add,	0,	"" },
    
    { "/Column",		NULL,		NULL,		0,	"<Branch>" },
    { "/Column/Add...",		"",		column_add,	0,	"" },
    { "/Column/Edit...",	"",		column_edit,	0,	"" },
    { "/Column/Delete",		"",		column_delete,	0,	"" },
    { "/Column/Move left",	"<Alt>,",	column_left,	0,	"" },
    { "/Column/Move right",	"<Alt>.",	column_right,	0,	"" },

    { "/Tools",		NULL,		NULL,		0,	"<Branch>" },
    { "/Tools/Find...",		"<Alt>F",	tools_find,	0,	"" },
    { "/Tools/Match...",	"<Alt>M",	tools_match,	0,	"" },

    { "/Help",			NULL,		NULL,		0,	"<Branch>" },
    { "/Help/About...",		"",		help_credits,	0,	"" }
};

static GtkItemFactoryEntry report_menu[] = {
    { "/File",			NULL,		NULL,		0,	"<Branch>" },
    { "/File/New...",		"<Alt>N",	new_file,	0,	"" },
    { "/File/Open...",		"<Alt>O",	open_file,	0,	"" },
    { "/File/Close",		"<Alt>W",	close_file,	0,	"" },
    { "/File/Save",		"<Alt>S",	save_file,	0,	"" },
    { "/File/Save as...",	"",		save_as,	0,	"" },
    { "/File/Import...",	"",		file_import,	0,	"" },
    { "/File/Export...",	"",		file_export,	0,	"" },
    { "/File/Exit",		"",		file_exit,	0,	"" },

    { "/Column",		NULL,		NULL,		0,	"<Branch>" },
    { "/Column/Add...", 	NULL,		report_col_add,		0,	"" },
    { "/Column/Delete",		NULL,		report_col_del,		0,	"" },
    { "/Column/Move left",	"<Alt>,",	report_col_left,	0,	"" },
    { "/Column/Move right",	"<Alt>.",	report_col_right,	0,	"" },

    { "/Totals",	NULL,		NULL,			0,	"<Branch>" },
    { "/Totals/Group",	"<Alt>G",	report_totals_group,	0,	"" },
    { "/Totals/Totals",	"<Alt>T",	report_totals_total,	0,	"" },

    { "/Help",		NULL,		NULL,		0,	"<Branch>" },
    { "/Help/About...",	NULL,		help_credits,	0,	"" }
};

GtkWidget *
build_list_mb (void)
{
    GtkWidget *mb;
    GtkItemFactory *item_factory;
    GtkAccelGroup *accel_group;
    gint nmenu_items = sizeof (list_menu) / sizeof (list_menu[0]);

    accel_group = gtk_accel_group_new ();
    item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<list>", 
                                         accel_group); 
    gtk_item_factory_create_items (item_factory, nmenu_items, list_menu, 
                                   NULL);
    mb = gtk_item_factory_get_widget (item_factory, "<list>");
    gtk_accel_group_attach (accel_group, GTK_OBJECT (front->list_win));

    front->list_menu = item_factory;

    return mb;
}

GtkWidget *
build_report_mb (void)
{
    GtkWidget *mb;
    GtkItemFactory *item_factory;
    GtkAccelGroup *accel_group;
    gint nmenu_items = sizeof (report_menu) / sizeof (report_menu[0]);

    accel_group = gtk_accel_group_new ();
    item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<report>", 
                                         accel_group); 
    gtk_item_factory_create_items (item_factory, nmenu_items, report_menu, 
                                   NULL);
    mb = gtk_item_factory_get_widget (item_factory, "<report>");

    front->report_menu = item_factory;

    return mb;
}


/* borrowed from the gimp */
void
menus_set_sensitive (gchar    *path,
                     gboolean  sensitive)
{
    GtkItemFactory *ifactory;
    GtkWidget *widget = NULL;

/*    ifactory = gtk_item_factory_from_path (path); */
    if (!strncmp(path, "<li", 3)) 
        ifactory = front->list_menu;
    else
        ifactory = front->report_menu;

    if (ifactory)
    {
        widget = gtk_item_factory_get_widget (ifactory, path);

        gtk_widget_set_sensitive (widget, sensitive);
    }
    if (!ifactory || !widget)
        g_warning ("Unable to set sensitivity for menu which doesn't exist:\n%s",
                   path);
}
