

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: RiskStatistics.i,v 1.8 2002/01/16 14:51:31 nando Exp $

#ifndef quantlib_risk_statistics_i
#define quantlib_risk_statistics_i

%include Vectors.i

%{
using QuantLib::RiskStatistics;
using QuantLib::Math::RiskMeasures;
%}


class RiskMeasures {
  public:
    RiskMeasures();
    ~RiskMeasures();
    double potentialUpside(double percentile, double mean, double std) const;
    double valueAtRisk(double percentile, double mean, double std) const;
    double shortfall(double target, double mean, double std) const;
    double averageShortfall(double target, double mean, double std) const;
};


class RiskStatistics {
  public:
    RiskStatistics();
    virtual ~RiskStatistics();
    // Accessors
    int samples() const;
    double weightSum() const;
    double mean() const;
    double variance() const;
    double standardDeviation() const;
    double errorEstimate() const;
    double skewness() const;
    double kurtosis() const;
    double min() const;
    double max() const;
    double potentialUpside(double percentile) const;
    double valueAtRisk(double percentile) const;
    double expectedShortfall(double percentile) const;
    double shortfall(double target) const;
    double averageShortfall(double target) const;
    // Modifiers
    void add(double value, double weight = 1.0);
    void reset();
};

%addmethods RiskStatistics {
    void crash() {}
    void addSequence(DoubleVector values) {
        self->addSequence(values.begin(), values.end());
    }
    void addWeightedSequence(DoubleVector values, DoubleVector weights) {
        self->addSequence(values.begin(), values.end(), weights.begin());
    }
}


#endif
