

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: RateHelpers.i,v 1.5 2002/01/16 14:51:31 nando Exp $

#ifndef quantlib_rate_helpers_i
#define quantlib_rate_helpers_i

%include Date.i
%include Calendars.i
%include DayCounters.i
%include Types.i
%include MarketElements.i

%{
    using QuantLib::Handle;
    using QuantLib::TermStructures::RateHelper;
    using QuantLib::TermStructures::DepositRateHelper;
    using QuantLib::TermStructures::FraRateHelper;
    using QuantLib::TermStructures::FuturesRateHelper;
    using QuantLib::TermStructures::SwapRateHelper;
    typedef Handle<RateHelper> RateHelperHandle;
    typedef Handle<DepositRateHelper> DepositRateHelperHandle;
    typedef Handle<FraRateHelper> FraRateHelperHandle;
    typedef Handle<FuturesRateHelper> FuturesRateHelperHandle;
    typedef Handle<SwapRateHelper> SwapRateHelperHandle;
%}

%name(RateHelper) class RateHelperHandle {
  private:
    // abstract class - no constructor exported
    RateHelperHandle();
  public:
    ~RateHelperHandle();
};

%addmethods RateHelperHandle {
    void crash() {}
    Date maturity() {
        return (*self)->maturity();
    }
}


%name(DepositRateHelper) class DepositRateHelperHandle
: public RateHelperHandle {
  public:
    // constructor redefined below
    ~DepositRateHelperHandle();
};

%addmethods DepositRateHelperHandle {
    void crash() {}
    DepositRateHelperHandle(MarketElementRelinkableHandle rate,
        int settlementDays, int n, TimeUnit units, Calendar calendar,
        RollingConvention convention, DayCounter dayCounter) {
            return new DepositRateHelperHandle(
                new DepositRateHelper(rate,settlementDays,n,units,calendar,
                    convention,dayCounter));
    }
}

%name(FraRateHelper) class FraRateHelperHandle
: public RateHelperHandle {
  public:
    // constructor redefined below
    ~FraRateHelperHandle();
};

%addmethods FraRateHelperHandle {
    void crash() {}
    FraRateHelperHandle(MarketElementRelinkableHandle rate,
        int settlementDays, int monthsToStart, int monthsToEnd,
        Calendar calendar, RollingConvention convention,
        DayCounter dayCounter) {
            return new FraRateHelperHandle(
                new FraRateHelper(rate,settlementDays,monthsToStart,
                    monthsToEnd,calendar,convention,dayCounter));
    }
}

%name(FuturesRateHelper) class FuturesRateHelperHandle
: public RateHelperHandle {
  public:
    // constructor redefined below
    ~FuturesRateHelperHandle();
};

%addmethods FuturesRateHelperHandle {
    void crash() {}
    FuturesRateHelperHandle(MarketElementRelinkableHandle price,
        const Date& immDate, int settlementDays, int months,
        Calendar calendar, RollingConvention convention,
        DayCounter dayCounter) {
            return new FuturesRateHelperHandle(
                new FuturesRateHelper(price,immDate,settlementDays,months,
                    calendar,convention,dayCounter));
    }
}

%name(SwapRateHelper) class SwapRateHelperHandle
: public RateHelperHandle {
  public:
    // constructor redefined below
    ~SwapRateHelperHandle();
};

%addmethods SwapRateHelperHandle {
    void crash() {}
    SwapRateHelperHandle(MarketElementRelinkableHandle rate,
        int settlementDays, int lengthInYears, Calendar calendar,
        RollingConvention rollingConvention,
        int fixedFrequency, bool fixedIsAdjusted,
        DayCounter fixedDayCount, int floatingFrequency) {
            return new SwapRateHelperHandle(
                new SwapRateHelper(rate, settlementDays, lengthInYears,
                    calendar, rollingConvention, fixedFrequency,
                    fixedIsAdjusted, fixedDayCount, floatingFrequency));
    }
}

// typemap array of RateHelpers to std::vector<Handle<RateHelper> >

%{
#include <vector>
typedef std::vector<Handle<RateHelper> > RateHelperHandleVector;
%}

%typemap(ruby,in) RateHelperHandleVector (RateHelperHandleVector temp),
                  const RateHelperHandleVector & (RateHelperHandleVector temp) {
    if (rb_obj_is_kind_of($source,rb_cArray)) {
        int size = RARRAY($source)->len;
        temp = RateHelperHandleVector(size);
        for (int i=0; i<size; i++) {
            VALUE o = RARRAY($source)->ptr[i];
            RateHelperHandle* h;
            Get_RateHelperHandle(o,h);
            temp[i] = *h;
        }
    } else {
        rb_raise(rb_eTypeError,
                 "wrong argument type (expected array of rate helpers)");
    }
    $target = &temp;
}


#endif
