# Check for Qt compiler flags, linker flags, and binary packages.
# Taken from autoqt, heavily modified by Pavel Roskin.
# Only Qt versions 3.x are supported.  Use pkg-config for Qt 4.x.
#
# Arguments: none.
# Variables set: QT_CPPFLAGS, QT_LDFLAGS, QT_LIBS, QT_MOC, QT_UIC.
# If Qt is not found, a fatal error is reported.

AC_DEFUN([gw_CHECK_QT],
[
AC_REQUIRE([AC_PATH_XTRA])

AC_ARG_WITH([qtdir],
  [  --with-qtdir=DIR        Qt main directory (default = $QTDIR)],
  [QTDIR=$withval])
AC_ARG_VAR(QTDIR, [Qt main directory])

AC_ARG_WITH([qt-binaries],
  [  --with-qt-binaries=DIR  Qt binary directory (default = $QTDIR/bin)],
  [QTBINDIR=$withval])

AC_ARG_WITH([qt-includes],
  [  --with-qt-includes=DIR  Qt include directory (default = $QTDIR/include)],
  [QTINCDIR=$withval])

AC_ARG_WITH([qt-libraries],
  [  --with-qt-libraries=DIR Qt library directory (default = $QTDIR/lib)],
  [QTLIBDIR=$withval])

if test -n "$QTDIR"; then
  : ${QTBINDIR="$QTDIR/bin"}
  : ${QTINCDIR="$QTDIR/include"}
fi

AC_MSG_CHECKING([for Qt includes])
if test -z "$QTINCDIR"; then
    qt_path_start="/usr/lib64 /usr/lib /usr/share /usr/X11R6 /usr /usr/local/lib64 /usr/local/lib /usr/local/share /opt"
    qt_path_end="qt33 qt-3.3 qt32 qt-3.2 qt31 qt-3.1 qt3 qt-3 qt"
    for i in $qt_path_start; do
	for j in $qt_path_end ""; do
	    if test -f $i${j:+/$j}/include/qglobal.h; then
		QTINCDIR=$i${j:+/$j}/include
		break 2
	    fi
	done
    done
fi
AC_MSG_RESULT([$QTINCDIR])

if test -z "$QTINCDIR"; then
    AC_MSG_ERROR([*** QTINCDIR must be defined, or --with-qt-includes option given])
fi

# Calculate QTDIR from QTINCDIR
if test -z "$QTDIR"; then
  QTDIR=`echo $QTINCDIR | sed 's,/include,,'`
  : ${QTBINDIR="$QTDIR/bin"}
fi

# Find QTLIBDIR from QTDIR
if test -z "$QTLIBDIR"; then
  if test -d "$QTDIR/lib64"; then
    QTLIBDIR="$QTDIR/lib64"
  else
    QTLIBDIR="$QTDIR/lib"
  fi
fi

# Find out which version of Qt we are using
AC_MSG_CHECKING([Qt version])
QT_VER=`sed -n 's/^#define *QT_VERSION_STR *[^"]*"\([^"]*\)".*$/\1/p' $QTINCDIR/qglobal.h`
AC_MSG_RESULT([$QT_VER])

case "${QT_VER}" in
    3*) ;;
    *) AC_MSG_ERROR([*** Unsupported Qt version, use --with-qtdir pointing to Qt 3.x]) ;;
esac

# Check that moc is in path
AC_PATH_PROG(QT_MOC, moc, , [$QTBINDIR:$PATH])
if test -z "$QT_MOC"; then
    AC_MSG_ERROR([*** moc is not found])
fi

# uic is the Qt user interface compiler
AC_PATH_PROG(QT_UIC, uic, , [$QTBINDIR:$PATH])
if test -z "$QT_UIC"; then
    AC_MSG_ERROR([*** uic is not found])
fi


# Checking for possible dependencies of the Qt library
gwqt_save_LDFLAGS="$LDFLAGS"
QT_LIBS_X="$X_PRE_LIBS -lX11 $X_EXTRA_LIBS"
AC_CHECK_LIB(pthread, pthread_exit, [QT_LIBS_MT="-lpthread $QT_LIBS"])

LDFLAGS="$LDFLAGS $X_LIBS"
AC_CHECK_LIB(Xft, XftFontOpen, [QT_LIBS_X="-lXft $QT_LIBS_X"], , [$QT_LIBS_X])


# Checking for the Qt library
LDFLAGS="$LDFLAGS -L$QTLIBDIR"
for i in qt-mt qt qte-mt qte qt-gl; do
    set X "$QTLIBDIR/lib$i."*
    test "$[2]" = "$QTLIBDIR/lib$i.*" && continue
    AC_CHECK_LIB([$i], main, [qtlib="$i"; break], , [$QT_LIBS_X $QT_LIBS_MT])
done

if test -z "$qtlib"; then
    AC_MSG_ERROR([*** Cannot find Qt library])
fi

LDFLAGS="$gwqt_save_LDFLAGS"

# Calculate QT_CPPFLAGS, QT_LDFLAGS and QT_LIBS
QT_LIBS="-l$qtlib"
case "$qtlib" in
    *-mt)
	QT_CPPFLAGS="-D_REENTRANT -DQT_THREAD_SUPPORT"
	QT_LIBS="$QT_LIBS $QT_LIBS_MT";;
esac

case "$qtlib" in
    qte*)
	QT_CPPFLAGS="-DQWS -fno-rtti";;
    *)
	QT_LIBS="$QT_LIBS $QT_LIBS_X"
	QT_LDFLAGS="$X_LIBS";;
esac

# Add Qt include path
if test "$QTINCDIR" != "/usr/include"; then
    QT_CPPFLAGS="-I$QTINCDIR $QT_CPPFLAGS"
fi

# Add Qt library path
case "$QTLIBDIR" in
    /usr/lib) ;;
    /usr/lib64) ;;
    /usr/X11R6/lib) ;;
    *) QT_LDFLAGS="$QT_LDFLAGS -L$QTLIBDIR";;
esac

# Report the results
AC_MSG_NOTICE([QT_CPPFLAGS = $QT_CPPFLAGS])
AC_SUBST(QT_CPPFLAGS)
AC_MSG_NOTICE([QT_LDFLAGS = $QT_LDFLAGS])
AC_SUBST(QT_LDFLAGS)
AC_MSG_NOTICE([QT_LIBS = $QT_LIBS])
AC_SUBST(QT_LIBS)
])
