/* Copyright (C) 2003, 2004 Peter J. Verveer
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met: 
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.      
 */

#ifndef ND_IMAGE_H
#define ND_IMAGE_H

#if !defined(ND_IMPORT_LIBNUMARRAY)
#define NO_IMPORT_ARRAY
#endif
#include "Python.h"
#include "libnumarray.h"
#include "numconfig.h"
#include "arrayobject.h"

#define NI_MAXDIM MAXDIM

int NI_GetArrayRank(PyArrayObject*);
NumarrayType NI_GetArrayType(PyArrayObject*);
void NI_GetArrayDimensions(PyArrayObject*, int*);
void NI_GetArrayStrides(PyArrayObject*, int*);
char* NI_GetArrayData(PyArrayObject*);
int NI_Elements(PyArrayObject*);
int NI_ShapeEqual(PyArrayObject*, PyArrayObject*);
int NI_CopyArray(PyArrayObject*, PyArrayObject*);
PyArrayObject* NI_ContiguousArray(PyArrayObject*); 
PyArrayObject* NI_NewArray(NumarrayType, int, int*);
int NI_OutputArray(NumarrayType, int, int*, PyObject*, PyArrayObject**);

#endif
