# Deploying your docs

A basic guide to deploying your docs to various hosting providers

---

## GitHub Pages

If you host the source code for a project on [GitHub], you can easily use
[GitHub Pages] to host the documentation for your project. After you `checkout`
the primary working branch (usually `master`) of the git repository where you
maintain the source documentation for your project, run the following command:

```sh
mkdocs gh-deploy --clean
```

That's it! Behind the scenes, MkDocs will build your docs and use the [ghp-import]
tool to commit them to the gh-pages branch and push the gh-pages branch to
GitHub.

Use `mkdocs gh-deploy --help` to get a full list of options available for the
`gh-deploy` command.

Be aware that you will not be able to review the built site before it is pushed
to GitHub. Therefore, you may want to verify any changes you make to the docs
beforehand by using the `build` or `serve` commands and reviewing the built
files locally.

!!! warning

    You should never edit files in your gh-pages branch by hand if you're using
    the `gh-deploy` command because you will lose your work.

[GitHub]: https://github.com/
[GitHub Pages]: https://pages.github.com/
[ghp-import]: https://github.com/davisp/ghp-import

## Read the Docs

[Read the Docs][rtd] offers free documentation hosting. You can import your docs
using any major version control system, including Mercurial, Git, Subversion,
and Bazaar. Read the Docs supports MkDocs out-of-the-box. Follow the
[instructions] on their site to arrange the files in your repository properly,
create an account and point it at your publicly hosted repository. If properly
configured, your documentation will update each time you push commits to your
public repository.

!!! note

    To benefit from all of the [features] offered by Read the Docs, you will need
    to use the [Read the Docs theme][theme] which ships with MkDocs. The various
    themes which may be referenced in Read the Docs' documentation are Sphinx
    specific themes and will not work with MkDocs.

[rtd]: https://readthedocs.org/
[instructions]: https://read-the-docs.readthedocs.org/en/latest/getting_started.html#in-markdown
[features]: http://read-the-docs.readthedocs.org/en/latest/features.html
[theme]: /user-guide/styling-your-docs.md

## PyPI

If you maintain a [Python] project which is hosted on the [Python Package
Index][PyPI] (PyPI), you can use the hosting provided at [pythonhosted.org] to
host documentation for your project. Run the following commands from your
project's root directory to upload your documentation:

```sh
mkdocs build --clean
python setup.py upload_docs --upload-dir=site
```

You documentation will be hosted at `http://pythonhosted.org/<projectname>/`
where `<projectname>` is the name you used to register your project with PyPI.

There are a few prerequisites for the above to work:

1. You must be using [Setuptools] in your `setup.py` script ([Distutils] does
   not offer an `upload_docs` command).
1. Your project must already be registered with PyPI (use `python setup.py
   register`).
1. Your `mkdocs.yml` config file and your "docs" directory (value assigned to
   the [docs_dir] configuration option) are presumed to be in the root directory
   of your project alongside your `setup.py` script.
1. It is assumed that the default value (`"site"`) is assigned to the [site_dir]
   configuration option in your `mkdocs.yaml` config file. If you have set a
   different value, assign that value to the `--upload-dir` option.

[Python]: http://www.python.org/
[PyPI]: https://pypi.python.org/pypi
[pythonhosted.org]: http://pythonhosted.org/
[Setuptools]: http://pythonhosted.org/setuptools/
[Distutils]: https://docs.python.org/2/distutils/
[docs_dir]: configuration.md#docs_dir
[site_dir]: configuration.md#site_dir

## Other Providers

Any hosting provider which can serve static files can be used to serve
documentation generated by MkDocs. While it would be impossible to document how
to upload the docs to every hosting provider out there, the following guidelines
should provide some general assistance.

When you build your site (using the `mkdocs build` command), all of the files
are written to the directory assigned to the [site_dir] configuration option
(defaults to `"site"`) in your `mkdocs.yaml` config file. Generally, you will
simply need to copy the contents of that directory to the root directory of your
hosting provider's server. Depending on your hosting provider's setup, you may
need to use a graphical or command line [ftp], [ssh] or [scp] client to transfer
the files.

For example, a typical set of commands from the command line might look
something like this:

```sh
mkdocs build --clean
scp -r ./site usr@host:/path/to/server/root
```

Of course, you will need to replace `user` with the username you have with your
hosting provider and `host` with the appropriate domain name. Additionally, you
will need to adjust the `/path/to/server/root` to match the configuration of
your hosts' file system.

[ftp]: https://en.wikipedia.org/wiki/File_Transfer_Protocol
[ssh]: https://en.wikipedia.org/wiki/Secure_Shell
[scp]: https://en.wikipedia.org/wiki/Secure_copy

See your host's documentation for specifics. You will likely want to search
their documentation for "ftp" or "uploading site".

