
#!/usr/bin/env python
#
#      Restriction Analysis Libraries.
#      Copyright (C) 2004. Frederic Sohm.
#
# This code is part of the Biopython distribution and governed by its
# license.  Please see the LICENSE file that should have been included
# as part of this package.
#
# This file is automatically generated - do not edit it by hand! Instead,
# use the tool Scripts/Restriction/ranacompiler.py which in turn uses
# Bio/Restriction/_Update/RestrictionCompiler.py
#
# The following dictionaries used to be defined in one go, but that does
# not work on Jython due to JVM limitations. Therefore we break this up
# into steps, using temporary functions to avoid the JVM limits.


rest_dict = {}
def _temp():
    return {
        'compsite' : '(?P<AanI>TTATAA)|(?P<AanI_as>TTATAA)',
        'results' : None,
        'site' : 'TTATAA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TTATAA'),
        'ovhgseq' : '',
    }
rest_dict['AanI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AarI>CACCTGC)|(?P<AarI_as>GCAGGTG)',
        'results' : None,
        'site' : 'CACCTGC',
        'substrat' : 'DNA',
        'fst3' : 8,
        'fst5' : 11,
        'freq' : 16384,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (11, 8, None, None, 'CACCTGC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['AarI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AasI>GAC......GTC)|(?P<AasI_as>GAC......GTC)',
        'results' : None,
        'site' : 'GACNNNNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'GACNNNNNNGTC'),
        'ovhgseq' : 'NN',
    }
rest_dict['AasI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AatI>AGGCCT)|(?P<AatI_as>AGGCCT)',
        'results' : None,
        'site' : 'AGGCCT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('O',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'AGGCCT'),
        'ovhgseq' : '',
    }
rest_dict['AatI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AatII>GACGTC)|(?P<AatII_as>GACGTC)',
        'results' : None,
        'site' : 'GACGTC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F', 'I', 'K', 'M', 'N', 'O', 'R', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GACGTC'),
        'ovhgseq' : 'ACGT',
    }
rest_dict['AatII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AbsI>CCTCGAGG)|(?P<AbsI_as>CCTCGAGG)',
        'results' : None,
        'site' : 'CCTCGAGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCTCGAGG'),
        'ovhgseq' : 'TCGA',
    }
rest_dict['AbsI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Acc16I>TGCGCA)|(?P<Acc16I_as>TGCGCA)',
        'results' : None,
        'site' : 'TGCGCA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TGCGCA'),
        'ovhgseq' : '',
    }
rest_dict['Acc16I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Acc36I>ACCTGC)|(?P<Acc36I_as>GCAGGT)',
        'results' : None,
        'site' : 'ACCTGC',
        'substrat' : 'DNA',
        'fst3' : 8,
        'fst5' : 10,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (10, 8, None, None, 'ACCTGC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['Acc36I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Acc65I>GGTACC)|(?P<Acc65I_as>GGTACC)',
        'results' : None,
        'site' : 'GGTACC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F', 'I', 'N', 'R', 'V', 'W'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGTACC'),
        'ovhgseq' : 'GTAC',
    }
rest_dict['Acc65I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AccB1I>GG[CT][AG]CC)|(?P<AccB1I_as>GG[CT][AG]CC)',
        'results' : None,
        'site' : 'GGYRCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGYRCC'),
        'ovhgseq' : 'GYRC',
    }
rest_dict['AccB1I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AccB7I>CCA.....TGG)|(?P<AccB7I_as>CCA.....TGG)',
        'results' : None,
        'site' : 'CCANNNNNTGG',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('I', 'R', 'V'),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'CCANNNNNTGG'),
        'ovhgseq' : 'NNN',
    }
rest_dict['AccB7I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AccBSI>CCGCTC)|(?P<AccBSI_as>GAGCGG)',
        'results' : None,
        'site' : 'CCGCTC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CCGCTC'),
        'ovhgseq' : '',
    }
rest_dict['AccBSI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AccI>GT[AC][GT]AC)|(?P<AccI_as>GT[AC][GT]AC)',
        'results' : None,
        'site' : 'GTMKAC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('B', 'J', 'K', 'M', 'N', 'O', 'R', 'S', 'U', 'W', 'X'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GTMKAC'),
        'ovhgseq' : 'MK',
    }
rest_dict['AccI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AccII>CGCG)|(?P<AccII_as>CGCG)',
        'results' : None,
        'site' : 'CGCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('J', 'K'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGCG'),
        'ovhgseq' : '',
    }
rest_dict['AccII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AccIII>TCCGGA)|(?P<AccIII_as>TCCGGA)',
        'results' : None,
        'site' : 'TCCGGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('J', 'K', 'R', 'W'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCCGGA'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['AccIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AceIII>CAGCTC)|(?P<AceIII_as>GAGCTG)',
        'results' : None,
        'site' : 'CAGCTC',
        'substrat' : 'DNA',
        'fst3' : 11,
        'fst5' : 13,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (13, 11, None, None, 'CAGCTC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['AceIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AciI>CCGC)|(?P<AciI_as>GCGG)',
        'results' : None,
        'site' : 'CCGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCGC'),
        'ovhgseq' : 'CG',
    }
rest_dict['AciI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AclI>AACGTT)|(?P<AclI_as>AACGTT)',
        'results' : None,
        'site' : 'AACGTT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('I', 'N', 'V'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'AACGTT'),
        'ovhgseq' : 'CG',
    }
rest_dict['AclI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AclWI>GGATC)|(?P<AclWI_as>GATCC)',
        'results' : None,
        'site' : 'GGATC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 9,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (9, 5, None, None, 'GGATC'),
        'ovhgseq' : 'N',
    }
rest_dict['AclWI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AcoI>[CT]GGCC[AG])|(?P<AcoI_as>[CT]GGCC[AG])',
        'results' : None,
        'site' : 'YGGCCR',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'YGGCCR'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['AcoI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AcsI>[AG]AATT[CT])|(?P<AcsI_as>[AG]AATT[CT])',
        'results' : None,
        'site' : 'RAATTY',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'RAATTY'),
        'ovhgseq' : 'AATT',
    }
rest_dict['AcsI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AcuI>CTGAAG)|(?P<AcuI_as>CTTCAG)',
        'results' : None,
        'site' : 'CTGAAG',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 22,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I', 'N'),
        'scd5' : None,
        'charac' : (22, 14, None, None, 'CTGAAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['AcuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AcvI>CACGTG)|(?P<AcvI_as>CACGTG)',
        'results' : None,
        'site' : 'CACGTG',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('Q', 'X'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CACGTG'),
        'ovhgseq' : '',
    }
rest_dict['AcvI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AcyI>G[AG]CG[CT]C)|(?P<AcyI_as>G[AG]CG[CT]C)',
        'results' : None,
        'site' : 'GRCGYC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('J', 'M'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GRCGYC'),
        'ovhgseq' : 'CG',
    }
rest_dict['AcyI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AdeI>CAC...GTG)|(?P<AdeI_as>CAC...GTG)',
        'results' : None,
        'site' : 'CACNNNGTG',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 4096,
        'size' : 9,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'CACNNNGTG'),
        'ovhgseq' : 'NNN',
    }
rest_dict['AdeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AfaI>GTAC)|(?P<AfaI_as>GTAC)',
        'results' : None,
        'site' : 'GTAC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GTAC'),
        'ovhgseq' : '',
    }
rest_dict['AfaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AfeI>AGCGCT)|(?P<AfeI_as>AGCGCT)',
        'results' : None,
        'site' : 'AGCGCT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'N'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'AGCGCT'),
        'ovhgseq' : '',
    }
rest_dict['AfeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AfiI>CC.......GG)|(?P<AfiI_as>CC.......GG)',
        'results' : None,
        'site' : 'CCNNNNNNNGG',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 256,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'CCNNNNNNNGG'),
        'ovhgseq' : 'NNN',
    }
rest_dict['AfiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AflII>CTTAAG)|(?P<AflII_as>CTTAAG)',
        'results' : None,
        'site' : 'CTTAAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('J', 'K', 'N'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTTAAG'),
        'ovhgseq' : 'TTAA',
    }
rest_dict['AflII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AflIII>AC[AG][CT]GT)|(?P<AflIII_as>AC[AG][CT]GT)',
        'results' : None,
        'site' : 'ACRYGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('M', 'N', 'W'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACRYGT'),
        'ovhgseq' : 'CRYG',
    }
rest_dict['AflIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AgeI>ACCGGT)|(?P<AgeI_as>ACCGGT)',
        'results' : None,
        'site' : 'ACCGGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('J', 'N', 'R'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACCGGT'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['AgeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AgsI>TT[CG]AA)|(?P<AgsI_as>TT[CG]AA)',
        'results' : None,
        'site' : 'TTSAA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TTSAA'),
        'ovhgseq' : 'S',
    }
rest_dict['AgsI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AhaIII>TTTAAA)|(?P<AhaIII_as>TTTAAA)',
        'results' : None,
        'site' : 'TTTAAA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TTTAAA'),
        'ovhgseq' : '',
    }
rest_dict['AhaIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AhdI>GAC.....GTC)|(?P<AhdI_as>GAC.....GTC)',
        'results' : None,
        'site' : 'GACNNNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'GACNNNNNGTC'),
        'ovhgseq' : 'N',
    }
rest_dict['AhdI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AhlI>ACTAGT)|(?P<AhlI_as>ACTAGT)',
        'results' : None,
        'site' : 'ACTAGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACTAGT'),
        'ovhgseq' : 'CTAG',
    }
rest_dict['AhlI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AjiI>CACGTC)|(?P<AjiI_as>GACGTG)',
        'results' : None,
        'site' : 'CACGTC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CACGTC'),
        'ovhgseq' : '',
    }
rest_dict['AjiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AjnI>CC[AT]GG)|(?P<AjnI_as>CC[AT]GG)',
        'results' : None,
        'site' : 'CCWGG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'CCWGG'),
        'ovhgseq' : 'CCWGG',
    }
rest_dict['AjnI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AjuI>GAA.......TTGG)|(?P<AjuI_as>CCAA.......TTC)',
        'results' : None,
        'site' : 'GAANNNNNNNTTGG',
        'substrat' : 'DNA',
        'fst3' : -26,
        'fst5' : -7,
        'freq' : 16384,
        'size' : 14,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : 6,
        'suppl' : ('F',),
        'scd5' : 25,
        'charac' : (-7, -26, 25, 6, 'GAANNNNNNNTTGG'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['AjuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AleI>CAC....GTG)|(?P<AleI_as>CAC....GTG)',
        'results' : None,
        'site' : 'CACNNNNGTG',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'CACNNNNGTG'),
        'ovhgseq' : '',
    }
rest_dict['AleI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AlfI>GCA......TGC)|(?P<AlfI_as>GCA......TGC)',
        'results' : None,
        'site' : 'GCANNNNNNTGC',
        'substrat' : 'DNA',
        'fst3' : -24,
        'fst5' : -10,
        'freq' : 4096,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : 10,
        'suppl' : ('F',),
        'scd5' : 24,
        'charac' : (-10, -24, 24, 10, 'GCANNNNNNTGC'),
        'ovhgseq' : 'NN',
    }
rest_dict['AlfI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AloI>GAAC......TCC)|(?P<AloI_as>GGA......GTTC)',
        'results' : None,
        'site' : 'GAACNNNNNNTCC',
        'substrat' : 'DNA',
        'fst3' : -25,
        'fst5' : -7,
        'freq' : 16384,
        'size' : 13,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : 7,
        'suppl' : ('F',),
        'scd5' : 25,
        'charac' : (-7, -25, 25, 7, 'GAACNNNNNNTCC'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['AloI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AluBI>AGCT)|(?P<AluBI_as>AGCT)',
        'results' : None,
        'site' : 'AGCT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'AGCT'),
        'ovhgseq' : '',
    }
rest_dict['AluBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AluI>AGCT)|(?P<AluI_as>AGCT)',
        'results' : None,
        'site' : 'AGCT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'AGCT'),
        'ovhgseq' : '',
    }
rest_dict['AluI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Alw21I>G[AT]GC[AT]C)|(?P<Alw21I_as>G[AT]GC[AT]C)',
        'results' : None,
        'site' : 'GWGCWC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GWGCWC'),
        'ovhgseq' : 'WGCW',
    }
rest_dict['Alw21I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Alw26I>GTCTC)|(?P<Alw26I_as>GAGAC)',
        'results' : None,
        'site' : 'GTCTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 6,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (6, 5, None, None, 'GTCTC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['Alw26I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Alw44I>GTGCAC)|(?P<Alw44I_as>GTGCAC)',
        'results' : None,
        'site' : 'GTGCAC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F', 'J', 'O', 'R'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GTGCAC'),
        'ovhgseq' : 'TGCA',
    }
rest_dict['Alw44I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AlwFI>GAAA[CT].....[AG]TG)|(?P<AlwFI_as>CA[CT].....[AG]TTTC)',
        'results' : None,
        'site' : 'GAAAYNNNNNRTG',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 16384,
        'size' : 13,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'GAAAYNNNNNRTG'),
        'ovhgseq' : None,
    }
rest_dict['AlwFI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AlwI>GGATC)|(?P<AlwI_as>GATCC)',
        'results' : None,
        'site' : 'GGATC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 9,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (9, 5, None, None, 'GGATC'),
        'ovhgseq' : 'N',
    }
rest_dict['AlwI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AlwNI>CAG...CTG)|(?P<AlwNI_as>CAG...CTG)',
        'results' : None,
        'site' : 'CAGNNNCTG',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 4096,
        'size' : 9,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'CAGNNNCTG'),
        'ovhgseq' : 'NNN',
    }
rest_dict['AlwNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Ama87I>C[CT]CG[AG]G)|(?P<Ama87I_as>C[CT]CG[AG]G)',
        'results' : None,
        'site' : 'CYCGRG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CYCGRG'),
        'ovhgseq' : 'YCGR',
    }
rest_dict['Ama87I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Aor13HI>TCCGGA)|(?P<Aor13HI_as>TCCGGA)',
        'results' : None,
        'site' : 'TCCGGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCCGGA'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['Aor13HI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Aor51HI>AGCGCT)|(?P<Aor51HI_as>AGCGCT)',
        'results' : None,
        'site' : 'AGCGCT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'AGCGCT'),
        'ovhgseq' : '',
    }
rest_dict['Aor51HI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ApaBI>GCA.....TGC)|(?P<ApaBI_as>GCA.....TGC)',
        'results' : None,
        'site' : 'GCANNNNNTGC',
        'substrat' : 'DNA',
        'fst3' : -8,
        'fst5' : 8,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (8, -8, None, None, 'GCANNNNNTGC'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['ApaBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ApaI>GGGCCC)|(?P<ApaI_as>GGGCCC)',
        'results' : None,
        'site' : 'GGGCCC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('B', 'F', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GGGCCC'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['ApaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ApaLI>GTGCAC)|(?P<ApaLI_as>GTGCAC)',
        'results' : None,
        'site' : 'GTGCAC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('C', 'K', 'N', 'U'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GTGCAC'),
        'ovhgseq' : 'TGCA',
    }
rest_dict['ApaLI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ApeKI>GC[AT]GC)|(?P<ApeKI_as>GC[AT]GC)',
        'results' : None,
        'site' : 'GCWGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GCWGC'),
        'ovhgseq' : 'CWG',
    }
rest_dict['ApeKI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ApoI>[AG]AATT[CT])|(?P<ApoI_as>[AG]AATT[CT])',
        'results' : None,
        'site' : 'RAATTY',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'RAATTY'),
        'ovhgseq' : 'AATT',
    }
rest_dict['ApoI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ApyPI>ATCGAC)|(?P<ApyPI_as>GTCGAT)',
        'results' : None,
        'site' : 'ATCGAC',
        'substrat' : 'DNA',
        'fst3' : 18,
        'fst5' : 26,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (26, 18, None, None, 'ATCGAC'),
        'ovhgseq' : 'NN',
    }
rest_dict['ApyPI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AquII>GCCG.AC)|(?P<AquII_as>GT.CGGC)',
        'results' : None,
        'site' : 'GCCGNAC',
        'substrat' : 'DNA',
        'fst3' : 18,
        'fst5' : 27,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (27, 18, None, None, 'GCCGNAC'),
        'ovhgseq' : 'NN',
    }
rest_dict['AquII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AquIII>GAGGAG)|(?P<AquIII_as>CTCCTC)',
        'results' : None,
        'site' : 'GAGGAG',
        'substrat' : 'DNA',
        'fst3' : 18,
        'fst5' : 26,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (26, 18, None, None, 'GAGGAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['AquIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AquIV>G[AG]GGAAG)|(?P<AquIV_as>CTTCC[CT]C)',
        'results' : None,
        'site' : 'GRGGAAG',
        'substrat' : 'DNA',
        'fst3' : 17,
        'fst5' : 26,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (26, 17, None, None, 'GRGGAAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['AquIV'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ArsI>GAC......TT[CT]G)|(?P<ArsI_as>C[AG]AA......GTC)',
        'results' : None,
        'site' : 'GACNNNNNNTTYG',
        'substrat' : 'DNA',
        'fst3' : -26,
        'fst5' : -8,
        'freq' : 8192,
        'size' : 13,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : 6,
        'suppl' : ('I',),
        'scd5' : 24,
        'charac' : (-8, -26, 24, 6, 'GACNNNNNNTTYG'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['ArsI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AscI>GGCGCGCC)|(?P<AscI_as>GGCGCGCC)',
        'results' : None,
        'site' : 'GGCGCGCC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N', 'W'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GGCGCGCC'),
        'ovhgseq' : 'CGCG',
    }
rest_dict['AscI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AseI>ATTAAT)|(?P<AseI_as>ATTAAT)',
        'results' : None,
        'site' : 'ATTAAT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('J', 'N', 'O'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'ATTAAT'),
        'ovhgseq' : 'TA',
    }
rest_dict['AseI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Asi256I>GATC)|(?P<Asi256I_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GATC'),
        'ovhgseq' : 'AT',
    }
rest_dict['Asi256I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AsiGI>ACCGGT)|(?P<AsiGI_as>ACCGGT)',
        'results' : None,
        'site' : 'ACCGGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACCGGT'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['AsiGI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AsiSI>GCGATCGC)|(?P<AsiSI_as>GCGATCGC)',
        'results' : None,
        'site' : 'GCGATCGC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GCGATCGC'),
        'ovhgseq' : 'AT',
    }
rest_dict['AsiSI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Asp700I>GAA....TTC)|(?P<Asp700I_as>GAA....TTC)',
        'results' : None,
        'site' : 'GAANNNNTTC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GAANNNNTTC'),
        'ovhgseq' : '',
    }
rest_dict['Asp700I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Asp718I>GGTACC)|(?P<Asp718I_as>GGTACC)',
        'results' : None,
        'site' : 'GGTACC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGTACC'),
        'ovhgseq' : 'GTAC',
    }
rest_dict['Asp718I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AspA2I>CCTAGG)|(?P<AspA2I_as>CCTAGG)',
        'results' : None,
        'site' : 'CCTAGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCTAGG'),
        'ovhgseq' : 'CTAG',
    }
rest_dict['AspA2I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AspCNI>GCCGC)|(?P<AspCNI_as>GCGGC)',
        'results' : None,
        'site' : 'GCCGC',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'GCCGC'),
        'ovhgseq' : None,
    }
rest_dict['AspCNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AspEI>GAC.....GTC)|(?P<AspEI_as>GAC.....GTC)',
        'results' : None,
        'site' : 'GACNNNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'GACNNNNNGTC'),
        'ovhgseq' : 'N',
    }
rest_dict['AspEI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AspI>GAC...GTC)|(?P<AspI_as>GAC...GTC)',
        'results' : None,
        'site' : 'GACNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 9,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'GACNNNGTC'),
        'ovhgseq' : 'N',
    }
rest_dict['AspI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AspLEI>GCGC)|(?P<AspLEI_as>GCGC)',
        'results' : None,
        'site' : 'GCGC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GCGC'),
        'ovhgseq' : 'CG',
    }
rest_dict['AspLEI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AspS9I>GG.CC)|(?P<AspS9I_as>GG.CC)',
        'results' : None,
        'site' : 'GGNCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGNCC'),
        'ovhgseq' : 'GNC',
    }
rest_dict['AspS9I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AssI>AGTACT)|(?P<AssI_as>AGTACT)',
        'results' : None,
        'site' : 'AGTACT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('U',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'AGTACT'),
        'ovhgseq' : '',
    }
rest_dict['AssI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AsuC2I>CC[CG]GG)|(?P<AsuC2I_as>CC[CG]GG)',
        'results' : None,
        'site' : 'CCSGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCSGG'),
        'ovhgseq' : 'S',
    }
rest_dict['AsuC2I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AsuHPI>GGTGA)|(?P<AsuHPI_as>TCACC)',
        'results' : None,
        'site' : 'GGTGA',
        'substrat' : 'DNA',
        'fst3' : 7,
        'fst5' : 13,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (13, 7, None, None, 'GGTGA'),
        'ovhgseq' : 'N',
    }
rest_dict['AsuHPI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AsuI>GG.CC)|(?P<AsuI_as>GG.CC)',
        'results' : None,
        'site' : 'GGNCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGNCC'),
        'ovhgseq' : 'GNC',
    }
rest_dict['AsuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AsuII>TTCGAA)|(?P<AsuII_as>TTCGAA)',
        'results' : None,
        'site' : 'TTCGAA',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('C',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'TTCGAA'),
        'ovhgseq' : 'CG',
    }
rest_dict['AsuII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AsuNHI>GCTAGC)|(?P<AsuNHI_as>GCTAGC)',
        'results' : None,
        'site' : 'GCTAGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GCTAGC'),
        'ovhgseq' : 'CTAG',
    }
rest_dict['AsuNHI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AvaI>C[CT]CG[AG]G)|(?P<AvaI_as>C[CT]CG[AG]G)',
        'results' : None,
        'site' : 'CYCGRG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'J', 'M', 'N', 'O', 'R', 'S', 'U', 'W', 'X'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CYCGRG'),
        'ovhgseq' : 'YCGR',
    }
rest_dict['AvaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AvaII>GG[AT]CC)|(?P<AvaII_as>GG[AT]CC)',
        'results' : None,
        'site' : 'GGWCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('J', 'K', 'M', 'N', 'R', 'S', 'W', 'Y'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGWCC'),
        'ovhgseq' : 'GWC',
    }
rest_dict['AvaII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AvaIII>ATGCAT)|(?P<AvaIII_as>ATGCAT)',
        'results' : None,
        'site' : 'ATGCAT',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'ATGCAT'),
        'ovhgseq' : None,
    }
rest_dict['AvaIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AviII>TGCGCA)|(?P<AviII_as>TGCGCA)',
        'results' : None,
        'site' : 'TGCGCA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TGCGCA'),
        'ovhgseq' : '',
    }
rest_dict['AviII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AvrII>CCTAGG)|(?P<AvrII_as>CCTAGG)',
        'results' : None,
        'site' : 'CCTAGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCTAGG'),
        'ovhgseq' : 'CTAG',
    }
rest_dict['AvrII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<AxyI>CCT.AGG)|(?P<AxyI_as>CCT.AGG)',
        'results' : None,
        'site' : 'CCTNAGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('J',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCTNAGG'),
        'ovhgseq' : 'TNA',
    }
rest_dict['AxyI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BaeGI>G[GT]GC[AC]C)|(?P<BaeGI_as>G[GT]GC[AC]C)',
        'results' : None,
        'site' : 'GKGCMC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GKGCMC'),
        'ovhgseq' : 'KGCM',
    }
rest_dict['BaeGI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BaeI>AC....GTA[CT]C)|(?P<BaeI_as>G[AG]TAC....GT)',
        'results' : None,
        'site' : 'ACNNNNGTAYC',
        'substrat' : 'DNA',
        'fst3' : -26,
        'fst5' : -10,
        'freq' : 8192,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : 7,
        'suppl' : ('N',),
        'scd5' : 23,
        'charac' : (-10, -26, 23, 7, 'ACNNNNGTAYC'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['BaeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BalI>TGGCCA)|(?P<BalI_as>TGGCCA)',
        'results' : None,
        'site' : 'TGGCCA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('J', 'K', 'R', 'X'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TGGCCA'),
        'ovhgseq' : '',
    }
rest_dict['BalI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BamHI>GGATCC)|(?P<BamHI_as>GGATCC)',
        'results' : None,
        'site' : 'GGATCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGATCC'),
        'ovhgseq' : 'GATC',
    }
rest_dict['BamHI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BanI>GG[CT][AG]CC)|(?P<BanI_as>GG[CT][AG]CC)',
        'results' : None,
        'site' : 'GGYRCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N', 'O', 'R', 'U'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGYRCC'),
        'ovhgseq' : 'GYRC',
    }
rest_dict['BanI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BanII>G[AG]GC[CT]C)|(?P<BanII_as>G[AG]GC[CT]C)',
        'results' : None,
        'site' : 'GRGCYC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('K', 'N', 'O', 'Q', 'R', 'W', 'X'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GRGCYC'),
        'ovhgseq' : 'RGCY',
    }
rest_dict['BanII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BanIII>ATCGAT)|(?P<BanIII_as>ATCGAT)',
        'results' : None,
        'site' : 'ATCGAT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('O',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'ATCGAT'),
        'ovhgseq' : 'CG',
    }
rest_dict['BanIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BarI>GAAG......TAC)|(?P<BarI_as>GTA......CTTC)',
        'results' : None,
        'site' : 'GAAGNNNNNNTAC',
        'substrat' : 'DNA',
        'fst3' : -25,
        'fst5' : -7,
        'freq' : 16384,
        'size' : 13,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : 7,
        'suppl' : ('I',),
        'scd5' : 25,
        'charac' : (-7, -25, 25, 7, 'GAAGNNNNNNTAC'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['BarI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BasI>CCA.....TGG)|(?P<BasI_as>CCA.....TGG)',
        'results' : None,
        'site' : 'CCANNNNNTGG',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('U',),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'CCANNNNNTGG'),
        'ovhgseq' : 'NNN',
    }
rest_dict['BasI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BauI>CACGAG)|(?P<BauI_as>CTCGTG)',
        'results' : None,
        'site' : 'CACGAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CACGAG'),
        'ovhgseq' : 'ACGA',
    }
rest_dict['BauI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BbeI>GGCGCC)|(?P<BbeI_as>GGCGCC)',
        'results' : None,
        'site' : 'GGCGCC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GGCGCC'),
        'ovhgseq' : 'GCGC',
    }
rest_dict['BbeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bbr7I>GAAGAC)|(?P<Bbr7I_as>GTCTTC)',
        'results' : None,
        'site' : 'GAAGAC',
        'substrat' : 'DNA',
        'fst3' : 11,
        'fst5' : 13,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (13, 11, None, None, 'GAAGAC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['Bbr7I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BbrPI>CACGTG)|(?P<BbrPI_as>CACGTG)',
        'results' : None,
        'site' : 'CACGTG',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('M', 'O'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CACGTG'),
        'ovhgseq' : '',
    }
rest_dict['BbrPI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BbsI>GAAGAC)|(?P<BbsI_as>GTCTTC)',
        'results' : None,
        'site' : 'GAAGAC',
        'substrat' : 'DNA',
        'fst3' : 6,
        'fst5' : 8,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (8, 6, None, None, 'GAAGAC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BbsI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BbuI>GCATGC)|(?P<BbuI_as>GCATGC)',
        'results' : None,
        'site' : 'GCATGC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('R',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GCATGC'),
        'ovhgseq' : 'CATG',
    }
rest_dict['BbuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bbv12I>G[AT]GC[AT]C)|(?P<Bbv12I_as>G[AT]GC[AT]C)',
        'results' : None,
        'site' : 'GWGCWC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GWGCWC'),
        'ovhgseq' : 'WGCW',
    }
rest_dict['Bbv12I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BbvCI>CCTCAGC)|(?P<BbvCI_as>GCTGAGG)',
        'results' : None,
        'site' : 'CCTCAGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 16384,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCTCAGC'),
        'ovhgseq' : 'TCA',
    }
rest_dict['BbvCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BbvI>GCAGC)|(?P<BbvI_as>GCTGC)',
        'results' : None,
        'site' : 'GCAGC',
        'substrat' : 'DNA',
        'fst3' : 12,
        'fst5' : 13,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (13, 12, None, None, 'GCAGC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BbvI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BbvII>GAAGAC)|(?P<BbvII_as>GTCTTC)',
        'results' : None,
        'site' : 'GAAGAC',
        'substrat' : 'DNA',
        'fst3' : 6,
        'fst5' : 8,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (8, 6, None, None, 'GAAGAC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BbvII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BccI>CCATC)|(?P<BccI_as>GATGG)',
        'results' : None,
        'site' : 'CCATC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 9,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (9, 5, None, None, 'CCATC'),
        'ovhgseq' : 'N',
    }
rest_dict['BccI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bce83I>CTTGAG)|(?P<Bce83I_as>CTCAAG)',
        'results' : None,
        'site' : 'CTTGAG',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 22,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (22, 14, None, None, 'CTTGAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['Bce83I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BceAI>ACGGC)|(?P<BceAI_as>GCCGT)',
        'results' : None,
        'site' : 'ACGGC',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 17,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (17, 14, None, None, 'ACGGC'),
        'ovhgseq' : 'NN',
    }
rest_dict['BceAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BcefI>ACGGC)|(?P<BcefI_as>GCCGT)',
        'results' : None,
        'site' : 'ACGGC',
        'substrat' : 'DNA',
        'fst3' : 13,
        'fst5' : 17,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (17, 13, None, None, 'ACGGC'),
        'ovhgseq' : 'N',
    }
rest_dict['BcefI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BcgI>CGA......TGC)|(?P<BcgI_as>GCA......TCG)',
        'results' : None,
        'site' : 'CGANNNNNNTGC',
        'substrat' : 'DNA',
        'fst3' : -24,
        'fst5' : -10,
        'freq' : 4096,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : 10,
        'suppl' : ('N',),
        'scd5' : 24,
        'charac' : (-10, -24, 24, 10, 'CGANNNNNNTGC'),
        'ovhgseq' : 'NN',
    }
rest_dict['BcgI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BciVI>GTATCC)|(?P<BciVI_as>GGATAC)',
        'results' : None,
        'site' : 'GTATCC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 12,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (12, 5, None, None, 'GTATCC'),
        'ovhgseq' : 'N',
    }
rest_dict['BciVI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BclI>TGATCA)|(?P<BclI_as>TGATCA)',
        'results' : None,
        'site' : 'TGATCA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('C', 'F', 'J', 'M', 'N', 'O', 'R', 'S', 'U', 'W', 'Y'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TGATCA'),
        'ovhgseq' : 'GATC',
    }
rest_dict['BclI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BcnI>CC[CG]GG)|(?P<BcnI_as>CC[CG]GG)',
        'results' : None,
        'site' : 'CCSGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('F', 'K'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCSGG'),
        'ovhgseq' : 'S',
    }
rest_dict['BcnI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BcuI>ACTAGT)|(?P<BcuI_as>ACTAGT)',
        'results' : None,
        'site' : 'ACTAGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACTAGT'),
        'ovhgseq' : 'CTAG',
    }
rest_dict['BcuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BdaI>TGA......TCA)|(?P<BdaI_as>TGA......TCA)',
        'results' : None,
        'site' : 'TGANNNNNNTCA',
        'substrat' : 'DNA',
        'fst3' : -24,
        'fst5' : -10,
        'freq' : 4096,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : 10,
        'suppl' : ('F',),
        'scd5' : 24,
        'charac' : (-10, -24, 24, 10, 'TGANNNNNNTCA'),
        'ovhgseq' : 'NN',
    }
rest_dict['BdaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BetI>[AT]CCGG[AT])|(?P<BetI_as>[AT]CCGG[AT])',
        'results' : None,
        'site' : 'WCCGGW',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'WCCGGW'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['BetI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BfaI>CTAG)|(?P<BfaI_as>CTAG)',
        'results' : None,
        'site' : 'CTAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTAG'),
        'ovhgseq' : 'TA',
    }
rest_dict['BfaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BfiI>ACTGGG)|(?P<BfiI_as>CCCAGT)',
        'results' : None,
        'site' : 'ACTGGG',
        'substrat' : 'DNA',
        'fst3' : 4,
        'fst5' : 11,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (11, 4, None, None, 'ACTGGG'),
        'ovhgseq' : 'N',
    }
rest_dict['BfiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BfmI>CT[AG][CT]AG)|(?P<BfmI_as>CT[AG][CT]AG)',
        'results' : None,
        'site' : 'CTRYAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTRYAG'),
        'ovhgseq' : 'TRYA',
    }
rest_dict['BfmI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BfoI>[AG]GCGC[CT])|(?P<BfoI_as>[AG]GCGC[CT])',
        'results' : None,
        'site' : 'RGCGCY',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'RGCGCY'),
        'ovhgseq' : 'GCGC',
    }
rest_dict['BfoI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BfrI>CTTAAG)|(?P<BfrI_as>CTTAAG)',
        'results' : None,
        'site' : 'CTTAAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('M', 'O'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTTAAG'),
        'ovhgseq' : 'TTAA',
    }
rest_dict['BfrI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BfuAI>ACCTGC)|(?P<BfuAI_as>GCAGGT)',
        'results' : None,
        'site' : 'ACCTGC',
        'substrat' : 'DNA',
        'fst3' : 8,
        'fst5' : 10,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (10, 8, None, None, 'ACCTGC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BfuAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BfuCI>GATC)|(?P<BfuCI_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GATC'),
        'ovhgseq' : 'GATC',
    }
rest_dict['BfuCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BfuI>GTATCC)|(?P<BfuI_as>GGATAC)',
        'results' : None,
        'site' : 'GTATCC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 12,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (12, 5, None, None, 'GTATCC'),
        'ovhgseq' : 'N',
    }
rest_dict['BfuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BglI>GCC.....GGC)|(?P<BglI_as>GCC.....GGC)',
        'results' : None,
        'site' : 'GCCNNNNNGGC',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('C', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'GCCNNNNNGGC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['BglI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BglII>AGATCT)|(?P<BglII_as>AGATCT)',
        'results' : None,
        'site' : 'AGATCT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'AGATCT'),
        'ovhgseq' : 'GATC',
    }
rest_dict['BglII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BinI>GGATC)|(?P<BinI_as>GATCC)',
        'results' : None,
        'site' : 'GGATC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 9,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (9, 5, None, None, 'GGATC'),
        'ovhgseq' : 'N',
    }
rest_dict['BinI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BisI>GC.GC)|(?P<BisI_as>GC.GC)',
        'results' : None,
        'site' : 'GCNGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCNGC'),
        'ovhgseq' : 'N',
    }
rest_dict['BisI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BlnI>CCTAGG)|(?P<BlnI_as>CCTAGG)',
        'results' : None,
        'site' : 'CCTAGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('K', 'M', 'S'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCTAGG'),
        'ovhgseq' : 'CTAG',
    }
rest_dict['BlnI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BlpI>GCT.AGC)|(?P<BlpI_as>GCT.AGC)',
        'results' : None,
        'site' : 'GCTNAGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCTNAGC'),
        'ovhgseq' : 'TNA',
    }
rest_dict['BlpI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BlsI>GC.GC)|(?P<BlsI_as>GC.GC)',
        'results' : None,
        'site' : 'GCNGC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GCNGC'),
        'ovhgseq' : 'N',
    }
rest_dict['BlsI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BmcAI>AGTACT)|(?P<BmcAI_as>AGTACT)',
        'results' : None,
        'site' : 'AGTACT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'AGTACT'),
        'ovhgseq' : '',
    }
rest_dict['BmcAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bme1390I>CC.GG)|(?P<Bme1390I_as>CC.GG)',
        'results' : None,
        'site' : 'CCNGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCNGG'),
        'ovhgseq' : 'N',
    }
rest_dict['Bme1390I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bme18I>GG[AT]CC)|(?P<Bme18I_as>GG[AT]CC)',
        'results' : None,
        'site' : 'GGWCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGWCC'),
        'ovhgseq' : 'GWC',
    }
rest_dict['Bme18I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BmeRI>GAC.....GTC)|(?P<BmeRI_as>GAC.....GTC)',
        'results' : None,
        'site' : 'GACNNNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'GACNNNNNGTC'),
        'ovhgseq' : 'N',
    }
rest_dict['BmeRI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BmeT110I>C[CT]CG[AG]G)|(?P<BmeT110I_as>C[CT]CG[AG]G)',
        'results' : None,
        'site' : 'CYCGRG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CYCGRG'),
        'ovhgseq' : 'YCGR',
    }
rest_dict['BmeT110I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BmgBI>CACGTC)|(?P<BmgBI_as>GACGTG)',
        'results' : None,
        'site' : 'CACGTC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CACGTC'),
        'ovhgseq' : '',
    }
rest_dict['BmgBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BmgI>G[GT]GCCC)|(?P<BmgI_as>GGGC[AC]C)',
        'results' : None,
        'site' : 'GKGCCC',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 2048,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'GKGCCC'),
        'ovhgseq' : None,
    }
rest_dict['BmgI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BmgT120I>GG.CC)|(?P<BmgT120I_as>GG.CC)',
        'results' : None,
        'site' : 'GGNCC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GGNCC'),
        'ovhgseq' : 'N',
    }
rest_dict['BmgT120I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BmiI>GG..CC)|(?P<BmiI_as>GG..CC)',
        'results' : None,
        'site' : 'GGNNCC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GGNNCC'),
        'ovhgseq' : '',
    }
rest_dict['BmiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BmrFI>CC.GG)|(?P<BmrFI_as>CC.GG)',
        'results' : None,
        'site' : 'CCNGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCNGG'),
        'ovhgseq' : 'N',
    }
rest_dict['BmrFI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BmrI>ACTGGG)|(?P<BmrI_as>CCCAGT)',
        'results' : None,
        'site' : 'ACTGGG',
        'substrat' : 'DNA',
        'fst3' : 4,
        'fst5' : 11,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (11, 4, None, None, 'ACTGGG'),
        'ovhgseq' : 'N',
    }
rest_dict['BmrI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BmsI>GCATC)|(?P<BmsI_as>GATGC)',
        'results' : None,
        'site' : 'GCATC',
        'substrat' : 'DNA',
        'fst3' : 9,
        'fst5' : 10,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (10, 9, None, None, 'GCATC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BmsI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BmtI>GCTAGC)|(?P<BmtI_as>GCTAGC)',
        'results' : None,
        'site' : 'GCTAGC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I', 'N', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GCTAGC'),
        'ovhgseq' : 'CTAG',
    }
rest_dict['BmtI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BmuI>ACTGGG)|(?P<BmuI_as>CCCAGT)',
        'results' : None,
        'site' : 'ACTGGG',
        'substrat' : 'DNA',
        'fst3' : 4,
        'fst5' : 11,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (11, 4, None, None, 'ACTGGG'),
        'ovhgseq' : 'N',
    }
rest_dict['BmuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BoxI>GAC....GTC)|(?P<BoxI_as>GAC....GTC)',
        'results' : None,
        'site' : 'GACNNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GACNNNNGTC'),
        'ovhgseq' : '',
    }
rest_dict['BoxI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BpiI>GAAGAC)|(?P<BpiI_as>GTCTTC)',
        'results' : None,
        'site' : 'GAAGAC',
        'substrat' : 'DNA',
        'fst3' : 6,
        'fst5' : 8,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (8, 6, None, None, 'GAAGAC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BpiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BplI>GAG.....CTC)|(?P<BplI_as>GAG.....CTC)',
        'results' : None,
        'site' : 'GAGNNNNNCTC',
        'substrat' : 'DNA',
        'fst3' : -24,
        'fst5' : -8,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : 8,
        'suppl' : ('F',),
        'scd5' : 24,
        'charac' : (-8, -24, 24, 8, 'GAGNNNNNCTC'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['BplI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BpmI>CTGGAG)|(?P<BpmI_as>CTCCAG)',
        'results' : None,
        'site' : 'CTGGAG',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 22,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I', 'N'),
        'scd5' : None,
        'charac' : (22, 14, None, None, 'CTGGAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['BpmI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bpu10I>CCT.AGC)|(?P<Bpu10I_as>GCT.AGG)',
        'results' : None,
        'site' : 'CCTNAGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F', 'I', 'N', 'V'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCTNAGC'),
        'ovhgseq' : 'TNA',
    }
rest_dict['Bpu10I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bpu1102I>GCT.AGC)|(?P<Bpu1102I_as>GCT.AGC)',
        'results' : None,
        'site' : 'GCTNAGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F', 'K'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCTNAGC'),
        'ovhgseq' : 'TNA',
    }
rest_dict['Bpu1102I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bpu14I>TTCGAA)|(?P<Bpu14I_as>TTCGAA)',
        'results' : None,
        'site' : 'TTCGAA',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'TTCGAA'),
        'ovhgseq' : 'CG',
    }
rest_dict['Bpu14I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BpuAI>GAAGAC)|(?P<BpuAI_as>GTCTTC)',
        'results' : None,
        'site' : 'GAAGAC',
        'substrat' : 'DNA',
        'fst3' : 6,
        'fst5' : 8,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (8, 6, None, None, 'GAAGAC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BpuAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BpuEI>CTTGAG)|(?P<BpuEI_as>CTCAAG)',
        'results' : None,
        'site' : 'CTTGAG',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 22,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (22, 14, None, None, 'CTTGAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['BpuEI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BpuMI>CC[CG]GG)|(?P<BpuMI_as>CC[CG]GG)',
        'results' : None,
        'site' : 'CCSGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCSGG'),
        'ovhgseq' : 'S',
    }
rest_dict['BpuMI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BpvUI>CGATCG)|(?P<BpvUI_as>CGATCG)',
        'results' : None,
        'site' : 'CGATCG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CGATCG'),
        'ovhgseq' : 'AT',
    }
rest_dict['BpvUI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsa29I>ATCGAT)|(?P<Bsa29I_as>ATCGAT)',
        'results' : None,
        'site' : 'ATCGAT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'ATCGAT'),
        'ovhgseq' : 'CG',
    }
rest_dict['Bsa29I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsaAI>[CT]ACGT[AG])|(?P<BsaAI_as>[CT]ACGT[AG])',
        'results' : None,
        'site' : 'YACGTR',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'YACGTR'),
        'ovhgseq' : '',
    }
rest_dict['BsaAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsaBI>GAT....ATC)|(?P<BsaBI_as>GAT....ATC)',
        'results' : None,
        'site' : 'GATNNNNATC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GATNNNNATC'),
        'ovhgseq' : '',
    }
rest_dict['BsaBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsaHI>G[AG]CG[CT]C)|(?P<BsaHI_as>G[AG]CG[CT]C)',
        'results' : None,
        'site' : 'GRCGYC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GRCGYC'),
        'ovhgseq' : 'CG',
    }
rest_dict['BsaHI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsaI>GGTCTC)|(?P<BsaI_as>GAGACC)',
        'results' : None,
        'site' : 'GGTCTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (7, 5, None, None, 'GGTCTC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BsaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsaJI>CC..GG)|(?P<BsaJI_as>CC..GG)',
        'results' : None,
        'site' : 'CCNNGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCNNGG'),
        'ovhgseq' : 'CNNG',
    }
rest_dict['BsaJI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsaMI>GAATGC)|(?P<BsaMI_as>GCATTC)',
        'results' : None,
        'site' : 'GAATGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('R',),
        'scd5' : None,
        'charac' : (7, -1, None, None, 'GAATGC'),
        'ovhgseq' : 'CN',
    }
rest_dict['BsaMI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsaWI>[AT]CCGG[AT])|(?P<BsaWI_as>[AT]CCGG[AT])',
        'results' : None,
        'site' : 'WCCGGW',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'WCCGGW'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['BsaWI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsaXI>AC.....CTCC)|(?P<BsaXI_as>GGAG.....GT)',
        'results' : None,
        'site' : 'ACNNNNNCTCC',
        'substrat' : 'DNA',
        'fst3' : -23,
        'fst5' : -9,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : 7,
        'suppl' : ('N',),
        'scd5' : 21,
        'charac' : (-9, -23, 21, 7, 'ACNNNNNCTCC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['BsaXI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsbI>CAACAC)|(?P<BsbI_as>GTGTTG)',
        'results' : None,
        'site' : 'CAACAC',
        'substrat' : 'DNA',
        'fst3' : 19,
        'fst5' : 27,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (27, 19, None, None, 'CAACAC'),
        'ovhgseq' : 'NN',
    }
rest_dict['BsbI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsc4I>CC.......GG)|(?P<Bsc4I_as>CC.......GG)',
        'results' : None,
        'site' : 'CCNNNNNNNGG',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 256,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'CCNNNNNNNGG'),
        'ovhgseq' : 'NNN',
    }
rest_dict['Bsc4I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BscAI>GCATC)|(?P<BscAI_as>GATGC)',
        'results' : None,
        'site' : 'GCATC',
        'substrat' : 'DNA',
        'fst3' : 6,
        'fst5' : 9,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (9, 6, None, None, 'GCATC'),
        'ovhgseq' : 'NN',
    }
rest_dict['BscAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BscGI>CCCGT)|(?P<BscGI_as>ACGGG)',
        'results' : None,
        'site' : 'CCCGT',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'CCCGT'),
        'ovhgseq' : None,
    }
rest_dict['BscGI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bse118I>[AG]CCGG[CT])|(?P<Bse118I_as>[AG]CCGG[CT])',
        'results' : None,
        'site' : 'RCCGGY',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'RCCGGY'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['Bse118I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bse1I>ACTGG)|(?P<Bse1I_as>CCAGT)',
        'results' : None,
        'site' : 'ACTGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 6,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (6, -1, None, None, 'ACTGG'),
        'ovhgseq' : 'GN',
    }
rest_dict['Bse1I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bse21I>CCT.AGG)|(?P<Bse21I_as>CCT.AGG)',
        'results' : None,
        'site' : 'CCTNAGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCTNAGG'),
        'ovhgseq' : 'TNA',
    }
rest_dict['Bse21I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bse3DI>GCAATG)|(?P<Bse3DI_as>CATTGC)',
        'results' : None,
        'site' : 'GCAATG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 8,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (8, 0, None, None, 'GCAATG'),
        'ovhgseq' : 'NN',
    }
rest_dict['Bse3DI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bse8I>GAT....ATC)|(?P<Bse8I_as>GAT....ATC)',
        'results' : None,
        'site' : 'GATNNNNATC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GATNNNNATC'),
        'ovhgseq' : '',
    }
rest_dict['Bse8I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseAI>TCCGGA)|(?P<BseAI_as>TCCGGA)',
        'results' : None,
        'site' : 'TCCGGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('C', 'M'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCCGGA'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['BseAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseBI>CC[AT]GG)|(?P<BseBI_as>CC[AT]GG)',
        'results' : None,
        'site' : 'CCWGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('C',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCWGG'),
        'ovhgseq' : 'W',
    }
rest_dict['BseBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseCI>ATCGAT)|(?P<BseCI_as>ATCGAT)',
        'results' : None,
        'site' : 'ATCGAT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('C',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'ATCGAT'),
        'ovhgseq' : 'CG',
    }
rest_dict['BseCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseDI>CC..GG)|(?P<BseDI_as>CC..GG)',
        'results' : None,
        'site' : 'CCNNGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCNNGG'),
        'ovhgseq' : 'CNNG',
    }
rest_dict['BseDI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseGI>GGATG)|(?P<BseGI_as>CATCC)',
        'results' : None,
        'site' : 'GGATG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 7,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (7, 0, None, None, 'GGATG'),
        'ovhgseq' : 'NN',
    }
rest_dict['BseGI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseJI>GAT....ATC)|(?P<BseJI_as>GAT....ATC)',
        'results' : None,
        'site' : 'GATNNNNATC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GATNNNNATC'),
        'ovhgseq' : '',
    }
rest_dict['BseJI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseLI>CC.......GG)|(?P<BseLI_as>CC.......GG)',
        'results' : None,
        'site' : 'CCNNNNNNNGG',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 256,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'CCNNNNNNNGG'),
        'ovhgseq' : 'NNN',
    }
rest_dict['BseLI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseMI>GCAATG)|(?P<BseMI_as>CATTGC)',
        'results' : None,
        'site' : 'GCAATG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 8,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (8, 0, None, None, 'GCAATG'),
        'ovhgseq' : 'NN',
    }
rest_dict['BseMI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseMII>CTCAG)|(?P<BseMII_as>CTGAG)',
        'results' : None,
        'site' : 'CTCAG',
        'substrat' : 'DNA',
        'fst3' : 8,
        'fst5' : 15,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (15, 8, None, None, 'CTCAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['BseMII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseNI>ACTGG)|(?P<BseNI_as>CCAGT)',
        'results' : None,
        'site' : 'ACTGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 6,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (6, -1, None, None, 'ACTGG'),
        'ovhgseq' : 'GN',
    }
rest_dict['BseNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsePI>GCGCGC)|(?P<BsePI_as>GCGCGC)',
        'results' : None,
        'site' : 'GCGCGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GCGCGC'),
        'ovhgseq' : 'CGCG',
    }
rest_dict['BsePI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseRI>GAGGAG)|(?P<BseRI_as>CTCCTC)',
        'results' : None,
        'site' : 'GAGGAG',
        'substrat' : 'DNA',
        'fst3' : 8,
        'fst5' : 16,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (16, 8, None, None, 'GAGGAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['BseRI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseSI>G[GT]GC[AC]C)|(?P<BseSI_as>G[GT]GC[AC]C)',
        'results' : None,
        'site' : 'GKGCMC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GKGCMC'),
        'ovhgseq' : 'KGCM',
    }
rest_dict['BseSI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseX3I>CGGCCG)|(?P<BseX3I_as>CGGCCG)',
        'results' : None,
        'site' : 'CGGCCG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CGGCCG'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['BseX3I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseXI>GCAGC)|(?P<BseXI_as>GCTGC)',
        'results' : None,
        'site' : 'GCAGC',
        'substrat' : 'DNA',
        'fst3' : 12,
        'fst5' : 13,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (13, 12, None, None, 'GCAGC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BseXI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BseYI>CCCAGC)|(?P<BseYI_as>GCTGGG)',
        'results' : None,
        'site' : 'CCCAGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCCAGC'),
        'ovhgseq' : 'CCAG',
    }
rest_dict['BseYI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsgI>GTGCAG)|(?P<BsgI_as>CTGCAC)',
        'results' : None,
        'site' : 'GTGCAG',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 22,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (22, 14, None, None, 'GTGCAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['BsgI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsh1236I>CGCG)|(?P<Bsh1236I_as>CGCG)',
        'results' : None,
        'site' : 'CGCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGCG'),
        'ovhgseq' : '',
    }
rest_dict['Bsh1236I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsh1285I>CG[AG][CT]CG)|(?P<Bsh1285I_as>CG[AG][CT]CG)',
        'results' : None,
        'site' : 'CGRYCG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CGRYCG'),
        'ovhgseq' : 'RY',
    }
rest_dict['Bsh1285I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BshFI>GGCC)|(?P<BshFI_as>GGCC)',
        'results' : None,
        'site' : 'GGCC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('C',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GGCC'),
        'ovhgseq' : '',
    }
rest_dict['BshFI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BshNI>GG[CT][AG]CC)|(?P<BshNI_as>GG[CT][AG]CC)',
        'results' : None,
        'site' : 'GGYRCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGYRCC'),
        'ovhgseq' : 'GYRC',
    }
rest_dict['BshNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BshTI>ACCGGT)|(?P<BshTI_as>ACCGGT)',
        'results' : None,
        'site' : 'ACCGGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACCGGT'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['BshTI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BshVI>ATCGAT)|(?P<BshVI_as>ATCGAT)',
        'results' : None,
        'site' : 'ATCGAT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'ATCGAT'),
        'ovhgseq' : 'CG',
    }
rest_dict['BshVI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsiEI>CG[AG][CT]CG)|(?P<BsiEI_as>CG[AG][CT]CG)',
        'results' : None,
        'site' : 'CGRYCG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CGRYCG'),
        'ovhgseq' : 'RY',
    }
rest_dict['BsiEI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsiHKAI>G[AT]GC[AT]C)|(?P<BsiHKAI_as>G[AT]GC[AT]C)',
        'results' : None,
        'site' : 'GWGCWC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GWGCWC'),
        'ovhgseq' : 'WGCW',
    }
rest_dict['BsiHKAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsiHKCI>C[CT]CG[AG]G)|(?P<BsiHKCI_as>C[CT]CG[AG]G)',
        'results' : None,
        'site' : 'CYCGRG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('Q', 'X'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CYCGRG'),
        'ovhgseq' : 'YCGR',
    }
rest_dict['BsiHKCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsiI>CACGAG)|(?P<BsiI_as>CTCGTG)',
        'results' : None,
        'site' : 'CACGAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CACGAG'),
        'ovhgseq' : 'ACGA',
    }
rest_dict['BsiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsiSI>CCGG)|(?P<BsiSI_as>CCGG)',
        'results' : None,
        'site' : 'CCGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('C',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCGG'),
        'ovhgseq' : 'CG',
    }
rest_dict['BsiSI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsiWI>CGTACG)|(?P<BsiWI_as>CGTACG)',
        'results' : None,
        'site' : 'CGTACG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('M', 'N', 'O'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CGTACG'),
        'ovhgseq' : 'GTAC',
    }
rest_dict['BsiWI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsiYI>CC.......GG)|(?P<BsiYI_as>CC.......GG)',
        'results' : None,
        'site' : 'CCNNNNNNNGG',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 256,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'CCNNNNNNNGG'),
        'ovhgseq' : 'NNN',
    }
rest_dict['BsiYI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BslFI>GGGAC)|(?P<BslFI_as>GTCCC)',
        'results' : None,
        'site' : 'GGGAC',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 15,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (15, 14, None, None, 'GGGAC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BslFI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BslI>CC.......GG)|(?P<BslI_as>CC.......GG)',
        'results' : None,
        'site' : 'CCNNNNNNNGG',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 256,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('N', 'W'),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'CCNNNNNNNGG'),
        'ovhgseq' : 'NNN',
    }
rest_dict['BslI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsmAI>GTCTC)|(?P<BsmAI_as>GAGAC)',
        'results' : None,
        'site' : 'GTCTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 6,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (6, 5, None, None, 'GTCTC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BsmAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsmBI>CGTCTC)|(?P<BsmBI_as>GAGACG)',
        'results' : None,
        'site' : 'CGTCTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (7, 5, None, None, 'CGTCTC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BsmBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsmFI>GGGAC)|(?P<BsmFI_as>GTCCC)',
        'results' : None,
        'site' : 'GGGAC',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 15,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (15, 14, None, None, 'GGGAC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BsmFI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsmI>GAATGC)|(?P<BsmI_as>GCATTC)',
        'results' : None,
        'site' : 'GAATGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('J', 'M', 'N', 'O', 'S', 'W'),
        'scd5' : None,
        'charac' : (7, -1, None, None, 'GAATGC'),
        'ovhgseq' : 'CN',
    }
rest_dict['BsmI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsnI>GGCC)|(?P<BsnI_as>GGCC)',
        'results' : None,
        'site' : 'GGCC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GGCC'),
        'ovhgseq' : '',
    }
rest_dict['BsnI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bso31I>GGTCTC)|(?P<Bso31I_as>GAGACC)',
        'results' : None,
        'site' : 'GGTCTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (7, 5, None, None, 'GGTCTC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['Bso31I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsoBI>C[CT]CG[AG]G)|(?P<BsoBI_as>C[CT]CG[AG]G)',
        'results' : None,
        'site' : 'CYCGRG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CYCGRG'),
        'ovhgseq' : 'YCGR',
    }
rest_dict['BsoBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsp119I>TTCGAA)|(?P<Bsp119I_as>TTCGAA)',
        'results' : None,
        'site' : 'TTCGAA',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'TTCGAA'),
        'ovhgseq' : 'CG',
    }
rest_dict['Bsp119I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsp120I>GGGCCC)|(?P<Bsp120I_as>GGGCCC)',
        'results' : None,
        'site' : 'GGGCCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGGCCC'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['Bsp120I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsp1286I>G[AGT]GC[ACT]C)|(?P<Bsp1286I_as>G[AGT]GC[ACT]C)',
        'results' : None,
        'site' : 'GDGCHC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('J', 'K', 'N', 'R'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GDGCHC'),
        'ovhgseq' : 'DGCH',
    }
rest_dict['Bsp1286I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsp13I>TCCGGA)|(?P<Bsp13I_as>TCCGGA)',
        'results' : None,
        'site' : 'TCCGGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCCGGA'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['Bsp13I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsp1407I>TGTACA)|(?P<Bsp1407I_as>TGTACA)',
        'results' : None,
        'site' : 'TGTACA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F', 'K'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TGTACA'),
        'ovhgseq' : 'GTAC',
    }
rest_dict['Bsp1407I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsp143I>GATC)|(?P<Bsp143I_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GATC'),
        'ovhgseq' : 'GATC',
    }
rest_dict['Bsp143I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsp1720I>GCT.AGC)|(?P<Bsp1720I_as>GCT.AGC)',
        'results' : None,
        'site' : 'GCTNAGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCTNAGC'),
        'ovhgseq' : 'TNA',
    }
rest_dict['Bsp1720I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsp19I>CCATGG)|(?P<Bsp19I_as>CCATGG)',
        'results' : None,
        'site' : 'CCATGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCATGG'),
        'ovhgseq' : 'CATG',
    }
rest_dict['Bsp19I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsp24I>GAC......TGG)|(?P<Bsp24I_as>CCA......GTC)',
        'results' : None,
        'site' : 'GACNNNNNNTGG',
        'substrat' : 'DNA',
        'fst3' : -25,
        'fst5' : -8,
        'freq' : 4096,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : 7,
        'suppl' : (),
        'scd5' : 24,
        'charac' : (-8, -25, 24, 7, 'GACNNNNNNTGG'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['Bsp24I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsp68I>TCGCGA)|(?P<Bsp68I_as>TCGCGA)',
        'results' : None,
        'site' : 'TCGCGA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TCGCGA'),
        'ovhgseq' : '',
    }
rest_dict['Bsp68I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspACI>CCGC)|(?P<BspACI_as>GCGG)',
        'results' : None,
        'site' : 'CCGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCGC'),
        'ovhgseq' : 'CG',
    }
rest_dict['BspACI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspCNI>CTCAG)|(?P<BspCNI_as>CTGAG)',
        'results' : None,
        'site' : 'CTCAG',
        'substrat' : 'DNA',
        'fst3' : 7,
        'fst5' : 14,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (14, 7, None, None, 'CTCAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['BspCNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspD6I>GACTC)|(?P<BspD6I_as>GAGTC)',
        'results' : None,
        'site' : 'GACTC',
        'substrat' : 'DNA',
        'fst3' : 6,
        'fst5' : 9,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (9, 6, None, None, 'GACTC'),
        'ovhgseq' : 'NN',
    }
rest_dict['BspD6I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspDI>ATCGAT)|(?P<BspDI_as>ATCGAT)',
        'results' : None,
        'site' : 'ATCGAT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'ATCGAT'),
        'ovhgseq' : 'CG',
    }
rest_dict['BspDI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspEI>TCCGGA)|(?P<BspEI_as>TCCGGA)',
        'results' : None,
        'site' : 'TCCGGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCCGGA'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['BspEI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspFNI>CGCG)|(?P<BspFNI_as>CGCG)',
        'results' : None,
        'site' : 'CGCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGCG'),
        'ovhgseq' : '',
    }
rest_dict['BspFNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspGI>CTGGAC)|(?P<BspGI_as>GTCCAG)',
        'results' : None,
        'site' : 'CTGGAC',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'CTGGAC'),
        'ovhgseq' : None,
    }
rest_dict['BspGI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspHI>TCATGA)|(?P<BspHI_as>TCATGA)',
        'results' : None,
        'site' : 'TCATGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCATGA'),
        'ovhgseq' : 'CATG',
    }
rest_dict['BspHI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspLI>GG..CC)|(?P<BspLI_as>GG..CC)',
        'results' : None,
        'site' : 'GGNNCC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GGNNCC'),
        'ovhgseq' : '',
    }
rest_dict['BspLI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspLU11I>ACATGT)|(?P<BspLU11I_as>ACATGT)',
        'results' : None,
        'site' : 'ACATGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACATGT'),
        'ovhgseq' : 'CATG',
    }
rest_dict['BspLU11I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspMI>ACCTGC)|(?P<BspMI_as>GCAGGT)',
        'results' : None,
        'site' : 'ACCTGC',
        'substrat' : 'DNA',
        'fst3' : 8,
        'fst5' : 10,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (10, 8, None, None, 'ACCTGC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BspMI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspMII>TCCGGA)|(?P<BspMII_as>TCCGGA)',
        'results' : None,
        'site' : 'TCCGGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCCGGA'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['BspMII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspNCI>CCAGA)|(?P<BspNCI_as>TCTGG)',
        'results' : None,
        'site' : 'CCAGA',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'CCAGA'),
        'ovhgseq' : None,
    }
rest_dict['BspNCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspOI>GCTAGC)|(?P<BspOI_as>GCTAGC)',
        'results' : None,
        'site' : 'GCTAGC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GCTAGC'),
        'ovhgseq' : 'CTAG',
    }
rest_dict['BspOI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspPI>GGATC)|(?P<BspPI_as>GATCC)',
        'results' : None,
        'site' : 'GGATC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 9,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (9, 5, None, None, 'GGATC'),
        'ovhgseq' : 'N',
    }
rest_dict['BspPI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspQI>GCTCTTC)|(?P<BspQI_as>GAAGAGC)',
        'results' : None,
        'site' : 'GCTCTTC',
        'substrat' : 'DNA',
        'fst3' : 4,
        'fst5' : 8,
        'freq' : 16384,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (8, 4, None, None, 'GCTCTTC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['BspQI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspT104I>TTCGAA)|(?P<BspT104I_as>TTCGAA)',
        'results' : None,
        'site' : 'TTCGAA',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'TTCGAA'),
        'ovhgseq' : 'CG',
    }
rest_dict['BspT104I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspT107I>GG[CT][AG]CC)|(?P<BspT107I_as>GG[CT][AG]CC)',
        'results' : None,
        'site' : 'GGYRCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGYRCC'),
        'ovhgseq' : 'GYRC',
    }
rest_dict['BspT107I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspTI>CTTAAG)|(?P<BspTI_as>CTTAAG)',
        'results' : None,
        'site' : 'CTTAAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTTAAG'),
        'ovhgseq' : 'TTAA',
    }
rest_dict['BspTI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspTNI>GGTCTC)|(?P<BspTNI_as>GAGACC)',
        'results' : None,
        'site' : 'GGTCTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('Q', 'X'),
        'scd5' : None,
        'charac' : (7, 5, None, None, 'GGTCTC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BspTNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BspXI>ATCGAT)|(?P<BspXI_as>ATCGAT)',
        'results' : None,
        'site' : 'ATCGAT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('W',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'ATCGAT'),
        'ovhgseq' : 'CG',
    }
rest_dict['BspXI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsrBI>CCGCTC)|(?P<BsrBI_as>GAGCGG)',
        'results' : None,
        'site' : 'CCGCTC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CCGCTC'),
        'ovhgseq' : '',
    }
rest_dict['BsrBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsrDI>GCAATG)|(?P<BsrDI_as>CATTGC)',
        'results' : None,
        'site' : 'GCAATG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 8,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (8, 0, None, None, 'GCAATG'),
        'ovhgseq' : 'NN',
    }
rest_dict['BsrDI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsrFI>[AG]CCGG[CT])|(?P<BsrFI_as>[AG]CCGG[CT])',
        'results' : None,
        'site' : 'RCCGGY',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'RCCGGY'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['BsrFI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsrGI>TGTACA)|(?P<BsrGI_as>TGTACA)',
        'results' : None,
        'site' : 'TGTACA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TGTACA'),
        'ovhgseq' : 'GTAC',
    }
rest_dict['BsrGI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsrI>ACTGG)|(?P<BsrI_as>CCAGT)',
        'results' : None,
        'site' : 'ACTGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 6,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (6, -1, None, None, 'ACTGG'),
        'ovhgseq' : 'GN',
    }
rest_dict['BsrI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsrSI>ACTGG)|(?P<BsrSI_as>CCAGT)',
        'results' : None,
        'site' : 'ACTGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 6,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('R',),
        'scd5' : None,
        'charac' : (6, -1, None, None, 'ACTGG'),
        'ovhgseq' : 'GN',
    }
rest_dict['BsrSI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BssAI>[AG]CCGG[CT])|(?P<BssAI_as>[AG]CCGG[CT])',
        'results' : None,
        'site' : 'RCCGGY',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('C',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'RCCGGY'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['BssAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BssECI>CC..GG)|(?P<BssECI_as>CC..GG)',
        'results' : None,
        'site' : 'CCNNGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCNNGG'),
        'ovhgseq' : 'CNNG',
    }
rest_dict['BssECI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BssHII>GCGCGC)|(?P<BssHII_as>GCGCGC)',
        'results' : None,
        'site' : 'GCGCGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GCGCGC'),
        'ovhgseq' : 'CGCG',
    }
rest_dict['BssHII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BssKI>CC.GG)|(?P<BssKI_as>CC.GG)',
        'results' : None,
        'site' : 'CCNGG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'CCNGG'),
        'ovhgseq' : 'CCNGG',
    }
rest_dict['BssKI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BssMI>GATC)|(?P<BssMI_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GATC'),
        'ovhgseq' : 'GATC',
    }
rest_dict['BssMI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BssNAI>GTATAC)|(?P<BssNAI_as>GTATAC)',
        'results' : None,
        'site' : 'GTATAC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GTATAC'),
        'ovhgseq' : '',
    }
rest_dict['BssNAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BssNI>G[AG]CG[CT]C)|(?P<BssNI_as>G[AG]CG[CT]C)',
        'results' : None,
        'site' : 'GRCGYC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GRCGYC'),
        'ovhgseq' : 'CG',
    }
rest_dict['BssNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BssSI>CACGAG)|(?P<BssSI_as>CTCGTG)',
        'results' : None,
        'site' : 'CACGAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CACGAG'),
        'ovhgseq' : 'ACGA',
    }
rest_dict['BssSI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BssT1I>CC[AT][AT]GG)|(?P<BssT1I_as>CC[AT][AT]GG)',
        'results' : None,
        'site' : 'CCWWGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCWWGG'),
        'ovhgseq' : 'CWWG',
    }
rest_dict['BssT1I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bst1107I>GTATAC)|(?P<Bst1107I_as>GTATAC)',
        'results' : None,
        'site' : 'GTATAC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F', 'K', 'M'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GTATAC'),
        'ovhgseq' : '',
    }
rest_dict['Bst1107I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bst2BI>CACGAG)|(?P<Bst2BI_as>CTCGTG)',
        'results' : None,
        'site' : 'CACGAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CACGAG'),
        'ovhgseq' : 'ACGA',
    }
rest_dict['Bst2BI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bst2UI>CC[AT]GG)|(?P<Bst2UI_as>CC[AT]GG)',
        'results' : None,
        'site' : 'CCWGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCWGG'),
        'ovhgseq' : 'W',
    }
rest_dict['Bst2UI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bst4CI>AC.GT)|(?P<Bst4CI_as>AC.GT)',
        'results' : None,
        'site' : 'ACNGT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'ACNGT'),
        'ovhgseq' : 'N',
    }
rest_dict['Bst4CI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bst6I>CTCTTC)|(?P<Bst6I_as>GAAGAG)',
        'results' : None,
        'site' : 'CTCTTC',
        'substrat' : 'DNA',
        'fst3' : 4,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (7, 4, None, None, 'CTCTTC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['Bst6I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bst98I>CTTAAG)|(?P<Bst98I_as>CTTAAG)',
        'results' : None,
        'site' : 'CTTAAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('R',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTTAAG'),
        'ovhgseq' : 'TTAA',
    }
rest_dict['Bst98I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstACI>G[AG]CG[CT]C)|(?P<BstACI_as>G[AG]CG[CT]C)',
        'results' : None,
        'site' : 'GRCGYC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GRCGYC'),
        'ovhgseq' : 'CG',
    }
rest_dict['BstACI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstAFI>CTTAAG)|(?P<BstAFI_as>CTTAAG)',
        'results' : None,
        'site' : 'CTTAAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTTAAG'),
        'ovhgseq' : 'TTAA',
    }
rest_dict['BstAFI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstAPI>GCA.....TGC)|(?P<BstAPI_as>GCA.....TGC)',
        'results' : None,
        'site' : 'GCANNNNNTGC',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('I', 'N'),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'GCANNNNNTGC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['BstAPI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstAUI>TGTACA)|(?P<BstAUI_as>TGTACA)',
        'results' : None,
        'site' : 'TGTACA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TGTACA'),
        'ovhgseq' : 'GTAC',
    }
rest_dict['BstAUI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstBAI>[CT]ACGT[AG])|(?P<BstBAI_as>[CT]ACGT[AG])',
        'results' : None,
        'site' : 'YACGTR',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'YACGTR'),
        'ovhgseq' : '',
    }
rest_dict['BstBAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstBI>TTCGAA)|(?P<BstBI_as>TTCGAA)',
        'results' : None,
        'site' : 'TTCGAA',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'TTCGAA'),
        'ovhgseq' : 'CG',
    }
rest_dict['BstBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstC8I>GC..GC)|(?P<BstC8I_as>GC..GC)',
        'results' : None,
        'site' : 'GCNNGC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GCNNGC'),
        'ovhgseq' : '',
    }
rest_dict['BstC8I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstDEI>CT.AG)|(?P<BstDEI_as>CT.AG)',
        'results' : None,
        'site' : 'CTNAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTNAG'),
        'ovhgseq' : 'TNA',
    }
rest_dict['BstDEI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstDSI>CC[AG][CT]GG)|(?P<BstDSI_as>CC[AG][CT]GG)',
        'results' : None,
        'site' : 'CCRYGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCRYGG'),
        'ovhgseq' : 'CRYG',
    }
rest_dict['BstDSI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstEII>GGT.ACC)|(?P<BstEII_as>GGT.ACC)',
        'results' : None,
        'site' : 'GGTNACC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('C', 'H', 'J', 'M', 'N', 'O', 'R', 'S', 'U', 'W'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGTNACC'),
        'ovhgseq' : 'GTNAC',
    }
rest_dict['BstEII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstENI>CCT.....AGG)|(?P<BstENI_as>CCT.....AGG)',
        'results' : None,
        'site' : 'CCTNNNNNAGG',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'CCTNNNNNAGG'),
        'ovhgseq' : 'N',
    }
rest_dict['BstENI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstF5I>GGATG)|(?P<BstF5I_as>CATCC)',
        'results' : None,
        'site' : 'GGATG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 7,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (7, 0, None, None, 'GGATG'),
        'ovhgseq' : 'NN',
    }
rest_dict['BstF5I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstFNI>CGCG)|(?P<BstFNI_as>CGCG)',
        'results' : None,
        'site' : 'CGCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGCG'),
        'ovhgseq' : '',
    }
rest_dict['BstFNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstH2I>[AG]GCGC[CT])|(?P<BstH2I_as>[AG]GCGC[CT])',
        'results' : None,
        'site' : 'RGCGCY',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'RGCGCY'),
        'ovhgseq' : 'GCGC',
    }
rest_dict['BstH2I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstHHI>GCGC)|(?P<BstHHI_as>GCGC)',
        'results' : None,
        'site' : 'GCGC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GCGC'),
        'ovhgseq' : 'CG',
    }
rest_dict['BstHHI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstKTI>GATC)|(?P<BstKTI_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GATC'),
        'ovhgseq' : 'AT',
    }
rest_dict['BstKTI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstMAI>GTCTC)|(?P<BstMAI_as>GAGAC)',
        'results' : None,
        'site' : 'GTCTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 6,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (6, 5, None, None, 'GTCTC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BstMAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstMBI>GATC)|(?P<BstMBI_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GATC'),
        'ovhgseq' : 'GATC',
    }
rest_dict['BstMBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstMCI>CG[AG][CT]CG)|(?P<BstMCI_as>CG[AG][CT]CG)',
        'results' : None,
        'site' : 'CGRYCG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CGRYCG'),
        'ovhgseq' : 'RY',
    }
rest_dict['BstMCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstMWI>GC.......GC)|(?P<BstMWI_as>GC.......GC)',
        'results' : None,
        'site' : 'GCNNNNNNNGC',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 256,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'GCNNNNNNNGC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['BstMWI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstNI>CC[AT]GG)|(?P<BstNI_as>CC[AT]GG)',
        'results' : None,
        'site' : 'CCWGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCWGG'),
        'ovhgseq' : 'W',
    }
rest_dict['BstNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstNSI>[AG]CATG[CT])|(?P<BstNSI_as>[AG]CATG[CT])',
        'results' : None,
        'site' : 'RCATGY',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'RCATGY'),
        'ovhgseq' : 'CATG',
    }
rest_dict['BstNSI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstOI>CC[AT]GG)|(?P<BstOI_as>CC[AT]GG)',
        'results' : None,
        'site' : 'CCWGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('R',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCWGG'),
        'ovhgseq' : 'W',
    }
rest_dict['BstOI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstPAI>GAC....GTC)|(?P<BstPAI_as>GAC....GTC)',
        'results' : None,
        'site' : 'GACNNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GACNNNNGTC'),
        'ovhgseq' : '',
    }
rest_dict['BstPAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstPI>GGT.ACC)|(?P<BstPI_as>GGT.ACC)',
        'results' : None,
        'site' : 'GGTNACC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGTNACC'),
        'ovhgseq' : 'GTNAC',
    }
rest_dict['BstPI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstSCI>CC.GG)|(?P<BstSCI_as>CC.GG)',
        'results' : None,
        'site' : 'CCNGG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'CCNGG'),
        'ovhgseq' : 'CCNGG',
    }
rest_dict['BstSCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstSFI>CT[AG][CT]AG)|(?P<BstSFI_as>CT[AG][CT]AG)',
        'results' : None,
        'site' : 'CTRYAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTRYAG'),
        'ovhgseq' : 'TRYA',
    }
rest_dict['BstSFI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstSLI>G[GT]GC[AC]C)|(?P<BstSLI_as>G[GT]GC[AC]C)',
        'results' : None,
        'site' : 'GKGCMC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GKGCMC'),
        'ovhgseq' : 'KGCM',
    }
rest_dict['BstSLI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstSNI>TACGTA)|(?P<BstSNI_as>TACGTA)',
        'results' : None,
        'site' : 'TACGTA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TACGTA'),
        'ovhgseq' : '',
    }
rest_dict['BstSNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstUI>CGCG)|(?P<BstUI_as>CGCG)',
        'results' : None,
        'site' : 'CGCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGCG'),
        'ovhgseq' : '',
    }
rest_dict['BstUI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstV1I>GCAGC)|(?P<BstV1I_as>GCTGC)',
        'results' : None,
        'site' : 'GCAGC',
        'substrat' : 'DNA',
        'fst3' : 12,
        'fst5' : 13,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (13, 12, None, None, 'GCAGC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BstV1I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstV2I>GAAGAC)|(?P<BstV2I_as>GTCTTC)',
        'results' : None,
        'site' : 'GAAGAC',
        'substrat' : 'DNA',
        'fst3' : 6,
        'fst5' : 8,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (8, 6, None, None, 'GAAGAC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BstV2I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstX2I>[AG]GATC[CT])|(?P<BstX2I_as>[AG]GATC[CT])',
        'results' : None,
        'site' : 'RGATCY',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'RGATCY'),
        'ovhgseq' : 'GATC',
    }
rest_dict['BstX2I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstXI>CCA......TGG)|(?P<BstXI_as>CCA......TGG)',
        'results' : None,
        'site' : 'CCANNNNNNTGG',
        'substrat' : 'DNA',
        'fst3' : -8,
        'fst5' : 8,
        'freq' : 4096,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'V', 'W', 'X'),
        'scd5' : None,
        'charac' : (8, -8, None, None, 'CCANNNNNNTGG'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BstXI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstYI>[AG]GATC[CT])|(?P<BstYI_as>[AG]GATC[CT])',
        'results' : None,
        'site' : 'RGATCY',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'RGATCY'),
        'ovhgseq' : 'GATC',
    }
rest_dict['BstYI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstZ17I>GTATAC)|(?P<BstZ17I_as>GTATAC)',
        'results' : None,
        'site' : 'GTATAC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GTATAC'),
        'ovhgseq' : '',
    }
rest_dict['BstZ17I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BstZI>CGGCCG)|(?P<BstZI_as>CGGCCG)',
        'results' : None,
        'site' : 'CGGCCG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('R',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CGGCCG'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['BstZI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsu15I>ATCGAT)|(?P<Bsu15I_as>ATCGAT)',
        'results' : None,
        'site' : 'ATCGAT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'ATCGAT'),
        'ovhgseq' : 'CG',
    }
rest_dict['Bsu15I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Bsu36I>CCT.AGG)|(?P<Bsu36I_as>CCT.AGG)',
        'results' : None,
        'site' : 'CCTNAGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('N', 'R'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCTNAGG'),
        'ovhgseq' : 'TNA',
    }
rest_dict['Bsu36I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsuRI>GGCC)|(?P<BsuRI_as>GGCC)',
        'results' : None,
        'site' : 'GGCC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F', 'I'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GGCC'),
        'ovhgseq' : '',
    }
rest_dict['BsuRI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BsuTUI>ATCGAT)|(?P<BsuTUI_as>ATCGAT)',
        'results' : None,
        'site' : 'ATCGAT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('X',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'ATCGAT'),
        'ovhgseq' : 'CG',
    }
rest_dict['BsuTUI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BtgI>CC[AG][CT]GG)|(?P<BtgI_as>CC[AG][CT]GG)',
        'results' : None,
        'site' : 'CCRYGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCRYGG'),
        'ovhgseq' : 'CRYG',
    }
rest_dict['BtgI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BtgZI>GCGATG)|(?P<BtgZI_as>CATCGC)',
        'results' : None,
        'site' : 'GCGATG',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 16,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (16, 14, None, None, 'GCGATG'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BtgZI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BthCI>GC.GC)|(?P<BthCI_as>GC.GC)',
        'results' : None,
        'site' : 'GCNGC',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'GCNGC'),
        'ovhgseq' : 'CNG',
    }
rest_dict['BthCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BtrI>CACGTC)|(?P<BtrI_as>GACGTG)',
        'results' : None,
        'site' : 'CACGTC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CACGTC'),
        'ovhgseq' : '',
    }
rest_dict['BtrI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BtsCI>GGATG)|(?P<BtsCI_as>CATCC)',
        'results' : None,
        'site' : 'GGATG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 7,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (7, 0, None, None, 'GGATG'),
        'ovhgseq' : 'NN',
    }
rest_dict['BtsCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BtsI>GCAGTG)|(?P<BtsI_as>CACTGC)',
        'results' : None,
        'site' : 'GCAGTG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 8,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (8, 0, None, None, 'GCAGTG'),
        'ovhgseq' : 'NN',
    }
rest_dict['BtsI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BtuMI>TCGCGA)|(?P<BtuMI_as>TCGCGA)',
        'results' : None,
        'site' : 'TCGCGA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TCGCGA'),
        'ovhgseq' : '',
    }
rest_dict['BtuMI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<BveI>ACCTGC)|(?P<BveI_as>GCAGGT)',
        'results' : None,
        'site' : 'ACCTGC',
        'substrat' : 'DNA',
        'fst3' : 8,
        'fst5' : 10,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (10, 8, None, None, 'ACCTGC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['BveI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Cac8I>GC..GC)|(?P<Cac8I_as>GC..GC)',
        'results' : None,
        'site' : 'GCNNGC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GCNNGC'),
        'ovhgseq' : '',
    }
rest_dict['Cac8I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CaiI>CAG...CTG)|(?P<CaiI_as>CAG...CTG)',
        'results' : None,
        'site' : 'CAGNNNCTG',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 4096,
        'size' : 9,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'CAGNNNCTG'),
        'ovhgseq' : 'NNN',
    }
rest_dict['CaiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CauII>CC[CG]GG)|(?P<CauII_as>CC[CG]GG)',
        'results' : None,
        'site' : 'CCSGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCSGG'),
        'ovhgseq' : 'S',
    }
rest_dict['CauII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CciI>TCATGA)|(?P<CciI_as>TCATGA)',
        'results' : None,
        'site' : 'TCATGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCATGA'),
        'ovhgseq' : 'CATG',
    }
rest_dict['CciI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CciNI>GCGGCCGC)|(?P<CciNI_as>GCGGCCGC)',
        'results' : None,
        'site' : 'GCGGCCGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCGGCCGC'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['CciNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CdiI>CATCG)|(?P<CdiI_as>CGATG)',
        'results' : None,
        'site' : 'CATCG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 4,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (4, -1, None, None, 'CATCG'),
        'ovhgseq' : '',
    }
rest_dict['CdiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CdpI>GCGGAG)|(?P<CdpI_as>CTCCGC)',
        'results' : None,
        'site' : 'GCGGAG',
        'substrat' : 'DNA',
        'fst3' : 18,
        'fst5' : 26,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (26, 18, None, None, 'GCGGAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['CdpI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CelII>GCT.AGC)|(?P<CelII_as>GCT.AGC)',
        'results' : None,
        'site' : 'GCTNAGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCTNAGC'),
        'ovhgseq' : 'TNA',
    }
rest_dict['CelII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CfoI>GCGC)|(?P<CfoI_as>GCGC)',
        'results' : None,
        'site' : 'GCGC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('M', 'R', 'S'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GCGC'),
        'ovhgseq' : 'CG',
    }
rest_dict['CfoI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Cfr10I>[AG]CCGG[CT])|(?P<Cfr10I_as>[AG]CCGG[CT])',
        'results' : None,
        'site' : 'RCCGGY',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F', 'K', 'O'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'RCCGGY'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['Cfr10I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Cfr13I>GG.CC)|(?P<Cfr13I_as>GG.CC)',
        'results' : None,
        'site' : 'GGNCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F', 'O'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGNCC'),
        'ovhgseq' : 'GNC',
    }
rest_dict['Cfr13I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Cfr42I>CCGCGG)|(?P<Cfr42I_as>CCGCGG)',
        'results' : None,
        'site' : 'CCGCGG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CCGCGG'),
        'ovhgseq' : 'GC',
    }
rest_dict['Cfr42I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Cfr9I>CCCGGG)|(?P<Cfr9I_as>CCCGGG)',
        'results' : None,
        'site' : 'CCCGGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F', 'O'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCCGGG'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['Cfr9I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CfrI>[CT]GGCC[AG])|(?P<CfrI_as>[CT]GGCC[AG])',
        'results' : None,
        'site' : 'YGGCCR',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'YGGCCR'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['CfrI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ChaI>GATC)|(?P<ChaI_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'GATC'),
        'ovhgseq' : 'GATC',
    }
rest_dict['ChaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CjeI>CCA......GT)|(?P<CjeI_as>AC......TGG)',
        'results' : None,
        'site' : 'CCANNNNNNGT',
        'substrat' : 'DNA',
        'fst3' : -25,
        'fst5' : -8,
        'freq' : 1024,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 6,
        'scd3' : 9,
        'suppl' : (),
        'scd5' : 26,
        'charac' : (-8, -25, 26, 9, 'CCANNNNNNGT'),
        'ovhgseq' : 'NNNNNN',
    }
rest_dict['CjeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CjeNII>GAG.....GT)|(?P<CjeNII_as>AC.....CTC)',
        'results' : None,
        'site' : 'GAGNNNNNGT',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 1024,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'GAGNNNNNGT'),
        'ovhgseq' : None,
    }
rest_dict['CjeNII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CjePI>CCA.......TC)|(?P<CjePI_as>GA.......TGG)',
        'results' : None,
        'site' : 'CCANNNNNNNTC',
        'substrat' : 'DNA',
        'fst3' : -25,
        'fst5' : -7,
        'freq' : 1024,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 6,
        'scd3' : 8,
        'suppl' : (),
        'scd5' : 26,
        'charac' : (-7, -25, 26, 8, 'CCANNNNNNNTC'),
        'ovhgseq' : 'NNNNNN',
    }
rest_dict['CjePI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CjuI>CA[CT].....[AG]TG)|(?P<CjuI_as>CA[CT].....[AG]TG)',
        'results' : None,
        'site' : 'CAYNNNNNRTG',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 1024,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'CAYNNNNNRTG'),
        'ovhgseq' : None,
    }
rest_dict['CjuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CjuII>CA[CT].....CTC)|(?P<CjuII_as>GAG.....[AG]TG)',
        'results' : None,
        'site' : 'CAYNNNNNCTC',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 2048,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'CAYNNNNNCTC'),
        'ovhgseq' : None,
    }
rest_dict['CjuII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ClaI>ATCGAT)|(?P<ClaI_as>ATCGAT)',
        'results' : None,
        'site' : 'ATCGAT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('B', 'H', 'K', 'M', 'N', 'R', 'S', 'U'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'ATCGAT'),
        'ovhgseq' : 'CG',
    }
rest_dict['ClaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CpoI>CGG[AT]CCG)|(?P<CpoI_as>CGG[AT]CCG)',
        'results' : None,
        'site' : 'CGGWCCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F', 'K'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGGWCCG'),
        'ovhgseq' : 'GWC',
    }
rest_dict['CpoI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CseI>GACGC)|(?P<CseI_as>GCGTC)',
        'results' : None,
        'site' : 'GACGC',
        'substrat' : 'DNA',
        'fst3' : 10,
        'fst5' : 10,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (10, 10, None, None, 'GACGC'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['CseI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CsiI>ACC[AT]GGT)|(?P<CsiI_as>ACC[AT]GGT)',
        'results' : None,
        'site' : 'ACCWGGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACCWGGT'),
        'ovhgseq' : 'CCWGG',
    }
rest_dict['CsiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Csp45I>TTCGAA)|(?P<Csp45I_as>TTCGAA)',
        'results' : None,
        'site' : 'TTCGAA',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('O', 'R'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'TTCGAA'),
        'ovhgseq' : 'CG',
    }
rest_dict['Csp45I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Csp6I>GTAC)|(?P<Csp6I_as>GTAC)',
        'results' : None,
        'site' : 'GTAC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GTAC'),
        'ovhgseq' : 'TA',
    }
rest_dict['Csp6I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CspAI>ACCGGT)|(?P<CspAI_as>ACCGGT)',
        'results' : None,
        'site' : 'ACCGGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('C',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACCGGT'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['CspAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CspCI>CAA.....GTGG)|(?P<CspCI_as>CCAC.....TTG)',
        'results' : None,
        'site' : 'CAANNNNNGTGG',
        'substrat' : 'DNA',
        'fst3' : -25,
        'fst5' : -11,
        'freq' : 16384,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : 10,
        'suppl' : ('N',),
        'scd5' : 24,
        'charac' : (-11, -25, 24, 10, 'CAANNNNNGTGG'),
        'ovhgseq' : 'NN',
    }
rest_dict['CspCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CspI>CGG[AT]CCG)|(?P<CspI_as>CGG[AT]CCG)',
        'results' : None,
        'site' : 'CGGWCCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('O', 'R'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGGWCCG'),
        'ovhgseq' : 'GWC',
    }
rest_dict['CspI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CstMI>AAGGAG)|(?P<CstMI_as>CTCCTT)',
        'results' : None,
        'site' : 'AAGGAG',
        'substrat' : 'DNA',
        'fst3' : 18,
        'fst5' : 26,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (26, 18, None, None, 'AAGGAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['CstMI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CviAII>CATG)|(?P<CviAII_as>CATG)',
        'results' : None,
        'site' : 'CATG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CATG'),
        'ovhgseq' : 'AT',
    }
rest_dict['CviAII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CviJI>[AG]GC[CT])|(?P<CviJI_as>[AG]GC[CT])',
        'results' : None,
        'site' : 'RGCY',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 64,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('Q', 'X'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'RGCY'),
        'ovhgseq' : '',
    }
rest_dict['CviJI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CviKI_1>[AG]GC[CT])|(?P<CviKI_1_as>[AG]GC[CT])',
        'results' : None,
        'site' : 'RGCY',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 64,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'RGCY'),
        'ovhgseq' : '',
    }
rest_dict['CviKI_1'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CviQI>GTAC)|(?P<CviQI_as>GTAC)',
        'results' : None,
        'site' : 'GTAC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GTAC'),
        'ovhgseq' : 'TA',
    }
rest_dict['CviQI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<CviRI>TGCA)|(?P<CviRI_as>TGCA)',
        'results' : None,
        'site' : 'TGCA',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'TGCA'),
        'ovhgseq' : '',
    }
rest_dict['CviRI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DdeI>CT.AG)|(?P<DdeI_as>CT.AG)',
        'results' : None,
        'site' : 'CTNAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('B', 'M', 'N', 'O', 'R', 'S', 'W'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTNAG'),
        'ovhgseq' : 'TNA',
    }
rest_dict['DdeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DinI>GGCGCC)|(?P<DinI_as>GGCGCC)',
        'results' : None,
        'site' : 'GGCGCC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GGCGCC'),
        'ovhgseq' : '',
    }
rest_dict['DinI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DpnI>GATC)|(?P<DpnI_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'E', 'F', 'M', 'N', 'O', 'R', 'S', 'W', 'X'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GATC'),
        'ovhgseq' : '',
    }
rest_dict['DpnI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DpnII>GATC)|(?P<DpnII_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GATC'),
        'ovhgseq' : 'GATC',
    }
rest_dict['DpnII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DraI>TTTAAA)|(?P<DraI_as>TTTAAA)',
        'results' : None,
        'site' : 'TTTAAA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'F', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TTTAAA'),
        'ovhgseq' : '',
    }
rest_dict['DraI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DraII>[AG]GG.CC[CT])|(?P<DraII_as>[AG]GG.CC[CT])',
        'results' : None,
        'site' : 'RGGNCCY',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 1024,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('M', 'W'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'RGGNCCY'),
        'ovhgseq' : 'GNC',
    }
rest_dict['DraII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DraIII>CAC...GTG)|(?P<DraIII_as>CAC...GTG)',
        'results' : None,
        'site' : 'CACNNNGTG',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 4096,
        'size' : 9,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('I', 'M', 'N', 'V', 'W'),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'CACNNNGTG'),
        'ovhgseq' : 'NNN',
    }
rest_dict['DraIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DraRI>CAAG.AC)|(?P<DraRI_as>GT.CTTG)',
        'results' : None,
        'site' : 'CAAGNAC',
        'substrat' : 'DNA',
        'fst3' : 18,
        'fst5' : 27,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (27, 18, None, None, 'CAAGNAC'),
        'ovhgseq' : 'NN',
    }
rest_dict['DraRI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DrdI>GAC......GTC)|(?P<DrdI_as>GAC......GTC)',
        'results' : None,
        'site' : 'GACNNNNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'GACNNNNNNGTC'),
        'ovhgseq' : 'NN',
    }
rest_dict['DrdI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DrdII>GAACCA)|(?P<DrdII_as>TGGTTC)',
        'results' : None,
        'site' : 'GAACCA',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'GAACCA'),
        'ovhgseq' : None,
    }
rest_dict['DrdII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DrdIV>TACGAC)|(?P<DrdIV_as>GTCGTA)',
        'results' : None,
        'site' : 'TACGAC',
        'substrat' : 'DNA',
        'fst3' : 18,
        'fst5' : 26,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (26, 18, None, None, 'TACGAC'),
        'ovhgseq' : 'NN',
    }
rest_dict['DrdIV'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DriI>GAC.....GTC)|(?P<DriI_as>GAC.....GTC)',
        'results' : None,
        'site' : 'GACNNNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'GACNNNNNGTC'),
        'ovhgseq' : 'N',
    }
rest_dict['DriI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DsaI>CC[AG][CT]GG)|(?P<DsaI_as>CC[AG][CT]GG)',
        'results' : None,
        'site' : 'CCRYGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCRYGG'),
        'ovhgseq' : 'CRYG',
    }
rest_dict['DsaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<DseDI>GAC......GTC)|(?P<DseDI_as>GAC......GTC)',
        'results' : None,
        'site' : 'GACNNNNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'GACNNNNNNGTC'),
        'ovhgseq' : 'NN',
    }
rest_dict['DseDI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EaeI>[CT]GGCC[AG])|(?P<EaeI_as>[CT]GGCC[AG])',
        'results' : None,
        'site' : 'YGGCCR',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('K', 'N'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'YGGCCR'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['EaeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EagI>CGGCCG)|(?P<EagI_as>CGGCCG)',
        'results' : None,
        'site' : 'CGGCCG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N', 'W'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CGGCCG'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['EagI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eam1104I>CTCTTC)|(?P<Eam1104I_as>GAAGAG)',
        'results' : None,
        'site' : 'CTCTTC',
        'substrat' : 'DNA',
        'fst3' : 4,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (7, 4, None, None, 'CTCTTC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['Eam1104I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eam1105I>GAC.....GTC)|(?P<Eam1105I_as>GAC.....GTC)',
        'results' : None,
        'site' : 'GACNNNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('F', 'K'),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'GACNNNNNGTC'),
        'ovhgseq' : 'N',
    }
rest_dict['Eam1105I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EarI>CTCTTC)|(?P<EarI_as>GAAGAG)',
        'results' : None,
        'site' : 'CTCTTC',
        'substrat' : 'DNA',
        'fst3' : 4,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (7, 4, None, None, 'CTCTTC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['EarI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EciI>GGCGGA)|(?P<EciI_as>TCCGCC)',
        'results' : None,
        'site' : 'GGCGGA',
        'substrat' : 'DNA',
        'fst3' : 9,
        'fst5' : 17,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (17, 9, None, None, 'GGCGGA'),
        'ovhgseq' : 'NN',
    }
rest_dict['EciI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Ecl136II>GAGCTC)|(?P<Ecl136II_as>GAGCTC)',
        'results' : None,
        'site' : 'GAGCTC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GAGCTC'),
        'ovhgseq' : '',
    }
rest_dict['Ecl136II'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EclXI>CGGCCG)|(?P<EclXI_as>CGGCCG)',
        'results' : None,
        'site' : 'CGGCCG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('M', 'S'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CGGCCG'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['EclXI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco105I>TACGTA)|(?P<Eco105I_as>TACGTA)',
        'results' : None,
        'site' : 'TACGTA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F', 'O'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TACGTA'),
        'ovhgseq' : '',
    }
rest_dict['Eco105I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco130I>CC[AT][AT]GG)|(?P<Eco130I_as>CC[AT][AT]GG)',
        'results' : None,
        'site' : 'CCWWGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCWWGG'),
        'ovhgseq' : 'CWWG',
    }
rest_dict['Eco130I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco147I>AGGCCT)|(?P<Eco147I_as>AGGCCT)',
        'results' : None,
        'site' : 'AGGCCT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'AGGCCT'),
        'ovhgseq' : '',
    }
rest_dict['Eco147I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco24I>G[AG]GC[CT]C)|(?P<Eco24I_as>G[AG]GC[CT]C)',
        'results' : None,
        'site' : 'GRGCYC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GRGCYC'),
        'ovhgseq' : 'RGCY',
    }
rest_dict['Eco24I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco31I>GGTCTC)|(?P<Eco31I_as>GAGACC)',
        'results' : None,
        'site' : 'GGTCTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (7, 5, None, None, 'GGTCTC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['Eco31I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco32I>GATATC)|(?P<Eco32I_as>GATATC)',
        'results' : None,
        'site' : 'GATATC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GATATC'),
        'ovhgseq' : '',
    }
rest_dict['Eco32I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco47I>GG[AT]CC)|(?P<Eco47I_as>GG[AT]CC)',
        'results' : None,
        'site' : 'GGWCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F', 'O'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGWCC'),
        'ovhgseq' : 'GWC',
    }
rest_dict['Eco47I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco47III>AGCGCT)|(?P<Eco47III_as>AGCGCT)',
        'results' : None,
        'site' : 'AGCGCT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F', 'M', 'O', 'R', 'W'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'AGCGCT'),
        'ovhgseq' : '',
    }
rest_dict['Eco47III'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco52I>CGGCCG)|(?P<Eco52I_as>CGGCCG)',
        'results' : None,
        'site' : 'CGGCCG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F', 'K', 'O'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CGGCCG'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['Eco52I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco53kI>GAGCTC)|(?P<Eco53kI_as>GAGCTC)',
        'results' : None,
        'site' : 'GAGCTC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GAGCTC'),
        'ovhgseq' : '',
    }
rest_dict['Eco53kI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco57I>CTGAAG)|(?P<Eco57I_as>CTTCAG)',
        'results' : None,
        'site' : 'CTGAAG',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 22,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (22, 14, None, None, 'CTGAAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['Eco57I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco57MI>CTG[AG]AG)|(?P<Eco57MI_as>CT[CT]CAG)',
        'results' : None,
        'site' : 'CTGRAG',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 22,
        'freq' : 2048,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (22, 14, None, None, 'CTGRAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['Eco57MI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco72I>CACGTG)|(?P<Eco72I_as>CACGTG)',
        'results' : None,
        'site' : 'CACGTG',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CACGTG'),
        'ovhgseq' : '',
    }
rest_dict['Eco72I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco81I>CCT.AGG)|(?P<Eco81I_as>CCT.AGG)',
        'results' : None,
        'site' : 'CCTNAGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F', 'K', 'O'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCTNAGG'),
        'ovhgseq' : 'TNA',
    }
rest_dict['Eco81I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco88I>C[CT]CG[AG]G)|(?P<Eco88I_as>C[CT]CG[AG]G)',
        'results' : None,
        'site' : 'CYCGRG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CYCGRG'),
        'ovhgseq' : 'YCGR',
    }
rest_dict['Eco88I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Eco91I>GGT.ACC)|(?P<Eco91I_as>GGT.ACC)',
        'results' : None,
        'site' : 'GGTNACC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGTNACC'),
        'ovhgseq' : 'GTNAC',
    }
rest_dict['Eco91I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EcoHI>CC[CG]GG)|(?P<EcoHI_as>CC[CG]GG)',
        'results' : None,
        'site' : 'CCSGG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'CCSGG'),
        'ovhgseq' : 'CCSGG',
    }
rest_dict['EcoHI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EcoICRI>GAGCTC)|(?P<EcoICRI_as>GAGCTC)',
        'results' : None,
        'site' : 'GAGCTC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'R', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GAGCTC'),
        'ovhgseq' : '',
    }
rest_dict['EcoICRI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EcoNI>CCT.....AGG)|(?P<EcoNI_as>CCT.....AGG)',
        'results' : None,
        'site' : 'CCTNNNNNAGG',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'CCTNNNNNAGG'),
        'ovhgseq' : 'N',
    }
rest_dict['EcoNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EcoO109I>[AG]GG.CC[CT])|(?P<EcoO109I_as>[AG]GG.CC[CT])',
        'results' : None,
        'site' : 'RGGNCCY',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 1024,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F', 'J', 'K', 'N'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'RGGNCCY'),
        'ovhgseq' : 'GNC',
    }
rest_dict['EcoO109I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EcoO65I>GGT.ACC)|(?P<EcoO65I_as>GGT.ACC)',
        'results' : None,
        'site' : 'GGTNACC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGTNACC'),
        'ovhgseq' : 'GTNAC',
    }
rest_dict['EcoO65I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EcoRI>GAATTC)|(?P<EcoRI_as>GAATTC)',
        'results' : None,
        'site' : 'GAATTC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GAATTC'),
        'ovhgseq' : 'AATT',
    }
rest_dict['EcoRI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EcoRII>CC[AT]GG)|(?P<EcoRII_as>CC[AT]GG)',
        'results' : None,
        'site' : 'CCWGG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('F', 'J', 'M', 'O', 'S'),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'CCWGG'),
        'ovhgseq' : 'CCWGG',
    }
rest_dict['EcoRII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EcoRV>GATATC)|(?P<EcoRV_as>GATATC)',
        'results' : None,
        'site' : 'GATATC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'C', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GATATC'),
        'ovhgseq' : '',
    }
rest_dict['EcoRV'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EcoT14I>CC[AT][AT]GG)|(?P<EcoT14I_as>CC[AT][AT]GG)',
        'results' : None,
        'site' : 'CCWWGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCWWGG'),
        'ovhgseq' : 'CWWG',
    }
rest_dict['EcoT14I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EcoT22I>ATGCAT)|(?P<EcoT22I_as>ATGCAT)',
        'results' : None,
        'site' : 'ATGCAT',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('K', 'O'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'ATGCAT'),
        'ovhgseq' : 'TGCA',
    }
rest_dict['EcoT22I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EcoT38I>G[AG]GC[CT]C)|(?P<EcoT38I_as>G[AG]GC[CT]C)',
        'results' : None,
        'site' : 'GRGCYC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('J',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GRGCYC'),
        'ovhgseq' : 'RGCY',
    }
rest_dict['EcoT38I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EgeI>GGCGCC)|(?P<EgeI_as>GGCGCC)',
        'results' : None,
        'site' : 'GGCGCC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GGCGCC'),
        'ovhgseq' : '',
    }
rest_dict['EgeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EheI>GGCGCC)|(?P<EheI_as>GGCGCC)',
        'results' : None,
        'site' : 'GGCGCC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F', 'O'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GGCGCC'),
        'ovhgseq' : '',
    }
rest_dict['EheI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ErhI>CC[AT][AT]GG)|(?P<ErhI_as>CC[AT][AT]GG)',
        'results' : None,
        'site' : 'CCWWGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCWWGG'),
        'ovhgseq' : 'CWWG',
    }
rest_dict['ErhI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EsaBC3I>TCGA)|(?P<EsaBC3I_as>TCGA)',
        'results' : None,
        'site' : 'TCGA',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'TCGA'),
        'ovhgseq' : '',
    }
rest_dict['EsaBC3I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EsaSSI>GACCAC)|(?P<EsaSSI_as>GTGGTC)',
        'results' : None,
        'site' : 'GACCAC',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'GACCAC'),
        'ovhgseq' : None,
    }
rest_dict['EsaSSI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Esp3I>CGTCTC)|(?P<Esp3I_as>GAGACG)',
        'results' : None,
        'site' : 'CGTCTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (7, 5, None, None, 'CGTCTC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['Esp3I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<EspI>GCT.AGC)|(?P<EspI_as>GCT.AGC)',
        'results' : None,
        'site' : 'GCTNAGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCTNAGC'),
        'ovhgseq' : 'TNA',
    }
rest_dict['EspI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FaeI>CATG)|(?P<FaeI_as>CATG)',
        'results' : None,
        'site' : 'CATG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CATG'),
        'ovhgseq' : 'CATG',
    }
rest_dict['FaeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FaiI>[CT]AT[AG])|(?P<FaiI_as>[CT]AT[AG])',
        'results' : None,
        'site' : 'YATR',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 64,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'YATR'),
        'ovhgseq' : '',
    }
rest_dict['FaiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FalI>AAG.....CTT)|(?P<FalI_as>AAG.....CTT)',
        'results' : None,
        'site' : 'AAGNNNNNCTT',
        'substrat' : 'DNA',
        'fst3' : -24,
        'fst5' : -8,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : 8,
        'suppl' : ('I',),
        'scd5' : 24,
        'charac' : (-8, -24, 24, 8, 'AAGNNNNNCTT'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['FalI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FaqI>GGGAC)|(?P<FaqI_as>GTCCC)',
        'results' : None,
        'site' : 'GGGAC',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 15,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (15, 14, None, None, 'GGGAC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['FaqI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FatI>CATG)|(?P<FatI_as>CATG)',
        'results' : None,
        'site' : 'CATG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'N'),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'CATG'),
        'ovhgseq' : 'CATG',
    }
rest_dict['FatI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FauI>CCCGC)|(?P<FauI_as>GCGGG)',
        'results' : None,
        'site' : 'CCCGC',
        'substrat' : 'DNA',
        'fst3' : 6,
        'fst5' : 9,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('I', 'N'),
        'scd5' : None,
        'charac' : (9, 6, None, None, 'CCCGC'),
        'ovhgseq' : 'NN',
    }
rest_dict['FauI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FauNDI>CATATG)|(?P<FauNDI_as>CATATG)',
        'results' : None,
        'site' : 'CATATG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CATATG'),
        'ovhgseq' : 'TA',
    }
rest_dict['FauNDI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FbaI>TGATCA)|(?P<FbaI_as>TGATCA)',
        'results' : None,
        'site' : 'TGATCA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TGATCA'),
        'ovhgseq' : 'GATC',
    }
rest_dict['FbaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FblI>GT[AC][GT]AC)|(?P<FblI_as>GT[AC][GT]AC)',
        'results' : None,
        'site' : 'GTMKAC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GTMKAC'),
        'ovhgseq' : 'MK',
    }
rest_dict['FblI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FinI>GGGAC)|(?P<FinI_as>GTCCC)',
        'results' : None,
        'site' : 'GGGAC',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'GGGAC'),
        'ovhgseq' : None,
    }
rest_dict['FinI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FmuI>GG.CC)|(?P<FmuI_as>GG.CC)',
        'results' : None,
        'site' : 'GGNCC',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'GGNCC'),
        'ovhgseq' : 'GNC',
    }
rest_dict['FmuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Fnu4HI>GC.GC)|(?P<Fnu4HI_as>GC.GC)',
        'results' : None,
        'site' : 'GCNGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCNGC'),
        'ovhgseq' : 'N',
    }
rest_dict['Fnu4HI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FnuDII>CGCG)|(?P<FnuDII_as>CGCG)',
        'results' : None,
        'site' : 'CGCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGCG'),
        'ovhgseq' : '',
    }
rest_dict['FnuDII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FokI>GGATG)|(?P<FokI_as>CATCC)',
        'results' : None,
        'site' : 'GGATG',
        'substrat' : 'DNA',
        'fst3' : 13,
        'fst5' : 14,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'J', 'K', 'M', 'N', 'Q', 'R', 'V', 'W', 'X'),
        'scd5' : None,
        'charac' : (14, 13, None, None, 'GGATG'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['FokI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FriOI>G[AG]GC[CT]C)|(?P<FriOI_as>G[AG]GC[CT]C)',
        'results' : None,
        'site' : 'GRGCYC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GRGCYC'),
        'ovhgseq' : 'RGCY',
    }
rest_dict['FriOI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FseI>GGCCGGCC)|(?P<FseI_as>GGCCGGCC)',
        'results' : None,
        'site' : 'GGCCGGCC',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'GGCCGGCC'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['FseI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Fsp4HI>GC.GC)|(?P<Fsp4HI_as>GC.GC)',
        'results' : None,
        'site' : 'GCNGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCNGC'),
        'ovhgseq' : 'N',
    }
rest_dict['Fsp4HI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FspAI>[AG]TGCGCA[CT])|(?P<FspAI_as>[AG]TGCGCA[CT])',
        'results' : None,
        'site' : 'RTGCGCAY',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 16384,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'RTGCGCAY'),
        'ovhgseq' : '',
    }
rest_dict['FspAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FspBI>CTAG)|(?P<FspBI_as>CTAG)',
        'results' : None,
        'site' : 'CTAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTAG'),
        'ovhgseq' : 'TA',
    }
rest_dict['FspBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<FspI>TGCGCA)|(?P<FspI_as>TGCGCA)',
        'results' : None,
        'site' : 'TGCGCA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('J', 'N', 'O'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TGCGCA'),
        'ovhgseq' : '',
    }
rest_dict['FspI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<GdiII>CGGCC[AG])|(?P<GdiII_as>[CT]GGCCG)',
        'results' : None,
        'site' : 'CGGCCR',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 2048,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CGGCCR'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['GdiII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<GlaI>GCGC)|(?P<GlaI_as>GCGC)',
        'results' : None,
        'site' : 'GCGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCGC'),
        'ovhgseq' : '',
    }
rest_dict['GlaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<GluI>GC.GC)|(?P<GluI_as>GC.GC)',
        'results' : None,
        'site' : 'GCNGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCNGC'),
        'ovhgseq' : 'N',
    }
rest_dict['GluI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<GsaI>CCCAGC)|(?P<GsaI_as>GCTGGG)',
        'results' : None,
        'site' : 'CCCAGC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'CCCAGC'),
        'ovhgseq' : 'CCAG',
    }
rest_dict['GsaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<GsuI>CTGGAG)|(?P<GsuI_as>CTCCAG)',
        'results' : None,
        'site' : 'CTGGAG',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 22,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (22, 14, None, None, 'CTGGAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['GsuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HaeI>[AT]GGCC[AT])|(?P<HaeI_as>[AT]GGCC[AT])',
        'results' : None,
        'site' : 'WGGCCW',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'WGGCCW'),
        'ovhgseq' : '',
    }
rest_dict['HaeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HaeII>[AG]GCGC[CT])|(?P<HaeII_as>[AG]GCGC[CT])',
        'results' : None,
        'site' : 'RGCGCY',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('J', 'K', 'N', 'O', 'R', 'W'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'RGCGCY'),
        'ovhgseq' : 'GCGC',
    }
rest_dict['HaeII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HaeIII>GGCC)|(?P<HaeIII_as>GGCC)',
        'results' : None,
        'site' : 'GGCC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GGCC'),
        'ovhgseq' : '',
    }
rest_dict['HaeIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HapII>CCGG)|(?P<HapII_as>CCGG)',
        'results' : None,
        'site' : 'CCGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCGG'),
        'ovhgseq' : 'CG',
    }
rest_dict['HapII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HgaI>GACGC)|(?P<HgaI_as>GCGTC)',
        'results' : None,
        'site' : 'GACGC',
        'substrat' : 'DNA',
        'fst3' : 10,
        'fst5' : 10,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('I', 'N'),
        'scd5' : None,
        'charac' : (10, 10, None, None, 'GACGC'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['HgaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HgiAI>G[AT]GC[AT]C)|(?P<HgiAI_as>G[AT]GC[AT]C)',
        'results' : None,
        'site' : 'GWGCWC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GWGCWC'),
        'ovhgseq' : 'WGCW',
    }
rest_dict['HgiAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HgiCI>GG[CT][AG]CC)|(?P<HgiCI_as>GG[CT][AG]CC)',
        'results' : None,
        'site' : 'GGYRCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGYRCC'),
        'ovhgseq' : 'GYRC',
    }
rest_dict['HgiCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HgiEII>ACC......GGT)|(?P<HgiEII_as>ACC......GGT)',
        'results' : None,
        'site' : 'ACCNNNNNNGGT',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 4096,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'ACCNNNNNNGGT'),
        'ovhgseq' : None,
    }
rest_dict['HgiEII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HgiJII>G[AG]GC[CT]C)|(?P<HgiJII_as>G[AG]GC[CT]C)',
        'results' : None,
        'site' : 'GRGCYC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GRGCYC'),
        'ovhgseq' : 'RGCY',
    }
rest_dict['HgiJII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HhaI>GCGC)|(?P<HhaI_as>GCGC)',
        'results' : None,
        'site' : 'GCGC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('B', 'F', 'J', 'K', 'N', 'O', 'R', 'U', 'W', 'Y'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GCGC'),
        'ovhgseq' : 'CG',
    }
rest_dict['HhaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Hin1I>G[AG]CG[CT]C)|(?P<Hin1I_as>G[AG]CG[CT]C)',
        'results' : None,
        'site' : 'GRCGYC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F', 'K', 'O'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GRCGYC'),
        'ovhgseq' : 'CG',
    }
rest_dict['Hin1I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Hin1II>CATG)|(?P<Hin1II_as>CATG)',
        'results' : None,
        'site' : 'CATG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CATG'),
        'ovhgseq' : 'CATG',
    }
rest_dict['Hin1II'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Hin4I>GA[CT].....[ACG]TC)|(?P<Hin4I_as>GA[CGT].....[AG]TC)',
        'results' : None,
        'site' : 'GAYNNNNNVTC',
        'substrat' : 'DNA',
        'fst3' : -24,
        'fst5' : -8,
        'freq' : 512,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : 8,
        'suppl' : ('F',),
        'scd5' : 24,
        'charac' : (-8, -24, 24, 8, 'GAYNNNNNVTC'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['Hin4I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Hin4II>CCTTC)|(?P<Hin4II_as>GAAGG)',
        'results' : None,
        'site' : 'CCTTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 11,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (11, 5, None, None, 'CCTTC'),
        'ovhgseq' : 'N',
    }
rest_dict['Hin4II'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Hin6I>GCGC)|(?P<Hin6I_as>GCGC)',
        'results' : None,
        'site' : 'GCGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GCGC'),
        'ovhgseq' : 'CG',
    }
rest_dict['Hin6I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HinP1I>GCGC)|(?P<HinP1I_as>GCGC)',
        'results' : None,
        'site' : 'GCGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GCGC'),
        'ovhgseq' : 'CG',
    }
rest_dict['HinP1I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HincII>GT[CT][AG]AC)|(?P<HincII_as>GT[CT][AG]AC)',
        'results' : None,
        'site' : 'GTYRAC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'F', 'H', 'J', 'K', 'N', 'O', 'Q', 'R', 'U', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GTYRAC'),
        'ovhgseq' : '',
    }
rest_dict['HincII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HindII>GT[CT][AG]AC)|(?P<HindII_as>GT[CT][AG]AC)',
        'results' : None,
        'site' : 'GTYRAC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'M', 'S', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GTYRAC'),
        'ovhgseq' : '',
    }
rest_dict['HindII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HindIII>AAGCTT)|(?P<HindIII_as>AAGCTT)',
        'results' : None,
        'site' : 'AAGCTT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'AAGCTT'),
        'ovhgseq' : 'AGCT',
    }
rest_dict['HindIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HinfI>GA.TC)|(?P<HinfI_as>GA.TC)',
        'results' : None,
        'site' : 'GANTC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GANTC'),
        'ovhgseq' : 'ANT',
    }
rest_dict['HinfI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HpaI>GTTAAC)|(?P<HpaI_as>GTTAAC)',
        'results' : None,
        'site' : 'GTTAAC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'C', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GTTAAC'),
        'ovhgseq' : '',
    }
rest_dict['HpaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HpaII>CCGG)|(?P<HpaII_as>CCGG)',
        'results' : None,
        'site' : 'CCGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('B', 'F', 'I', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCGG'),
        'ovhgseq' : 'CG',
    }
rest_dict['HpaII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HphI>GGTGA)|(?P<HphI_as>TCACC)',
        'results' : None,
        'site' : 'GGTGA',
        'substrat' : 'DNA',
        'fst3' : 7,
        'fst5' : 13,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('F', 'N'),
        'scd5' : None,
        'charac' : (13, 7, None, None, 'GGTGA'),
        'ovhgseq' : 'N',
    }
rest_dict['HphI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Hpy166II>GT..AC)|(?P<Hpy166II_as>GT..AC)',
        'results' : None,
        'site' : 'GTNNAC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GTNNAC'),
        'ovhgseq' : '',
    }
rest_dict['Hpy166II'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Hpy178III>TC..GA)|(?P<Hpy178III_as>TC..GA)',
        'results' : None,
        'site' : 'TCNNGA',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'TCNNGA'),
        'ovhgseq' : 'NN',
    }
rest_dict['Hpy178III'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Hpy188I>TC.GA)|(?P<Hpy188I_as>TC.GA)',
        'results' : None,
        'site' : 'TCNGA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TCNGA'),
        'ovhgseq' : 'N',
    }
rest_dict['Hpy188I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Hpy188III>TC..GA)|(?P<Hpy188III_as>TC..GA)',
        'results' : None,
        'site' : 'TCNNGA',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'TCNNGA'),
        'ovhgseq' : 'NN',
    }
rest_dict['Hpy188III'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Hpy8I>GT..AC)|(?P<Hpy8I_as>GT..AC)',
        'results' : None,
        'site' : 'GTNNAC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GTNNAC'),
        'ovhgseq' : '',
    }
rest_dict['Hpy8I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Hpy99I>CG[AT]CG)|(?P<Hpy99I_as>CG[AT]CG)',
        'results' : None,
        'site' : 'CGWCG',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'CGWCG'),
        'ovhgseq' : 'CGWCG',
    }
rest_dict['Hpy99I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HpyAV>CCTTC)|(?P<HpyAV_as>GAAGG)',
        'results' : None,
        'site' : 'CCTTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 11,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (11, 5, None, None, 'CCTTC'),
        'ovhgseq' : 'N',
    }
rest_dict['HpyAV'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HpyCH4III>AC.GT)|(?P<HpyCH4III_as>AC.GT)',
        'results' : None,
        'site' : 'ACNGT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'ACNGT'),
        'ovhgseq' : 'N',
    }
rest_dict['HpyCH4III'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HpyCH4IV>ACGT)|(?P<HpyCH4IV_as>ACGT)',
        'results' : None,
        'site' : 'ACGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACGT'),
        'ovhgseq' : 'CG',
    }
rest_dict['HpyCH4IV'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HpyCH4V>TGCA)|(?P<HpyCH4V_as>TGCA)',
        'results' : None,
        'site' : 'TGCA',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'TGCA'),
        'ovhgseq' : '',
    }
rest_dict['HpyCH4V'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HpyF10VI>GC.......GC)|(?P<HpyF10VI_as>GC.......GC)',
        'results' : None,
        'site' : 'GCNNNNNNNGC',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 256,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'GCNNNNNNNGC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['HpyF10VI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HpyF3I>CT.AG)|(?P<HpyF3I_as>CT.AG)',
        'results' : None,
        'site' : 'CTNAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTNAG'),
        'ovhgseq' : 'TNA',
    }
rest_dict['HpyF3I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Hsp92I>G[AG]CG[CT]C)|(?P<Hsp92I_as>G[AG]CG[CT]C)',
        'results' : None,
        'site' : 'GRCGYC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('R',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GRCGYC'),
        'ovhgseq' : 'CG',
    }
rest_dict['Hsp92I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Hsp92II>CATG)|(?P<Hsp92II_as>CATG)',
        'results' : None,
        'site' : 'CATG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('R',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CATG'),
        'ovhgseq' : 'CATG',
    }
rest_dict['Hsp92II'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<HspAI>GCGC)|(?P<HspAI_as>GCGC)',
        'results' : None,
        'site' : 'GCGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GCGC'),
        'ovhgseq' : 'CG',
    }
rest_dict['HspAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ItaI>GC.GC)|(?P<ItaI_as>GC.GC)',
        'results' : None,
        'site' : 'GCNGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCNGC'),
        'ovhgseq' : 'N',
    }
rest_dict['ItaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<KasI>GGCGCC)|(?P<KasI_as>GGCGCC)',
        'results' : None,
        'site' : 'GGCGCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGCGCC'),
        'ovhgseq' : 'GCGC',
    }
rest_dict['KasI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<KflI>GGG[AT]CCC)|(?P<KflI_as>GGG[AT]CCC)',
        'results' : None,
        'site' : 'GGGWCCC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GGGWCCC'),
        'ovhgseq' : 'GWC',
    }
rest_dict['KflI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Kpn2I>TCCGGA)|(?P<Kpn2I_as>TCCGGA)',
        'results' : None,
        'site' : 'TCCGGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCCGGA'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['Kpn2I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<KpnI>GGTACC)|(?P<KpnI_as>GGTACC)',
        'results' : None,
        'site' : 'GGTACC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GGTACC'),
        'ovhgseq' : 'GTAC',
    }
rest_dict['KpnI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Ksp22I>TGATCA)|(?P<Ksp22I_as>TGATCA)',
        'results' : None,
        'site' : 'TGATCA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TGATCA'),
        'ovhgseq' : 'GATC',
    }
rest_dict['Ksp22I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Ksp632I>CTCTTC)|(?P<Ksp632I_as>GAAGAG)',
        'results' : None,
        'site' : 'CTCTTC',
        'substrat' : 'DNA',
        'fst3' : 4,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (7, 4, None, None, 'CTCTTC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['Ksp632I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<KspAI>GTTAAC)|(?P<KspAI_as>GTTAAC)',
        'results' : None,
        'site' : 'GTTAAC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GTTAAC'),
        'ovhgseq' : '',
    }
rest_dict['KspAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<KspI>CCGCGG)|(?P<KspI_as>CCGCGG)',
        'results' : None,
        'site' : 'CCGCGG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('M', 'S'),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CCGCGG'),
        'ovhgseq' : 'GC',
    }
rest_dict['KspI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Kzo9I>GATC)|(?P<Kzo9I_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GATC'),
        'ovhgseq' : 'GATC',
    }
rest_dict['Kzo9I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<LguI>GCTCTTC)|(?P<LguI_as>GAAGAGC)',
        'results' : None,
        'site' : 'GCTCTTC',
        'substrat' : 'DNA',
        'fst3' : 4,
        'fst5' : 8,
        'freq' : 16384,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (8, 4, None, None, 'GCTCTTC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['LguI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<LpnI>[AG]GCGC[CT])|(?P<LpnI_as>[AG]GCGC[CT])',
        'results' : None,
        'site' : 'RGCGCY',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'RGCGCY'),
        'ovhgseq' : '',
    }
rest_dict['LpnI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Lsp1109I>GCAGC)|(?P<Lsp1109I_as>GCTGC)',
        'results' : None,
        'site' : 'GCAGC',
        'substrat' : 'DNA',
        'fst3' : 12,
        'fst5' : 13,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (13, 12, None, None, 'GCAGC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['Lsp1109I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<LweI>GCATC)|(?P<LweI_as>GATGC)',
        'results' : None,
        'site' : 'GCATC',
        'substrat' : 'DNA',
        'fst3' : 9,
        'fst5' : 10,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (10, 9, None, None, 'GCATC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['LweI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MabI>ACC[AT]GGT)|(?P<MabI_as>ACC[AT]GGT)',
        'results' : None,
        'site' : 'ACCWGGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACCWGGT'),
        'ovhgseq' : 'CCWGG',
    }
rest_dict['MabI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MaeI>CTAG)|(?P<MaeI_as>CTAG)',
        'results' : None,
        'site' : 'CTAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTAG'),
        'ovhgseq' : 'TA',
    }
rest_dict['MaeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MaeII>ACGT)|(?P<MaeII_as>ACGT)',
        'results' : None,
        'site' : 'ACGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACGT'),
        'ovhgseq' : 'CG',
    }
rest_dict['MaeII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MaeIII>GT.AC)|(?P<MaeIII_as>GT.AC)',
        'results' : None,
        'site' : 'GTNAC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GTNAC'),
        'ovhgseq' : 'GTNAC',
    }
rest_dict['MaeIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MalI>GATC)|(?P<MalI_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GATC'),
        'ovhgseq' : '',
    }
rest_dict['MalI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MaqI>C[AG]TTGAC)|(?P<MaqI_as>GTCAA[CT]G)',
        'results' : None,
        'site' : 'CRTTGAC',
        'substrat' : 'DNA',
        'fst3' : 19,
        'fst5' : 28,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (28, 19, None, None, 'CRTTGAC'),
        'ovhgseq' : 'NN',
    }
rest_dict['MaqI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MauBI>CGCGCGCG)|(?P<MauBI_as>CGCGCGCG)',
        'results' : None,
        'site' : 'CGCGCGCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGCGCGCG'),
        'ovhgseq' : 'CGCG',
    }
rest_dict['MauBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MbiI>CCGCTC)|(?P<MbiI_as>GAGCGG)',
        'results' : None,
        'site' : 'CCGCTC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CCGCTC'),
        'ovhgseq' : '',
    }
rest_dict['MbiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MboI>GATC)|(?P<MboI_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'K', 'N', 'Q', 'R', 'U', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GATC'),
        'ovhgseq' : 'GATC',
    }
rest_dict['MboI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MboII>GAAGA)|(?P<MboII_as>TCTTC)',
        'results' : None,
        'site' : 'GAAGA',
        'substrat' : 'DNA',
        'fst3' : 7,
        'fst5' : 13,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('F', 'I', 'J', 'K', 'N', 'O', 'Q', 'R', 'V', 'W', 'X'),
        'scd5' : None,
        'charac' : (13, 7, None, None, 'GAAGA'),
        'ovhgseq' : 'N',
    }
rest_dict['MboII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<McaTI>GCGCGC)|(?P<McaTI_as>GCGCGC)',
        'results' : None,
        'site' : 'GCGCGC',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'GCGCGC'),
        'ovhgseq' : 'GC',
    }
rest_dict['McaTI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<McrI>CG[AG][CT]CG)|(?P<McrI_as>CG[AG][CT]CG)',
        'results' : None,
        'site' : 'CGRYCG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CGRYCG'),
        'ovhgseq' : 'RY',
    }
rest_dict['McrI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MfeI>CAATTG)|(?P<MfeI_as>CAATTG)',
        'results' : None,
        'site' : 'CAATTG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CAATTG'),
        'ovhgseq' : 'AATT',
    }
rest_dict['MfeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MflI>[AG]GATC[CT])|(?P<MflI_as>[AG]GATC[CT])',
        'results' : None,
        'site' : 'RGATCY',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'RGATCY'),
        'ovhgseq' : 'GATC',
    }
rest_dict['MflI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MhlI>G[AGT]GC[ACT]C)|(?P<MhlI_as>G[AGT]GC[ACT]C)',
        'results' : None,
        'site' : 'GDGCHC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GDGCHC'),
        'ovhgseq' : 'DGCH',
    }
rest_dict['MhlI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MjaIV>GT..AC)|(?P<MjaIV_as>GT..AC)',
        'results' : None,
        'site' : 'GTNNAC',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'GTNNAC'),
        'ovhgseq' : None,
    }
rest_dict['MjaIV'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MlsI>TGGCCA)|(?P<MlsI_as>TGGCCA)',
        'results' : None,
        'site' : 'TGGCCA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TGGCCA'),
        'ovhgseq' : '',
    }
rest_dict['MlsI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MluI>ACGCGT)|(?P<MluI_as>ACGCGT)',
        'results' : None,
        'site' : 'ACGCGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACGCGT'),
        'ovhgseq' : 'CGCG',
    }
rest_dict['MluI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MluNI>TGGCCA)|(?P<MluNI_as>TGGCCA)',
        'results' : None,
        'site' : 'TGGCCA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('M', 'S'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TGGCCA'),
        'ovhgseq' : '',
    }
rest_dict['MluNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Mly113I>GGCGCC)|(?P<Mly113I_as>GGCGCC)',
        'results' : None,
        'site' : 'GGCGCC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GGCGCC'),
        'ovhgseq' : 'CG',
    }
rest_dict['Mly113I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MlyI>GAGTC)|(?P<MlyI_as>GACTC)',
        'results' : None,
        'site' : 'GAGTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 10,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (10, 5, None, None, 'GAGTC'),
        'ovhgseq' : '',
    }
rest_dict['MlyI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MmeI>TCC[AG]AC)|(?P<MmeI_as>GT[CT]GGA)',
        'results' : None,
        'site' : 'TCCRAC',
        'substrat' : 'DNA',
        'fst3' : 18,
        'fst5' : 26,
        'freq' : 2048,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N', 'X'),
        'scd5' : None,
        'charac' : (26, 18, None, None, 'TCCRAC'),
        'ovhgseq' : 'NN',
    }
rest_dict['MmeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MnlI>CCTC)|(?P<MnlI_as>GAGG)',
        'results' : None,
        'site' : 'CCTC',
        'substrat' : 'DNA',
        'fst3' : 6,
        'fst5' : 11,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('F', 'I', 'N', 'Q', 'V', 'W', 'X'),
        'scd5' : None,
        'charac' : (11, 6, None, None, 'CCTC'),
        'ovhgseq' : 'N',
    }
rest_dict['MnlI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Mph1103I>ATGCAT)|(?P<Mph1103I_as>ATGCAT)',
        'results' : None,
        'site' : 'ATGCAT',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'ATGCAT'),
        'ovhgseq' : 'TGCA',
    }
rest_dict['Mph1103I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MreI>CGCCGGCG)|(?P<MreI_as>CGCCGGCG)',
        'results' : None,
        'site' : 'CGCCGGCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGCCGGCG'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['MreI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MroI>TCCGGA)|(?P<MroI_as>TCCGGA)',
        'results' : None,
        'site' : 'TCCGGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('M', 'O'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCCGGA'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['MroI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MroNI>GCCGGC)|(?P<MroNI_as>GCCGGC)',
        'results' : None,
        'site' : 'GCCGGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GCCGGC'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['MroNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MroXI>GAA....TTC)|(?P<MroXI_as>GAA....TTC)',
        'results' : None,
        'site' : 'GAANNNNTTC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GAANNNNTTC'),
        'ovhgseq' : '',
    }
rest_dict['MroXI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MscI>TGGCCA)|(?P<MscI_as>TGGCCA)',
        'results' : None,
        'site' : 'TGGCCA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'N', 'O'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TGGCCA'),
        'ovhgseq' : '',
    }
rest_dict['MscI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MseI>TTAA)|(?P<MseI_as>TTAA)',
        'results' : None,
        'site' : 'TTAA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('B', 'N'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TTAA'),
        'ovhgseq' : 'TA',
    }
rest_dict['MseI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MslI>CA[CT]....[AG]TG)|(?P<MslI_as>CA[CT]....[AG]TG)',
        'results' : None,
        'site' : 'CAYNNNNRTG',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'CAYNNNNRTG'),
        'ovhgseq' : '',
    }
rest_dict['MslI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Msp20I>TGGCCA)|(?P<Msp20I_as>TGGCCA)',
        'results' : None,
        'site' : 'TGGCCA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TGGCCA'),
        'ovhgseq' : '',
    }
rest_dict['Msp20I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MspA1I>C[AC]GC[GT]G)|(?P<MspA1I_as>C[AC]GC[GT]G)',
        'results' : None,
        'site' : 'CMGCKG',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'N', 'R', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CMGCKG'),
        'ovhgseq' : '',
    }
rest_dict['MspA1I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MspCI>CTTAAG)|(?P<MspCI_as>CTTAAG)',
        'results' : None,
        'site' : 'CTTAAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('C',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTTAAG'),
        'ovhgseq' : 'TTAA',
    }
rest_dict['MspCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MspI>CCGG)|(?P<MspI_as>CCGG)',
        'results' : None,
        'site' : 'CCGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCGG'),
        'ovhgseq' : 'CG',
    }
rest_dict['MspI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MspR9I>CC.GG)|(?P<MspR9I_as>CC.GG)',
        'results' : None,
        'site' : 'CCNGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCNGG'),
        'ovhgseq' : 'N',
    }
rest_dict['MspR9I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MssI>GTTTAAAC)|(?P<MssI_as>GTTTAAAC)',
        'results' : None,
        'site' : 'GTTTAAAC',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'GTTTAAAC'),
        'ovhgseq' : '',
    }
rest_dict['MssI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MstI>TGCGCA)|(?P<MstI_as>TGCGCA)',
        'results' : None,
        'site' : 'TGCGCA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TGCGCA'),
        'ovhgseq' : '',
    }
rest_dict['MstI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MunI>CAATTG)|(?P<MunI_as>CAATTG)',
        'results' : None,
        'site' : 'CAATTG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F', 'K', 'M'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CAATTG'),
        'ovhgseq' : 'AATT',
    }
rest_dict['MunI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Mva1269I>GAATGC)|(?P<Mva1269I_as>GCATTC)',
        'results' : None,
        'site' : 'GAATGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (7, -1, None, None, 'GAATGC'),
        'ovhgseq' : 'CN',
    }
rest_dict['Mva1269I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MvaI>CC[AT]GG)|(?P<MvaI_as>CC[AT]GG)',
        'results' : None,
        'site' : 'CCWGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('F', 'K', 'M', 'O', 'S', 'W'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCWGG'),
        'ovhgseq' : 'W',
    }
rest_dict['MvaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MvnI>CGCG)|(?P<MvnI_as>CGCG)',
        'results' : None,
        'site' : 'CGCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGCG'),
        'ovhgseq' : '',
    }
rest_dict['MvnI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MvrI>CGATCG)|(?P<MvrI_as>CGATCG)',
        'results' : None,
        'site' : 'CGATCG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('U',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CGATCG'),
        'ovhgseq' : 'AT',
    }
rest_dict['MvrI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<MwoI>GC.......GC)|(?P<MwoI_as>GC.......GC)',
        'results' : None,
        'site' : 'GCNNNNNNNGC',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 256,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'GCNNNNNNNGC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['MwoI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NaeI>GCCGGC)|(?P<NaeI_as>GCCGGC)',
        'results' : None,
        'site' : 'GCCGGC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('C', 'K', 'M', 'N', 'O', 'R', 'U'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GCCGGC'),
        'ovhgseq' : '',
    }
rest_dict['NaeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NarI>GGCGCC)|(?P<NarI_as>GGCGCC)',
        'results' : None,
        'site' : 'GGCGCC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('J', 'M', 'N', 'O', 'Q', 'R', 'U', 'W', 'X'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GGCGCC'),
        'ovhgseq' : 'CG',
    }
rest_dict['NarI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NciI>CC[CG]GG)|(?P<NciI_as>CC[CG]GG)',
        'results' : None,
        'site' : 'CCSGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('J', 'N', 'O', 'R', 'W'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCSGG'),
        'ovhgseq' : 'S',
    }
rest_dict['NciI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NcoI>CCATGG)|(?P<NcoI_as>CCATGG)',
        'results' : None,
        'site' : 'CCATGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCATGG'),
        'ovhgseq' : 'CATG',
    }
rest_dict['NcoI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NdeI>CATATG)|(?P<NdeI_as>CATATG)',
        'results' : None,
        'site' : 'CATATG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('B', 'F', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CATATG'),
        'ovhgseq' : 'TA',
    }
rest_dict['NdeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NdeII>GATC)|(?P<NdeII_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('J', 'M', 'R', 'W'),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GATC'),
        'ovhgseq' : 'GATC',
    }
rest_dict['NdeII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NgoAVIII>GAC.....TGA)|(?P<NgoAVIII_as>TCA.....GTC)',
        'results' : None,
        'site' : 'GACNNNNNTGA',
        'substrat' : 'DNA',
        'fst3' : -25,
        'fst5' : -12,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : 11,
        'suppl' : (),
        'scd5' : 24,
        'charac' : (-12, -25, 24, 11, 'GACNNNNNTGA'),
        'ovhgseq' : 'NN',
    }
rest_dict['NgoAVIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NgoMIV>GCCGGC)|(?P<NgoMIV_as>GCCGGC)',
        'results' : None,
        'site' : 'GCCGGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N', 'R'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GCCGGC'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['NgoMIV'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NhaXI>CAAG[AG]AG)|(?P<NhaXI_as>CT[CT]CTTG)',
        'results' : None,
        'site' : 'CAAGRAG',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'CAAGRAG'),
        'ovhgseq' : None,
    }
rest_dict['NhaXI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NheI>GCTAGC)|(?P<NheI_as>GCTAGC)',
        'results' : None,
        'site' : 'GCTAGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'J', 'K', 'M', 'N', 'O', 'R', 'S', 'U', 'W'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GCTAGC'),
        'ovhgseq' : 'CTAG',
    }
rest_dict['NheI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NlaCI>CATCAC)|(?P<NlaCI_as>GTGATG)',
        'results' : None,
        'site' : 'CATCAC',
        'substrat' : 'DNA',
        'fst3' : 17,
        'fst5' : 25,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (25, 17, None, None, 'CATCAC'),
        'ovhgseq' : 'NN',
    }
rest_dict['NlaCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NlaIII>CATG)|(?P<NlaIII_as>CATG)',
        'results' : None,
        'site' : 'CATG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('N', 'W'),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CATG'),
        'ovhgseq' : 'CATG',
    }
rest_dict['NlaIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NlaIV>GG..CC)|(?P<NlaIV_as>GG..CC)',
        'results' : None,
        'site' : 'GGNNCC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N', 'W'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GGNNCC'),
        'ovhgseq' : '',
    }
rest_dict['NlaIV'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Nli3877I>C[CT]CG[AG]G)|(?P<Nli3877I_as>C[CT]CG[AG]G)',
        'results' : None,
        'site' : 'CYCGRG',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'CYCGRG'),
        'ovhgseq' : 'YCGR',
    }
rest_dict['Nli3877I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NmeAIII>GCCGAG)|(?P<NmeAIII_as>CTCGGC)',
        'results' : None,
        'site' : 'GCCGAG',
        'substrat' : 'DNA',
        'fst3' : 19,
        'fst5' : 27,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (27, 19, None, None, 'GCCGAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['NmeAIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NmeDI>[AG]CCGG[CT])|(?P<NmeDI_as>[AG]CCGG[CT])',
        'results' : None,
        'site' : 'RCCGGY',
        'substrat' : 'DNA',
        'fst3' : -13,
        'fst5' : -12,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : 12,
        'suppl' : (),
        'scd5' : 13,
        'charac' : (-12, -13, 13, 12, 'RCCGGY'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['NmeDI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NmuCI>GT[CG]AC)|(?P<NmuCI_as>GT[CG]AC)',
        'results' : None,
        'site' : 'GTSAC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GTSAC'),
        'ovhgseq' : 'GTSAC',
    }
rest_dict['NmuCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NotI>GCGGCCGC)|(?P<NotI_as>GCGGCCGC)',
        'results' : None,
        'site' : 'GCGGCCGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCGGCCGC'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['NotI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NruI>TCGCGA)|(?P<NruI_as>TCGCGA)',
        'results' : None,
        'site' : 'TCGCGA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'U', 'W', 'X'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TCGCGA'),
        'ovhgseq' : '',
    }
rest_dict['NruI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NsbI>TGCGCA)|(?P<NsbI_as>TGCGCA)',
        'results' : None,
        'site' : 'TGCGCA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F', 'K'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TGCGCA'),
        'ovhgseq' : '',
    }
rest_dict['NsbI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NsiI>ATGCAT)|(?P<NsiI_as>ATGCAT)',
        'results' : None,
        'site' : 'ATGCAT',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('B', 'H', 'J', 'M', 'N', 'R', 'S', 'U', 'W'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'ATGCAT'),
        'ovhgseq' : 'TGCA',
    }
rest_dict['NsiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NspBII>C[AC]GC[GT]G)|(?P<NspBII_as>C[AC]GC[GT]G)',
        'results' : None,
        'site' : 'CMGCKG',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CMGCKG'),
        'ovhgseq' : '',
    }
rest_dict['NspBII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NspI>[AG]CATG[CT])|(?P<NspI_as>[AG]CATG[CT])',
        'results' : None,
        'site' : 'RCATGY',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('M', 'N'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'RCATGY'),
        'ovhgseq' : 'CATG',
    }
rest_dict['NspI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<NspV>TTCGAA)|(?P<NspV_as>TTCGAA)',
        'results' : None,
        'site' : 'TTCGAA',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('J', 'O'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'TTCGAA'),
        'ovhgseq' : 'CG',
    }
rest_dict['NspV'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<OliI>CAC....GTG)|(?P<OliI_as>CAC....GTG)',
        'results' : None,
        'site' : 'CACNNNNGTG',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'CACNNNNGTG'),
        'ovhgseq' : '',
    }
rest_dict['OliI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PabI>GTAC)|(?P<PabI_as>GTAC)',
        'results' : None,
        'site' : 'GTAC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GTAC'),
        'ovhgseq' : 'TA',
    }
rest_dict['PabI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PacI>TTAATTAA)|(?P<PacI_as>TTAATTAA)',
        'results' : None,
        'site' : 'TTAATTAA',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F', 'N', 'O', 'W'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'TTAATTAA'),
        'ovhgseq' : 'AT',
    }
rest_dict['PacI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PaeI>GCATGC)|(?P<PaeI_as>GCATGC)',
        'results' : None,
        'site' : 'GCATGC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GCATGC'),
        'ovhgseq' : 'CATG',
    }
rest_dict['PaeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PaeR7I>CTCGAG)|(?P<PaeR7I_as>CTCGAG)',
        'results' : None,
        'site' : 'CTCGAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTCGAG'),
        'ovhgseq' : 'TCGA',
    }
rest_dict['PaeR7I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PagI>TCATGA)|(?P<PagI_as>TCATGA)',
        'results' : None,
        'site' : 'TCATGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCATGA'),
        'ovhgseq' : 'CATG',
    }
rest_dict['PagI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PalAI>GGCGCGCC)|(?P<PalAI_as>GGCGCGCC)',
        'results' : None,
        'site' : 'GGCGCGCC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GGCGCGCC'),
        'ovhgseq' : 'CGCG',
    }
rest_dict['PalAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PasI>CCC[AT]GGG)|(?P<PasI_as>CCC[AT]GGG)',
        'results' : None,
        'site' : 'CCCWGGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCCWGGG'),
        'ovhgseq' : 'CWG',
    }
rest_dict['PasI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PauI>GCGCGC)|(?P<PauI_as>GCGCGC)',
        'results' : None,
        'site' : 'GCGCGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GCGCGC'),
        'ovhgseq' : 'CGCG',
    }
rest_dict['PauI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PceI>AGGCCT)|(?P<PceI_as>AGGCCT)',
        'results' : None,
        'site' : 'AGGCCT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'AGGCCT'),
        'ovhgseq' : '',
    }
rest_dict['PceI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PciI>ACATGT)|(?P<PciI_as>ACATGT)',
        'results' : None,
        'site' : 'ACATGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'N'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACATGT'),
        'ovhgseq' : 'CATG',
    }
rest_dict['PciI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PciSI>GCTCTTC)|(?P<PciSI_as>GAAGAGC)',
        'results' : None,
        'site' : 'GCTCTTC',
        'substrat' : 'DNA',
        'fst3' : 4,
        'fst5' : 8,
        'freq' : 16384,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (8, 4, None, None, 'GCTCTTC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['PciSI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PctI>GAATGC)|(?P<PctI_as>GCATTC)',
        'results' : None,
        'site' : 'GAATGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (7, -1, None, None, 'GAATGC'),
        'ovhgseq' : 'CN',
    }
rest_dict['PctI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PdiI>GCCGGC)|(?P<PdiI_as>GCCGGC)',
        'results' : None,
        'site' : 'GCCGGC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GCCGGC'),
        'ovhgseq' : '',
    }
rest_dict['PdiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PdmI>GAA....TTC)|(?P<PdmI_as>GAA....TTC)',
        'results' : None,
        'site' : 'GAANNNNTTC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GAANNNNTTC'),
        'ovhgseq' : '',
    }
rest_dict['PdmI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PfeI>GA[AT]TC)|(?P<PfeI_as>GA[AT]TC)',
        'results' : None,
        'site' : 'GAWTC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GAWTC'),
        'ovhgseq' : 'AWT',
    }
rest_dict['PfeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Pfl1108I>TCGTAG)|(?P<Pfl1108I_as>CTACGA)',
        'results' : None,
        'site' : 'TCGTAG',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'TCGTAG'),
        'ovhgseq' : None,
    }
rest_dict['Pfl1108I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Pfl23II>CGTACG)|(?P<Pfl23II_as>CGTACG)',
        'results' : None,
        'site' : 'CGTACG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CGTACG'),
        'ovhgseq' : 'GTAC',
    }
rest_dict['Pfl23II'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PflFI>GAC...GTC)|(?P<PflFI_as>GAC...GTC)',
        'results' : None,
        'site' : 'GACNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 9,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'GACNNNGTC'),
        'ovhgseq' : 'N',
    }
rest_dict['PflFI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PflMI>CCA.....TGG)|(?P<PflMI_as>CCA.....TGG)',
        'results' : None,
        'site' : 'CCANNNNNTGG',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'CCANNNNNTGG'),
        'ovhgseq' : 'NNN',
    }
rest_dict['PflMI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PfoI>TCC.GGA)|(?P<PfoI_as>TCC.GGA)',
        'results' : None,
        'site' : 'TCCNGGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCCNGGA'),
        'ovhgseq' : 'CCNGG',
    }
rest_dict['PfoI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PhoI>GGCC)|(?P<PhoI_as>GGCC)',
        'results' : None,
        'site' : 'GGCC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GGCC'),
        'ovhgseq' : '',
    }
rest_dict['PhoI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PinAI>ACCGGT)|(?P<PinAI_as>ACCGGT)',
        'results' : None,
        'site' : 'ACCGGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'M', 'Q', 'X'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACCGGT'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['PinAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PlaDI>CATCAG)|(?P<PlaDI_as>CTGATG)',
        'results' : None,
        'site' : 'CATCAG',
        'substrat' : 'DNA',
        'fst3' : 19,
        'fst5' : 27,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (27, 19, None, None, 'CATCAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['PlaDI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Ple19I>CGATCG)|(?P<Ple19I_as>CGATCG)',
        'results' : None,
        'site' : 'CGATCG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CGATCG'),
        'ovhgseq' : 'AT',
    }
rest_dict['Ple19I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PleI>GAGTC)|(?P<PleI_as>GACTC)',
        'results' : None,
        'site' : 'GAGTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 9,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (9, 5, None, None, 'GAGTC'),
        'ovhgseq' : 'N',
    }
rest_dict['PleI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PmaCI>CACGTG)|(?P<PmaCI_as>CACGTG)',
        'results' : None,
        'site' : 'CACGTG',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CACGTG'),
        'ovhgseq' : '',
    }
rest_dict['PmaCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PmeI>GTTTAAAC)|(?P<PmeI_as>GTTTAAAC)',
        'results' : None,
        'site' : 'GTTTAAAC',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N', 'W'),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'GTTTAAAC'),
        'ovhgseq' : '',
    }
rest_dict['PmeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PmlI>CACGTG)|(?P<PmlI_as>CACGTG)',
        'results' : None,
        'site' : 'CACGTG',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CACGTG'),
        'ovhgseq' : '',
    }
rest_dict['PmlI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PpiI>GAAC.....CTC)|(?P<PpiI_as>GAG.....GTTC)',
        'results' : None,
        'site' : 'GAACNNNNNCTC',
        'substrat' : 'DNA',
        'fst3' : -24,
        'fst5' : -7,
        'freq' : 16384,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : 8,
        'suppl' : ('F',),
        'scd5' : 25,
        'charac' : (-7, -24, 25, 8, 'GAACNNNNNCTC'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['PpiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PpsI>GAGTC)|(?P<PpsI_as>GACTC)',
        'results' : None,
        'site' : 'GAGTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 9,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (9, 5, None, None, 'GAGTC'),
        'ovhgseq' : 'N',
    }
rest_dict['PpsI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Ppu10I>ATGCAT)|(?P<Ppu10I_as>ATGCAT)',
        'results' : None,
        'site' : 'ATGCAT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ATGCAT'),
        'ovhgseq' : 'TGCA',
    }
rest_dict['Ppu10I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Ppu21I>[CT]ACGT[AG])|(?P<Ppu21I_as>[CT]ACGT[AG])',
        'results' : None,
        'site' : 'YACGTR',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'YACGTR'),
        'ovhgseq' : '',
    }
rest_dict['Ppu21I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PpuMI>[AG]GG[AT]CC[CT])|(?P<PpuMI_as>[AG]GG[AT]CC[CT])',
        'results' : None,
        'site' : 'RGGWCCY',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 2048,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('N', 'O'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'RGGWCCY'),
        'ovhgseq' : 'GWC',
    }
rest_dict['PpuMI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PscI>ACATGT)|(?P<PscI_as>ACATGT)',
        'results' : None,
        'site' : 'ACATGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACATGT'),
        'ovhgseq' : 'CATG',
    }
rest_dict['PscI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PshAI>GAC....GTC)|(?P<PshAI_as>GAC....GTC)',
        'results' : None,
        'site' : 'GACNNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('K', 'N'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GACNNNNGTC'),
        'ovhgseq' : '',
    }
rest_dict['PshAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PshBI>ATTAAT)|(?P<PshBI_as>ATTAAT)',
        'results' : None,
        'site' : 'ATTAAT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'ATTAAT'),
        'ovhgseq' : 'TA',
    }
rest_dict['PshBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PsiI>TTATAA)|(?P<PsiI_as>TTATAA)',
        'results' : None,
        'site' : 'TTATAA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'N', 'O'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TTATAA'),
        'ovhgseq' : '',
    }
rest_dict['PsiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Psp03I>GG[AT]CC)|(?P<Psp03I_as>GG[AT]CC)',
        'results' : None,
        'site' : 'GGWCC',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'GGWCC'),
        'ovhgseq' : 'GWC',
    }
rest_dict['Psp03I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Psp124BI>GAGCTC)|(?P<Psp124BI_as>GAGCTC)',
        'results' : None,
        'site' : 'GAGCTC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GAGCTC'),
        'ovhgseq' : 'AGCT',
    }
rest_dict['Psp124BI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Psp1406I>AACGTT)|(?P<Psp1406I_as>AACGTT)',
        'results' : None,
        'site' : 'AACGTT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F', 'K'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'AACGTT'),
        'ovhgseq' : 'CG',
    }
rest_dict['Psp1406I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Psp5II>[AG]GG[AT]CC[CT])|(?P<Psp5II_as>[AG]GG[AT]CC[CT])',
        'results' : None,
        'site' : 'RGGWCCY',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 2048,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'RGGWCCY'),
        'ovhgseq' : 'GWC',
    }
rest_dict['Psp5II'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Psp6I>CC[AT]GG)|(?P<Psp6I_as>CC[AT]GG)',
        'results' : None,
        'site' : 'CCWGG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'CCWGG'),
        'ovhgseq' : 'CCWGG',
    }
rest_dict['Psp6I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PspCI>CACGTG)|(?P<PspCI_as>CACGTG)',
        'results' : None,
        'site' : 'CACGTG',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CACGTG'),
        'ovhgseq' : '',
    }
rest_dict['PspCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PspEI>GGT.ACC)|(?P<PspEI_as>GGT.ACC)',
        'results' : None,
        'site' : 'GGTNACC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGTNACC'),
        'ovhgseq' : 'GTNAC',
    }
rest_dict['PspEI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PspGI>CC[AT]GG)|(?P<PspGI_as>CC[AT]GG)',
        'results' : None,
        'site' : 'CCWGG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'CCWGG'),
        'ovhgseq' : 'CCWGG',
    }
rest_dict['PspGI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PspLI>CGTACG)|(?P<PspLI_as>CGTACG)',
        'results' : None,
        'site' : 'CGTACG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CGTACG'),
        'ovhgseq' : 'GTAC',
    }
rest_dict['PspLI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PspN4I>GG..CC)|(?P<PspN4I_as>GG..CC)',
        'results' : None,
        'site' : 'GGNNCC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GGNNCC'),
        'ovhgseq' : '',
    }
rest_dict['PspN4I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PspOMI>GGGCCC)|(?P<PspOMI_as>GGGCCC)',
        'results' : None,
        'site' : 'GGGCCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'N', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGGCCC'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['PspOMI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PspOMII>CGCCCA[AG])|(?P<PspOMII_as>[CT]TGGGCG)',
        'results' : None,
        'site' : 'CGCCCAR',
        'substrat' : 'DNA',
        'fst3' : 18,
        'fst5' : 27,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (27, 18, None, None, 'CGCCCAR'),
        'ovhgseq' : 'NN',
    }
rest_dict['PspOMII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PspPI>GG.CC)|(?P<PspPI_as>GG.CC)',
        'results' : None,
        'site' : 'GGNCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('C',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGNCC'),
        'ovhgseq' : 'GNC',
    }
rest_dict['PspPI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PspPPI>[AG]GG[AT]CC[CT])|(?P<PspPPI_as>[AG]GG[AT]CC[CT])',
        'results' : None,
        'site' : 'RGGWCCY',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 2048,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'RGGWCCY'),
        'ovhgseq' : 'GWC',
    }
rest_dict['PspPPI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PspPRI>CC[CT]CAG)|(?P<PspPRI_as>CTG[AG]GG)',
        'results' : None,
        'site' : 'CCYCAG',
        'substrat' : 'DNA',
        'fst3' : 13,
        'fst5' : 21,
        'freq' : 2048,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (21, 13, None, None, 'CCYCAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['PspPRI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PspXI>[ACG]CTCGAG[CGT])|(?P<PspXI_as>[ACG]CTCGAG[CGT])',
        'results' : None,
        'site' : 'VCTCGAGB',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'N'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'VCTCGAGB'),
        'ovhgseq' : 'TCGA',
    }
rest_dict['PspXI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PsrI>GAAC......TAC)|(?P<PsrI_as>GTA......GTTC)',
        'results' : None,
        'site' : 'GAACNNNNNNTAC',
        'substrat' : 'DNA',
        'fst3' : -25,
        'fst5' : -7,
        'freq' : 16384,
        'size' : 13,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : 7,
        'suppl' : ('I',),
        'scd5' : 25,
        'charac' : (-7, -25, 25, 7, 'GAACNNNNNNTAC'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['PsrI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PssI>[AG]GG.CC[CT])|(?P<PssI_as>[AG]GG.CC[CT])',
        'results' : None,
        'site' : 'RGGNCCY',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'RGGNCCY'),
        'ovhgseq' : 'GNC',
    }
rest_dict['PssI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PstI>CTGCAG)|(?P<PstI_as>CTGCAG)',
        'results' : None,
        'site' : 'CTGCAG',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'CTGCAG'),
        'ovhgseq' : 'TGCA',
    }
rest_dict['PstI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PsuI>[AG]GATC[CT])|(?P<PsuI_as>[AG]GATC[CT])',
        'results' : None,
        'site' : 'RGATCY',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'RGATCY'),
        'ovhgseq' : 'GATC',
    }
rest_dict['PsuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PsyI>GAC...GTC)|(?P<PsyI_as>GAC...GTC)',
        'results' : None,
        'site' : 'GACNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 9,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'GACNNNGTC'),
        'ovhgseq' : 'N',
    }
rest_dict['PsyI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PteI>GCGCGC)|(?P<PteI_as>GCGCGC)',
        'results' : None,
        'site' : 'GCGCGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GCGCGC'),
        'ovhgseq' : 'CGCG',
    }
rest_dict['PteI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PvuI>CGATCG)|(?P<PvuI_as>CGATCG)',
        'results' : None,
        'site' : 'CGATCG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('B', 'F', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CGATCG'),
        'ovhgseq' : 'AT',
    }
rest_dict['PvuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<PvuII>CAGCTG)|(?P<PvuII_as>CAGCTG)',
        'results' : None,
        'site' : 'CAGCTG',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CAGCTG'),
        'ovhgseq' : '',
    }
rest_dict['PvuII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<RcaI>TCATGA)|(?P<RcaI_as>TCATGA)',
        'results' : None,
        'site' : 'TCATGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCATGA'),
        'ovhgseq' : 'CATG',
    }
rest_dict['RcaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<RceI>CATCGAC)|(?P<RceI_as>GTCGATG)',
        'results' : None,
        'site' : 'CATCGAC',
        'substrat' : 'DNA',
        'fst3' : 18,
        'fst5' : 27,
        'freq' : 16384,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (27, 18, None, None, 'CATCGAC'),
        'ovhgseq' : 'NN',
    }
rest_dict['RceI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<RgaI>GCGATCGC)|(?P<RgaI_as>GCGATCGC)',
        'results' : None,
        'site' : 'GCGATCGC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GCGATCGC'),
        'ovhgseq' : 'AT',
    }
rest_dict['RgaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<RigI>GGCCGGCC)|(?P<RigI_as>GGCCGGCC)',
        'results' : None,
        'site' : 'GGCCGGCC',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'GGCCGGCC'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['RigI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<RleAI>CCCACA)|(?P<RleAI_as>TGTGGG)',
        'results' : None,
        'site' : 'CCCACA',
        'substrat' : 'DNA',
        'fst3' : 9,
        'fst5' : 18,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (18, 9, None, None, 'CCCACA'),
        'ovhgseq' : 'NNN',
    }
rest_dict['RleAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<RpaB5I>CG[AG]GGAC)|(?P<RpaB5I_as>GTCC[CT]CG)',
        'results' : None,
        'site' : 'CGRGGAC',
        'substrat' : 'DNA',
        'fst3' : 18,
        'fst5' : 27,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (27, 18, None, None, 'CGRGGAC'),
        'ovhgseq' : 'NN',
    }
rest_dict['RpaB5I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<RruI>TCGCGA)|(?P<RruI_as>TCGCGA)',
        'results' : None,
        'site' : 'TCGCGA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TCGCGA'),
        'ovhgseq' : '',
    }
rest_dict['RruI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<RsaI>GTAC)|(?P<RsaI_as>GTAC)',
        'results' : None,
        'site' : 'GTAC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'I', 'J', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GTAC'),
        'ovhgseq' : '',
    }
rest_dict['RsaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<RsaNI>GTAC)|(?P<RsaNI_as>GTAC)',
        'results' : None,
        'site' : 'GTAC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GTAC'),
        'ovhgseq' : 'TA',
    }
rest_dict['RsaNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<RseI>CA[CT]....[AG]TG)|(?P<RseI_as>CA[CT]....[AG]TG)',
        'results' : None,
        'site' : 'CAYNNNNRTG',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'CAYNNNNRTG'),
        'ovhgseq' : '',
    }
rest_dict['RseI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Rsr2I>CGG[AT]CCG)|(?P<Rsr2I_as>CGG[AT]CCG)',
        'results' : None,
        'site' : 'CGGWCCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGGWCCG'),
        'ovhgseq' : 'GWC',
    }
rest_dict['Rsr2I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<RsrII>CGG[AT]CCG)|(?P<RsrII_as>CGG[AT]CCG)',
        'results' : None,
        'site' : 'CGGWCCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('M', 'N', 'Q', 'X'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGGWCCG'),
        'ovhgseq' : 'GWC',
    }
rest_dict['RsrII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SacI>GAGCTC)|(?P<SacI_as>GAGCTC)',
        'results' : None,
        'site' : 'GAGCTC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F', 'H', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'W', 'X'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GAGCTC'),
        'ovhgseq' : 'AGCT',
    }
rest_dict['SacI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SacII>CCGCGG)|(?P<SacII_as>CCGCGG)',
        'results' : None,
        'site' : 'CCGCGG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('H', 'J', 'K', 'N', 'O', 'Q', 'R', 'W', 'X'),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CCGCGG'),
        'ovhgseq' : 'GC',
    }
rest_dict['SacII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SalI>GTCGAC)|(?P<SalI_as>GTCGAC)',
        'results' : None,
        'site' : 'GTCGAC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GTCGAC'),
        'ovhgseq' : 'TCGA',
    }
rest_dict['SalI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SanDI>GGG[AT]CCC)|(?P<SanDI_as>GGG[AT]CCC)',
        'results' : None,
        'site' : 'GGGWCCC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('E',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GGGWCCC'),
        'ovhgseq' : 'GWC',
    }
rest_dict['SanDI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SapI>GCTCTTC)|(?P<SapI_as>GAAGAGC)',
        'results' : None,
        'site' : 'GCTCTTC',
        'substrat' : 'DNA',
        'fst3' : 4,
        'fst5' : 8,
        'freq' : 16384,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (8, 4, None, None, 'GCTCTTC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['SapI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SaqAI>TTAA)|(?P<SaqAI_as>TTAA)',
        'results' : None,
        'site' : 'TTAA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TTAA'),
        'ovhgseq' : 'TA',
    }
rest_dict['SaqAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SatI>GC.GC)|(?P<SatI_as>GC.GC)',
        'results' : None,
        'site' : 'GCNGC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GCNGC'),
        'ovhgseq' : 'N',
    }
rest_dict['SatI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Sau3AI>GATC)|(?P<Sau3AI_as>GATC)',
        'results' : None,
        'site' : 'GATC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('C', 'H', 'J', 'K', 'M', 'N', 'O', 'R', 'S', 'U', 'W', 'X'),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GATC'),
        'ovhgseq' : 'GATC',
    }
rest_dict['Sau3AI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Sau96I>GG.CC)|(?P<Sau96I_as>GG.CC)',
        'results' : None,
        'site' : 'GGNCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('J', 'N', 'O', 'U', 'W'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGNCC'),
        'ovhgseq' : 'GNC',
    }
rest_dict['Sau96I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SauI>CCT.AGG)|(?P<SauI_as>CCT.AGG)',
        'results' : None,
        'site' : 'CCTNAGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCTNAGG'),
        'ovhgseq' : 'TNA',
    }
rest_dict['SauI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SbfI>CCTGCAGG)|(?P<SbfI_as>CCTGCAGG)',
        'results' : None,
        'site' : 'CCTGCAGG',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I', 'N', 'O', 'V'),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'CCTGCAGG'),
        'ovhgseq' : 'TGCA',
    }
rest_dict['SbfI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ScaI>AGTACT)|(?P<ScaI_as>AGTACT)',
        'results' : None,
        'site' : 'AGTACT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'W', 'X'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'AGTACT'),
        'ovhgseq' : '',
    }
rest_dict['ScaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SchI>GAGTC)|(?P<SchI_as>GACTC)',
        'results' : None,
        'site' : 'GAGTC',
        'substrat' : 'DNA',
        'fst3' : 5,
        'fst5' : 10,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (10, 5, None, None, 'GAGTC'),
        'ovhgseq' : '',
    }
rest_dict['SchI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SciI>CTCGAG)|(?P<SciI_as>CTCGAG)',
        'results' : None,
        'site' : 'CTCGAG',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CTCGAG'),
        'ovhgseq' : '',
    }
rest_dict['SciI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ScrFI>CC.GG)|(?P<ScrFI_as>CC.GG)',
        'results' : None,
        'site' : 'CCNGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('J', 'N', 'O', 'S'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCNGG'),
        'ovhgseq' : 'N',
    }
rest_dict['ScrFI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SdaI>CCTGCAGG)|(?P<SdaI_as>CCTGCAGG)',
        'results' : None,
        'site' : 'CCTGCAGG',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'CCTGCAGG'),
        'ovhgseq' : 'TGCA',
    }
rest_dict['SdaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SdeAI>CAG[AG]AG)|(?P<SdeAI_as>CT[CT]CTG)',
        'results' : None,
        'site' : 'CAGRAG',
        'substrat' : 'DNA',
        'fst3' : 19,
        'fst5' : 27,
        'freq' : 2048,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (27, 19, None, None, 'CAGRAG'),
        'ovhgseq' : 'NN',
    }
rest_dict['SdeAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SdeOSI>GAC....[AG]TGA)|(?P<SdeOSI_as>TCA[CT]....GTC)',
        'results' : None,
        'site' : 'GACNNNNRTGA',
        'substrat' : 'DNA',
        'fst3' : -24,
        'fst5' : -11,
        'freq' : 8192,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : 10,
        'suppl' : (),
        'scd5' : 23,
        'charac' : (-11, -24, 23, 10, 'GACNNNNRTGA'),
        'ovhgseq' : 'NN',
    }
rest_dict['SdeOSI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SduI>G[AGT]GC[ACT]C)|(?P<SduI_as>G[AGT]GC[ACT]C)',
        'results' : None,
        'site' : 'GDGCHC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GDGCHC'),
        'ovhgseq' : 'DGCH',
    }
rest_dict['SduI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SecI>CC..GG)|(?P<SecI_as>CC..GG)',
        'results' : None,
        'site' : 'CCNNGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCNNGG'),
        'ovhgseq' : 'CNNG',
    }
rest_dict['SecI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SelI>CGCG)|(?P<SelI_as>CGCG)',
        'results' : None,
        'site' : 'CGCG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'CGCG'),
        'ovhgseq' : 'CGCG',
    }
rest_dict['SelI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SetI>A[CG][CG]T)|(?P<SetI_as>A[CG][CG]T)',
        'results' : None,
        'site' : 'ASST',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 64,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'ASST'),
        'ovhgseq' : 'ASST',
    }
rest_dict['SetI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SexAI>ACC[AT]GGT)|(?P<SexAI_as>ACC[AT]GGT)',
        'results' : None,
        'site' : 'ACCWGGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('M', 'N'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACCWGGT'),
        'ovhgseq' : 'CCWGG',
    }
rest_dict['SexAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SfaAI>GCGATCGC)|(?P<SfaAI_as>GCGATCGC)',
        'results' : None,
        'site' : 'GCGATCGC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GCGATCGC'),
        'ovhgseq' : 'AT',
    }
rest_dict['SfaAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SfaNI>GCATC)|(?P<SfaNI_as>GATGC)',
        'results' : None,
        'site' : 'GCATC',
        'substrat' : 'DNA',
        'fst3' : 9,
        'fst5' : 10,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'N', 'V'),
        'scd5' : None,
        'charac' : (10, 9, None, None, 'GCATC'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['SfaNI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SfcI>CT[AG][CT]AG)|(?P<SfcI_as>CT[AG][CT]AG)',
        'results' : None,
        'site' : 'CTRYAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTRYAG'),
        'ovhgseq' : 'TRYA',
    }
rest_dict['SfcI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SfeI>CT[AG][CT]AG)|(?P<SfeI_as>CT[AG][CT]AG)',
        'results' : None,
        'site' : 'CTRYAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTRYAG'),
        'ovhgseq' : 'TRYA',
    }
rest_dict['SfeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SfiI>GGCC.....GGCC)|(?P<SfiI_as>GGCC.....GGCC)',
        'results' : None,
        'site' : 'GGCCNNNNNGGCC',
        'substrat' : 'DNA',
        'fst3' : -8,
        'fst5' : 8,
        'freq' : 65536,
        'size' : 13,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('C', 'F', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X'),
        'scd5' : None,
        'charac' : (8, -8, None, None, 'GGCCNNNNNGGCC'),
        'ovhgseq' : 'NNN',
    }
rest_dict['SfiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SfoI>GGCGCC)|(?P<SfoI_as>GGCGCC)',
        'results' : None,
        'site' : 'GGCGCC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GGCGCC'),
        'ovhgseq' : '',
    }
rest_dict['SfoI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Sfr274I>CTCGAG)|(?P<Sfr274I_as>CTCGAG)',
        'results' : None,
        'site' : 'CTCGAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTCGAG'),
        'ovhgseq' : 'TCGA',
    }
rest_dict['Sfr274I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Sfr303I>CCGCGG)|(?P<Sfr303I_as>CCGCGG)',
        'results' : None,
        'site' : 'CCGCGG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CCGCGG'),
        'ovhgseq' : 'GC',
    }
rest_dict['Sfr303I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SfuI>TTCGAA)|(?P<SfuI_as>TTCGAA)',
        'results' : None,
        'site' : 'TTCGAA',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'TTCGAA'),
        'ovhgseq' : 'CG',
    }
rest_dict['SfuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SgfI>GCGATCGC)|(?P<SgfI_as>GCGATCGC)',
        'results' : None,
        'site' : 'GCGATCGC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('R',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GCGATCGC'),
        'ovhgseq' : 'AT',
    }
rest_dict['SgfI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SgrAI>C[AG]CCGG[CT]G)|(?P<SgrAI_as>C[AG]CCGG[CT]G)',
        'results' : None,
        'site' : 'CRCCGGYG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 16384,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('M', 'N'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CRCCGGYG'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['SgrAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SgrBI>CCGCGG)|(?P<SgrBI_as>CCGCGG)',
        'results' : None,
        'site' : 'CCGCGG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('C',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CCGCGG'),
        'ovhgseq' : 'GC',
    }
rest_dict['SgrBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SgrDI>CGTCGACG)|(?P<SgrDI_as>CGTCGACG)',
        'results' : None,
        'site' : 'CGTCGACG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGTCGACG'),
        'ovhgseq' : 'TCGA',
    }
rest_dict['SgrDI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SgsI>GGCGCGCC)|(?P<SgsI_as>GGCGCGCC)',
        'results' : None,
        'site' : 'GGCGCGCC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GGCGCGCC'),
        'ovhgseq' : 'CGCG',
    }
rest_dict['SgsI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SimI>GGGTC)|(?P<SimI_as>GACCC)',
        'results' : None,
        'site' : 'GGGTC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 2,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (2, 0, None, None, 'GGGTC'),
        'ovhgseq' : 'GTC',
    }
rest_dict['SimI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SinI>GG[AT]CC)|(?P<SinI_as>GG[AT]CC)',
        'results' : None,
        'site' : 'GGWCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('Q', 'R', 'W', 'X'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGWCC'),
        'ovhgseq' : 'GWC',
    }
rest_dict['SinI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SlaI>CTCGAG)|(?P<SlaI_as>CTCGAG)',
        'results' : None,
        'site' : 'CTCGAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('C',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTCGAG'),
        'ovhgseq' : 'TCGA',
    }
rest_dict['SlaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SmaI>CCCGGG)|(?P<SmaI_as>CCCGGG)',
        'results' : None,
        'site' : 'CCCGGG',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'CCCGGG'),
        'ovhgseq' : '',
    }
rest_dict['SmaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SmiI>ATTTAAAT)|(?P<SmiI_as>ATTTAAAT)',
        'results' : None,
        'site' : 'ATTTAAAT',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('F', 'I', 'K', 'V'),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'ATTTAAAT'),
        'ovhgseq' : '',
    }
rest_dict['SmiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SmiMI>CA[CT]....[AG]TG)|(?P<SmiMI_as>CA[CT]....[AG]TG)',
        'results' : None,
        'site' : 'CAYNNNNRTG',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'CAYNNNNRTG'),
        'ovhgseq' : '',
    }
rest_dict['SmiMI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SmlI>CT[CT][AG]AG)|(?P<SmlI_as>CT[CT][AG]AG)',
        'results' : None,
        'site' : 'CTYRAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTYRAG'),
        'ovhgseq' : 'TYRA',
    }
rest_dict['SmlI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SmoI>CT[CT][AG]AG)|(?P<SmoI_as>CT[CT][AG]AG)',
        'results' : None,
        'site' : 'CTYRAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTYRAG'),
        'ovhgseq' : 'TYRA',
    }
rest_dict['SmoI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SmuI>CCCGC)|(?P<SmuI_as>GCGGG)',
        'results' : None,
        'site' : 'CCCGC',
        'substrat' : 'DNA',
        'fst3' : 6,
        'fst5' : 9,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (9, 6, None, None, 'CCCGC'),
        'ovhgseq' : 'NN',
    }
rest_dict['SmuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SnaBI>TACGTA)|(?P<SnaBI_as>TACGTA)',
        'results' : None,
        'site' : 'TACGTA',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('C', 'K', 'M', 'N', 'R'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'TACGTA'),
        'ovhgseq' : '',
    }
rest_dict['SnaBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SnaI>GTATAC)|(?P<SnaI_as>GTATAC)',
        'results' : None,
        'site' : 'GTATAC',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'GTATAC'),
        'ovhgseq' : None,
    }
rest_dict['SnaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SpeI>ACTAGT)|(?P<SpeI_as>ACTAGT)',
        'results' : None,
        'site' : 'ACTAGT',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'H', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'W', 'X'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'ACTAGT'),
        'ovhgseq' : 'CTAG',
    }
rest_dict['SpeI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SphI>GCATGC)|(?P<SphI_as>GCATGC)',
        'results' : None,
        'site' : 'GCATGC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('B', 'C', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'W', 'X'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GCATGC'),
        'ovhgseq' : 'CATG',
    }
rest_dict['SphI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SplI>CGTACG)|(?P<SplI_as>CGTACG)',
        'results' : None,
        'site' : 'CGTACG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CGTACG'),
        'ovhgseq' : 'GTAC',
    }
rest_dict['SplI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SpoDI>GCGG[AG]AG)|(?P<SpoDI_as>CT[CT]CCGC)',
        'results' : None,
        'site' : 'GCGGRAG',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'GCGGRAG'),
        'ovhgseq' : None,
    }
rest_dict['SpoDI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SrfI>GCCCGGGC)|(?P<SrfI_as>GCCCGGGC)',
        'results' : None,
        'site' : 'GCCCGGGC',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('E', 'O'),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'GCCCGGGC'),
        'ovhgseq' : '',
    }
rest_dict['SrfI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Sse232I>CGCCGGCG)|(?P<Sse232I_as>CGCCGGCG)',
        'results' : None,
        'site' : 'CGCCGGCG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CGCCGGCG'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['Sse232I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Sse8387I>CCTGCAGG)|(?P<Sse8387I_as>CCTGCAGG)',
        'results' : None,
        'site' : 'CCTGCAGG',
        'substrat' : 'DNA',
        'fst3' : -6,
        'fst5' : 6,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (6, -6, None, None, 'CCTGCAGG'),
        'ovhgseq' : 'TGCA',
    }
rest_dict['Sse8387I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Sse8647I>AGG[AT]CCT)|(?P<Sse8647I_as>AGG[AT]CCT)',
        'results' : None,
        'site' : 'AGGWCCT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 8192,
        'size' : 7,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'AGGWCCT'),
        'ovhgseq' : 'GWC',
    }
rest_dict['Sse8647I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Sse9I>AATT)|(?P<Sse9I_as>AATT)',
        'results' : None,
        'site' : 'AATT',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'AATT'),
        'ovhgseq' : 'AATT',
    }
rest_dict['Sse9I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SseBI>AGGCCT)|(?P<SseBI_as>AGGCCT)',
        'results' : None,
        'site' : 'AGGCCT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('C',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'AGGCCT'),
        'ovhgseq' : '',
    }
rest_dict['SseBI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SsiI>CCGC)|(?P<SsiI_as>GCGG)',
        'results' : None,
        'site' : 'CCGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCGC'),
        'ovhgseq' : 'CG',
    }
rest_dict['SsiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SspD5I>GGTGA)|(?P<SspD5I_as>TCACC)',
        'results' : None,
        'site' : 'GGTGA',
        'substrat' : 'DNA',
        'fst3' : 8,
        'fst5' : 13,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (13, 8, None, None, 'GGTGA'),
        'ovhgseq' : '',
    }
rest_dict['SspD5I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SspDI>GGCGCC)|(?P<SspDI_as>GGCGCC)',
        'results' : None,
        'site' : 'GGCGCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGCGCC'),
        'ovhgseq' : 'GCGC',
    }
rest_dict['SspDI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SspI>AATATT)|(?P<SspI_as>AATATT)',
        'results' : None,
        'site' : 'AATATT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'AATATT'),
        'ovhgseq' : '',
    }
rest_dict['SspI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SstI>GAGCTC)|(?P<SstI_as>GAGCTC)',
        'results' : None,
        'site' : 'GAGCTC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('B', 'C'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GAGCTC'),
        'ovhgseq' : 'AGCT',
    }
rest_dict['SstI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SstII>CCGCGG)|(?P<SstII_as>CCGCGG)',
        'results' : None,
        'site' : 'CCGCGG',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('B',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'CCGCGG'),
        'ovhgseq' : 'GC',
    }
rest_dict['SstII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Sth132I>CCCG)|(?P<Sth132I_as>CGGG)',
        'results' : None,
        'site' : 'CCCG',
        'substrat' : 'DNA',
        'fst3' : 8,
        'fst5' : 8,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (8, 8, None, None, 'CCCG'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['Sth132I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Sth302II>CCGG)|(?P<Sth302II_as>CCGG)',
        'results' : None,
        'site' : 'CCGG',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'CCGG'),
        'ovhgseq' : '',
    }
rest_dict['Sth302II'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<StrI>CTCGAG)|(?P<StrI_as>CTCGAG)',
        'results' : None,
        'site' : 'CTCGAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('U',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTCGAG'),
        'ovhgseq' : 'TCGA',
    }
rest_dict['StrI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<StsI>GGATG)|(?P<StsI_as>CATCC)',
        'results' : None,
        'site' : 'GGATG',
        'substrat' : 'DNA',
        'fst3' : 14,
        'fst5' : 15,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (15, 14, None, None, 'GGATG'),
        'ovhgseq' : 'NNNN',
    }
rest_dict['StsI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<StuI>AGGCCT)|(?P<StuI_as>AGGCCT)',
        'results' : None,
        'site' : 'AGGCCT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('B', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'U', 'X'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'AGGCCT'),
        'ovhgseq' : '',
    }
rest_dict['StuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<StyD4I>CC.GG)|(?P<StyD4I_as>CC.GG)',
        'results' : None,
        'site' : 'CCNGG',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'CCNGG'),
        'ovhgseq' : 'CCNGG',
    }
rest_dict['StyD4I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<StyI>CC[AT][AT]GG)|(?P<StyI_as>CC[AT][AT]GG)',
        'results' : None,
        'site' : 'CCWWGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('C', 'J', 'M', 'N', 'R', 'S'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCWWGG'),
        'ovhgseq' : 'CWWG',
    }
rest_dict['StyI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<SwaI>ATTTAAAT)|(?P<SwaI_as>ATTTAAAT)',
        'results' : None,
        'site' : 'ATTTAAAT',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 65536,
        'size' : 8,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('J', 'M', 'N', 'S', 'W'),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'ATTTAAAT'),
        'ovhgseq' : '',
    }
rest_dict['SwaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TaaI>AC.GT)|(?P<TaaI_as>AC.GT)',
        'results' : None,
        'site' : 'ACNGT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'ACNGT'),
        'ovhgseq' : 'N',
    }
rest_dict['TaaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TaiI>ACGT)|(?P<TaiI_as>ACGT)',
        'results' : None,
        'site' : 'ACGT',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'ACGT'),
        'ovhgseq' : 'ACGT',
    }
rest_dict['TaiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TaqI>TCGA)|(?P<TaqI_as>TCGA)',
        'results' : None,
        'site' : 'TCGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCGA'),
        'ovhgseq' : 'CG',
    }
rest_dict['TaqI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TaqII>CACCCA)|(?P<TaqII_as>TGGGTG)',
        'results' : None,
        'site' : 'CACCCA|GACCGA',
        'substrat' : 'DNA',
        'fst3' : 9,
        'fst5' : 17,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('Q', 'X'),
        'scd5' : None,
        'charac' : (17, 9, None, None, 'CACCCA|GACCGA'),
        'ovhgseq' : '(?P<TaqII>CACCCA|GACCGA)|(?P<TaqII_as>TGGGTG|TCGGTC)',
    }
rest_dict['TaqII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TatI>[AT]GTAC[AT])|(?P<TatI_as>[AT]GTAC[AT])',
        'results' : None,
        'site' : 'WGTACW',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'WGTACW'),
        'ovhgseq' : 'GTAC',
    }
rest_dict['TatI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TauI>GC[CG]GC)|(?P<TauI_as>GC[CG]GC)',
        'results' : None,
        'site' : 'GCSGC',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'GCSGC'),
        'ovhgseq' : 'CSG',
    }
rest_dict['TauI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TfiI>GA[AT]TC)|(?P<TfiI_as>GA[AT]TC)',
        'results' : None,
        'site' : 'GAWTC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GAWTC'),
        'ovhgseq' : 'AWT',
    }
rest_dict['TfiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TliI>CTCGAG)|(?P<TliI_as>CTCGAG)',
        'results' : None,
        'site' : 'CTCGAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTCGAG'),
        'ovhgseq' : 'TCGA',
    }
rest_dict['TliI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Tru1I>TTAA)|(?P<Tru1I_as>TTAA)',
        'results' : None,
        'site' : 'TTAA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TTAA'),
        'ovhgseq' : 'TA',
    }
rest_dict['Tru1I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Tru9I>TTAA)|(?P<Tru9I_as>TTAA)',
        'results' : None,
        'site' : 'TTAA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('I', 'M', 'R', 'V', 'W'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TTAA'),
        'ovhgseq' : 'TA',
    }
rest_dict['Tru9I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TscAI>CA[CG]TG)|(?P<TscAI_as>CA[CG]TG)',
        'results' : None,
        'site' : 'CASTG',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 10,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'CASTG'),
        'ovhgseq' : 'NNCASTGNN',
    }
rest_dict['TscAI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TseI>GC[AT]GC)|(?P<TseI_as>GC[AT]GC)',
        'results' : None,
        'site' : 'GCWGC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GCWGC'),
        'ovhgseq' : 'CWG',
    }
rest_dict['TseI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TsoI>TA[AG]CCA)|(?P<TsoI_as>TGG[CT]TA)',
        'results' : None,
        'site' : 'TARCCA',
        'substrat' : 'DNA',
        'fst3' : 9,
        'fst5' : 17,
        'freq' : 2048,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (17, 9, None, None, 'TARCCA'),
        'ovhgseq' : 'NN',
    }
rest_dict['TsoI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Tsp45I>GT[CG]AC)|(?P<Tsp45I_as>GT[CG]AC)',
        'results' : None,
        'site' : 'GTSAC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GTSAC'),
        'ovhgseq' : 'GTSAC',
    }
rest_dict['Tsp45I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Tsp4CI>AC.GT)|(?P<Tsp4CI_as>AC.GT)',
        'results' : None,
        'site' : 'ACNGT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'ACNGT'),
        'ovhgseq' : 'N',
    }
rest_dict['Tsp4CI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Tsp509I>AATT)|(?P<Tsp509I_as>AATT)',
        'results' : None,
        'site' : 'AATT',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'AATT'),
        'ovhgseq' : 'AATT',
    }
rest_dict['Tsp509I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TspDTI>ATGAA)|(?P<TspDTI_as>TTCAT)',
        'results' : None,
        'site' : 'ATGAA',
        'substrat' : 'DNA',
        'fst3' : 9,
        'fst5' : 16,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('X',),
        'scd5' : None,
        'charac' : (16, 9, None, None, 'ATGAA'),
        'ovhgseq' : 'NN',
    }
rest_dict['TspDTI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TspEI>AATT)|(?P<TspEI_as>AATT)',
        'results' : None,
        'site' : 'AATT',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('O',),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'AATT'),
        'ovhgseq' : 'AATT',
    }
rest_dict['TspEI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TspGWI>ACGGA)|(?P<TspGWI_as>TCCGT)',
        'results' : None,
        'site' : 'ACGGA',
        'substrat' : 'DNA',
        'fst3' : 9,
        'fst5' : 16,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : ('X',),
        'scd5' : None,
        'charac' : (16, 9, None, None, 'ACGGA'),
        'ovhgseq' : 'NN',
    }
rest_dict['TspGWI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TspMI>CCCGGG)|(?P<TspMI_as>CCCGGG)',
        'results' : None,
        'site' : 'CCCGGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCCGGG'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['TspMI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TspRI>CA[CG]TG)|(?P<TspRI_as>CA[CG]TG)',
        'results' : None,
        'site' : 'CASTG',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 10,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'CASTG'),
        'ovhgseq' : 'NNCASTGNN',
    }
rest_dict['TspRI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TssI>GAG...CTC)|(?P<TssI_as>GAG...CTC)',
        'results' : None,
        'site' : 'GAGNNNCTC',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 4096,
        'size' : 9,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'GAGNNNCTC'),
        'ovhgseq' : None,
    }
rest_dict['TssI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TstI>CAC......TCC)|(?P<TstI_as>GGA......GTG)',
        'results' : None,
        'site' : 'CACNNNNNNTCC',
        'substrat' : 'DNA',
        'fst3' : -25,
        'fst5' : -8,
        'freq' : 4096,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 5,
        'scd3' : 7,
        'suppl' : ('F',),
        'scd5' : 24,
        'charac' : (-8, -25, 24, 7, 'CACNNNNNNTCC'),
        'ovhgseq' : 'NNNNN',
    }
rest_dict['TstI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<TsuI>GCGAC)|(?P<TsuI_as>GTCGC)',
        'results' : None,
        'site' : 'GCGAC',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'GCGAC'),
        'ovhgseq' : None,
    }
rest_dict['TsuI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Tth111I>GAC...GTC)|(?P<Tth111I_as>GAC...GTC)',
        'results' : None,
        'site' : 'GACNNNGTC',
        'substrat' : 'DNA',
        'fst3' : -4,
        'fst5' : 4,
        'freq' : 4096,
        'size' : 9,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('I', 'K', 'N', 'Q', 'R', 'V', 'W', 'X'),
        'scd5' : None,
        'charac' : (4, -4, None, None, 'GACNNNGTC'),
        'ovhgseq' : 'N',
    }
rest_dict['Tth111I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Tth111II>CAA[AG]CA)|(?P<Tth111II_as>TG[CT]TTG)',
        'results' : None,
        'site' : 'CAARCA',
        'substrat' : 'DNA',
        'fst3' : 9,
        'fst5' : 17,
        'freq' : 2048,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 2,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (17, 9, None, None, 'CAARCA'),
        'ovhgseq' : 'NN',
    }
rest_dict['Tth111II'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<UbaF11I>TCGTA)|(?P<UbaF11I_as>TACGA)',
        'results' : None,
        'site' : 'TCGTA',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 1024,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'TCGTA'),
        'ovhgseq' : None,
    }
rest_dict['UbaF11I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<UbaF12I>CTAC...GTC)|(?P<UbaF12I_as>GAC...GTAG)',
        'results' : None,
        'site' : 'CTACNNNGTC',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 16384,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'CTACNNNGTC'),
        'ovhgseq' : None,
    }
rest_dict['UbaF12I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<UbaF13I>GAG......CTGG)|(?P<UbaF13I_as>CCAG......CTC)',
        'results' : None,
        'site' : 'GAGNNNNNNCTGG',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 16384,
        'size' : 13,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'GAGNNNNNNCTGG'),
        'ovhgseq' : None,
    }
rest_dict['UbaF13I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<UbaF14I>CCA.....TCG)|(?P<UbaF14I_as>CGA.....TGG)',
        'results' : None,
        'site' : 'CCANNNNNTCG',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'CCANNNNNTCG'),
        'ovhgseq' : None,
    }
rest_dict['UbaF14I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<UbaF9I>TAC.....[AG]TGT)|(?P<UbaF9I_as>ACA[CT].....GTA)',
        'results' : None,
        'site' : 'TACNNNNNRTGT',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 8192,
        'size' : 12,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'TACNNNNNRTGT'),
        'ovhgseq' : None,
    }
rest_dict['UbaF9I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<UbaPI>CGAACG)|(?P<UbaPI_as>CGTTCG)',
        'results' : None,
        'site' : 'CGAACG',
        'substrat' : 'DNA',
        'fst3' : None,
        'fst5' : None,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : None,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (None, None, None, None, 'CGAACG'),
        'ovhgseq' : None,
    }
rest_dict['UbaPI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<UnbI>GG.CC)|(?P<UnbI_as>GG.CC)',
        'results' : None,
        'site' : 'GGNCC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 256,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GGNCC'),
        'ovhgseq' : 'GGNCC',
    }
rest_dict['UnbI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Van91I>CCA.....TGG)|(?P<Van91I_as>CCA.....TGG)',
        'results' : None,
        'site' : 'CCANNNNNTGG',
        'substrat' : 'DNA',
        'fst3' : -7,
        'fst5' : 7,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 3,
        'scd3' : None,
        'suppl' : ('F', 'K', 'M'),
        'scd5' : None,
        'charac' : (7, -7, None, None, 'CCANNNNNTGG'),
        'ovhgseq' : 'NNN',
    }
rest_dict['Van91I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Vha464I>CTTAAG)|(?P<Vha464I_as>CTTAAG)',
        'results' : None,
        'site' : 'CTTAAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('V',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTTAAG'),
        'ovhgseq' : 'TTAA',
    }
rest_dict['Vha464I'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<VneI>GTGCAC)|(?P<VneI_as>GTGCAC)',
        'results' : None,
        'site' : 'GTGCAC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GTGCAC'),
        'ovhgseq' : 'TGCA',
    }
rest_dict['VneI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<VpaK11AI>GG[AT]CC)|(?P<VpaK11AI_as>GG[AT]CC)',
        'results' : None,
        'site' : 'GGWCC',
        'substrat' : 'DNA',
        'fst3' : 0,
        'fst5' : 0,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -5,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (0, 0, None, None, 'GGWCC'),
        'ovhgseq' : 'GGWCC',
    }
rest_dict['VpaK11AI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<VpaK11BI>GG[AT]CC)|(?P<VpaK11BI_as>GG[AT]CC)',
        'results' : None,
        'site' : 'GGWCC',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 512,
        'size' : 5,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -3,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'GGWCC'),
        'ovhgseq' : 'GWC',
    }
rest_dict['VpaK11BI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<VspI>ATTAAT)|(?P<VspI_as>ATTAAT)',
        'results' : None,
        'site' : 'ATTAAT',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F', 'I', 'R', 'V'),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'ATTAAT'),
        'ovhgseq' : 'TA',
    }
rest_dict['VspI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XagI>CCT.....AGG)|(?P<XagI_as>CCT.....AGG)',
        'results' : None,
        'site' : 'CCTNNNNNAGG',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 11,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -1,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'CCTNNNNNAGG'),
        'ovhgseq' : 'N',
    }
rest_dict['XagI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XapI>[AG]AATT[CT])|(?P<XapI_as>[AG]AATT[CT])',
        'results' : None,
        'site' : 'RAATTY',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'RAATTY'),
        'ovhgseq' : 'AATT',
    }
rest_dict['XapI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XbaI>TCTAGA)|(?P<XbaI_as>TCTAGA)',
        'results' : None,
        'site' : 'TCTAGA',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'C', 'F', 'H', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'TCTAGA'),
        'ovhgseq' : 'CTAG',
    }
rest_dict['XbaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XceI>[AG]CATG[CT])|(?P<XceI_as>[AG]CATG[CT])',
        'results' : None,
        'site' : 'RCATGY',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'RCATGY'),
        'ovhgseq' : 'CATG',
    }
rest_dict['XceI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XcmI>CCA.........TGG)|(?P<XcmI_as>CCA.........TGG)',
        'results' : None,
        'site' : 'CCANNNNNNNNNTGG',
        'substrat' : 'DNA',
        'fst3' : -8,
        'fst5' : 8,
        'freq' : 4096,
        'size' : 15,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 1,
        'scd3' : None,
        'suppl' : ('N',),
        'scd5' : None,
        'charac' : (8, -8, None, None, 'CCANNNNNNNNNTGG'),
        'ovhgseq' : 'N',
    }
rest_dict['XcmI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XhoI>CTCGAG)|(?P<XhoI_as>CTCGAG)',
        'results' : None,
        'site' : 'CTCGAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('B', 'F', 'H', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'W', 'X', 'Y'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTCGAG'),
        'ovhgseq' : 'TCGA',
    }
rest_dict['XhoI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XhoII>[AG]GATC[CT])|(?P<XhoII_as>[AG]GATC[CT])',
        'results' : None,
        'site' : 'RGATCY',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('R', 'W'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'RGATCY'),
        'ovhgseq' : 'GATC',
    }
rest_dict['XhoII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XmaCI>CCCGGG)|(?P<XmaCI_as>CCCGGG)',
        'results' : None,
        'site' : 'CCCGGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('M',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCCGGG'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['XmaCI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XmaI>CCCGGG)|(?P<XmaI_as>CCCGGG)',
        'results' : None,
        'site' : 'CCCGGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('I', 'N', 'R', 'U', 'V'),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCCGGG'),
        'ovhgseq' : 'CCGG',
    }
rest_dict['XmaI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XmaIII>CGGCCG)|(?P<XmaIII_as>CGGCCG)',
        'results' : None,
        'site' : 'CGGCCG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : (),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CGGCCG'),
        'ovhgseq' : 'GGCC',
    }
rest_dict['XmaIII'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XmaJI>CCTAGG)|(?P<XmaJI_as>CCTAGG)',
        'results' : None,
        'site' : 'CCTAGG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -4,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CCTAGG'),
        'ovhgseq' : 'CTAG',
    }
rest_dict['XmaJI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XmiI>GT[AC][GT]AC)|(?P<XmiI_as>GT[AC][GT]AC)',
        'results' : None,
        'site' : 'GTMKAC',
        'substrat' : 'DNA',
        'fst3' : -2,
        'fst5' : 2,
        'freq' : 1024,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('F',),
        'scd5' : None,
        'charac' : (2, -2, None, None, 'GTMKAC'),
        'ovhgseq' : 'MK',
    }
rest_dict['XmiI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XmnI>GAA....TTC)|(?P<XmnI_as>GAA....TTC)',
        'results' : None,
        'site' : 'GAANNNNTTC',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 10,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('N', 'R', 'U', 'W'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'GAANNNNTTC'),
        'ovhgseq' : '',
    }
rest_dict['XmnI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<XspI>CTAG)|(?P<XspI_as>CTAG)',
        'results' : None,
        'site' : 'CTAG',
        'substrat' : 'DNA',
        'fst3' : -1,
        'fst5' : 1,
        'freq' : 256,
        'size' : 4,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : -2,
        'scd3' : None,
        'suppl' : ('K',),
        'scd5' : None,
        'charac' : (1, -1, None, None, 'CTAG'),
        'ovhgseq' : 'TA',
    }
rest_dict['XspI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ZraI>GACGTC)|(?P<ZraI_as>GACGTC)',
        'results' : None,
        'site' : 'GACGTC',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I', 'N', 'V'),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'GACGTC'),
        'ovhgseq' : '',
    }
rest_dict['ZraI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<ZrmI>AGTACT)|(?P<ZrmI_as>AGTACT)',
        'results' : None,
        'site' : 'AGTACT',
        'substrat' : 'DNA',
        'fst3' : -3,
        'fst5' : 3,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 0,
        'scd3' : None,
        'suppl' : ('I',),
        'scd5' : None,
        'charac' : (3, -3, None, None, 'AGTACT'),
        'ovhgseq' : '',
    }
rest_dict['ZrmI'] = _temp()

def _temp():
    return {
        'compsite' : '(?P<Zsp2I>ATGCAT)|(?P<Zsp2I_as>ATGCAT)',
        'results' : None,
        'site' : 'ATGCAT',
        'substrat' : 'DNA',
        'fst3' : -5,
        'fst5' : 5,
        'freq' : 4096,
        'size' : 6,
        'opt_temp' : 37,
        'dna' : None,
        'inact_temp' : 65,
        'ovhg' : 4,
        'scd3' : None,
        'suppl' : ('I', 'V'),
        'scd5' : None,
        'charac' : (5, -5, None, None, 'ATGCAT'),
        'ovhgseq' : 'TGCA',
    }
rest_dict['Zsp2I'] = _temp()

suppliers = {}
def _temp():
    return (
        'Invitrogen Corporation',
        ['MluI', 'HpaII', 'SalI', 'NcoI', 'ClaI', 'DraI', 'SstII', 'AvaI', 'PvuI', 'DpnI', 'TaqI', 'KpnI', 'NdeI', 'PinAI', 'BglII', 'NruI', 'RsaI', 'HincII', 'XbaI', 'MboI', 'AluI', 'MscI', 'SmaI', 'NheI', 'StuI', 'SphI', 'PvuII', 'SstI', 'SpeI', 'HinfI', 'EcoRV', 'EcoRI', 'XhoI', 'PstI', 'MseI', 'HaeIII', 'AccI', 'SspI', 'NsiI', 'ApaI', 'ScaI', 'DdeI', 'NotI', 'HindIII', 'BamHI', 'HpaI', 'HhaI'],
    )
suppliers['B'] = _temp()

def _temp():
    return (
        'Minotech Biotechnology',
        ['SgrBI', 'BclI', 'BglI', 'SalI', 'PspPI', 'SnaBI', 'BstEII', 'NcoI', 'BshFI', 'AsuII', 'BssAI', 'BseAI', 'TaqI', 'KpnI', 'BglII', 'NaeI', 'BseBI', 'NruI', 'SlaI', 'RsaI', 'BsiSI', 'XbaI', 'Sau3AI', 'MboI', 'AluI', 'SseBI', 'SmaI', 'NheI', 'SphI', 'PvuII', 'ApaLI', 'SstI', 'HinfI', 'MspCI', 'EcoRV', 'EcoRI', 'BseCI', 'PstI', 'SfiI', 'SspI', 'CspAI', 'ScaI', 'NotI', 'HindIII', 'BamHI', 'HpaI', 'StyI'],
    )
suppliers['C'] = _temp()

def _temp():
    return (
        'Stratagene',
        ['SanDI', 'DpnI', 'SrfI'],
    )
suppliers['E'] = _temp()

def _temp():
    return (
        'Fermentas International Inc.',
        ['MluI', 'CseI', 'PscI', 'HpaII', 'MreI', 'BclI', 'SacI', 'PauI', 'BglI', 'SalI', 'MspI', 'Bsu15I', 'Mva1269I', 'Bsp68I', 'LweI', 'SmiI', 'PteI', 'BshTI', 'TstI', 'TscAI', 'NcoI', 'PsyI', 'BseJI', 'MauBI', 'Eco24I', 'Eco47III', 'Eco91I', 'DraI', 'BseXI', 'BstXI', 'RruI', 'Esp3I', 'BseSI', 'Cfr9I', 'AarI', 'RseI', 'PvuI', 'BspOI', 'DpnI', 'Hin6I', 'Van91I', 'Bst1107I', 'Bme1390I', 'BveI', 'Psp5II', 'TaqI', 'Eco52I', 'BfiI', 'KpnI', 'Kpn2I', 'SspDI', 'SsiI', 'MlsI', 'NdeI', 'PpiI', 'Cfr13I', 'MboII', 'SdaI', 'BmsI', 'BglII', 'AjuI', 'AloI', 'FspBI', 'SchI', 'PfoI', 'Bpu10I', 'BshNI', 'Acc65I', 'XapI', 'TaaI', 'Bsp1407I', 'MvaI', 'PasI', 'Hin1II', 'Bsh1236I', 'MssI', 'CpoI', 'Eco130I', 'BdaI', 'TaiI', 'FspAI', 'BfmI', 'Eco47I', 'BoxI', 'RsaI', 'HincII', 'HpyF10VI', 'XbaI', 'Lsp1109I', 'Cfr10I', 'AjiI', 'Bsp119I', 'MboI', 'AluI', 'SduI', 'SgsI', 'BseGI', 'Eco72I', 'BcnI', 'Mph1103I', 'EcoRII', 'Alw21I', 'XagI', 'Hpy8I', 'PsuI', 'PaeI', 'SmaI', 'NheI', 'BplI', 'Ppu21I', 'SmoI', 'FaqI', 'AdeI', 'BcuI', 'BspTI', 'GsuI', 'BseLI', 'AasI', 'PvuII', 'EheI', 'Hin1I', 'Alw26I', 'SgrDI', 'Eco31I', 'HinfI', 'Eam1105I', 'BsuRI', 'TsoI', 'XmiI', 'Eam1104I', 'Ecl136II', 'XmaJI', 'SfaAI', 'HphI', 'Psp1406I', 'Csp6I', 'EcoO109I', 'BseMII', 'AatII', 'BfuI', 'EcoRI', 'TauI', 'XhoI', 'Bsp143I', 'BspPI', 'CfrI', 'MnlI', 'PfeI', 'CaiI', 'Bpu1102I', 'MunI', 'Tru1I', 'BspLI', 'SmuI', 'Eco105I', 'NsbI', 'PstI', 'LguI', 'VspI', 'Alw44I', 'SfiI', 'BpiI', 'XceI', 'BseMI', 'Eco57MI', 'Cfr42I', 'SatI', 'Hin4I', 'SspI', 'Eco32I', 'KflI', 'BseDI', 'KspAI', 'Eco81I', 'BauI', 'AanI', 'ApaI', 'SaqAI', 'Eco88I', 'ScaI', 'AlfI', 'Eco57I', 'Eco147I', 'OliI', 'PacI', 'PdmI', 'CsiI', 'Bsp120I', 'NotI', 'MbiI', 'HindIII', 'BamHI', 'BfoI', 'TatI', 'HpyF3I', 'Pfl23II', 'Bsh1285I', 'HhaI', 'NmuCI', 'BseNI', 'PagI', 'PdiI'],
    )
suppliers['F'] = _temp()

def _temp():
    return (
        'American Allied Biochemical, Inc.',
        ['MluI', 'SacI', 'BglI', 'SalI', 'MspI', 'BstEII', 'NcoI', 'ClaI', 'BstXI', 'KpnI', 'BglII', 'SacII', 'RsaI', 'HincII', 'XbaI', 'Sau3AI', 'AluI', 'SmaI', 'SphI', 'PvuII', 'SpeI', 'HinfI', 'EcoRV', 'EcoRI', 'XhoI', 'PstI', 'HaeIII', 'NsiI', 'NotI', 'HindIII', 'BamHI', 'HpaI'],
    )
suppliers['H'] = _temp()

def _temp():
    return (
        'SibEnzyme Ltd.',
        ['AsuNHI', 'AgsI', 'BstSFI', 'MluI', 'CciI', 'BstHHI', 'HpaII', 'AhlI', 'PspN4I', 'BglI', 'SalI', 'MspI', 'VneI', 'BstH2I', 'BisI', 'BmtI', 'PspXI', 'AsiGI', 'CciNI', 'Sfr274I', 'SmiI', 'Ksp22I', 'BssT1I', 'MspA1I', 'Bsp19I', 'Bse1I', 'AspS9I', 'AbsI', 'FauNDI', 'BstMWI', 'AclWI', 'DraI', 'Bst2UI', 'AluBI', 'PsrI', 'BstACI', 'BstXI', 'BstDEI', 'GluI', 'BspACI', 'AcoI', 'XmaI', 'BstF5I', 'BstMBI', 'BstENI', 'BssECI', 'FalI', 'EgeI', 'Ama87I', 'BstDSI', 'BstV2I', 'AjnI', 'AspLEI', 'PalAI', 'Zsp2I', 'DseDI', 'BstAUI', 'Bpu14I', 'FaeI', 'TaqI', 'KpnI', 'BstSNI', 'AclI', 'MboII', 'BglII', 'PspPPI', 'SetI', 'AcsI', 'BstNSI', 'BseX3I', 'RsaNI', 'Bpu10I', 'Rsr2I', 'Acc65I', 'PspEI', 'Bst2BI', 'NruI', 'Ple19I', 'SmiMI', 'PciI', 'MalI', 'Bse118I', 'BsePI', 'BstMCI', 'Bme18I', 'RsaI', 'BssNAI', 'BstV1I', 'Bsp13I', 'Bst4CI', 'MabI', 'AsuHPI', 'BtrI', 'XbaI', 'ArsI', 'BstC8I', 'Psp124BI', 'GlaI', 'HgaI', 'BstX2I', 'AluI', 'ZraI', 'Bse21I', 'Sfr303I', 'BstSCI', 'Bse3DI', 'Bso31I', 'AccB7I', 'BstKTI', 'AccBSI', 'SmaI', 'AspA2I', 'Bsp1720I', 'Bsc4I', 'SphI', 'Mly113I', 'FriOI', 'PvuII', 'ErhI', 'FokI', 'AsuC2I', 'GsaI', 'HinfI', 'BsuRI', 'PpsI', 'BstPAI', 'HspAI', 'RgaI', 'Fsp4HI', 'Kzo9I', 'Acc36I', 'DraIII', 'Acc16I', 'MspR9I', 'EcoRV', 'PsiI', 'AatII', 'MroXI', 'EcoRI', 'ZrmI', 'BstFNI', 'PspOMI', 'BslFI', 'Bsa29I', 'MnlI', 'SbfI', 'PstI', 'Bse8I', 'FauI', 'VspI', 'PciSI', 'SfiI', 'Bst6I', 'PspLI', 'BspFNI', 'Msp20I', 'Bbv12I', 'HaeIII', 'BstAPI', 'SspI', 'AfeI', 'Tth111I', 'BstMAI', 'BstSLI', 'ApaI', 'BlsI', 'FblI', 'BmuI', 'BarI', 'PctI', 'FaiI', 'BpmI', 'AcuI', 'AccB1I', 'PceI', 'Sse9I', 'Tru9I', 'MhlI', 'BstBAI', 'DriI', 'MroNI', 'HindIII', 'EcoICRI', 'FatI', 'BamHI', 'Psp6I', 'BstAFI', 'SfaNI', 'RigI', 'HpaI', 'PspCI', 'HindII'],
    )
suppliers['I'] = _temp()

def _temp():
    return (
        'Nippon Gene Co., Ltd.',
        ['BssHII', 'AxyI', 'MluI', 'BclI', 'SacI', 'EcoT38I', 'BglI', 'SalI', 'MspI', 'BstEII', 'NcoI', 'DraI', 'BstXI', 'SwaI', 'AvaI', 'TaqI', 'AseI', 'KpnI', 'Sau96I', 'HaeII', 'NdeI', 'MboII', 'AflII', 'BglII', 'AccII', 'SacII', 'NruI', 'NarI', 'RsaI', 'HincII', 'XbaI', 'Sau3AI', 'AluI', 'ScrFI', 'EcoRII', 'SmaI', 'NheI', 'StuI', 'SphI', 'NciI', 'FspI', 'PvuII', 'FokI', 'SpeI', 'HinfI', 'EcoO109I', 'EcoRV', 'EcoRI', 'XhoI', 'Bsp1286I', 'AccIII', 'PstI', 'BsmI', 'Alw44I', 'SfiI', 'HaeIII', 'NdeII', 'AccI', 'SspI', 'NsiI', 'ApaI', 'ScaI', 'AgeI', 'NspV', 'BalI', 'NotI', 'HindIII', 'AcyI', 'BamHI', 'AvaII', 'HpaI', 'StyI', 'HhaI'],
    )
suppliers['J'] = _temp()

def _temp():
    return (
        'Takara Bio Inc.',
        ['BssHII', 'MluI', 'BspT107I', 'SacI', 'XspI', 'BglI', 'SalI', 'MspI', 'BstPI', 'BanII', 'PmaCI', 'SnaBI', 'SmiI', 'BmgT120I', 'NcoI', 'ClaI', 'DraI', 'BstXI', 'PshAI', 'PvuI', 'Van91I', 'Bst1107I', 'TaqI', 'EaeI', 'Eco52I', 'BspT104I', 'KpnI', 'HaeII', 'EcoO65I', 'NdeI', 'HapII', 'MboII', 'AflII', 'EcoT14I', 'BglII', 'NaeI', 'AccII', 'SacII', 'BmeT110I', 'Aor51HI', 'Bsp1407I', 'NruI', 'MvaI', 'Sse8387I', 'CpoI', 'HincII', 'XbaI', 'Sau3AI', 'Cfr10I', 'MboI', 'AluI', 'BcnI', 'SmaI', 'NheI', 'StuI', 'SphI', 'PvuII', 'MflI', 'FokI', 'Hin1I', 'ApaLI', 'SpeI', 'HinfI', 'Eam1105I', 'Psp1406I', 'EcoO109I', 'BbeI', 'EcoRV', 'AatII', 'EcoRI', 'XhoI', 'VpaK11BI', 'Bsp1286I', 'AccIII', 'Bpu1102I', 'MunI', 'Aor13HI', 'NsbI', 'PstI', 'SfiI', 'BlnI', 'HaeIII', 'AccI', 'SspI', 'Tth111I', 'FbaI', 'Eco81I', 'ApaI', 'PshBI', 'EcoT22I', 'ScaI', 'BalI', 'AfaI', 'NotI', 'HindIII', 'BamHI', 'AvaII', 'HpaI', 'HhaI'],
    )
suppliers['K'] = _temp()

def _temp():
    return (
        'Roche Applied Science',
        ['BssHII', 'MluI', 'HpaII', 'BclI', 'SacI', 'BglI', 'SalI', 'Asp718I', 'MspI', 'SnaBI', 'XmaCI', 'BstEII', 'NcoI', 'ClaI', 'DraII', 'Eco47III', 'DraI', 'BstXI', 'SwaI', 'AvaI', 'PvuI', 'BseAI', 'DpnI', 'Van91I', 'Bst1107I', 'BsiWI', 'TaqI', 'SexAI', 'KpnI', 'NdeI', 'PinAI', 'BglII', 'NaeI', 'MaeI', 'AspI', 'NruI', 'MvaI', 'BpuAI', 'NarI', 'RsaI', 'MaeII', 'AflIII', 'AspEI', 'XbaI', 'Sau3AI', 'MvnI', 'AluI', 'RsrII', 'EcoRII', 'CfoI', 'SmaI', 'NheI', 'StuI', 'BbrPI', 'SphI', 'MaeIII', 'PvuII', 'FokI', 'SpeI', 'HinfI', 'DraIII', 'MluNI', 'EcoRV', 'AatII', 'EcoRI', 'XhoI', 'MunI', 'EclXI', 'PstI', 'BsmI', 'SfiI', 'BlnI', 'HaeIII', 'NdeII', 'AccI', 'SspI', 'SgrAI', 'NsiI', 'ItaI', 'ApaI', 'SfuI', 'ScaI', 'BfrI', 'NspI', 'KspI', 'Tru9I', 'DdeI', 'NotI', 'MroI', 'Asp700I', 'HindIII', 'AcyI', 'RcaI', 'BamHI', 'AviII', 'AvaII', 'CelII', 'HpaI', 'StyI', 'HindII'],
    )
suppliers['M'] = _temp()

def _temp():
    return (
        'New England Biolabs',
        ['BssHII', 'EciI', 'BsrFI', 'DpnII', 'AlwI', 'MluI', 'NgoMIV', 'HpaII', 'TspMI', 'BclI', 'MlyI', 'BsaWI', 'SacI', 'MwoI', 'BfaI', 'DrdI', 'BmgBI', 'BglI', 'SalI', 'MspI', 'BanII', 'MslI', 'BmtI', 'PspXI', 'BsaBI', 'SnaBI', 'BstEII', 'TspRI', 'NcoI', 'MspA1I', 'BtgI', 'ClaI', 'BsaI', 'BsrBI', 'AlwNI', 'XmnI', 'DraI', 'Hpy166II', 'Hpy99I', 'StyD4I', 'BstXI', 'PspGI', 'BsiHKAI', 'BlpI', 'PshAI', 'XmaI', 'SwaI', 'AvaI', 'PvuI', 'DpnI', 'CspCI', 'PflFI', 'BpuEI', 'BsiWI', 'TaqI', 'EaeI', 'SexAI', 'BsrI', 'AseI', 'KpnI', 'Sau96I', 'BstNI', 'HaeII', 'AclI', 'ApoI', 'HpyCH4IV', 'NdeI', 'MboII', 'AflII', 'TseI', 'BglII', 'SmlI', 'NaeI', 'Bpu10I', 'SacII', 'Acc65I', 'BspQI', 'AvrII', 'NruI', 'BaeI', 'BtsCI', 'BssKI', 'PciI', 'PhoI', 'BcgI', 'BsaHI', 'SfoI', 'TliI', 'NarI', 'Bsu36I', 'RsaI', 'HincII', 'AflIII', 'BsgI', 'XbaI', 'Sau3AI', 'BfuAI', 'TfiI', 'PmlI', 'BbvI', 'MboI', 'HgaI', 'BanI', 'AluI', 'BaeGI', 'ZraI', 'Hpy188III', 'RsrII', 'BspMI', 'AciI', 'ScrFI', 'MscI', 'BseYI', 'CviQI', 'BmrI', 'Hpy188I', 'SmaI', 'PleI', 'EcoNI', 'NheI', 'BccI', 'BsiEI', 'StuI', 'BspCNI', 'SphI', 'HpyAV', 'NciI', 'FspI', 'CviAII', 'PvuII', 'Eco53kI', 'MfeI', 'BsrDI', 'BssSI', 'FokI', 'ApaLI', 'ApeKI', 'SpeI', 'HinfI', 'BciVI', 'HinP1I', 'BceAI', 'HphI', 'BsmAI', 'DraIII', 'EcoO109I', 'BtsI', 'SapI', 'PpuMI', 'EcoRV', 'PsiI', 'AatII', 'EcoRI', 'BsmFI', 'XhoI', 'Bsp1286I', 'PspOMI', 'MnlI', 'EagI', 'AscI', 'AhdI', 'NlaIII', 'SbfI', 'BsoBI', 'PstI', 'Tsp509I', 'MseI', 'FauI', 'SfcI', 'BspEI', 'BsmI', 'SfiI', 'BstUI', 'BstZ17I', 'KasI', 'HaeIII', 'BsmBI', 'XcmI', 'BstAPI', 'AccI', 'SspI', 'HpyCH4III', 'BsrGI', 'AfeI', 'Tth111I', 'SgrAI', 'NsiI', 'BspHI', 'BstYI', 'PmeI', 'FseI', 'ApaI', 'BseRI', 'MmeI', 'ScaI', 'AgeI', 'BtgZI', 'BpmI', 'EarI', 'CviKI_1', 'AcuI', 'BfuCI', 'NspI', 'PacI', 'BstBI', 'HpyCH4V', 'NlaIV', 'BbsI', 'DdeI', 'NotI', 'BsaXI', 'HindIII', 'FatI', 'BamHI', 'BslI', 'AvaII', 'BspDI', 'PaeR7I', 'SfaNI', 'HpaI', 'BsaJI', 'BbvCI', 'Fnu4HI', 'Cac8I', 'Tsp45I', 'StyI', 'PflMI', 'HhaI', 'AsiSI', 'AleI', 'NmeAIII', 'BsaAI'],
    )
suppliers['N'] = _temp()

def _temp():
    return (
        'Toyobo Biochemicals',
        ['BssHII', 'MluI', 'HpaII', 'BclI', 'SacI', 'BglI', 'SalI', 'MspI', 'BanII', 'BstEII', 'NcoI', 'Eco47III', 'DraI', 'BstXI', 'Cfr9I', 'AvaI', 'PvuI', 'DpnI', 'BsiWI', 'TaqI', 'Eco52I', 'AseI', 'KpnI', 'Sau96I', 'HaeII', 'Cfr13I', 'MboII', 'TspEI', 'BglII', 'NaeI', 'SacII', 'NruI', 'MvaI', 'CspI', 'NarI', 'Eco47I', 'RsaI', 'HincII', 'XbaI', 'Sau3AI', 'Cfr10I', 'BanIII', 'BanI', 'AluI', 'ScrFI', 'EcoRII', 'MscI', 'Csp45I', 'SmaI', 'NheI', 'BbrPI', 'SphI', 'NciI', 'FspI', 'PvuII', 'EheI', 'Hin1I', 'SpeI', 'HinfI', 'PpuMI', 'EcoRV', 'PsiI', 'AatII', 'EcoRI', 'AatI', 'XhoI', 'SbfI', 'Eco105I', 'PstI', 'BsmI', 'Alw44I', 'SfiI', 'HaeIII', 'AccI', 'SspI', 'SrfI', 'Eco81I', 'ApaI', 'EcoT22I', 'ScaI', 'NspV', 'BfrI', 'PacI', 'DdeI', 'NotI', 'MroI', 'HindIII', 'BamHI', 'HpaI', 'HhaI'],
    )
suppliers['O'] = _temp()

def _temp():
    return (
        'Molecular Biology Resources - CHIMERx',
        ['BssHII', 'MluI', 'HpaII', 'BspTNI', 'SacI', 'BglI', 'SalI', 'MspI', 'BanII', 'NcoI', 'CviJI', 'DraI', 'BstXI', 'AcvI', 'PvuI', 'TaqI', 'SinI', 'KpnI', 'NdeI', 'PinAI', 'MboII', 'BglII', 'SacII', 'NruI', 'NarI', 'TaqII', 'RsaI', 'HincII', 'XbaI', 'MboI', 'AluI', 'RsrII', 'SmaI', 'StuI', 'SphI', 'FokI', 'SpeI', 'HinfI', 'BsiHKCI', 'EcoRV', 'EcoRI', 'XhoI', 'MnlI', 'PstI', 'SfiI', 'HaeIII', 'SspI', 'Tth111I', 'ApaI', 'ScaI', 'NotI', 'HindIII', 'BamHI', 'HpaI'],
    )
suppliers['Q'] = _temp()

def _temp():
    return (
        'Promega Corporation',
        ['BssHII', 'MluI', 'NgoMIV', 'HpaII', 'BclI', 'SacI', 'BglI', 'SalI', 'BstOI', 'MspI', 'BanII', 'SnaBI', 'BstEII', 'NcoI', 'MspA1I', 'ClaI', 'XmnI', 'Eco47III', 'DraI', 'BstXI', 'XmaI', 'AvaI', 'PvuI', 'DpnI', 'BbuI', 'TaqI', 'SinI', 'KpnI', 'HaeII', 'NdeI', 'MboII', 'BglII', 'NaeI', 'SacII', 'Acc65I', 'NruI', 'CspI', 'NarI', 'Bsu36I', 'Bst98I', 'RsaI', 'HincII', 'XbaI', 'BsrSI', 'Sau3AI', 'MboI', 'BanI', 'AluI', 'CfoI', 'Csp45I', 'AccB7I', 'SmaI', 'NheI', 'XhoII', 'StuI', 'SphI', 'NciI', 'PvuII', 'FokI', 'SpeI', 'HinfI', 'SgfI', 'EcoRV', 'AatII', 'EcoRI', 'XhoI', 'Bsp1286I', 'AccIII', 'PstI', 'VspI', 'BstZI', 'Alw44I', 'SfiI', 'Hsp92I', 'HaeIII', 'NdeII', 'AccI', 'SspI', 'Tth111I', 'NsiI', 'ApaI', 'ScaI', 'AgeI', 'BsaMI', 'BalI', 'Tru9I', 'Hsp92II', 'DdeI', 'NotI', 'HindIII', 'EcoICRI', 'BamHI', 'AvaII', 'HpaI', 'StyI', 'HhaI'],
    )
suppliers['R'] = _temp()

def _temp():
    return (
        'Sigma Chemical Corporation',
        ['BssHII', 'MluI', 'HpaII', 'BclI', 'SacI', 'BglI', 'SalI', 'MspI', 'BstEII', 'NcoI', 'ClaI', 'DraI', 'SwaI', 'AvaI', 'PvuI', 'DpnI', 'TaqI', 'KpnI', 'NdeI', 'BglII', 'MvaI', 'RsaI', 'XbaI', 'Sau3AI', 'AluI', 'ScrFI', 'EcoRII', 'CfoI', 'SmaI', 'NheI', 'StuI', 'SphI', 'PvuII', 'SpeI', 'MluNI', 'EcoRV', 'EcoRI', 'XhoI', 'EclXI', 'PstI', 'BsmI', 'SfiI', 'BlnI', 'HaeIII', 'AccI', 'SspI', 'NsiI', 'ApaI', 'ScaI', 'KspI', 'DdeI', 'NotI', 'HindIII', 'BamHI', 'AvaII', 'HpaI', 'StyI', 'HindII'],
    )
suppliers['S'] = _temp()

def _temp():
    return (
        'Bangalore Genei',
        ['MluI', 'HpaII', 'BclI', 'SacI', 'BglI', 'SalI', 'MspI', 'BstEII', 'NcoI', 'ClaI', 'XmnI', 'DraI', 'XmaI', 'AvaI', 'PvuI', 'AssI', 'TaqI', 'KpnI', 'Sau96I', 'BglII', 'NaeI', 'NruI', 'NarI', 'HincII', 'XbaI', 'Sau3AI', 'StrI', 'MboI', 'BanI', 'AluI', 'SmaI', 'BasI', 'NheI', 'StuI', 'PvuII', 'ApaLI', 'SpeI', 'HinfI', 'MvrI', 'EcoRV', 'EcoRI', 'XhoI', 'PstI', 'SfiI', 'HaeIII', 'AccI', 'SspI', 'NsiI', 'ApaI', 'NotI', 'HindIII', 'BamHI', 'HpaI', 'HhaI'],
    )
suppliers['U'] = _temp()

def _temp():
    return (
        'Vivantis Technologies',
        ['BssMI', 'AsuNHI', 'MluI', 'BstHHI', 'HpaII', 'AhlI', 'BglI', 'SalI', 'MspI', 'VneI', 'BstH2I', 'BmtI', 'AsiGI', 'CciNI', 'Sfr274I', 'SmiI', 'Ksp22I', 'BssT1I', 'MspA1I', 'Bsp19I', 'Bse1I', 'AspS9I', 'BmcAI', 'FauNDI', 'DraI', 'Bst2UI', 'Vha464I', 'BstXI', 'BstDEI', 'XmaI', 'BstF5I', 'BpvUI', 'BstMBI', 'BstENI', 'Ama87I', 'BstDSI', 'BstV2I', 'AspLEI', 'Zsp2I', 'DseDI', 'BstAUI', 'Bpu14I', 'TaqI', 'KpnI', 'BstSNI', 'AclI', 'MboII', 'BmrFI', 'BglII', 'AcsI', 'BstNSI', 'BmeRI', 'BseX3I', 'Bpu10I', 'Rsr2I', 'Acc65I', 'BtuMI', 'PspEI', 'Bst2BI', 'SmiMI', 'Bse118I', 'BsnI', 'BmiI', 'BsePI', 'BstMCI', 'Bme18I', 'RsaI', 'BssNAI', 'Bsp13I', 'Bst4CI', 'AsuHPI', 'BtrI', 'XbaI', 'Psp124BI', 'BstX2I', 'AluI', 'ZraI', 'Bse21I', 'Sfr303I', 'BpuMI', 'Bse3DI', 'Bso31I', 'AccB7I', 'AccBSI', 'SmaI', 'AspA2I', 'Bsp1720I', 'SphI', 'FriOI', 'PvuII', 'ErhI', 'BshVI', 'FokI', 'HinfI', 'BstPAI', 'HspAI', 'DraIII', 'Acc16I', 'EcoRV', 'AatII', 'MroXI', 'EcoRI', 'DinI', 'BstFNI', 'AfiI', 'PspOMI', 'MnlI', 'SbfI', 'PstI', 'Bse8I', 'VspI', 'SfiI', 'Bst6I', 'Msp20I', 'Bbv12I', 'SspI', 'Tth111I', 'BstMAI', 'ApaI', 'FblI', 'PctI', 'AccB1I', 'BssNI', 'PceI', 'Sse9I', 'Tru9I', 'MhlI', 'BstBAI', 'MroNI', 'HindIII', 'EcoICRI', 'BamHI', 'SfaNI', 'HpaI', 'PspCI', 'HindII'],
    )
suppliers['V'] = _temp()

def _temp():
    return (
        'MP Biomedicals',
        ['MluI', 'HpaII', 'BclI', 'SacI', 'BglI', 'SalI', 'MspI', 'BanII', 'BstEII', 'NcoI', 'DraII', 'XmnI', 'Eco47III', 'DraI', 'BstXI', 'SwaI', 'AvaI', 'PvuI', 'DpnI', 'TaqI', 'SinI', 'KpnI', 'Sau96I', 'HaeII', 'NdeI', 'MboII', 'BglII', 'SacII', 'Acc65I', 'BspXI', 'NruI', 'MvaI', 'NarI', 'RsaI', 'HincII', 'AflIII', 'XbaI', 'Sau3AI', 'MboI', 'AluI', 'SmaI', 'NheI', 'XhoII', 'SphI', 'NciI', 'PvuII', 'FokI', 'SpeI', 'HinfI', 'DraIII', 'EcoRV', 'EcoRI', 'XhoI', 'MnlI', 'AccIII', 'EagI', 'AscI', 'NlaIII', 'PstI', 'BsmI', 'SfiI', 'HaeIII', 'NdeII', 'AccI', 'SspI', 'Tth111I', 'NsiI', 'PmeI', 'ApaI', 'ScaI', 'PacI', 'NlaIV', 'Tru9I', 'DdeI', 'NotI', 'HindIII', 'BamHI', 'BslI', 'AvaII', 'HpaI', 'HhaI'],
    )
suppliers['W'] = _temp()

def _temp():
    return (
        'EURx Ltd.',
        ['BssHII', 'MluI', 'HpaII', 'BspTNI', 'SacI', 'BglI', 'SalI', 'MspI', 'BanII', 'NcoI', 'CviJI', 'DraI', 'BstXI', 'AcvI', 'AvaI', 'PvuI', 'DpnI', 'TaqI', 'SinI', 'KpnI', 'NdeI', 'PinAI', 'MboII', 'BglII', 'SacII', 'NruI', 'NarI', 'TaqII', 'RsaI', 'HincII', 'XbaI', 'Sau3AI', 'TspGWI', 'MboI', 'AluI', 'RsrII', 'SmaI', 'StuI', 'SphI', 'PvuII', 'FokI', 'SpeI', 'HinfI', 'BsiHKCI', 'EcoRV', 'EcoRI', 'XhoI', 'MnlI', 'PstI', 'SfiI', 'HaeIII', 'AccI', 'SspI', 'Tth111I', 'ApaI', 'MmeI', 'ScaI', 'TspDTI', 'BalI', 'NotI', 'HindIII', 'BamHI', 'BsuTUI', 'HpaI'],
    )
suppliers['X'] = _temp()

def _temp():
    return (
        'CinnaGen Inc.',
        ['BclI', 'BglI', 'SalI', 'MspI', 'NcoI', 'DraI', 'PvuI', 'TaqI', 'KpnI', 'NdeI', 'BglII', 'RsaI', 'HincII', 'XbaI', 'MboI', 'AluI', 'SmaI', 'PvuII', 'HinfI', 'EcoRV', 'EcoRI', 'XhoI', 'PstI', 'HaeIII', 'NotI', 'HindIII', 'BamHI', 'AvaII', 'HhaI'],
    )
suppliers['Y'] = _temp()

typedict = {}
def _temp():
    return (
        ('NonPalindromic', 'NoCut', 'Unknown', 'NotDefined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['BscGI', 'AspCNI'],
    )
typedict['type146'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'NoCut', 'Unknown', 'NotDefined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['SpoDI', 'UbaF14I', 'EsaSSI', 'UbaPI', 'CjuII', 'AlwFI', 'BspGI', 'CjuI', 'MjaIV', 'Pfl1108I', 'AvaIII', 'UbaF13I', 'TssI', 'UbaF12I', 'DrdII', 'NhaXI', 'BspNCI', 'TsuI', 'UbaF9I', 'FinI', 'UbaF11I', 'CjeNII', 'BmgI', 'SnaI', 'HgiEII'],
    )
typedict['type148'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['MlyI', 'BmgBI', 'SnaBI', 'MspA1I', 'CviJI', 'BsrBI', 'DraI', 'PshAI', 'SwaI', 'NaeI', 'PhoI', 'SfoI', 'RsaI', 'HincII', 'AluI', 'Hpy8I', 'SmaI', 'FspI', 'PvuII', 'BsuRI', 'EcoRV', 'BstUI', 'HaeIII', 'SspI', 'ScaI', 'BalI', 'NlaIV', 'HpaI', 'Cac8I', 'HindII', 'BsaAI'],
    )
typedict['type209'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['FnuDII', 'EsaBC3I', 'CviRI'],
    )
typedict['type210'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['PspN4I', 'MslI', 'Bsp68I', 'PmaCI', 'BsaBI', 'SmiI', 'BseJI', 'BshFI', 'BmcAI', 'XmnI', 'Eco47III', 'Hpy166II', 'AluBI', 'AcvI', 'RruI', 'EgeI', 'RseI', 'DpnI', 'AssI', 'Bst1107I', 'BstSNI', 'MlsI', 'SchI', 'AccII', 'BtuMI', 'Aor51HI', 'NruI', 'SmiMI', 'Bsh1236I', 'MalI', 'MssI', 'BsnI', 'FspAI', 'BmiI', 'BoxI', 'BssNAI', 'BtrI', 'BstC8I', 'AjiI', 'PmlI', 'GlaI', 'MvnI', 'ZraI', 'Eco72I', 'MscI', 'SseBI', 'AccBSI', 'Ppu21I', 'StuI', 'BbrPI', 'Eco53kI', 'EheI', 'BstPAI', 'Ecl136II', 'Acc16I', 'MluNI', 'PsiI', 'MroXI', 'AatI', 'ZrmI', 'DinI', 'BstFNI', 'BspLI', 'Eco105I', 'NsbI', 'Bse8I', 'BspFNI', 'BstZ17I', 'Msp20I', 'AfeI', 'SrfI', 'Eco32I', 'KspAI', 'AanI', 'PmeI', 'FaiI', 'Eco147I', 'CviKI_1', 'OliI', 'PdmI', 'HpyCH4V', 'PceI', 'BstBAI', 'AfaI', 'MbiI', 'Asp700I', 'EcoICRI', 'AviII', 'PspCI', 'PdiI', 'AleI'],
    )
typedict['type211'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['CdiI', 'HaeI', 'SciI', 'NspBII', 'SspD5I', 'LpnI', 'AhaIII', 'Sth302II', 'MstI'],
    )
typedict['type212'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['BssHII', 'BsrFI', 'DpnII', 'MluI', 'NgoMIV', 'HpaII', 'TspMI', 'BclI', 'BsaWI', 'SalI', 'MspI', 'Bsu15I', 'NcoI', 'ClaI', 'XmaI', 'Cfr9I', 'TaqI', 'EaeI', 'AseI', 'Kpn2I', 'AclI', 'ApoI', 'HpyCH4IV', 'NdeI', 'HapII', 'BglII', 'BsaHI', 'XbaI', 'Sau3AI', 'Cfr10I', 'MboI', 'AciI', 'CviQI', 'XhoII', 'CviAII', 'MfeI', 'BssSI', 'ApaLI', 'HinP1I', 'HspAI', 'EcoRI', 'XhoI', 'BseCI', 'CfrI', 'MunI', 'EagI', 'AscI', 'Tsp509I', 'MseI', 'VspI', 'KasI', 'SgrAI', 'BspHI', 'BstYI', 'AgeI', 'Sse9I', 'NotI', 'HindIII', 'FatI', 'BamHI', 'PaeR7I', 'BbvCI'],
    )
typedict['type221'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['XmaIII'],
    )
typedict['type222'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['BssMI', 'AsuNHI', 'CciI', 'PscI', 'MreI', 'AhlI', 'XspI', 'BfaI', 'PauI', 'Asp718I', 'VneI', 'PspXI', 'AsiGI', 'CciNI', 'Sfr274I', 'PteI', 'XmaCI', 'Ksp22I', 'BshTI', 'Bsp19I', 'MauBI', 'AbsI', 'AsuII', 'FauNDI', 'Vha464I', 'BstACI', 'BspACI', 'AcoI', 'BstMBI', 'BssAI', 'BseAI', 'Hin6I', 'PalAI', 'BstAUI', 'BsiWI', 'Bpu14I', 'Eco52I', 'BspT104I', 'SspDI', 'SsiI', 'PinAI', 'AflII', 'TspEI', 'AcsI', 'BseX3I', 'FspBI', 'RsaNI', 'Acc65I', 'AvrII', 'MaeI', 'XapI', 'BspXI', 'Bsp1407I', 'Bst2BI', 'PciI', 'Bse118I', 'SlaI', 'TliI', 'NarI', 'BsePI', 'Bst98I', 'MaeII', 'Bsp13I', 'BsiSI', 'StrI', 'Bsp119I', 'BanIII', 'BstX2I', 'SgsI', 'BseYI', 'Csp45I', 'PsuI', 'NheI', 'AspA2I', 'BcuI', 'BspTI', 'Mly113I', 'MflI', 'BshVI', 'Hin1I', 'SpeI', 'SgrDI', 'XmaJI', 'MspCI', 'Psp1406I', 'Kzo9I', 'Csp6I', 'Bsp143I', 'PspOMI', 'Bsa29I', 'AccIII', 'Tru1I', 'Aor13HI', 'EclXI', 'BspEI', 'BstZI', 'Alw44I', 'Hsp92I', 'PspLI', 'BlnI', 'NdeII', 'BsrGI', 'CspAI', 'FbaI', 'BauI', 'SaqAI', 'PshBI', 'SfuI', 'NspV', 'BfuCI', 'BfrI', 'BstBI', 'BssNI', 'Tru9I', 'Bsp120I', 'MroI', 'MroNI', 'AcyI', 'RcaI', 'BsuTUI', 'BspDI', 'BstAFI', 'TatI', 'Pfl23II', 'PagI'],
    )
typedict['type223'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['SelI', 'BspLU11I', 'SimI', 'Asi256I', 'Ppu10I', 'Sse232I', 'BetI', 'SplI', 'GdiII', 'BsiI', 'BspMII'],
    )
typedict['type224'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['AlwI', 'PspPI', 'StyD4I', 'PspGI', 'BlpI', 'Esp3I', 'AvaI', 'SexAI', 'SinI', 'Sau96I', 'BstNI', 'Cfr13I', 'TseI', 'Bpu10I', 'MvaI', 'BssKI', 'AflIII', 'Lsp1109I', 'BfuAI', 'TfiI', 'BbvI', 'HgaI', 'BanI', 'RsrII', 'BspMI', 'BcnI', 'ScrFI', 'EcoRII', 'FokI', 'Alw26I', 'ApeKI', 'Eco31I', 'HinfI', 'BceAI', 'Fsp4HI', 'BsmAI', 'EcoO109I', 'PpuMI', 'BsmFI', 'BsoBI', 'BsmBI', 'AccI', 'Tth111I', 'DdeI', 'AvaII', 'BsaJI', 'Fnu4HI', 'Tsp45I'],
    )
typedict['type225'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['StsI', 'HgiCI', 'EcoHI'],
    )
typedict['type226'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['AxyI', 'BstSFI', 'CseI', 'SanDI', 'BspTNI', 'BspT107I', 'BstOI', 'BisI', 'BstPI', 'LweI', 'BstEII', 'BmgT120I', 'BssT1I', 'PsyI', 'BtgI', 'AspS9I', 'BsaI', 'DraII', 'AclWI', 'Eco91I', 'Bst2UI', 'BseXI', 'BstDEI', 'GluI', 'BstENI', 'BssECI', 'Ama87I', 'BstDSI', 'BstV2I', 'AarI', 'AjnI', 'PflFI', 'Bme1390I', 'BveI', 'Psp5II', 'EcoO65I', 'BmrFI', 'EcoT14I', 'BmsI', 'PspPPI', 'SmlI', 'BseBI', 'PfoI', 'BshNI', 'Rsr2I', 'BspQI', 'BmeT110I', 'PspEI', 'AspI', 'BpuAI', 'PasI', 'CpoI', 'Eco130I', 'CspI', 'BfmI', 'Eco47I', 'Bsu36I', 'Bme18I', 'BstV1I', 'MabI', 'Hpy188III', 'Bse21I', 'BstSCI', 'BpuMI', 'XagI', 'Bso31I', 'PleI', 'EcoNI', 'BccI', 'SmoI', 'FaqI', 'Bsp1720I', 'NciI', 'MaeIII', 'ErhI', 'AsuC2I', 'PpsI', 'BsiHKCI', 'XmiI', 'Eam1104I', 'Acc36I', 'MspR9I', 'SapI', 'VpaK11BI', 'BspPI', 'BslFI', 'PfeI', 'Bpu1102I', 'SmuI', 'FauI', 'SfcI', 'LguI', 'PciSI', 'Bst6I', 'BpiI', 'SatI', 'KflI', 'BseDI', 'Eco81I', 'ItaI', 'BstMAI', 'Eco88I', 'FblI', 'BtgZI', 'EarI', 'AccB1I', 'CsiI', 'BbsI', 'Psp6I', 'CelII', 'SfaNI', 'HpyF3I', 'StyI', 'NmuCI'],
    )
typedict['type227'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['DsaI', 'SauI', 'Sth132I', 'UnbI', 'BbvII', 'VpaK11AI', 'BinI', 'Bbr7I', 'SfeI', 'CauII', 'BscAI', 'Hpy178III', 'BspD6I', 'BcefI', 'AceIII', 'Ksp632I', 'AsuI', 'SecI', 'EspI', 'Sse8647I'],
    )
typedict['type228'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['SacI', 'BmtI', 'KpnI', 'HaeII', 'SacII', 'NlaIII', 'PstI', 'Cfr42I', 'FseI', 'ApaI', 'NspI', 'HhaI', 'AsiSI'],
    )
typedict['type233'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['PabI', 'McaTI'],
    )
typedict['type234'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['SgrBI', 'BstHHI', 'BstH2I', 'BpvUI', 'SstII', 'PvuI', 'BspOI', 'BbuI', 'AspLEI', 'Zsp2I', 'FaeI', 'SdaI', 'BstNSI', 'Ple19I', 'Hin1II', 'Sse8387I', 'TaiI', 'Psp124BI', 'Sfr303I', 'Mph1103I', 'CfoI', 'PaeI', 'BstKTI', 'SphI', 'SstI', 'GsaI', 'MvrI', 'SfaAI', 'RgaI', 'BbeI', 'SgfI', 'AatII', 'SbfI', 'XceI', 'NsiI', 'EcoT22I', 'PacI', 'KspI', 'Hsp92II', 'BfoI', 'RigI'],
    )
typedict['type235'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['ChaI'],
    )
typedict['type236'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['MwoI', 'EcoT38I', 'BglI', 'BanII', 'TspRI', 'Hpy99I', 'BsiHKAI', 'BstF5I', 'BsrI', 'BfiI', 'MboII', 'BmrI', 'Hpy188I', 'Bsc4I', 'BspCNI', 'HpyAV', 'HphI', 'DraIII', 'Bsp1286I', 'MnlI', 'SfiI', 'XcmI', 'MmeI', 'Eco57I', 'BslI'],
    )
typedict['type237'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['BthCI'],
    )
typedict['type238'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['EciI', 'AgsI', 'DrdI', 'Mva1269I', 'TscAI', 'Bse1I', 'BstMWI', 'Eco24I', 'AlwNI', 'BstXI', 'BseSI', 'BpuEI', 'Van91I', 'DseDI', 'SetI', 'BmeRI', 'TaaI', 'BtsCI', 'BstMCI', 'TaqII', 'HpyF10VI', 'Bst4CI', 'AsuHPI', 'AspEI', 'BsgI', 'BsrSI', 'TspGWI', 'BaeGI', 'SduI', 'BseGI', 'Alw21I', 'Bse3DI', 'AccB7I', 'BasI', 'AdeI', 'BsiEI', 'GsuI', 'BseLI', 'FriOI', 'AasI', 'BsrDI', 'BciVI', 'Eam1105I', 'TsoI', 'BseMII', 'BtsI', 'BfuI', 'TauI', 'AfiI', 'CaiI', 'AhdI', 'BsmI', 'Bbv12I', 'BseMI', 'Eco57MI', 'BstAPI', 'HpyCH4III', 'BstSLI', 'BlsI', 'BseRI', 'TspDTI', 'BmuI', 'PctI', 'BpmI', 'BsaMI', 'AcuI', 'MhlI', 'DriI', 'Bsh1285I', 'PflMI', 'BseNI', 'NmeAIII'],
    )
typedict['type239'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['Nli3877I', 'Bce83I', 'SdeAI', 'Psp03I', 'RceI', 'DraRI', 'BsiYI', 'ApaBI', 'Tsp4CI', 'Hin4II', 'CstMI', 'PspOMII', 'DrdIV', 'PlaDI', 'FmuI', 'RpaB5I', 'McrI', 'MaqI', 'CdpI', 'Tth111II', 'HgiJII', 'BsbI', 'NlaCI', 'AquII', 'AquIV', 'ApyPI', 'PspPRI', 'AquIII', 'PssI', 'HgiAI', 'RleAI'],
    )
typedict['type240'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['NmeDI'],
    )
typedict['type274'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['AloI', 'BcgI'],
    )
typedict['type285'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['TstI', 'PsrI', 'FalI', 'CspCI', 'PpiI', 'AjuI', 'BaeI', 'BdaI', 'ArsI', 'BplI', 'Hin4I', 'AlfI', 'BarI', 'BsaXI'],
    )
typedict['type287'] = _temp()

def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['CjeI', 'CjePI', 'NgoAVIII', 'Bsp24I', 'SdeOSI'],
    )
typedict['type288'] = _temp()

del _temp

