# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DataLakeStoreAccountProperties(Model):
    """Data Lake Store account properties information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provisioning_state: the status of the Data Lake Store account while
     being provisioned. Possible values include: 'Failed', 'Creating',
     'Running', 'Succeeded', 'Patching', 'Suspending', 'Resuming',
     'Deleting', 'Deleted'
    :vartype provisioning_state: str or :class:`DataLakeStoreAccountStatus
     <azure.mgmt.datalake.store.account.models.DataLakeStoreAccountStatus>`
    :ivar state: the status of the Data Lake Store account after provisioning
     has completed. Possible values include: 'active', 'suspended'
    :vartype state: str or :class:`DataLakeStoreAccountState
     <azure.mgmt.datalake.store.account.models.DataLakeStoreAccountState>`
    :ivar creation_time: the account creation time.
    :vartype creation_time: datetime
    :ivar encryption_state: The current state of encryption for this Data
     Lake store account. Possible values include: 'Enabled', 'Disabled'
    :vartype encryption_state: str or :class:`EncryptionState
     <azure.mgmt.datalake.store.account.models.EncryptionState>`
    :ivar encryption_provisioning_state: The current state of encryption
     provisioning for this Data Lake store account. Possible values include:
     'Creating', 'Succeeded'
    :vartype encryption_provisioning_state: str or
     :class:`EncryptionProvisioningState
     <azure.mgmt.datalake.store.account.models.EncryptionProvisioningState>`
    :param encryption_config: The Key vault encryption configuration.
    :type encryption_config: :class:`EncryptionConfig
     <azure.mgmt.datalake.store.account.models.EncryptionConfig>`
    :ivar last_modified_time: the account last modified time.
    :vartype last_modified_time: datetime
    :param endpoint: the gateway host.
    :type endpoint: str
    :param default_group: the default owner group for all new folders and
     files created in the Data Lake Store account.
    :type default_group: str
    """ 

    _validation = {
        'provisioning_state': {'readonly': True},
        'state': {'readonly': True},
        'creation_time': {'readonly': True},
        'encryption_state': {'readonly': True},
        'encryption_provisioning_state': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'DataLakeStoreAccountStatus'},
        'state': {'key': 'state', 'type': 'DataLakeStoreAccountState'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'encryption_state': {'key': 'encryptionState', 'type': 'EncryptionState'},
        'encryption_provisioning_state': {'key': 'encryptionProvisioningState', 'type': 'EncryptionProvisioningState'},
        'encryption_config': {'key': 'encryptionConfig', 'type': 'EncryptionConfig'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'default_group': {'key': 'defaultGroup', 'type': 'str'},
    }

    def __init__(self, encryption_config=None, endpoint=None, default_group=None):
        self.provisioning_state = None
        self.state = None
        self.creation_time = None
        self.encryption_state = None
        self.encryption_provisioning_state = None
        self.encryption_config = encryption_config
        self.last_modified_time = None
        self.endpoint = endpoint
        self.default_group = default_group
