# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class CertificateOrder(Resource):
    """Certificate purchase order.

    :param id: Resource Id
    :type id: str
    :param name: Resource Name
    :type name: str
    :param kind: Kind of resource
    :type kind: str
    :param location: Resource Location
    :type location: str
    :param type: Resource type
    :type type: str
    :param tags: Resource tags
    :type tags: dict
    :param certificates: State of the Key Vault secret
    :type certificates: dict
    :param distinguished_name: Certificate distinguished name
    :type distinguished_name: str
    :param domain_verification_token: Domain Verification Token
    :type domain_verification_token: str
    :param validity_in_years: Duration in years (must be between 1 and 3)
    :type validity_in_years: int
    :param key_size: Certificate Key Size
    :type key_size: int
    :param product_type: Certificate product type. Possible values include:
     'StandardDomainValidatedSsl', 'StandardDomainValidatedWildCardSsl'
    :type product_type: str or :class:`CertificateProductType
     <azure.mgmt.web.models.CertificateProductType>`
    :param auto_renew: Auto renew
    :type auto_renew: bool
    :param provisioning_state: Status of certificate order. Possible values
     include: 'Succeeded', 'Failed', 'Canceled', 'InProgress', 'Deleting'
    :type provisioning_state: str or :class:`ProvisioningState
     <azure.mgmt.web.models.ProvisioningState>`
    :param status: Current order status. Possible values include:
     'Pendingissuance', 'Issued', 'Revoked', 'Canceled', 'Denied',
     'Pendingrevocation', 'PendingRekey', 'Unused', 'Expired', 'NotSubmitted'
    :type status: str or :class:`CertificateOrderStatus
     <azure.mgmt.web.models.CertificateOrderStatus>`
    :param signed_certificate: Signed certificate
    :type signed_certificate: :class:`CertificateDetails
     <azure.mgmt.web.models.CertificateDetails>`
    :param csr: Last CSR that was created for this order
    :type csr: str
    :param intermediate: Intermediate certificate
    :type intermediate: :class:`CertificateDetails
     <azure.mgmt.web.models.CertificateDetails>`
    :param root: Root certificate
    :type root: :class:`CertificateDetails
     <azure.mgmt.web.models.CertificateDetails>`
    :param serial_number: Current serial number of the certificate
    :type serial_number: str
    :param last_certificate_issuance_time: Certificate last issuance time
    :type last_certificate_issuance_time: datetime
    :param expiration_time: Certificate expiration time
    :type expiration_time: datetime
    """ 

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'certificates': {'key': 'properties.certificates', 'type': '{CertificateOrderCertificate}'},
        'distinguished_name': {'key': 'properties.distinguishedName', 'type': 'str'},
        'domain_verification_token': {'key': 'properties.domainVerificationToken', 'type': 'str'},
        'validity_in_years': {'key': 'properties.validityInYears', 'type': 'int'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'product_type': {'key': 'properties.productType', 'type': 'CertificateProductType'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
        'status': {'key': 'properties.status', 'type': 'CertificateOrderStatus'},
        'signed_certificate': {'key': 'properties.signedCertificate', 'type': 'CertificateDetails'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'intermediate': {'key': 'properties.intermediate', 'type': 'CertificateDetails'},
        'root': {'key': 'properties.root', 'type': 'CertificateDetails'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'last_certificate_issuance_time': {'key': 'properties.lastCertificateIssuanceTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
    }

    def __init__(self, location, id=None, name=None, kind=None, type=None, tags=None, certificates=None, distinguished_name=None, domain_verification_token=None, validity_in_years=None, key_size=None, product_type=None, auto_renew=None, provisioning_state=None, status=None, signed_certificate=None, csr=None, intermediate=None, root=None, serial_number=None, last_certificate_issuance_time=None, expiration_time=None):
        super(CertificateOrder, self).__init__(id=id, name=name, kind=kind, location=location, type=type, tags=tags)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = domain_verification_token
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = provisioning_state
        self.status = status
        self.signed_certificate = signed_certificate
        self.csr = csr
        self.intermediate = intermediate
        self.root = root
        self.serial_number = serial_number
        self.last_certificate_issuance_time = last_certificate_issuance_time
        self.expiration_time = expiration_time
