# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SharedAccessAuthorizationRule(Model):
    """SharedAccessAuthorizationRule.

    :param key_name: The key name.
    :type key_name: str
    :param primary_key: The primary key.
    :type primary_key: str
    :param issuer_name: The issuer name.
    :type issuer_name: str
    :param secondary_key: The secondary key.
    :type secondary_key: str
    :param claim_type: The claim type.
    :type claim_type: str
    :param claim_value: The claim value.
    :type claim_value: str
    :param rights: The rights.
    :type rights: list of str or :class:`SBAccessRights
     <azure.mgmt.iothub.models.SBAccessRights>`
    :param created_time: The created time.
    :type created_time: datetime
    :param modified_time: The modified time.
    :type modified_time: datetime
    :param revision: The revision.
    :type revision: long
    """ 

    _attribute_map = {
        'key_name': {'key': 'KeyName', 'type': 'str'},
        'primary_key': {'key': 'PrimaryKey', 'type': 'str'},
        'issuer_name': {'key': 'IssuerName', 'type': 'str'},
        'secondary_key': {'key': 'SecondaryKey', 'type': 'str'},
        'claim_type': {'key': 'ClaimType', 'type': 'str'},
        'claim_value': {'key': 'ClaimValue', 'type': 'str'},
        'rights': {'key': 'Rights', 'type': '[SBAccessRights]'},
        'created_time': {'key': 'CreatedTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'ModifiedTime', 'type': 'iso-8601'},
        'revision': {'key': 'Revision', 'type': 'long'},
    }

    def __init__(self, key_name=None, primary_key=None, issuer_name=None, secondary_key=None, claim_type=None, claim_value=None, rights=None, created_time=None, modified_time=None, revision=None):
        self.key_name = key_name
        self.primary_key = primary_key
        self.issuer_name = issuer_name
        self.secondary_key = secondary_key
        self.claim_type = claim_type
        self.claim_value = claim_value
        self.rights = rights
        self.created_time = created_time
        self.modified_time = modified_time
        self.revision = revision
