

import test_helper

from Ft.Server.Common import DocumentReference, ResourceTypes

def test_create_raw_file(tester):

    sty = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:fcore='http://xmlns.4suite.org/4ss/score'
  extension-element-prefixes="fcore"
  >
  <xsl:output method='xml'/>
  <xsl:template match="/">
    <bar>Foo</bar>
    <fcore:create-raw-file path='rf1' imt='text/jpg'>
      <xsl:text>RAW</xsl:text>
    </fcore:create-raw-file>
  </xsl:template>
</xsl:stylesheet>"""

    expected = """<?xml version='1.0' encoding='UTF-8'?>\n<bar>Foo</bar>"""

    tester.startTest("XSLT Extension Create Raw File")

    repo = test_helper.GetRepo(tester)

    test = repo.fetchResource('test')
    test_helper.TestXslt(tester,test,sty,expected)
    tester.compare(ResourceTypes.ResourceType.RAW_FILE,test.hasResource('rf1'))
    tester.compare('text/jpg',test.fetchResource('rf1').getImt())
    repo.txCommit()

    tester.testDone()


def test_create_document(tester):

    sty = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:fcore='http://xmlns.4suite.org/4ss/score'
  extension-element-prefixes="fcore"
  >
  <xsl:output method='xml'/>
  <xsl:template match="/">
    <bar>Foo</bar>
    <fcore:create-document path='doc1'>
      <foo/>
    </fcore:create-document>
  </xsl:template>
</xsl:stylesheet>"""

    expected = """<?xml version='1.0' encoding='UTF-8'?>\n<bar>Foo</bar>"""

    tester.startTest("XSLT Extension Create Document")

    repo = test_helper.GetRepo(tester)

    test = repo.fetchResource('test')
    test_helper.TestXslt(tester,test,sty,expected)
    tester.compare(ResourceTypes.ResourceType.XML_DOCUMENT,test.hasResource('doc1'))
    repo.txCommit()

    tester.testDone()

def test_has_resource(tester):

    sty = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:fcore='http://xmlns.4suite.org/4ss/score'
  extension-element-prefixes="fcore"
  >
  <xsl:output method='text'/>
  <xsl:template match="/">
    <xsl:value-of select='fcore:has-resource("/test")'/>
  </xsl:template>
</xsl:stylesheet>"""

    expected = """%d""" % ResourceTypes.ResourceType.CONTAINER

    tester.startTest("XSLT Extension Has Resource")

    repo = test_helper.GetRepo(tester)

    test = repo.fetchResource('test')
    test_helper.TestXslt(tester,test,sty,expected)
    repo.txCommit()

    tester.testDone()




def cleanup(tester):

    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    
    repo.createContainer('test')
    repo.txCommit()
    tester.testDone()




def Test(tester):


    cleanup(tester)
    test_create_raw_file(tester)
    test_create_document(tester)
    test_has_resource(tester)
