########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Xml/MessageSource.py,v 1.10 2005/04/12 06:41:35 mbrown Exp $
"""
Localizable message strings

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft import TranslateMessage as _
from Ft.Xml import ReaderException, XIncludeException

XINCLUDE = {
    XIncludeException.MISSING_HREF : _('Missing or empty href attribute'),
    XIncludeException.INVALID_PARSE_ATTR : _("Invalid value %r for parse attribute"),
    }

READER = {
    ReaderException.XML_PARSE_ERROR: _('XML parse error in %r at line %d, column %d: %s'),
    ReaderException.RECURSIVE_PARSE_ERROR: _('Recursive parsing of %r'),
    ReaderException.XMLNS_UNKNOWN_PREFIX: _('Unknown namespace prefix found while parsing XML file: %s'),
    ReaderException.XMLNS_DUPLICATE_ATTRS: _('Element %r has duplicate attributes: %r and %r'),
    ReaderException.INVALID_XMLNS: _('Invalid xmlns found parsing XML file: %s'),
    }

