########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Share/Demos/Cribbage/CribbageXsltExtensions.py,v 1.5 2005/04/06 23:05:47 jkloth Exp $
"""
XSLT extension elements for the Cribbage demo

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft.Xml.XPath import Conversions
from Ft.Xml.Xslt import XsltElement, AttributeValueTemplate
from Ft.Xml.Xslt import ContentInfo, AttributeInfo

CARD_EXTENSION_NAMESPACE = u"http://xmlns.4suite.org/demos/cards"

class DrawCribbageBoard(XsltElement):

    content = ContentInfo.Empty

    legalAttrs = {
        'p1-scores' : AttributeInfo.NodeSetExpression(required=1,
                                                     description='Player Ones scores'),
        'p2-scores' : AttributeInfo.NodeSetExpression(required=1,
                                                     description='Player Twos scores'),
        }

    def instantiate(self, context, processor):

        context.setProcessState(self)

        p1Scores = self._p1_scores.evaluate(context)
        p1LastScore = reduce(lambda x,y,f=Conversions.NumberValue:x + f(y),p1Scores[:-1],0)
        p1Score = p1LastScore + Conversions.NumberValue(p1Scores[-1])

        p2Scores = self._p2_scores.evaluate(context)
        p2LastScore = reduce(lambda x,y,f=Conversions.NumberValue:x + f(y),p2Scores[:-1],0)
        p2Score = p2LastScore + Conversions.NumberValue(p2Scores[-1])


        w = processor.writers[-1]

        #Draw the top boarder
        w.startElement(u'TR')
        self.__drawTd(w, u'/images/cards/Cribbage/top-left-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/top-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/top-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/top-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/top-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/top-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/top-right-border.gif')
        w.endElement(u'TR')

        #Draw the first start row
        w.startElement(u'TR')
        self.__drawTd(w, u'/images/cards/Cribbage/left-border.gif')
        if not p1LastScore:
            self.__drawTd(w, u'/images/cards/Cribbage/red-starter-filled.gif',colspan=u'2',width=u'40')
        else:
            self.__drawTd(w, u'/images/cards/Cribbage/red-starter-empty.gif',colspan=u'2',width=u'40')
        self.__drawTd(w, u'/images/cards/Cribbage/blank-board.gif')
        if not p2LastScore:
            self.__drawTd(w, u'/images/cards/Cribbage/blue-starter-filled.gif',colspan=u'2',width=u'40')
        else:
            self.__drawTd(w, u'/images/cards/Cribbage/blue-starter-empty.gif',colspan=u'2',width=u'40')
        self.__drawTd(w, u'/images/cards/Cribbage/right-border.gif')
        w.endElement(u'TR')

        #Draw the second start row
        w.startElement(u'TR')
        self.__drawTd(w, u'/images/cards/Cribbage/left-border.gif')
        if not p1Score or p1Score > 120:
            self.__drawTd(w, u'/images/cards/Cribbage/red-starter-filled.gif',colspan=u'2',width=u'40')
        else:
            self.__drawTd(w, u'/images/cards/Cribbage/red-starter-empty.gif',colspan=u'2',width=u'40')
        self.__drawTd(w, u'/images/cards/Cribbage/blank-board.gif')
        if not p2Score or p2Score > 120:
            self.__drawTd(w, u'/images/cards/Cribbage/blue-starter-filled.gif',colspan=u'2',width=u'40')
        else:
            self.__drawTd(w, u'/images/cards/Cribbage/blue-starter-empty.gif',colspan=u'2',width=u'40')
        self.__drawTd(w, u'/images/cards/Cribbage/right-border.gif')
        w.endElement(u'TR')


        p1Col, p1Row = self.p1ScoreMap.get(p1Score, (-1, -1))
        p1LastCol, p1LastRow = self.p1ScoreMap.get(p1LastScore, (-1, -1))
        p2Col, p2Row = self.p2ScoreMap.get(p2Score,(-1,-1))
        p2LastCol, p2LastRow = self.p2ScoreMap.get(p2LastScore, (-1, -1))

        for ctr in range(30):
            #Draw the board
            w.startElement(u'TR')
            self.__drawTd(w, u'/images/cards/Cribbage/left-border.gif')


            if not p1Col and p1Row == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/red-filled.gif')
            elif not p1LastCol and p1LastRow == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/red-filled.gif')
            else:
                self.__drawTd(w, u'/images/cards/Cribbage/red-empty.gif')

            if p1Col and p1Row == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/red-filled.gif')
            elif p1LastCol and p1LastRow == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/red-filled.gif')
            else:
                self.__drawTd(w, u'/images/cards/Cribbage/red-empty.gif')

            self.__drawTd(w, u'/images/cards/Cribbage/center-border.gif')

            if not p2Col and p2Row == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/blue-filled.gif')
            elif not p2LastCol and p2LastRow == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/blue-filled.gif')
            else:
                self.__drawTd(w, u'/images/cards/Cribbage/blue-empty.gif')

            if p2Col and p2Row == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/blue-filled.gif')
            elif p2LastCol and p2LastRow == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/blue-filled.gif')
            else:
                self.__drawTd(w, u'/images/cards/Cribbage/blue-empty.gif')

            self.__drawTd(w, u'/images/cards/Cribbage/right-border.gif')
            w.endElement(u'TR')

            if not (ctr+1) % 5:
                w.startElement(u'TR')
                self.__drawTd(w, u'/images/cards/Cribbage/left-border.gif',height=u'8')
                self.__drawTd(w, u'/images/cards/Cribbage/spacer-border.gif',height=u'8')
                self.__drawTd(w, u'/images/cards/Cribbage/spacer-border.gif',height=u'8')
                self.__drawTd(w, u'/images/cards/Cribbage/center-border.gif',height=u'8')
                self.__drawTd(w, u'/images/cards/Cribbage/spacer-border.gif',height=u'8')
                self.__drawTd(w, u'/images/cards/Cribbage/spacer-border.gif',height=u'8')
                self.__drawTd(w, u'/images/cards/Cribbage/right-border.gif',height=u'8')
                w.endElement(u'TR')

        #Draw the bottom boarder
        w.startElement(u'TR')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-left-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-right-border.gif')
        w.endElement(u'TR')

        return

    def __drawTd(self, w, img, width=u'20', height=u'16', colspan=u''):
        w.startElement(u'TD')
        #w.attribute(u'width',width)
        #w.attribute(u'height',height)
        if colspan:
            w.attribute(u'colspan', colspan)
        w.startElement(u'IMG')
        w.attribute(u'SRC',img)
        w.attribute(u'width',width)
        w.attribute(u'height',height)
        w.endElement(u'IMG')
        w.endElement(u'TD')



    p1ScoreMap = {}
    p2ScoreMap = {}

    for ctr in range(30):
        p1ScoreMap[ctr+1] = (0,ctr)
        p1ScoreMap[60 -ctr] = (1,ctr)
        p1ScoreMap[ctr+61] = (0,ctr)
        p1ScoreMap[120 -ctr] = (1,ctr)

    for ctr in range(30):
        p2ScoreMap[ctr+1] = (1,ctr)
        p2ScoreMap[60 -ctr] = (0,ctr)
        p2ScoreMap[ctr+61] = (1,ctr)
        p2ScoreMap[120 -ctr] = (0,ctr)


class CountHand(XsltElement):

    content = ContentInfo.Empty

    legalAttrs = {
        'card1' : AttributeInfo.Expression(required=1,
                                          description='First card'),
        'card2' : AttributeInfo.Expression(required=1,
                                          description='Second card'),
        'card3' : AttributeInfo.Expression(required=1,
                                          description='Third card'),
        'card4' : AttributeInfo.Expression(required=1,
                                          description='Fourth card'),
        'draw' : AttributeInfo.Expression(required=1,
                                          description='Fifth card'),
        }

    def instantiate(self, context, processor):

        context.setProcessState(self)

        p1Score = Conversions.NumberValue(self._p1_score.evaluate(context))
        p1LastScore = Conversions.NumberValue(self._p1_last_score.evaluate(context))
        p2Score = Conversions.NumberValue(self._p2_score.evaluate(context))
        p2LastScore = Conversions.NumberValue(self._p2_last_score.evaluate(context))


        w = processor.writers[-1]

        #Draw the top boarder
        w.startElement(u'TR')
        self.__drawTd(w, u'/images/cards/Cribbage/top-left-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/top-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/top-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/top-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/top-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/top-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/top-right-border.gif')
        w.endElement(u'TR')

        #Draw the first start row
        w.startElement(u'TR')
        self.__drawTd(w, u'/images/cards/Cribbage/left-border.gif')
        if not p1LastScore:
            self.__drawTd(w, u'/images/cards/Cribbage/red-starter-filled.gif',colspan=u'2',width=u'40')
        else:
            self.__drawTd(w, u'/images/cards/Cribbage/red-starter-empty.gif',colspan=u'2',width=u'40')
        self.__drawTd(w, u'/images/cards/Cribbage/blank-board.gif')
        if not p2LastScore:
            self.__drawTd(w, u'/images/cards/Cribbage/blue-starter-filled.gif',colspan=u'2',width=u'40')
        else:
            self.__drawTd(w, u'/images/cards/Cribbage/blue-starter-empty.gif',colspan=u'2',width=u'40')
        self.__drawTd(w, u'/images/cards/Cribbage/right-border.gif')
        w.endElement(u'TR')

        #Draw the second start row
        w.startElement(u'TR')
        self.__drawTd(w, u'/images/cards/Cribbage/left-border.gif')
        if not p1Score or p1Score > 120:
            self.__drawTd(w, u'/images/cards/Cribbage/red-starter-filled.gif',colspan=u'2',width=u'40')
        else:
            self.__drawTd(w, u'/images/cards/Cribbage/red-starter-empty.gif',colspan=u'2',width=u'40')
        self.__drawTd(w, u'/images/cards/Cribbage/blank-board.gif')
        if not p2Score or p2Score > 120:
            self.__drawTd(w, u'/images/cards/Cribbage/blue-starter-filled.gif',colspan=u'2',width=u'40')
        else:
            self.__drawTd(w, u'/images/cards/Cribbage/blue-starter-empty.gif',colspan=u'2',width=u'40')
        self.__drawTd(w, u'/images/cards/Cribbage/right-border.gif')
        w.endElement(u'TR')


        p1Col,p1Row = self.p1ScoreMap.get(p1Score,(-1,-1))
        p1LastCol,p1LastRow = self.p1ScoreMap.get(p1LastScore,(-1,-1))
        p2Col,p2Row = self.p2ScoreMap.get(p2Score,(-1,-1))
        p2LastCol,p2LastRow = self.p2ScoreMap.get(p2LastScore,(-1,-1))

        for ctr in range(30):
            #Draw the board
            w.startElement(u'TR')
            self.__drawTd(w, u'/images/cards/Cribbage/left-border.gif')


            if not p1Col and p1Row == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/red-filled.gif')
            elif not p1LastCol and p1LastRow == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/red-filled.gif')
            else:
                self.__drawTd(w, u'/images/cards/Cribbage/red-empty.gif')

            if p1Col and p1Row == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/red-filled.gif')
            elif p1LastCol and p1LastRow == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/red-filled.gif')
            else:
                self.__drawTd(w, u'/images/cards/Cribbage/red-empty.gif')

            self.__drawTd(w, u'/images/cards/Cribbage/center-border.gif')

            if not p2Col and p2Row == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/blue-filled.gif')
            elif not p2LastCol and p2LastRow == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/blue-filled.gif')
            else:
                self.__drawTd(w, u'/images/cards/Cribbage/blue-empty.gif')

            if p2Col and p2Row == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/blue-filled.gif')
            elif p2LastCol and p2LastRow == ctr:
                self.__drawTd(w, u'/images/cards/Cribbage/blue-filled.gif')
            else:
                self.__drawTd(w, u'/images/cards/Cribbage/blue-empty.gif')

            self.__drawTd(w, u'/images/cards/Cribbage/right-border.gif')
            w.endElement(u'TR')

            if not (ctr+1) % 5:
                w.startElement(u'TR')
                self.__drawTd(w, u'/images/cards/Cribbage/left-border.gif',height=u'8')
                self.__drawTd(w, u'/images/cards/Cribbage/spacer-border.gif',height=u'8')
                self.__drawTd(w, u'/images/cards/Cribbage/spacer-border.gif',height=u'8')
                self.__drawTd(w, u'/images/cards/Cribbage/center-border.gif',height=u'8')
                self.__drawTd(w, u'/images/cards/Cribbage/spacer-border.gif',height=u'8')
                self.__drawTd(w, u'/images/cards/Cribbage/spacer-border.gif',height=u'8')
                self.__drawTd(w, u'/images/cards/Cribbage/right-border.gif',height=u'8')
                w.endElement(u'TR')





        #Draw the bottom boarder
        w.startElement(u'TR')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-left-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-border.gif')
        self.__drawTd(w, u'/images/cards/Cribbage/bottom-right-border.gif')
        w.endElement(u'TR')

        return

    def __drawTd(self, w, img, width=u'20', height=u'16', colspan=u''):
        w.startElement(u'TD')
        #w.attribute(u'width',width)
        #w.attribute(u'height',height)
        if colspan:
            w.attribute(u'colspan',colspan)
        w.startElement(u'IMG')
        w.attribute(u'SRC',img)
        w.attribute(u'width',width)
        w.attribute(u'height',height)
        w.endElement(u'IMG')
        w.endElement(u'TD')



    p1ScoreMap = {}
    p2ScoreMap = {}

    for ctr in range(30):
        p1ScoreMap[ctr+1] = (0,ctr)
        p1ScoreMap[60 -ctr] = (1,ctr)
        p1ScoreMap[ctr+61] = (0,ctr)
        p1ScoreMap[120 -ctr] = (1,ctr)

    for ctr in range(30):
        p2ScoreMap[ctr+1] = (1,ctr)
        p2ScoreMap[60 -ctr] = (0,ctr)
        p2ScoreMap[ctr+61] = (1,ctr)
        p2ScoreMap[120 -ctr] = (0,ctr)


ExtNamespaces = {
    CARD_EXTENSION_NAMESPACE : 'cext',
    }

ExtElements = {
    (CARD_EXTENSION_NAMESPACE, 'draw-cribbage-board'): DrawCribbageBoard
    }

##ExtFunctions = {
##    (CARD_EXTENSION_NAMESPACE, ''): ,
##    }
