from xml.xslt import XsltException, Error
from Xslt import test_harness

source_1 = """<foo>dummy</foo>"""



"""
ValueOfElement.py:            raise XsltException(Error.VALUEOF_MISSING_SELECT)
WhenElement.py                raise XsltException(Error.WHEN_MISSING_TEST)
"""



apply_templates_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates>
      <foo/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates>
      <xsl:apply-templates/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_3 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates>
      <xsl:sort select='.'/>
      <foo/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_4 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates>
      <xsl:sort select='.'/>
      <xsl:apply-templates/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_5 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates>
      <xsl:with-param name='foo' select='.'/>
      <foo/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_6 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates>
      <xsl:with-param name='foo' select='.'/>
      <xsl:apply-templates/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_7 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates>
      <xsl:with-param name='foo' select='.'/>
      <xsl:sort select='.'/>
      <foo/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_8 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates>
      <xsl:with-param name='foo' select='.'/>
      <xsl:sort select='.'/>
      <xsl:apply-templates/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_9 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates select='foo'>
      <foo/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_10 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates select='foo'>
      <xsl:apply-templates/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_11 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates select='foo'>
      <xsl:sort select='.'/>
      <foo/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_12 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates select='foo'>
      <xsl:sort select='.'/>
      <xsl:apply-templates/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_13 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates select='foo'>
      <xsl:with-param name='foo' select='.'/>
      <foo/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_14 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates select='foo'>
      <xsl:with-param name='foo' select='.'/>
      <xsl:apply-templates/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_15 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates select='foo'>
      <xsl:with-param name='foo' select='.'/>
      <xsl:sort select='.'/>
      <foo/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

apply_templates_16 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:apply-templates select='foo'>
      <xsl:with-param name='foo' select='.'/>
      <xsl:sort select='.'/>
      <xsl:apply-templates/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

attribute_set_template_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:attribute-set/>
</xsl:stylesheet>
"""

attribute_set_template_2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:attribute-set name='foo'>
    <foo/>
  </xsl:attribute-set>
</xsl:stylesheet>
"""

attribute_set_template_3 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:attribute-set name='foo'>
    <xsl:apply-templates/>
  </xsl:attribute-set>
</xsl:stylesheet>
"""

attribute_set_template_4 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:attribute-set name='foo' use-attribute-sets='bar'/>
  <xsl:template match='/'>
    <xsl:element use-attribute-sets='foo'/>
  </xsl:template>
</xsl:stylesheet>
"""

avt_template_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <TABLE WIDTH='{'/>
  </xsl:template>
</xsl:stylesheet>
"""

avt_template_2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <TABLE WIDTH='{{}'/>
  </xsl:template>
</xsl:stylesheet>
"""

avt_template_3 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <TABLE WIDTH='}'/>
  </xsl:template>
</xsl:stylesheet>
"""

call_template_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:call-template name='foo'>
      <foo/>
    </xsl:call-template>
  </xsl:template>
</xsl:stylesheet>
"""

call_template_2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:call-template name='foo'>
      <xsl:apply-templates/>
    </xsl:call-template>
  </xsl:template>
</xsl:stylesheet>
"""

choose_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:choose>
      <foo/>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
"""

choose_2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:choose>
      <xsl:apply-templates/>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
"""

choose_3 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:choose/>
  </xsl:template>
</xsl:stylesheet>
"""

choose_4 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:choose>
      <xsl:otherwise/>
      <xsl:when test='foo'/>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
"""

choose_5 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test='foo'/>
      <xsl:otherwise/>
      <xsl:otherwise/>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
"""

copy_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:attribute-set name='foo'/>
  <xsl:template match='/*'>
    <xsl:copy use-attribute-sets='bar'/>
  </xsl:template>
</xsl:stylesheet>
"""

copy_of_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/*'>
    <xsl:copy-of/>
  </xsl:template>
</xsl:stylesheet>
"""

element_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:attribute-set name='foo'/>
  <xsl:template match='/'>
    <xsl:element use-attribute-sets='bar'/>
  </xsl:template>
</xsl:stylesheet>
"""

literal_element_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:attribute-set name='foo'/>
  <xsl:template match='/*'>
    <TABLE xsl:use-attribute-sets='bar'/>
  </xsl:template>
</xsl:stylesheet>
"""

message_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <xsl:message terminate='yes'/>
  </xsl:template>
</xsl:stylesheet>
"""

number_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <xsl:number level='foo'/>
  </xsl:template>
</xsl:stylesheet>
"""

number_2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <xsl:number grouping-separator=',' grouping-size='A'/>
  </xsl:template>
</xsl:stylesheet>
"""

number_3 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <xsl:number letter-value='foo'/>
  </xsl:template>
</xsl:stylesheet>
"""

number_4 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <xsl:number format='?'/>
  </xsl:template>
</xsl:stylesheet>
"""

number_5 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <xsl:number format='H'/>
  </xsl:template>
</xsl:stylesheet>
"""

sort_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <xsl:apply-templates select='/|*'>
      <xsl:sort data-type='foo'/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

sort_2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <xsl:apply-templates select='/|*'>
      <xsl:sort case-order='foo'/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

sort_3 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <xsl:apply-templates select='/|*'>
      <xsl:sort order='foo'/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

stylesheet_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
<xsl:namespace-alias result-prefix="xsl"/>
  <xsl:template match='/'>
    <xsl:apply-templates select='/|*'>
      <xsl:sort order='foo'/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

stylesheet_2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
<xsl:namespace-alias stylesheet-prefix="axsl"/>
  <xsl:template match='/'>
    <xsl:apply-templates select='/|*'>
      <xsl:sort order='foo'/>
    </xsl:apply-templates>
  </xsl:template>
</xsl:stylesheet>
"""

stylesheet_reader_1 = """<?xml version="1.0"?>
<xsl:foo xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <xsl:apply-templates/>
  </xsl:template>
</xsl:foo>
"""

stylesheet_reader_2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <xsl:foo/>
  </xsl:template>
</xsl:stylesheet>
"""

stylesheet_reader_3 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match='/'>
    <xsl:foo/>
  </xsl:template>
</xsl:stylesheet>
"""

stylesheet_reader_4 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template foo='/'/>
</xsl:stylesheet>
"""

stylesheet_reader_5 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="foo"
version="1.0">
  <xsl:template match='/'/>
</xsl:stylesheet>
"""

template_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/' priority='foo'/>
</xsl:stylesheet>
"""

text_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match='/'>
    <xsl:text><Foo/></xsl:text>
  </xsl:template>
</xsl:stylesheet>
"""

value_of_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:value-of/>
  </xsl:template>
</xsl:stylesheet>
"""

when_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:template match="/">
    <xsl:choose>
      <xsl:when/>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
"""



#"

errors = [('Illegal apply-templates child 1', apply_templates_1,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 2', apply_templates_2,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 3', apply_templates_3,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 4', apply_templates_4,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 5', apply_templates_5,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 6', apply_templates_6,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 7', apply_templates_7,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 8', apply_templates_8,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 9', apply_templates_9,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 10', apply_templates_10,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 11', apply_templates_11,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 12', apply_templates_12,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 13', apply_templates_13,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 14', apply_templates_14,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 15', apply_templates_15,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),
          ('Illegal apply-templates child 16', apply_templates_16,
           XsltException, {'errorCode' : Error.ILLEGAL_APPLYTEMPLATE_CHILD}),

          ('attribute-set requires name', attribute_set_template_1,
           XsltException, {'errorCode' : Error.ATTRIBUTESET_REQUIRES_NAME}),
          ('Illegal attribute-set with child 1', attribute_set_template_2,
           XsltException, {'errorCode' : Error.ILLEGAL_ATTRIBUTESET_CHILD}),
          ('Illegal attribute-set with child 2', attribute_set_template_3,
           XsltException, {'errorCode' : Error.ILLEGAL_ATTRIBUTESET_CHILD}),
          ('Undefined attribute-set', attribute_set_template_4,
           XsltException, {'errorCode' : Error.UNDEFINED_ATTRIBUTE_SET}),

          ('invalid attribute value template 1', avt_template_1,
           XsltException, {'errorCode' : Error.INVALID_AVT}),
          ('invalid attribute value template 2', avt_template_2,
           XsltException, {'errorCode' : Error.INVALID_AVT}),
          ('invalid attribute value template 3', avt_template_3,
           XsltException, {'errorCode' : Error.INVALID_AVT}),

          ('Illegal call-template child 1', call_template_1,
           XsltException, {'errorCode' : Error.ILLEGAL_CALLTEMPLATE_CHILD}),
          ('Illegal call-template child 2', call_template_2,
           XsltException, {'errorCode' : Error.ILLEGAL_CALLTEMPLATE_CHILD}),

          ('Illegal choose child 1', choose_1,
           XsltException, {'errorCode' : Error.ILLEGAL_CHOOSE_CHILD}),
          ('Illegal choose child 2', choose_2,
           XsltException, {'errorCode' : Error.ILLEGAL_CHOOSE_CHILD}),
          ('choose requires when child', choose_3,
           XsltException, {'errorCode' : Error.CHOOSE_REQUIRES_WHEN_CHILD}),
          ('choose with when after otherwise', choose_4,
           XsltException, {'errorCode' : Error.CHOOSE_WHEN_AFTER_OTHERWISE}),
          ('choose with multiple otherwise', choose_5,
           XsltException, {'errorCode' : Error.CHOOSE_MULTIPLE_OTHERWISE}),

          ('copy invalid use name', copy_1,
           XsltException, {'errorCode':Error.UNDEFINED_ATTRIBUTE_SET}),

          ('copy-of missing select', copy_of_1,
           XsltException, {'errorCode' : Error.COPYOF_MISSING_SELECT}),

          ('element invalid use name', element_1,
           XsltException, {'errorCode' : Error.UNDEFINED_ATTRIBUTE_SET}),

          ('literal element invalid use name', literal_element_1,
           XsltException, {'errorCode' : Error.UNDEFINED_ATTRIBUTE_SET}),

          ('message terminate', message_1,
           XsltException, {'errorCode' : Error.STYLESHEET_REQUESTED_TERMINATION}),

          ('Illegal number level value', number_1,
           XsltException, {'errorCode' : Error.ILLEGAL_NUMBER_LEVEL_VALUE}),
          ('Illegal number grouping size value', number_2,
           XsltException, {'errorCode' : Error.ILLEGAL_NUMBER_GROUPING_SIZE_VALUE}),
          ('Illegal number letter value', number_3,
           XsltException, {'errorCode' : Error.ILLEGAL_NUMBER_LETTER_VALUE_VALUE}),
          ('Illegal number format value 1', number_4,
           XsltException, {'errorCode' : Error.ILLEGAL_NUMBER_FORMAT_VALUE}),
          ('Illegal number format value 2', number_5,
           XsltException, {'errorCode' : Error.ILLEGAL_NUMBER_FORMAT_VALUE}),

          ('Illegal sort data-type value', sort_1,
           XsltException, {'errorCode' : Error.ILLEGAL_SORT_DATA_TYPE_VALUE}),
          ('Illegal sort case-order value', sort_2,
           XsltException, {'errorCode' : Error.ILLEGAL_SORT_CASE_ORDER_VALUE}),
          ('Illegal sort order value', sort_3,
           XsltException, {'errorCode' : Error.ILLEGAL_SORT_ORDER_VALUE}),

          ('Invalid namespace alias 1 ', stylesheet_1,
           XsltException, {'errorCode' : Error.INVALID_NAMESPACE_ALIAS}),
          ('Invalid namespace alias 2', stylesheet_2,
           XsltException, {'errorCode' : Error.INVALID_NAMESPACE_ALIAS}),

          ('stylesheet illegal root', stylesheet_reader_1,
           XsltException, {'errorCode' : Error.STYLESHEET_ILLEGAL_ROOT}),
          ('stylesheet illegal element', stylesheet_reader_2,
           XsltException, {'errorCode' : Error.XSLT_ILLEGAL_ELEMENT}),
          ('stylesheet missing version', stylesheet_reader_3,
           XsltException, {'errorCode' : Error.STYLESHEET_MISSING_VERSION}),
          ('stylesheet illegal attribute', stylesheet_reader_4,
           XsltException, {'errorCode' : Error.XSLT_ILLEGAL_ATTR}),
          ('stylesheet missing version', stylesheet_reader_5,
           XsltException, {'errorCode' : Error.STYLESHEET_MISSING_VERSION_NOTE1}),

          ('Illegal template priority', template_1,
           XsltException, {'errorCode' : Error.ILLEGAL_TEMPLATE_PRIORITY}),

          ('illegal text child', text_1,
           XsltException, {'errorCode' : Error.ILLEGAL_TEXT_CHILD}),

          ('value-of missing select', value_of_1,
           XsltException, {'errorCode' : Error.VALUEOF_MISSING_SELECT}),

          ('when missing test', when_1,
           XsltException, {'errorCode' : Error.WHEN_MISSING_TEST}),
          ]

def Test(tester):

    for name, sheet, exception, values in errors:
        
        tester.startGroup(name)
        source = test_harness.FileInfo(string=source_1)
        sty = test_harness.FileInfo(string=sheet)
        xtest = test_harness.XsltTester(source,
                                        [sty],
                                        "",
                                        expectedException=exception,
                                        exceptionValues=values
                                        )

        xtest.test(tester)
        tester.groupDone()

    return

