#Dieter Maurer <dieter@handshake.de> reports problems with xsl:import and variables

from Xslt import test_harness

sheet_1 = """\
<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version='1.0'>

  <xsl:import href="Xslt/Borrowed/dm_20010506.xslt"/>

  <xsl:variable name="section.autolabel" select="1" />
  <xsl:variable name="html.stylesheet">book.xsl</xsl:variable>
  <xsl:variable name="html.stylesheet.type">text/css</xsl:variable>
    
</xsl:stylesheet>"""

source_1 = "<dummy/>"


expected_1 = """\
<html>\n    START\n    <link type='text/css' rel='stylesheet' href='book.xsl'>\n    END\n    </html>"""


sheet_2 = """\
<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version='1.0'>

  <xsl:import href="Xslt/Borrowed/dm_20010506.xslt"/>

  <xsl:param name="section.autolabel" select="1" />
  <xsl:param name="html.stylesheet">book.xsl</xsl:param>
  <xsl:param name="html.stylesheet.type">text/css</xsl:param>

</xsl:stylesheet>"""

source_2 = source_1


expected_2 = expected_1


def Test(tester):
    tester.startGroup("Imports+variables")
    source = test_harness.FileInfo(string=source_1)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    )
    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("Import+params")
    source = test_harness.FileInfo(string=source_2)
    sty = test_harness.FileInfo(string=sheet_2)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_2,
                                    )
    xtest.test(tester)
    tester.groupDone()

    return
