from Ft.Rdf.Drivers import Memory
from Ft.Rdf import Model
import sys, cStringIO

def CreateInfEng():
    from Ft.Rdf.Inference import InferenceEngine
    db = Memory.DbAdapter('kb')
    db.begin()
    kb = Model.Model(db)
    return InferenceEngine.InferenceEngine(kb)

def Test(test):
    test.startGroup('Inference Commands')
    
    test.startTest('Syntax')
    if 1:
    #try:
        from Ft.Rdf.Inference import InferenceEngine
        from Ft.Rdf.Inference import Command
        from Ft.Rdf.Inference import Common
    #except:
    #    test.error('Error in syntax', 1)
    test.testDone()

    test.startTest('Stop')
    c = Command.StopCommand()

    infeng = CreateInfEng()

    context = Common.Context()
    context.skolemVariables = {}
    c.execute(infeng,context)

    test.testResults(InferenceEngine.InferenceEngine.STOPPED,infeng.state)

    test.startTest('Fire')
    c = Command.FireCommand()

    infeng = CreateInfEng()

    context = Common.Context()
    context.skolemVariables = {}
    c.execute(infeng,context)

    test.testResults(InferenceEngine.InferenceEngine.READY,infeng.state)

    test.startTest('Message')
    s = Common.StringLiteralArgument("arg1","Foo")
    c = Command.MessageCommand([s])

    infeng = CreateInfEng()

    context = Common.Context()
    context.skolemVariables = {}
    infeng.outStream = cStringIO.StringIO()
    c.execute(infeng,context)
    result = infeng.outStream.getvalue()
    expected = "**Start Ril Message**\n"
    expected = expected + "['Foo']\n"
    expected = expected + "**End Ril Message**\n"
    test.testResults(expected, result)

    test.testDone()
    test.groupDone()


if __name__ == '__main__':
    import sys
    from Ft.Lib import TestSuite

    testmgr = TestSuite.TestSuite()
    ret_val = Test(testmgr)
    sys.exit(ret_val)

