/*
    BundleProjectType.h

    Interface declaration of the BundleProjectType class for the
    ProjectManager application.

    Copyright (C) 2005, 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>
#import "../../ProjectType.h"

#import "../../ProjectModules/MakeBuilder/MakeBuilderDelegate.h"
#import "../../ProjectModules/FileManager/FileManagerDelegate.h"
#import "../../ProjectModules/ProjectAttributes/ProjectAttributesDelegate.h"
#import "../../ProjectModules/SubprojectsManager/SubprojectsManagerDelegate.h"

@class NSString,
       NSDictionary,
       NSArray,
       NSMutableArray,
       NSNotification;

@class ProjectDocument,
       FileManager,
       MakeBuilder,
       GNUstepAppLauncher;

@class BundleGeneralAttributes;

@interface BundleProjectType : NSObject <ProjectType,
                                         ProjectAttributesDelegate,
                                         FileManagerDelegate,
                                         MakeBuilderDelegate,
                                         SubprojectsManagerDelegate>
{
  // weak reference
  ProjectDocument * owner;

  BundleGeneralAttributes * attributes;

  NSString * principalClass;
  NSArray  * authors;
  NSString * copyright;
  NSString * copyrightDescription;

  FileManager * fileManager;
  MakeBuilder * builder;

  unsigned int oldMakeHash;
}

- (void) setPrincipalClass: (NSString *) aClass;
- (NSString *) principalClass;

- (void) setAuthors: (NSArray *) anArray;
- (NSArray *) authors;

- (void) setCopyright: (NSString *) aCopyright;
- (NSString *) copyright;

- (void) setCopyrightDescription: (NSString *) aCopyrightDescription;
- (NSString *) copyrightDescription;

@end
