/*
    TemplateFileSelector.h

    Interface declaration for the TemplateFileSelector class for
    the ProjectManager class.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>

#import <AppKit/NSNibDeclarations.h>

@class NSString;

@class NSPanel,
       NSBrowser,
       NSTextView,
       NSButton,
       NSMatrix,
       NSFormCell;

@interface TemplateFileSelector : NSObject
{
  IBOutlet NSPanel * panel;

  IBOutlet NSBrowser * browser;
  IBOutlet NSTextView * fileDescription;

  IBOutlet NSFormCell * filename;

  IBOutlet NSButton * okButton;
  IBOutlet NSButton * importAssociatedButton;

  NSString * directory;
  NSString * oldBrowserPath;
}

+ shared;

- (int) runModalForTemplatesDirectory: (NSString *) aDirectory;

- (NSString *) filename;
- (NSString *) templateFile;
- (NSString *) templateDirectory;
- (BOOL) shouldImportAssociatedFiles;

// button actions
- (void) ok: sender;
- (void) cancel: sender;

// browser action
- (void) updateSelection: sender;

// browser delegate methods
- (void) browser: (NSBrowser *)sender createRowsForColumn: (int)column
  inMatrix: (NSMatrix *)matrix;

@end
