/*
    NewFileTypeChooser.m

    Implementation of the NewFileTypeChooser class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "NewFileTypeChooser.h"

#import <Foundation/NSArray.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSString.h>
#import <Foundation/NSSortDescriptor.h>
#import <Foundation/NSBundle.h>

#import <AppKit/NSApplication.h>
#import <AppKit/NSMatrix.h>
#import <AppKit/NSPanel.h>
#import <AppKit/NSNibLoading.h>

@interface NewFileTypeChooser (Private)

- (void) setupMatrixWithKey: key value: value;

@end

@implementation NewFileTypeChooser (Private)

- (void) setupMatrixWithKey: key value: value
{
  int i;
  NSEnumerator * e;
  NSDictionary * type;

  for (i = [matrix numberOfRows] - 1; i >= 0; i--)
    {
      [matrix removeRow: i];
    }

  if (key == nil)
    {
      ASSIGN(types, allTypes);
    }
  else
    {
      NSEnumerator * e;
      NSDictionary * typeEntry;
      NSMutableArray * array;

      e = [allTypes objectEnumerator];
      array = [NSMutableArray array];
      while ((typeEntry = [e nextObject]) != nil)
        {
          if (value == nil)
            {
              if ([typeEntry objectForKey: key] != nil)
                {
                  [array addObject: typeEntry];
                }
            }
          else
            {
              if ([[typeEntry objectForKey: key] isEqual: value])
                {
                  [array addObject: typeEntry];
                }
            }
        }

      ASSIGN(types, array);
    }

  e = [types objectEnumerator];
  while ((type = [e nextObject]) != nil)
    {
      [matrix addRow];
      [[matrix cellAtRow: [matrix numberOfRows] - 1 column: 0]
        setTitle: [type objectForKey: @"NSHumanReadableName"]];
    }

  [matrix sizeToCells];
  if ([matrix numberOfRows] > 0)
    {
      [matrix selectCellAtRow: 0 column: 0];
    }
}

@end

@implementation NewFileTypeChooser

static NewFileTypeChooser * shared = nil;

+ shared
{
  if (shared == nil)
    {
      shared = [self new];
    }

  return shared;
}

- (void) dealloc
{
  TEST_RELEASE(allTypes);
  TEST_RELEASE(types);

  [super dealloc];
}

- init
{
  if ([super init])
    {
      NSDictionary * infoDict;
      NSSortDescriptor * sd;

      infoDict = [NSDictionary dictionaryWithContentsOfFile:
        [[NSBundle mainBundle] pathForResource: @"Info-gnustep"
                                        ofType: @"plist"]];
      if (infoDict == nil)
        {
          infoDict = [NSDictionary dictionaryWithContentsOfFile:
            [[NSBundle mainBundle] pathForResource: @"Info"
                                            ofType: @"plist"]];
        }

      // sort the types array at the beginning - this way we won't
      // have to do it aftewards anymore
      sd = [[[NSSortDescriptor alloc]
        initWithKey: @"NSHumanReadableName" ascending: YES]
        autorelease];
      ASSIGN(allTypes, [[infoDict objectForKey: @"NSTypes"]
        sortedArrayUsingDescriptors: [NSArray arrayWithObject: sd]]);

      return self;
    }
  else
    {
      return nil;
    }
}

- (void) awakeFromNib
{
  NSRect r = [matrix frame];

  r.size.width = [[matrix superview] frame].size.width;

  [matrix setFrame: r];

  [matrix setTarget: okButton];
  [matrix setDoubleAction: @selector(performClick:)];
}

- (NSString *) runModalWithRequiredKey: key value: value
{
  int code;

  if (panel == nil)
    {
      [NSBundle loadNibNamed: @"NewFileTypePanel" owner: self];
    }

  [self setupMatrixWithKey: key value: value];

  [panel selectKeyViewFollowingView: okButton];
  code = [NSApp runModalForWindow: panel];
  [panel close];

  if (code == NSOKButton)
    {
      return [[types objectAtIndex: [matrix selectedRow]]
        objectForKey: @"NSName"];
    }
  else
    {
      return nil;
    }
}

- (void) ok: sender
{
  [NSApp stopModalWithCode: NSOKButton];
}

- (void) cancel: sender
{
  [NSApp stopModalWithCode: NSCancelButton];
}

@end
